<?php
/**
 *
 * @package BookLibrary nav-pills
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Pro
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'];
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.main.categories.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.authors.php");
/*
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/functions.php");
    */

function print_vars($obj) {
    $arr = get_object_vars($obj);
    while (list($prop, $val) = each($arr)) if (class_exists($val)) print_vars($val);
    else echo "\t $prop = $val\n<br />";
}
function print_methods($obj) {
    $arr = get_class_methods(get_class($obj));
    foreach($arr as $method) echo "\tfunction $method()\n <br />";
}
if (PHP_VERSION >= 5) {
    // Emulate the old xslt library functions
    function xslt_create() {
        return new XsltProcessor();
    }
    function xslt_process($xsltproc, $xml_arg, $xsl_arg, $xslcontainer = null, 
            $args = null, $params = null) {
        // Create instances of the DomDocument class
        $xml = new DomDocument;
        $xsl = new DomDocument;
        // Load the xml document and the xsl template
        $xml->load($xml_arg);
        $xsl->load($xsl_arg);
        // Load the xsl template
        $xsltproc->importStyleSheet($xsl);
        // Set parameters when defined
        if ($params) {
            foreach($params as $param => $value) {
                $xsltproc->setParameter("", $param, $value);
            }
        }
        // Start the transformation
        $processed = $xsltproc->transformToXML($xml);
        // Put the result in a file when specified
        if ($xslcontainer) {
            return file_put_contents($xslcontainer, $processed);
        } else {
            return $processed;
        }
    }
    function xslt_free($xsltproc) {
        unset($xsltproc);
    }
}
class mosBooklibraryImportExport {
    /**
     * Imports the lines given to this method into the database and writes a
     * table containing the information of the imported books.
     * The imported books will be set to [not published]
     * Format: #;id;isbn;title;author;language
     * @param array lines - an array of lines read from the file
     * @param int catid - the id of the category the books should be added to
     */
    static function importBooksFullCSV($lines, $catid) {
        global $database;
        $retVal = array();
        $i = 0;
        foreach($lines as $line) {
            $tmp = array();
            if (trim($line) == "") continue;
            $line = explode('|', $line);
            $book = new mosBookLibrary($database);
            //print_r($book);exit;
            $book->bookid = trim($line[0]);
            $book->isbn = $line[1];
            $book->title = $line[2];
            
            $book->authors = $line[3];
       
           
            $book->manufacturer = $line[4];  
            $book->price = $line[9];
            //$book->date = date("Y-m-d H:i:s");
            $book->date = $line[15];
            $book->language = $line[6]; //Language
            if (count($line) > 21) { //if new version csv
                $book->priceunit = $line[16];
                $book->owneremail = $line[17];
                $book->owner_id = $line[18];
                $book->featured_clicks = $line[19];
                $book->featured_shows = $line[20];
                $book->numberOfPages = $line[21];
                $book->comment = $line[22]; //Book Description
                
            } else if (count($line) > 16) { //if new version csv

                $book->priceunit = $line[16];
                $book->owneremail = $line[17];
                $book->featured_clicks = $line[18];
                $book->featured_shows = $line[19];
                $book->numberOfPages = $line[20];
                $book->comment = $line[21]; //Book Description
                
            } // optimize!!!
            else { //if old version csv
                $book->comment = $line[16];
            }


            $tmp[0] = $i;
            $tmp[1] = $book->bookid;
            $tmp[2] = $line[1];
            $tmp[3] = $line[2];
            $tmp[4] = $line[3];
            $tmp[5] = $line[4];
            if (!$book->check()) {
                $tmp[6] = $book->getError();
                $retVal[$i] = $tmp;
                $i++;
                continue;
            }
            //print_r($tmp);exit();
            if (!$book->store()) {

                $tmp[6] = $book->getError();
                $retVal[$i] = $tmp;
                $i++;
                continue;
                $tmp[6] = $book->getError();
            } else {
                $tmp[6] = "OK";

                $book->authors = mosBooklibraryImportExport::importAuthors($book->authors);
                
            }
            
            $book->categs = array($catid);
            $book->saveCategs();
            $book->saveAuthors();
            $book->checkin();

            $retVal[$i] = $tmp;


            $i++;
        }

        return $retVal;
    }


    static function importAuthors($authors) {
        $authorarray =array_unique (explode(',', $authors) );
        $resultarray = array();

        foreach ($authorarray as  $value) {
            if(empty($value) ) continue ;
            $result = null;
            $author_id = findAuthorByName(trim($value));


            // if(is_array($author_id) && count($author_id) != 0) {
            if($author_id && count($author_id) != 0) {

                if(is_array( $author_id ) ){
                    $author_id = array_unique ( $author_id );
                    $resultarray = array_merge( $resultarray, $author_id );
                } else $resultarray[] = $author_id;
            } else {

                $result = createAuthorByName(trim($value)); 
                if( !in_array( $result ,$resultarray) ) $resultarray[] = $result;
            }
            
        }         

        $resultarray =array_unique ( $resultarray );

        return $resultarray;
    }


    static function getXMLItemValue($item, $item_name,$default="") {
        $book_items = $item->getElementsByTagName($item_name);
        $book_item = $book_items->item(0);

        // if($item_name == "status"){
        //     echo ":1111111111111111112:";
        //     print_r($book_item);
        //     echo ":1111111111111111113:";
        //     print_r($default);
        //     echo ":1111111111111111114:";
        //     print_r($book_item->nodeValue);
        //     if( "0" === $book_item->nodeValue ) echo ":44444444444444:";

        // }


        if (NULL != $book_item && isset($book_item->nodeValue) 
            && ( ( "0" === $book_item->nodeValue ) || !empty($book_item->nodeValue) ) ) {
            return $book_item->nodeValue;
        }
        else if ("" != $default)
            return $default;
        else 
            return "";        
    }

    //*********************************************************************************************
    static function findCategory(&$categories, $new_category) {
        global $database;
        foreach($categories as $category) {
            if ($category->old_id == $new_category->old_id) return $category;
        }
        $new_parent_id = 0;
        if ($new_category->old_parent_id != 0) {
            foreach($categories as $category) {
                if ($category->old_id == $new_category->old_parent_id) {
                    $new_parent_id = $category->id;
                    break;
                }
            }
        } else $new_parent_id = 0;
        $row = new mainBooklibraryCategories($database); 
        $row->section = 'com_booklibrary';
        $new_category->parent_id = $row->parent_id = $new_parent_id;
        $row->name = $new_category->name;
        $row->title = $new_category->title;
        $row->alias = $new_category->alias;
        $row->published = $new_category->published;
        $row->ordering = $new_category->ordering;
        $row->access = $new_category->access;
        $row->description = $new_category->description;
        $row->params = $new_category->params;
        $row->params2 = $new_category->params2; 
        $row->metadata = $new_category->metadata;
        $row->publish_up = $new_category->publish_up;
        $row->publish_down = $new_category->publish_down;
        if (!$row->check()) {
            echo "error in import2 !";
            exit;
            exit();
        }
        if (!$mess = $row->store()) {
            // echo "err-mess_".$mess."_";
            echo "error in import3 !: " . $mess;
            exit;
            // echo "error in import3 !"; exit;
            exit();
        }
        ///$row->updateOrder("extension='com_booklibrary' AND parent_id='$row->parent_id'");
        $row->updateOrder("section='com_booklibrary' AND parent_id='$row->parent_id'"); 
        $new_category->id = $row->id;
        $categories[] = $new_category;
        return $new_category;
    }

    static function updateAssociateAuthor() {

    }


    static function updateAssociateBook($infoArr) {
        $dataToUpdate = array();
        global $database;
        if( !isset($infoArr) ) return ;
        for ($i = 0; $i < count($infoArr);$i++) {
            if (isset($infoArr[$i]['associateBook']) && $infoArr[$i]['associateBook']) {
                $currentAssocId = array();
                $newObjAssociateBook = unserialize($infoArr[$i]['associateBook']);
                foreach($newObjAssociateBook as $value => $key) {
                    if ($key && $key != 0) {
                        for ($j = 0;$j < count($infoArr);$j++) {
                            if (isset($infoArr[$j]['oldId']) && $infoArr[$j]['oldId'] == $key) {
                                $newObjAssociateBook[$value] = $infoArr[$j]['newId'];
                                $currentAssocId[] = $infoArr[$j]['newId'];
                            }
                        }
                    }
                }
                $newSerializAssoc = serialize($newObjassociateBook);
                $currentAssocIdToString = implode(',', $currentAssocId);
                if (!isset($dataToUpdate[$newSerializAssoc])) {
                    $dataToUpdate[$newSerializAssoc] = $currentAssocIdToString;
                }
            }
        }
        if (!empty($dataToUpdate)) {
            foreach($dataToUpdate as $value => $key) {
                $query = "UPDATE #__booklibrary 
                                  SET associate_book = '$value' 
                                  WHERE id in ($key) ";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }
    static function refreshCategoryParentId(&$categories) {
        global $database;
        foreach($categories as $category) {
            if ($category->parent_id == 0 && $category->old_parent_id != 0) {
                foreach($categories as $category2) {
                    if ($category2->old_id == $category->old_parent_id) {
                        $category->parent_id = $category2->id;
                        $row = new mainBooklibraryCategories($database); 
                        $row->load($category->id);
                        $row->parent_id = $category->parent_id;
                        if (!$row->check()) {
                            echo "error in import4 !";
                            exit;
                            exit();
                        }
                        if (!$mess = $row->store()) {
                            // echo "err-mess_".$mess."_";
                            echo "error in import5 !: " . $mess;
                            exit;
                        }
                        $row->updateOrder("section='com_booklibrary' 
                                           AND parent_id='$row->parent_id'"); 
                        break;
                    }
                }
            }
        }
    }


    static function importCategoriesXML($catid, &$dom, &$new_categories){
        $categories_xml = $dom->getElementsByTagName('category');
        if ($categories_xml->item(0) != NULL) { 
            if ($catid === null) { 
                //IF FULL IMPORT
                for ($i = 0;$i < $categories_xml->length;$i++) {
                    $category = $categories_xml->item($i);
                    $new_category = new stdClass();
                    $new_category->old_id = mosBooklibraryImportExport::getXMLItemValue($category, 'id');
                    $new_category->old_parent_id = mosBooklibraryImportExport::getXMLItemValue($category, 'parent_id');
                    $new_category->name = mosBooklibraryImportExport::getXMLItemValue($category, 'name');
                    $new_category->title = mosBooklibraryImportExport::getXMLItemValue($category, 'title');
                    $new_category->alias = mosBooklibraryImportExport::getXMLItemValue($category, 'alias');
                    $new_category->published = mosBooklibraryImportExport::getXMLItemValue($category, 'published');
                    $new_category->ordering = mosBooklibraryImportExport::getXMLItemValue($category, 'ordering');
                    $new_category->access = mosBooklibraryImportExport::getXMLItemValue($category, 'access');
                    $new_category->description = mosBooklibraryImportExport::getXMLItemValue($category, 'description');
                    $new_category->params = mosBooklibraryImportExport::getXMLItemValue($category, 'params');
                    $new_category->params2 = mosBooklibraryImportExport::getXMLItemValue($category, 'params2');
                    $new_category->metadata = mosBooklibraryImportExport::getXMLItemValue($category, 'metadata');
                    $new_category->publish_up = mosBooklibraryImportExport::getXMLItemValue($category, 'publish_up');
                    $new_category->publish_down = mosBooklibraryImportExport::getXMLItemValue($category, 'publish_down');
                    $new_category = mosBooklibraryImportExport::findCategory($new_categories, $new_category);
                }
                mosBooklibraryImportExport::refreshCategoryParentId($new_categories);
            }
        }  //end if exist categories

    }

    static function importAuthorsXML(&$dom, &$new_authrs){
        global $database;
        $authors_xml = $dom->getElementsByTagName('author');


        foreach($authors_xml as $i => $author_xml) {
            $author = new mosBookLibrary_authors($database);
            $author->hits = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'hits');
            $author->date = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'date');
            $author->associate_authors = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'associate_authors');
            $author->published = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'published');
            $author->authors_name = $database->escape(mosBooklibraryImportExport::getXMLItemValue($author_xml, 'authors_name'));
            $author->description = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'description');
            $author->auto_gener_description = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'auto_gener_description');
            $author->imageURL = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'imageURL');
            $author->date = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'date');
            $author->langshow = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'langshow');
            $author->owneremail = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'owneremail');
            $author->owner_id = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'owner_id');
            $author->metadata = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'metadata');
            $author->publish_up = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'publish_up');
            $author->publish_down = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'publish_down');

            $query = "SELECT id FROM #__booklibrary_authors 
                    WHERE authors_name = '$author->authors_name'";
            $database->setQuery($query);
            $result = $database->loadResult();

            if (!$result) {
                if (!$author->check() || !$author->store()) {
                    echo $author->getError();
                }
            } 

            $author->old_id = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'id');
            $new_authrs[] = $author ;

        }

    }


     static function importAuthorsXMLOld(&$dom, &$new_authrs){
        global $database;
        $authors_xml = $dom->getElementsByTagName('book');


         foreach($authors_xml as $i => $author_xml) {

            $author = new mosBookLibrary_authors($database);
            $author->authors_name = mosBooklibraryImportExport::getXMLItemValue($author_xml,'authors');
            $author->authors_name = $database->escape($author->authors_name);
            //$author->authors_name = $database->Quote($author->authors_name);
            //$author->authors_name = str_replace("'","", $author->authors_name); 
            $author->book_id = mosBooklibraryImportExport::getXMLItemValue($author_xml,'bookid');

            $query = "SELECT id FROM #__booklibrary_authors 
                    WHERE authors_name = '$author->authors_name'";
            $database->setQuery($query);
            $result = $database->loadResult();

            if (!$result)
            {
                $query = "INSERT INTO #__booklibrary_authors (authors_name) VALUES ('{$author->authors_name}')";
                $database->setQuery($query);
                $database->execute();
                $result = $database->insertid();
            
            } 
     
            //$author->old_id = mosBooklibraryImportExport::getXMLItemValue($author_xml, 'id');
            $author->id = $result;
            $new_authrs[] = $author ;


        }

    }

    static function importBooksXML($catid, &$dom, &$new_categories,&$new_authrs,&$numversion){
        global $database;

        $retVal = array();

        $book_list = $dom->getElementsByTagName('book');

        for ($i = 0;$i < $book_list->length;$i++) {
            
            $book_xml = $book_list->item($i);
            //echo mosBooklibraryImportExport::getXMLItemValue($book_xml,'bookid');
            $book = new mosBooklibrary($database);
            //get BookID
            $book->bookid = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'bookid');
            //get ISBN
            $book->isbn = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'isbn');
            //get Title(book)
            $book->title = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'title');
            if ($numversion[0] < 3.6) {
                //get Authors
                $book->authors = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'authors');
            }            
            //get Manufacturer
            $book->manufacturer = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'manufacturer');
            //get releasedate
            $book->release_Date = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'releaseDate');
            //get language
            $book->language = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'language');
            $book->langshow = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'langshow');
            if ($book->langshow == "") $book->langshow = "*";
            //get hits
            $book->hits = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'hits');
            $book->user_name = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'user_name');
            //get featured_clicks
            $book->featured_clicks = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'featured_clicks');
            //get featured_shows
            $book->featured_shows = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'featured_shows');
            //get rating
            $book->rating = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'rating');
            //get price
            $book->price = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'price');
            //get priceunit
            $book->priceunit = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'priceunit');
            //get URL
            $book->URL = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'url');
            //get imageURL
            $book->imageURL = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'imageURL');
            //get edition
            $book->edition = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'edition');
            //get ebookURL
            $book->ebookURL = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'ebookURL');
            //get informationFrom
            $book->informationFrom = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'informationFrom');
            if ($numversion[0] == 3.5) {
                //get author id
                $book->fk_authors = mosBooklibraryImportExport::checkid($book->authors);
            }
            //get date
            $book->date = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'date');
            //get fk_lendid
            // $book->fk_lendid = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'fk_lendid');
            //get published
            $book->published = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'published');
            //get comment
            $book->comment = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'comment');
            //get numberOfPages
            $book->numberOfPages = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'numberOfPages');
            $book->comment = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'comment');
            //get email owner book
            $book->owneremail = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'owneremail');
            //get owner_id owner book
            $book->owner_id = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'owner_id');
            $book->vm_id_product = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'vm_id_product');
            if($book->vm_id_product == "" ) $book->vm_id_product = 0 ;
            $book->metadata = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'metadata');
            $book->publish_up = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'publish_up');
            $book->publish_down = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'publish_down');
            if ($catid === null) {
                //get associate_book
                $book->associate_book = mosBooklibraryImportExport::getXMLItemValue($book_xml, 'associate_book');
            }
            //get Categories

            if ($catid != "0" && $catid != "") { 
                $book->categs = array($catid);
            } else {
                $categ = $book_xml->getElementsByTagName('categ');

                $arrcatid = array();
                foreach($categ as $cattemp) { 
                    $category_book_old_id = $cattemp->nodeValue; 
                    foreach($new_categories as $new_category) { 
                        if ($new_category->old_id == $category_book_old_id) {
                            $arrcatid[] = $new_category->id;
                        }
                    }
                }
                $book->categs = $arrcatid;
            }
            //get Authors

            $authors_names = $book->authors;
            
            if ($numversion[0] >= 3.6) 
            {

                $authors_id = $book_xml->getElementsByTagName('author_id');
                $arrauthorid = array();
                $result = null;
                foreach($authors_id as $avtor1) { 
                    $author_book_old_id = $avtor1->nodeValue; 
                    foreach($new_authrs as $new_authr) { 
                        if ($new_authr->old_id == $author_book_old_id) {
                            $database->setQuery("SELECT id FROM #__booklibrary_authors  
                                     WHERE authors_name = '$new_authr->authors_name'");
                            $result = $database->loadResult();
                            if ($result) {
                                
                                if( !in_array( $result ,$arrauthorid) ) $arrauthorid[] = $result;
                                // $authors_names = $new_authr->authors_name;
                            } else {
                                
                                if( !in_array( $new_authr->id ,$arrauthorid) ) $arrauthorid[] = $new_authr->id;
                                if($authors_names == "") $authors_names = $new_authr->authors_name ;
                                else $authors_names .= ", " . $new_authr->authors_name ;
                            }
                        }
                    }
                }
                $book->authors = $arrauthorid;
            }


            $tmp[] = $i;
            $tmp[] = $book->bookid;
            $tmp[] = $book->isbn;
            $tmp[] = $book->title;
            $tmp[] = $authors_names ;
            $tmp[] = $book->manufacturer;

            if (!$book->check()) {
                $tmp[] = $book->getError();
                $retVal[$i] = $tmp;
                unset($tmp);
                unset($book);
                continue;
            }
            if (!$book->store()) {
                $tmp[] = $book->getError();
                $retVal[$i] = $tmp;
                unset($tmp);
                unset($book);
                continue;
            } else {
                $book->saveCategs();
                if ($numversion[0] >= 3.6) 
                {                
                    $book->saveAuthors();
                }
                $tmp[] = "OK";
                //save categs             
                $book->checkin();
                //$book->updateOrder( "catid='$book->catid'" );
                $retVal[$i] = $tmp;


                $fk_bookid = $book->id;


                if($numversion[0] < 3.6) //for old version
                {
                        $query = "INSERT INTO #__booklibrary_authors_connect (fk_bookid,fk_authorid) VALUES ('$fk_bookid','{$new_authrs[$i]->id}')";
                        $database->setQuery($query);
                        $database->execute();          
                }

                mosBooklibraryImportExport::importReviewXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importRentsXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importRentRequestsXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importEfilesXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importVideoXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importAudioXML($fk_bookid, $book_xml);
                mosBooklibraryImportExport::importTrackXML($fk_bookid, $book_xml);
            }
            //echo $i,':';var_dump($tmp); echo '<br/>';
            unset($tmp);
            unset($book);
            continue;
        } //end foreach books */

        return $retVal ;

    }    

    static function importReviewXML($fk_bookid, &$book_xml){
        global $database, $book;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'reviews') != "") {
            $review_list = $book_xml->getElementsByTagName('review');
            for ($j = 0;$j < $review_list->length;$j++) {
                $review = $review_list->item($j);
                //get for review - fk_userid
                $review_fk_userid = mosBooklibraryImportExport::getXMLItemValue($review, 'fk_userid');
                //check - exist this user or not - if don't exist set he as anonymous
                $database->setQuery("SELECT id 
                                     FROM #__users " . "\n 
                                     WHERE id = " . $review_fk_userid . ";");
                $review_fk_userid = $database->loadResult();
                if (!isset($review_fk_userid) || count($review_fk_userid) == 0) $review_fk_userid = 0;
                //get for review - date
                $review_date = mosBooklibraryImportExport::getXMLItemValue($review, 'date');
                //get for review - rating
                $review_rating = mosBooklibraryImportExport::getXMLItemValue($review, 'rating');
                //get for review - title
                $review_title = mosBooklibraryImportExport::getXMLItemValue($review, 'title');
                //get for review - comment
                $review_comment = mosBooklibraryImportExport::getXMLItemValue($review, 'comment');
                //insert data in table #__booklibrary_review
                if (version_compare(JVERSION, "3.3.0", "ge")) {
                    $database->setQuery("INSERT INTO #__booklibrary_review" . "\n 
                                        (fk_bookid, fk_userid, date, rating, title, 
                                         comment)" . "\n 
                                         VALUES " . "\n 
                                         (" . $database->Quote($fk_bookid) . ", " . 
                                         $database->Quote($review_fk_userid) . ", " . 
                                         $database->Quote($review_date) . ", " . 
                                         $database->Quote($review_rating) . ", " . 
                                         $database->Quote($review_title) . ", " . 
                                         $database->Quote($review_comment) . ");");
                } else {
                    $database->setQuery("INSERT INTO #__booklibrary_review" . "\n 
                                        (fk_bookid, fk_userid, date, rating, title, 
                                         comment)" . "\n VALUES " . "\n 
                                        (" . $fk_bookid . "," . $review_fk_userid . 
                                        ", '" . $review_date . "', " . 
                                        $review_rating . ", '" . $review_title . "', 
                                        '" . $review_comment . "');");
                }
                $database->execute();
            } 
        } 

    }
    static function importRentsXML($fk_bookid, &$book_xml){
        global $database, $book;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'rents') != "") {
            $lend_list = $book_xml->getElementsByTagName('lend');
            for ($j = 0;$j < $lend_list->length;$j++) {

                $lend = $lend_list->item($j);

                //get for lend - fk_userid
                $lend_fk_userid = mosBooklibraryImportExport::getXMLItemValue($lend, 'fk_userid');
                if (empty($lend_fk_userid) ) $lend_fk_userid = 0;
                //check - exist this user or not - if don't exist set he as anonymous
                $database->setQuery("SELECT id 
                                     FROM #__users " . "\n 
                                     WHERE id = " . $lend_fk_userid . ";");
                $lend_fk_userid = $database->loadResult();
                if (!isset($lend_fk_userid) || count($lend_fk_userid) == 0) $lend_fk_userid = 0;
                //get for lend - lend_from
                $lend_from = mosBooklibraryImportExport::getXMLItemValue($lend, 'lend_from');
                //get for lend - lend_until
                $lend_until = mosBooklibraryImportExport::getXMLItemValue($lend, 'lend_until');
                //get for lend - lend_return
                $lend_return = mosBooklibraryImportExport::getXMLItemValue($lend, 'lend_return');
                //get for lend - user_name
                $user_name = mosBooklibraryImportExport::getXMLItemValue($lend, 'user_name');
                //get for lend - user_email
                $user_email = mosBooklibraryImportExport::getXMLItemValue($lend, 'user_email');
                //get for lend - user_mailing
                $user_mailing = mosBooklibraryImportExport::getXMLItemValue($lend, 'user_mailing');
                //insert data in table #__booklibrary_lend
                $database->setQuery("INSERT INTO #__booklibrary_lend" . "\n 
                                    (fk_bookid, fk_userid, lend_from, lend_until, lend_return,user_name,user_email, 
                                     user_mailing)" . "\n 
                                     VALUES " . "\n 
                                     (" . $database->Quote($fk_bookid) . ", " . 
                                     $database->Quote($lend_fk_userid) . ", " . 
                                     $database->Quote($lend_from) . ", " . 
                                     $database->Quote($lend_until) . ", " . 
                                     $database->Quote($lend_return) . ", " . 
                                     $database->Quote($user_name) . ", " . 
                                     $database->Quote($user_email) . ", " . 
                                     $database->Quote($user_mailing) . ");");

                $database->execute();
            } 
        } 

    }

    static function importRentRequestsXML($fk_bookid, &$book_xml){
        global $database, $book;
      
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'rentrequests') != "") {
            $lendrequest_list = $book_xml->getElementsByTagName('lendrequest');
            for ($j = 0;$j < $lendrequest_list->length;$j++) {

                $lendrequest = $lendrequest_list->item($j);
                //get for lendrequest - fk_userid
                $lendrequest_fk_userid = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'fk_userid');
                if (empty($lendrequest_fk_userid) ) $lendrequest_fk_userid = 0;
                //check - exist this user or not - if don't exist set he as anonymous
                $database->setQuery("SELECT id 
                                     FROM #__users " . "\n 
                                     WHERE id = " . $lendrequest_fk_userid . ";");
                $lendrequest_fk_userid = $database->loadResult();
                if (!isset($lendrequest_fk_userid) || count($lendrequest_fk_userid) == 0) $lendrequest_fk_userid = 0;
                //get for lendrequest - lend_from
                $lend_from = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'lend_from');
                //get for lendrequest - lend_until
                $lend_until = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'lend_until');
                //get for lendrequest - lend_request
                $lend_request = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'lend_request');
                //get for lendrequest - user_name
                $user_name = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'user_name');
                //get for lendrequest - user_email
                $user_email = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'user_email');
                //get for lendrequest - user_mailing
                $user_mailing = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'user_mailing');
                //get for lendrequest - status
                $status = mosBooklibraryImportExport::getXMLItemValue($lendrequest, 'status');
                //insert data in table #__booklibrary_lend_request
                $database->setQuery("INSERT INTO #__booklibrary_lend_request" . "\n 
                                    (fk_bookid, fk_userid, lend_from, lend_until, lend_request, user_name, user_email, user_mailing, 
                                     status)" . "\n 
                                     VALUES " . "\n 
                                     (" . $database->Quote($fk_bookid) . ", " . 
                                     $database->Quote($lendrequest_fk_userid) . ", " . 
                                     $database->Quote($lend_from) . ", " . 
                                     $database->Quote($lend_until) . ", " . 
                                     $database->Quote($lend_request) . ", " . 
                                     $database->Quote($user_name) . ", " . 
                                     $database->Quote($user_email) . ", " . 
                                     $database->Quote($user_mailing) . ", " . 
                                     $database->Quote($status) . ");");

                $database->execute();
            } 
        } 

    }



    static function importEfilesXML($fk_bookid, &$book_xml){
        global $database;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'ebook') != "") {
            $ebook_list = $book_xml->getElementsByTagName('ebook');
            for ($j = 0;$j < $ebook_list->length;$j++) {
                $efile = $ebook_list->item($j);
                $efileLoc = mosBooklibraryImportExport::getXMLItemValue($efile, 'location');
                $efileDesc = mosBooklibraryImportExport::getXMLItemValue($efile, 'description');
                //insert data in table #__booklibrary_files
                $database->setQuery("INSERT INTO #__booklibrary_files" . "\n 
                                    (fk_book_id, location, description)" . "\n 
                                    VALUES " . "\n (" . $fk_bookid . ",'" . 
                                    $efileLoc . "', '" . $efileDesc . "');");
                $database->execute();
            }     
        }

    }

    static function importVideoXML($fk_bookid, &$book_xml){
        global $database;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'video') != "") {
            $video_list = $book_xml->getElementsByTagName('video');
            for ($j = 0;$j < $video_list->length;$j++) {
                $vfile = $video_list->item($j);
                $vfileSrc = mosBooklibraryImportExport::getXMLItemValue($vfile, 'src');
                $vfileType = mosBooklibraryImportExport::getXMLItemValue($vfile, 'type');
                $vfileMedia = mosBooklibraryImportExport::getXMLItemValue($vfile, 'media');
                $youtubeCode = mosBooklibraryImportExport::getXMLItemValue($vfile, 'youtube');
                //insert data in table #__booklibrary_video_source
                $database->setQuery("INSERT INTO #__booklibrary_video_source" . "\n 
                                   (fk_book_id, src, type, media, youtube)" . "\n 
                                   VALUES " . "\n (" . $fk_bookid . ",'" . 
                                   $vfileSrc . "', '" . $vfileType . "', '" . 
                                   $vfileMedia . "', '" . $youtubeCode . "');");
                $database->execute();
            }
        }

    }    

    static function importAudioXML($fk_bookid, &$book_xml){
        global $database;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'audio') != "") {
            $audio_list = $book_xml->getElementsByTagName('audio');
                for ($j = 0;$j < $audio_list->length;$j++) {
                    $afile = $audio_list->item($j);
                    $afileSrc = mosBooklibraryImportExport::getXMLItemValue($afile, 'src');
                    $afileType = mosBooklibraryImportExport::getXMLItemValue($afile, 'type');
                    //insert data in table #__booklibrary_audio_source
                    $database->setQuery("INSERT INTO #__booklibrary_audio_source" . 
                                        "\n (fk_book_id, src, type)" . 
                                        "\n VALUES " . 
                                        "\n (" . $fk_bookid . ",
                                         '" . $afileSrc . "', 
                                         '" . $afileType . "');");
                    $database->execute();
                } 
        } 

    }

    static function importTrackXML($fk_bookid, &$book_xml){
        global $database;
        if (mosBooklibraryImportExport::getXMLItemValue($book_xml, 'track') != "") {
            $track_list = $book_xml->getElementsByTagName('track');
            for ($j = 0;$j < $track_list->length;$j++) {
                $tfile = $track_list->item($j);
                $tfileSrc = mosBooklibraryImportExport::getXMLItemValue($tfile, 'src');
                $tfilekind = mosBooklibraryImportExport::getXMLItemValue($tfile, 'kind');
                $tfileSrclang = mosBooklibraryImportExport::getXMLItemValue($tfile, 'scrlang');
                $tfileLabel = mosBooklibraryImportExport::getXMLItemValue($tfile, 'label');
                //insert data in table #__booklibrary_audio_source
                $database->setQuery("INSERT INTO #__booklibrary_track_source" . "\n 
                                    (fk_book_id, src, kind, scrlang, label)" . "\n 
                                    VALUES " . "\n (" . $fk_bookid . ",'" . 
                                    $tfileSrc . "', '" . $tfilekind . "', '" . 
                                    $tfileSrclang . "', '" . $tfileLabel . "');");
                $database->execute();
            } 
        } 

    }

    //***********************   begin add for import XML format   ***********************************
    //***********************************************************************************************
    static function importBooksFullXML($files_name_pars, $catid) {

        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);        

        $files_name_pars = file($files_name_pars);
        $files_name_pars = implode('', $files_name_pars);
        //echo $files_name_pars;
        global $database;
        $retVal = array();
        $new_categories = array();
        $new_authrs = array();
        $categories_xml = '';
        $authors_xml ='';
        $k = 0;
        $dom = new domDocument('1.0', 'utf-8');
        $dom->loadXML($files_name_pars);

        $version = $dom->getElementsByTagName('version');// [length] => 1

       
        if ($version->item(0) != NULL) {


            if ($catid === null) { 
                //IF FULL IMPORT
                $ret = mosBooklibraryImportExport::remove_info();
                //if ($ret != "") return;
            }

            $numversion = explode(' ', $version->item(0)->nodeValue);// get version


            if ($numversion[0] >= 3.6) {

                mosBooklibraryImportExport::importCategoriesXML($catid, $dom,$new_categories);     
                mosBooklibraryImportExport::importAuthorsXML($dom, $new_authrs);
                $retVal = mosBooklibraryImportExport::importBooksXML($catid, $dom, $new_categories,$new_authrs,$numversion);
            }
            elseif ($numversion[0] >= 2 && $numversion[0] < 3.6) {
      
                mosBooklibraryImportExport::importCategoriesXML($catid, $dom,$new_categories);     
                mosBooklibraryImportExport::importAuthorsXMLOld($dom, $new_authrs);
                $retVal = mosBooklibraryImportExport::importBooksXML($catid, $dom, $new_categories,$new_authrs,$numversion);

            } // end if version > 2.0
            
        } // endif version in XML exist
        else { // ----- OLD VERSION------
            //exit;
            $st = $bookid = "";
            $begin = $end = $kol = 0;
            $book_list = $dom->getElementsByTagName('book');
            $associateSaveArr = array();
            for ($i = 0;$i < $book_list->length;$i++) {
                $book_class = new mosBookLibrary($database);
                $book = $book_list->item($i);
                //            echo $book_item->hasChildNodes() . "<br />";
                //get BookID
                $book_id = $book_class->bookid = 1 + $book_class->getMaxBookid(); 
                //mosBooklibraryImportExport::getXMLItemValue($book,'bookid');

                //get ISBN
                $book_isbn = $book_class->isbn = mosBooklibraryImportExport::getXMLItemValue($book, 'isbn');
                //get Title(book)
                $book_title = $book_class->title = mosBooklibraryImportExport::getXMLItemValue($book, 'title');
                //get Authors
                $book_authors = $book_class->authors = mosBooklibraryImportExport::getXMLItemValue($book, 'authors');
                //get Manufacturer
                $book_manufacturer = $book_class->manufacturer = mosBooklibraryImportExport::getXMLItemValue($book, 'manufacturer');
                //get releasedate
                $book_class->release_Date = mosBooklibraryImportExport::getXMLItemValue($book, 'releaseDate');
                //get hits
                $book_class->hits = mosBooklibraryImportExport::getXMLItemValue($book, 'hits');
                $book_class->user_name = mosBooklibraryImportExport::getXMLItemValue($book, 'user_name');
                //get rating
                $book_class->rating = mosBooklibraryImportExport::getXMLItemValue($book, 'rating');
                //get featured_clicks
                $book_class->featured_clicks = mosBooklibraryImportExport::getXMLItemValue($book, 'featured_clicks');
                //get featured_shows
                $book_class->featured_shows = mosBooklibraryImportExport::getXMLItemValue($book, 'featured_shows');
                //get price
                $book_class->price = mosBooklibraryImportExport::getXMLItemValue($book, 'price');
                if (substr($book_class->price, 0, 1) == "$") {
                    $book_class->price = substr($book_class->price, 1);
                    $book_class->priceunit = 'USD';
                }
                //get URL
                $book_class->URL = mosBooklibraryImportExport::getXMLItemValue($book, 'url');
                //get imageURL
                $book_class->imageURL = mosBooklibraryImportExport::getXMLItemValue($book, 'imageURL');
                //get edition
                $book_class->edition = mosBooklibraryImportExport::getXMLItemValue($book, 'edition');
                //get ebookURL
                $book_class->ebookURL = mosBooklibraryImportExport::getXMLItemValue($book, 'ebookURL');
                //get informationFrom
                $book_class->informationFrom = mosBooklibraryImportExport::getXMLItemValue($book, 
                    'informationFrom');
                //get date
                $book_class->date = mosBooklibraryImportExport::getXMLItemValue($book, 'date');
                //get comment
                $book_class->comment = mosBooklibraryImportExport::getXMLItemValue($book, 'comment');
                //get Categorie
                $book_class->categs = array($catid);
                //get Language
                $book_class->language = mosBooklibraryImportExport::getXMLItemValue($book, 'language');
                $book_class->langshow = mosBooklibraryImportExport::getXMLItemValue($book, 'langshow');
                if ($book_class->langshow == "") $book_class->langshow = "*";
                //get Comment for book (item Book Description)
                $book_class->comment = mosBooklibraryImportExport::getXMLItemValue($book, 'comment');
                 //get vm_id_product
                $book_class->vm_id_product = mosBooklibraryImportExport::getXMLItemValue($book, 'vm_id_product');
                //for output rezult in table
                if ($catid === null) {
                    //get associate_book
                    $book_class->associate_book = mosBooklibraryImportExport::getXMLItemValue($book, 
                        'associate_book');
                }
                $tmp[0] = $i;
                $tmp[1] = $book_id;
                $tmp[2] = $book_isbn;
                $tmp[3] = $book_title;
                $tmp[4] = $book_authors;
                $tmp[5] = $book_manufacturer;
                if (!$book_class->check()) {
                    $tmp[6] = $book_class->getError();
                    $retVal[$i] = $tmp;
                    unset($book_class);
                    continue;
                }
                $ussuesArray = array();
                $ussuesArray["associateBook"] = mosBooklibraryImportExport::getXMLItemValue($book, 
                    'associate_book');
                $ussuesArray["oldId"] = mosBooklibraryImportExport::getXMLItemValue($book, 'id');
                $ussuesArray["newId"] = $book_class->id;
                $associateSaveArr[] = $ussuesArray;
                if (!$book_class->store()) {
                    $tmp[6] = $book_class->getError();
                    $retVal[$i] = $tmp;
                    unset($book_class);
                    continue;
                } else {
                    $tmp[6] = "OK";
                    $book_class->saveCategs();
                }
                $book_class->checkin();
                //$book_class->updateOrder( "catid='$book_class->catid'" );
                $retVal[$i] = $tmp;
                //get Reviews
                if ($tmp[6] == "OK" 
                        && mosBooklibraryImportExport::getXMLItemValue($book, 'reviews') != "") {
                    $review_list = $book->getElementsByTagname('review');
                    for ($j = 0;$j < $review_list->length;$j++) {
                        $review = $review_list->item($j);
                        //get for review - fk_bookid == #__booklibrary.id
                        /*            $database->setQuery("SELECT id FROM #__booklibrary  ".
                        "\n WHERE isbn = '".$book_isbn."';");
                        $fk_bookid = $database->loadResult();*/
                        $fk_bookid = $book_class->id;
                        //get for review - fk_userid
                        $review_fk_userid = 
                        mosBooklibraryImportExport::getXMLItemValue($review, 'fk_userid');
                        //check - exist this user or not - if don't exist set he as anonymous
                        $database->setQuery("SELECT id 
                                             FROM #__users " . "\n 
                                             WHERE id = " . $review_fk_userid . ";");
                        $review_fk_userid = $database->loadResult();
                        if (!isset($review_fk_userid) || count($review_fk_userid) == 0) $review_fk_userid = 0;
                        //get for review - date
                        $review_date = 
                            mosBooklibraryImportExport::getXMLItemValue($review, 'date');
                        //get for review - rating
                        $review_rating = mosBooklibraryImportExport::getXMLItemValue($review, 'rating');
                        //get for review - title
                        $review_title = mosBooklibraryImportExport::getXMLItemValue($review, 'title');
                        //get for review - comment
                        $review_comment = mosBooklibraryImportExport::getXMLItemValue($review, 
                            'comment');
                        //insert data in table #__booklibrary_review
                        if (version_compare(JVERSION, "3.3.0", "ge")) {
                            $database->setQuery("INSERT INTO #__booklibrary_review " . "\n 
                                                (fk_bookid, fk_userid, date, rating, title, comment)" . "\n 
                                                VALUES " . "\n (" . $database->Quote($fk_bookid) . ", " . 
                                                $database->Quote($review_fk_userid) . ", '" . 
                                                $database->Quote($review_date) . "', " . 
                                                $database->Quote($review_rating) . ", '" . 
                                                $database->Quote($review_title) . "', '" . 
                                                $database->Quote($review_comment) . "');");
                        } else {
                            $database->setQuery("INSERT INTO #__booklibrary_review " . "\n 
                                               (fk_bookid, fk_userid, date, rating, title, comment)" . "\n 
                                               VALUES " . "\n (" . $fk_bookid . "," . 
                                                $review_fk_userid . ", '" . $review_date . "', " . 
                                                $review_rating . ", '" . $review_title . "', '" . 
                                                $review_comment . "');");
                        }
                        $database->execute();
                    } //end for(...) - REVIEW
                    
                }
            } //end for(...) - BOOK
            
        }
        if ($catid === null) {
            @mosBooklibraryImportExport::updateAssociateBook($associateSaveArr);
        }
        // print_r('OK');

        // print_r(':1111111111111111111:');
        //exit;
        unset($book_class);
        return $retVal;
    }
    //***********************************************************************************************
    //***********************   end add for import XML format   *************************************
    //***********************************************************************************************
    static function checkid($book_authors) {
        global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration, $database;
        $database->setQuery("SELECT id,authors_name FROM #__booklibrary_authors");
        $authors = $database->loadObjectList();
        for ($i = 0;$n = count($authors);$i++) {
            if ($authors[$i]->authors_name == $book_authors) {
                return $authors[$i]->id;
            }
        }
    }
    static function exportBooksXML($books, $cats = '') {
        /*
        // global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration, $database;
        // $strXmlDoc = "";
        // $strXmlDoc.= "<?xml version='1.0' encoding='utf-8' ?>\n";
        // $strXmlDoc.= "<data>\n";
        // $strXmlDoc.= "<version>" . $booklibrary_configuration['release']['version'] . "</version>\n";
        // $strXmlDoc.= "<books>\n";
        // //create and append list element
        // foreach($books as $book) {
        //     $strXmlDoc.= $book->toXML2();
        // }
        // //print_r($strXmlDoc);exit;
        // $strXmlDoc.= "</books>\n";
        // if ($cats != '') {
        //     $strXmlDoc.= "<categories>\n";
        //     foreach($cats as $cat) {
        //         $strXmlDoc.= "<category>\n";
        //         foreach($cat as $field => $value) {
        //             $strXmlDoc.= '<' . $field . '><![CDATA[' . $value . ']]></' . $field . ">\n";
        //         }
        //         $strXmlDoc.= "</category>\n";
        //     }
        //     $strXmlDoc.= "</categories>\n";
        // }
        // $strXmlDoc.= "</data>\n";
        // return $strXmlDoc;
        */
    }
    static function storeExportFile($data, $type) {
        global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration;
        $fileName = "booklibrary_" . date("Ymd_His");
        $fileBase = "/administrator/components/com_booklibrary/exports/";
        //echo 'PRINT : '.$mosConfig_absolute_path;exit;
        //write the xml file
        $fp = fopen($mosConfig_absolute_path . $fileBase . $fileName . ".xml", "w", 0); #open for writing
        fwrite($fp, $data); #write all of $data to our opened file
        fclose($fp); #close the file
        $InformationArray = array();
        $InformationArray['xml_file'] = $fileName . '.xml';
        $InformationArray['log_file'] = $fileName . '.log';
        $InformationArray['fileBase'] = "file://" . getcwd() . "/components/com_booklibrary/exports/";
        $InformationArray['urlBase'] = $mosConfig_live_site . $fileBase;
        $InformationArray['out_file'] = $InformationArray['xml_file'];
        $InformationArray['error'] = null;
        switch ($type) {
            case 'csv':
                $InformationArray['xslt_file'] = 'csv.xsl';
                $InformationArray['out_file'] = $fileName . '.csv';
                mosBooklibraryImportExport::transformPHP4($InformationArray);
            break;
            default:
            break;
        }
        return $InformationArray;
    }
    static function transformPHP4(&$InformationArray) {
        // create the XSLT processor^M
        $xh = xslt_create() or die("Could not create XSLT processor");
        // Process the document
        $result = xslt_process($xh, $InformationArray['fileBase'] . $InformationArray['xml_file'], 
                $InformationArray['fileBase'] . $InformationArray['xslt_file'], 
                $InformationArray['fileBase'] . $InformationArray['out_file']);
        if (!$result) {
            // Something croaked. Show the error
            $InformationArray['error'] = "Cannot process XSLT document: " ;
        }
        // Destroy the XSLT processor
        xslt_free($xh);
    }
    //////////  MY  ///////////////////////////////////////////////
    function wise_select_cat() {
        global $database;
        $fcnt = 0;
        $cnt = 0;
        $parenttmp = 0;
        $result = '';
        $reslt = '';
        $resrt = '';
        $reslt = "# Dump of category \n";
        $reslt.= "# Dump DATE : " . date("d-M-Y") . "\n\n\n";
        $query = "select * 
                  from #__booklibrary_main_categories 
                  where section = 'com_booklibrary' 
                  order by parent_id";
        try {
        $database->setQuery($query);
        $Rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        for ($i = 0;$i < count($Rows);$i++) {
            $reslt.= "INSERT INTO #__booklibrary_main_categories (";
            $resrt.= ") VALUES ('";
            while (list($key, $value) = each($Rows[$i])) {
                $reslt.= $key . ",";
                switch ($fcnt) //specialize params
                {
                    case 0:
                        $resrt.= "','";
                    break;
                    case 1:
                        $resrt.= "%|%','";
                    break;
                    default:
                        $value = addslashes($value);
                        $resrt.= $value . "','";
                    }
                    $fcnt++;
            }
            $reslt = substr($reslt, 0, -1);
            $resrt = substr($resrt, 0, -2);
            $resrt.= ")|%|\n";
            $result.= ($reslt . $resrt);
            $reslt = '';
            $resrt = '';
            $fcnt = 0;
        }
        return $result;
    }
    function wise_select_book() {
        global $database;
        $fcnt = 0;
        $cnt = 0;
        $parenttmp = 0;
        $result = '';
        $reslt = '';
        $resrt = '';
        $reslt = "# Dump of  \n";
        $reslt.= "# Dump DATE : " . date("d-M-Y") . "\n\n\n";
        $query = 'select * from #__booklibrary order by id';
        try {
        $database->setQuery($query);
        $Rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        for ($i = 0;$i < count($Rows);$i++) {
            $reslt.= "INSERT INTO #__booklibrary (";
            $resrt.= ") VALUES ('";
            while (list($key, $value) = each($Rows[$i])) {
                $reslt.= $key . ",";
                switch ($fcnt) {
                    case 0:
                        $resrt.= "','";
                    break;
                    case 2:
                        $resrt.= "%|%','";
                    break;
                    default:
                        $resrt.= $database->getEscaped($value) . "','";
                }
                $fcnt++;
            }
            $reslt = substr($reslt, 0, -1);
            $resrt = substr($resrt, 0, -2);
            $resrt.= ")|%|\n";
            $result.= ($reslt . $resrt);
            $reslt = '';
            $resrt = '';
            $fcnt = 0;
        }
        return $result;
    }
    function select_catid() {
        global $database;
        $str = '';
        $c = 0;
        $i = 0;
        $query = 'select catid from #__booklibrary order by id';
        try {
        $database->setQuery($query);
        $Rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $arr = array();
        $arr = array_values($Rows);
        for ($i = 0;$i < count($Rows);$i++) {
            list($key, $value) = each($Rows[$i]);
            $arr[$c] = $value;
            $c++;
        }
        for ($i = 0;$i < count($arr);$i++) {
            $tmp = $arr[$i];
            $str.= $tmp . "::";
        }
        return substr($str, 0, -2);
    }
    function select_linked() {
        global $database;
        $str = '';
        $c = 0;
        $i = 0;
        $query = 'select id, parent_id from #__booklibrary_main_categories 
                 where section = "com_booklibrary" order by parent_id';
        try {
        $database->setQuery($query);
        $Rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $arr = array();
        for ($i = 0;$i < count($Rows);$i++) {
            list($key, $value) = each($Rows[$i]);
            $arr[$c][0] = $value;
            list($key, $value) = each($Rows[$i]);
            $arr[$c][1] = $value;
            $c++;
        }
        for ($i = 0;$i < count($arr);$i++) {
            $tmp0 = $arr[$i][0];
            $tmp1 = $arr[$i][1];
            $str.= $tmp0 . "::" . $tmp1 . "::";
        }
        return substr($str, 0, -2);
    }
    //************   begin add for 'MySQL tables import/export' #__booklibrary_review   **********
    function wise_select_review() {
        global $database;
        $fcnt = 0;
        $cnt = 0;
        $parenttmp = 0;
        $result = '';
        $reslt = '';
        $resrt = '';
        $reslt = "# Dump of  \n";
        $reslt.= "# Dump DATE : " . date("d-M-Y") . "\n\n\n";
        $query = 'select * from #__booklibrary_review order by id';
        try {
        $database->setQuery($query);
        $Rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        for ($i = 0;$i < count($Rows);$i++) {
            $reslt.= "INSERT INTO #__booklibrary_review (";
            $resrt.= ") VALUES ('";
            while (list($key, $value) = each($Rows[$i])) {
                $reslt.= $key . ",";
                switch ($fcnt) {
                    case 1:
                        $resrt.= "','";
                    break;
                    default:
                        $resrt.= $database->getEscaped($value) . "','";
                }
                $fcnt++;
            }
            $reslt = substr($reslt, 0, -1);
            $resrt = substr($resrt, 0, -2);
            $resrt.= ")|%|\n";
            $result.= ($reslt . $resrt);
            $reslt = '';
            $resrt = '';
            $fcnt = 0;
        }
        return $result;
    }
    function load_isbn() {
        global $database;
        $result = '';
        $result = "# Dump of  \n";
        $result.= "# Dump DATE : " . date("d-M-Y") . "\n\n\n";
        $query = 'SELECT review.id,book.isbn FROM #__booklibrary_review AS review, 
                  #__booklibrary AS book WHERE review.fk_bookid=book.id;';
        try {
        $database->setQuery($query);
        $rows = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        for ($i = 0;$i < count($rows);$i++) {
            if ($i == 0) {
                $result.= "::" . $rows[$i]->id . "::" . $rows[$i]->isbn . "::";
            } else {
                $result.= $rows[$i]->id . "::" . $rows[$i]->isbn . "::";
            }
        }
        return $result;
    }
    //***********   end add for 'MySQL tables import/export' #__booklibrary_review   *************
    function entire_export() {
        global $mosConfig_absolute_path, $mosConfig_live_site;
        $cats = mosBooklibraryImportExport::wise_select_cat();
        $books = mosBooklibraryImportExport::wise_select_book();
        $reviews = mosBooklibraryImportExport::wise_select_review();
        $id_isbn = mosBooklibraryImportExport::load_isbn();
        $sarr = mosBooklibraryImportExport::select_catid();
        $carr = mosBooklibraryImportExport::select_linked();
        $fileName = "booklibrary_full_backup_" . date("Ymd_His") . ".dat";
        $fileBase = "/administrator/components/com_booklibrary/exports/";
        $file_path = $mosConfig_absolute_path . $fileBase . $fileName;
        $fp = fopen($file_path, "w");
        fwrite($fp, $books . "\n\n###CAT\n\n" . $cats . "\n\n###" . $sarr . "\n\n###" . $carr . 
                             "\n\n###REVIEW\n\n" . $reviews . "\n\n###ISBN\n\n" . $id_isbn);
        fclose($fp);
        $InformationArray = array();
        $InformationArray['out_file'] = $fileName;
        $InformationArray['urlBase'] = $mosConfig_live_site . $fileBase;
        $InformationArray['error'] = null;
        return $InformationArray;
    }
    //////////////  IMPORT  ////////////////
    function import_cat($whole, $supp_file) {
        global $database;
        $tmparr = array();
        $cont = explode('|%|', $whole);
        $arr = mosBooklibraryImportExport::load_arr($supp_file);
        for ($i = 0;$i < count($cont);$i++) {
            $strquer = substr($cont[$i], strpos($cont[$i], "INSERT"));
            if (substr($strquer, 0, 6) == "INSERT") {
                if ($arr[$i][1] == 0) {
                    $strquer = str_replace('%|%', '0', $strquer);
                } else {
                    $tmp_ind = mosBooklibraryImportExport::search_in_arr($arr[$i][1], $arr);
                    $strquer = str_replace('%|%', $tmparr[$tmp_ind], $strquer);
                }
                try {
                $database->setQuery($strquer);
                $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                $tmparr[$i] = $database->insertid();
                $arr[$i][1] = $tmparr[$i];
            }
        }
        return $arr;
    }
    function search_in_arr($search, $arr) {
        for ($i = 0;$i < count($arr);$i++) {
            if ($arr[$i][0] == $search) return $i;
        }
        return 0;
    }
    function load_arr($whole) {
        $arr = array();
        $cont = explode('::', $whole);
        for ($i = 0;$i < count($cont) / 2;$i++) {
            $arr[$i][0] = $cont[$i * 2];
            $arr[$i][1] = $cont[$i * 2 + 1];
        }
        return $arr;
    }
    function load_catid($whole) {
        $arr = array();
        $cont = explode('::', $whole);
        for ($i = 0;$i < count($cont);$i++) $arr[$i] = $cont[$i];
        return $arr;
    }
    function import_book($whole, $supp_file, $arr) {
        global $database;
        $ctidarr = mosBooklibraryImportExport::load_catid($supp_file);
        $cont = explode('|%|', $whole);
        for ($i = 0;$i < count($cont);$i++) {
            $strquer = substr($cont[$i], strpos($cont[$i], "INSERT"));
            if (substr($strquer, 0, 6) == "INSERT") {
                $tmp_ind = mosBooklibraryImportExport::search_in_arr($ctidarr[$i], $arr);
                $strquer = str_replace('%|%', $arr[$tmp_ind][1], $strquer);
                try {
                $database->setQuery($strquer);
                $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
            }
        }
        return "";
    }
    function import_review($review, $isbn) {
        global $database; //$pc[4]=review,$pc[5]=isbn
        //select new bookid for review
        $query = 'SELECT id,isbn FROM #__booklibrary;';
        $database->setQuery($query);
        $rows = $database->loadObjectList();

        $query = 'SELECT id FROM #__users;';
        try {
        $database->setQuery($query);
        $users = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        $st = $isbn;
        $tmp = explode('::', $isbn);
        $mas = "";
        for ($i = 1;$i < count($tmp) - 1;$i++) {
            for ($j = 0;$j < count($rows);$j++) {
                if ($tmp[$i] == $rows[$j]->isbn) $mas.= $rows[$j]->id . "::";
            }
        }
        //new fk_bookid = $mas[$i]
        $mas = explode('::', $mas); //potom -- 'count($mas)-1'//in $mas = new id for #__booklibrary
        $st = $review;
        $kol = strlen($st);
        $st = substr($st, strpos($st, "INSERT"), $kol);
        $insert = ""; 
        for ($i = 0;$i < count($mas) - 1;$i++) {
            $k = strpos($st, "|%|");
            $insert = substr($st, strpos($st, "INSERT"), $k);
            $insert_1 = substr($insert, strpos($insert, "INSERT"), strpos($insert, ",'',"));
            $insert_2 = substr($insert, strpos($insert, ",'',") + 4, strlen($insert));
            //insert user
            $usr = substr($insert, strpos($insert, ",'',") + 4, strlen($insert));
            //$usr_1 == number user id old from file .dat
            $usr_1 = substr($usr, strpos($usr, "'") + 1, strpos($usr, "','") - 1);
            $usr_1 = (int)$usr_1;
            $status = false;
            for ($j = 0;$j < count($users);$j++) {
                if ($users[$j]->id == $usr_1) $status = true;
            }
            if ($status) {
                $zapros = $insert_1 . ",'" . $mas[$i] . "'," . $insert_2;
            } else {
                $usr_2 = substr($usr, strpos($usr, ",'"), strlen($usr));
                $zapros = $insert_1 . ",'" . $mas[$i] . "','0'" . $usr_2;
            }
            $query = $zapros . ";";
            try {
            $database->setQuery($query);
            @$kuku = $database->loadResult();
            } catch (RuntimeException $e) {
                echo $e->getMessage();
            }
            $kol = strlen($st);
            $st = substr($st, $k + 4, $kol);
        }
        return "";
    }
    static function remove_info() {
        global $database;

        try {
        $database->setQuery('truncate #__booklibrary_authors');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_authors_connect');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery("delete from #__booklibrary_main_categories 
                             where section='com_booklibrary'");
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        try {
        $database->setQuery('truncate #__booklibrary_review');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_categories');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_files');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_audio_source');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_track_source');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        try {
        $database->setQuery('truncate #__booklibrary_video_source');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        try {
        $database->setQuery('truncate #__booklibrary_lend');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        try {
        $database->setQuery('truncate #__booklibrary_lend_request');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        try {
        $database->setQuery('truncate #__booklibrary_suggestion');
        $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        return "";
    }
    function entire_import($file) {
        global $mosConfig_absolute_path;
        $ret = mosBooklibraryImportExport::remove_info();
        if ($ret != "") return;
        $fp = fopen($file, "r");
        $whole = fread($fp, filesize($file));
        $pc = array();
        $pc = explode('###', $whole);
        $urr = mosBooklibraryImportExport::import_cat(trim($pc[1]), trim($pc[3]));
        if (!is_array($urr)) return;
        $ret = mosBooklibraryImportExport::import_book(trim($pc[0]), trim($pc[2]), $urr);
        //$pc[4]=review,$pc[5]=isbn
        $ret = mosBooklibraryImportExport::import_review(trim($pc[4]), trim($pc[5]));
        if ($ret == "") echo "<h2 style='color:#0f0;'>OK</h2>";
    }
}
