<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Pro
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
    
include_once ( /* dirname(__FILE__) */
JPATH_COMPONENT_SITE . '/compat.joomla1.5.php');
include_once ( /* dirname(__FILE__) */
JPATH_COMPONENT_SITE . '/functions.php');

$GLOBALS['bl_state'] = $bl_state = checkBlActivation() ;

use Joomla\CMS\Plugin\PluginHelper; //need for trigger events to finder for smart search plugin

jimport('joomla.filesystem.folder');
// load language
$languagelocale = "";
$database->setQuery("SELECT title, lang_code FROM #__booklibrary_languages");
$languages = $database->loadObjectList();
$lang = JFactory::getLanguage();
foreach($lang->getLocale() as $locale) {
    foreach($languages as $language) {
        if (strtolower($locale) == strtolower($language->title) || 
            strtolower($locale) == strtolower($language->lang_code)) {
            $mosConfig_lang = $locale;
            $languagelocale = $language->lang_code;
            break;
        }
    }
}
if ($languagelocale == '') $languagelocale = "en-GB";
$query = "SELECT c.const, cl.value_const ";
$query.= "FROM #__booklibrary_const_languages as cl ";
$query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
$query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id ";
$query.= "WHERE l.lang_code = '$languagelocale'";
$database->setQuery($query);
$langConst = $database->loadObjectList();
foreach($langConst as $item) {
    define($item->const, $item->value_const);
}
$my = $GLOBALS['my'];

$css = $mosConfig_live_site . 
'/administrator/components/com_booklibrary/admin_booklibrary.css';
$mainframe = JFactory::getApplication();
jimport('joomla.html.pagination');
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/booklibrary.html.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.language.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.lend.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.lend_request.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.authors.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.main.categories.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.ws.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.impexp.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.conf.php");
if (version_compare(JVERSION, "4.0.0", "ge")) {
    require_once ($mosConfig_absolute_path . 
        "/administrator/components/com_content/src/Field/Modal/ArticleField.php");
    JFactory::getDocument()->addStyleSheet($mosConfig_live_site . 
        '/administrator/components/com_booklibrary/admin_booklibrary.css');
    JFactory::getDocument()->addStyleSheet($mosConfig_live_site . 
        '/administrator/components/com_booklibrary/admin_booklibrary_j4.css');
} else {
    require_once ($mosConfig_absolute_path . 
        "/administrator/components/com_content/models/fields/modal/article.php");
    JFactory::getDocument()->addStyleSheet($mosConfig_live_site . 
        '/administrator/components/com_booklibrary/admin_booklibrary.css');
}
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.article.php");

$GLOBALS['booklibrary_configuration'] = $booklibrary_configuration;
$GLOBALS['database'] = $database;
$GLOBALS['my'] = $my;
$GLOBALS['mosConfig_absolute_path'] = $mosConfig_absolute_path;
$table_prefix = $database->getPrefix(); 
$GLOBALS['table_prefix'] = $table_prefix;
$jinput = JFactory::getApplication()->input;
$GLOBALS['task'] = $task = $jinput->get('task', '', 'RAW');

$GLOBALS['option'] = $option = mosGetParam($_REQUEST, 'option', 'com_booklibrary');
global $mosConfig_lang;
$cls_path = $mosConfig_absolute_path . "/components/com_booklibrary/booklibrary.class.php";
require_once ($cls_path);

require_once ($mosConfig_absolute_path . 
        "/administrator/components/com_booklibrary/toolbar.booklibrary.php");

$bid = mosGetParam($_POST, 'bid', array(0),'ARRAY'); 
if ($task == 'edit' or 'edit_author' && $bid[0] == 0) {
    if (!empty($_GET['bid'])) $bid = $_GET['bid'];
}
$section = mosGetParam($_REQUEST, 'section', 'courses');

// --------------- Debug mode ----------------
$booklibrary_configuration['debug'] = 0;
if ($booklibrary_configuration['debug'] == '1') {
    echo "Task: " . $task . "<br />";
    print_r($_POST);
    echo "<hr>";
    print_r($_GET);
    echo "<hr /><br />";
    echo $task;
    exit;
}
// --------------------------------------------
// print_r($task);exit;
if (isset($section) && $section == 'categories') {
    switch ($task) {
        case "edit":
            editCategory($option, $bid[0]);
        break;
        case "add": 
            editCategory($option, 0);
        break;
        case "cancel":
            cancelCategory();
        break;
        case "apply":
        case "save":
            saveCategory($task);
        break;
        case "remove":
            removeCategories($option, $bid);
        break;
        case "publish":
            publishCategories("com_booklibrary", $id, $bid, 1);
        break;
        case "unpublish":
            publishCategories("com_booklibrary", $id, $bid, 0);
        break;
        case "orderup":
            orderCategory($bid[0], -1);
        break;
        case "orderdown":
            orderCategory($bid[0], 1);
        break;
        case "accesspublic":
            accessCategory($bid[0], 0);
        break;
        case "accessregistered":
            accessCategory($bid[0], 1);
        break;
        case "accessspecial":
            accessCategory($bid[0], 2);
        break;
        case "show":
        default:
            showCategories($option);
    }
} elseif ((isset($section)) && ($section == 'language_manager')) {
    switch ($task) {
        case "edit":
            editLanguageManager($option, $bid[0]);
        break;
        case "cancel":
            cancelLanguageManager();
        break;
        case "save":
            saveLanguageManager();
        break;
        default:
            showLanguageManager($option);
        break;
    }
} else {
    switch ($task) {

        case "categories":
            echo "now work $section=='categories , this part not work";
            exit;
            mosRedirect("index.php?option=categories&extension=com_booklibrary");
        break;


        case "randNumber":
            randNumber();
        break;
        case "show_all":
            unsetCatId();
        break;
        case "article":
            modalArticle($option);
        break;
        case "show_import_export":
            importExportBooks($option);
        break;
        case "import":
            import($option);
        break;
        case "export":
            export($option);
        break;
        case "config_frontend":
            configure_frontend($option);
        break;
        case "config_backend":
            configure_backend($option);
        break;
        case "config_save_frontend":
            configure_save_frontend($option);
        break;
        case "config_save_backend":
            configure_save_backend($option);
        break;        
            //***************   begin for manage authors   ***********************
        case "apply_author":
        case "save_author":
            saveAuthor($option, $task);
        break;        
       case "add_author": 
            editAuthor($option, 0);
        break;
        case "edit_author":
            editAuthor($option, array_pop($bid));
        break;
        case "manage_author":
            manageAuthor($option);
        break;
        case "publish_manage_author":
            publish_manage_author($bid, 1, $option);
        break;
        case "unpublish_manage_author":
            publish_manage_author($bid, 0, $option);
        break;

        case "clone_author":
            cloneAuthor($bid, $option);
        break;                
            //***************   end for manage authors   ***********************
 
            //***************   begin for manage book   ***********************
        case "add": 
            editBook($option, 0);
        break;
        case "edit":
            editBook($option, array_pop($bid));
        break;        
        case "remove":
            if (mosGetParam($_POST, 'author') == 1) {
                removeAuthor($bid, $option);
            } else {
                removeBooks($bid, $option);
            }
        break;
        case "clone_book":
            cloneBook($bid, $option);
        break;        
        case "refetchInfos":
            refetchInfo($option, $bid);
        break;
        case "apply":
        case "save":
            //print_r("2222222222");exit();
            saveBook($option, $task);
        break;
        case "publish":
            publishBooks($bid, 1, $option);
        break;
        case "unpublish":
            publishBooks($bid, 0, $option);
        break;
        case "approve":
            ApproveBooks($bid, 1, $option);
        break;
        case "unapprove":
            ApproveBooks($bid, 0, $option);
        break;
        case "cancel":
            cancelBook($option);
        break;
        case "bookorderdown":
            orderBooks($bid[0], 1, $option);
        break;
        case "bookorderup":
            orderBooks($bid[0], -1, $option);
        break;        
            //***************   end for manage book   ***********************
            //***************   begin for manage reviews   ***********************
        case "publish_manage_review":
            publish_manage_review($bid[0], 1, $option);
        break;
        case "unpublish_manage_review":
            publish_manage_review($bid[0], 0, $option);
        break;            
        case "manage_review":
            manage_review_s($option, "");
        break;
        case "delete_manage_review":
            delete_manage_review($option, $bid);
            manage_review_s($option, "");
        break;
        case "edit_manage_review":
            edit_manage_review($option, $bid);
        break;
        case "update_edit_manage_review":
            $title = mosGetParam($_POST, 'title');
            $comment = mosGetParam($_POST, 'comment');
            $rating = mosGetParam($_POST, 'rating');
            $book_id = mosGetParam($_POST, 'book_id');
            $review_id = mosGetParam($_POST, 'review_id');
            update_review($title, $comment, $rating, $review_id);
            manage_review_s($option, "");
        break;
        case "cancel_edit_manage_review":
            manage_review_s($option, "");
        break;
        case "sorting_manage_review_numer":
            manage_review_s($option, "review_id");
        break;
        case "sorting_manage_review_isbn":
            manage_review_s($option, "isbn");
        break;
        case "sorting_manage_review_title_book":
            manage_review_s($option, "title_book");
        break;
        case "sorting_manage_review_title_catigory":
            manage_review_s($option, "title_catigory");
        break;
        case "sorting_manage_review_title_review":
            manage_review_s($option, "title_review");
        break;
        case "sorting_manage_review_user_name":
            manage_review_s($option, "user_name");
        break;
        case "sorting_manage_review_date":
            manage_review_s($option, "date");
        break;
        case "sorting_manage_review_rating":
            manage_review_s($option, "rating");
        break;
        case "sorting_manage_review_approve":
            manage_review_s($option, "published");
        break;

        case "delete_review":
            $ids = explode(',', $bid[0]);
            delete_review($option, $ids[1]);
            editBook($option, $ids[0]);
        break;
        case "edit_review":
            $ids = explode(',', $bid[0]);
            edit_review($option, $ids[1], $ids[0]);
        break;
        case "update_review":
            $title = mosGetParam($_POST, 'title');
            $comment = mosGetParam($_POST, 'comment');
            $rating = mosGetParam($_POST, 'rating');
            $book_id = mosGetParam($_POST, 'book_id');
            $review_id = mosGetParam($_POST, 'review_id');
            update_review($title, $comment, $rating, $review_id);
            editBook($option, $book_id);
        break;
        case "cancel_review_edit":
            $book_id = mosGetParam($_POST, 'book_id');
            editBook($option, $book_id);
        break;        
            //***************   end for manage reviews   *************************
            //**********   begin for manage suggestion   *************************
            
        case "manage_suggestion":
            manage_suggestion($option);
        break;
        case "delete_suggestion":
            delete_suggestion($option, $bid);
            manage_suggestion($option);
        break;
        case "view_suggestion":
            $bid = mosGetParam($_POST, 'bid');
            view_suggestion($option, $bid);
        break;
            //**********   end for manage suggestion   ***************************
            
            //**********   start for manage lend   ***************************
        case "lend":
            if (mosGetParam($_POST, 'save') == 1) {
                saveLend($option, $bid);
            } else {
                lend($option, $bid);
            }
        break;
        case "lend_requests":
            lend_requests($option, $bid);
        break;
        case "users_lend_history":
             users_lend_history($option, $bid, "title");
        break;   
       case "lend_history":
            lend_history($option, $bid);
        break;
        
        case "accept_lend_requests":
            accept_lend_requests($option, $bid);
        break;
        case "decline_lend_requests":
            decline_lend_requests($option, $bid);
        break;
        case "about":
            HTML_booklibrary::about();
        break;
        case "show_info":
            showInfo($option, $bid);
        break;
        case "lend_return":
            if (mosGetParam($_POST, 'save') == 1) {
                saveLend_return($option, $bid);
            } else {
                lend_return($option, $bid);
            }
        break;
        case "edit_lend":
            if (mosGetParam($_POST, 'save') == 1) {
                if (count($bid) > 1) {
                    echo "<script> alert('You must select only one item for edit'); 
                          window.history.go(-1); </script>\n";
                    exit();
                }
                saveLend($option, $bid, "edit_lend");
            } else {
                edit_lend($option, $bid);
            }
        break;
		case "sorting_userlend_book_id":
            users_lend_history($option, $bid, "bookid");
        break;
        case "sorting_userlend_book_title":
            users_lend_history($option, $bid, "title");
        break;
        case "sorting_userlend_lendfrom":
            users_lend_history($option, $bid, "lend_from");
        break;
        case "sorting_userlend_lenduntil":
            users_lend_history($option, $bid, "lend_until");
        break;
        case "sorting_userlend_returnmedia":
            users_lend_history($option, $bid, "lend_return");
        break;
        case "sorting_userlend_email":
            users_lend_history($option, $bid, "user_email");
        break;
            //**********   end for manage lend   ***************************



            //******   begin add for button print in Manager Books   ***********
            
        case "print_books":
            print_books($option);
            showBooks($option);
        break;
        case "print_item":
            print_item($option);
        break;
            //******   end add for button print in Manager Books   *************

    case "check_package_state":
        $state = checkBlState();
        print_r($state);exit();
        break ;


    case "set_package_license":
        $data = protectInjectionWithoutQuote('data', '', 'string');
        setBlLicense($data);
    
        default:
            showBooks($option);
        break;
    }
}
/*
* CAT_Utils Class
*/
class CAT_Utils {
    static function categoryArray() {
        global $database;
        // get a list of the menu items
        $query = "SELECT c.*, c.parent_id AS parent" . 
         "\n FROM #__booklibrary_main_categories c" . 
         "\n WHERE section='com_booklibrary'" . 
         "\n AND published <> -2" . 
         "\n ORDER BY ordering";
        $database->setQuery($query);
        $items = $database->loadObjectList();
        if ($items == null) echo "<strong 
                                  style='color:red' > Please create categories for Book Library first!
                                  </strong>";
        // establish the hierarchy of the menu
        $children = array();
        // first pass - collect children
        foreach($items as $v) {
            $pt = $v->parent;
            $list = @$children[$pt] ? $children[$pt] : array();
            array_push($list, $v);
            $children[$pt] = $list;
        }
        // second pass - get an indent list of the items
        $array = bookLibraryTreeRecurse(0, '', array(), $children); 
        return $array;
    }
}
/**
 * HTML Class
 * Utility class for all HTML drawing classes
 * @desc class General HTML creation class. We use it for back/front ends.
 */
class HTML {
    // TODO :: merge categoryList and categoryParentList
    // add filter option ?
    function categoryList($id, $action, $options = array()) {
        $list = CAT_Utils::categoryArray();
        // assemble menu items to the array
        foreach($list as $item) {
            $options[] = mosHTML::makeOption($item->id, $item->treename);
        }
        $parent = mosHTML::selectList($options, 'catid', 'id="catid" class="inputbox" 
            size="1" onchange="' . $action . '"', 'value', 'text', $id);
        return $parent;
    }
    static function categoryParentList($id, $action, $is_new, $options = array()) {
        global $database;
        $list = CAT_Utils::categoryArray();
        $cat = new mainBooklibraryCategories($database); 
        $cat->load($id);
        $this_treename = '';
        $childs_ids = Array();
        foreach($list as $item) {
            if ($item->id == $cat->id || array_key_exists($item->parent_id, $childs_ids)) 
        $childs_ids[$item->id] = $item->id;
        }
        foreach($list as $item) {
            if ($this_treename) {
                if ($item->id != $cat->id && strpos($item->treename, $this_treename) === false && 
          array_key_exists($item->id, $childs_ids) === false) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                }
            } else {
                if ($item->id != $cat->id) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                } else {
                    $this_treename = "$item->treename/";
                }
            }
        }
        $parent = null;
        $parent = mosHTML::selectList($options, 'parent_id', 
            'class="inputbox edit_cat_select" size="1"', 
        'value', 'text', $cat->parent_id);
        return $parent;
    }
    /*
    * function imageList ()
    */
    static function imageList($name, &$active, $javascript = null, $directory = null) {
        global $mosConfig_absolute_path;
        if (!$javascript) {
            $javascript = "onchange=\"javascript:if (document.adminForm." . $name . 
              ".options[selectedIndex].value!='')    " . 
              "{document.imagelib.src='../images/stories/' + document.adminForm." . $name . 
              ".options[selectedIndex].value} else  
             {document.imagelib.src='../components/com_booklibrary/images/no-img_eng.gif'}\"";
        }
        if (!$directory) {
            $directory = '/images/stories';
        }
        // inserted by Wonderer
        if (!file_exists($mosConfig_absolute_path . $directory)) {
            @mkdir($mosConfig_absolute_path . $directory, 0777) 
      or die("Error of directory creating: [" . $mosConfig_absolute_path . $directory . "] ");
        } else {
        }
        // --
        $imageFiles = mosReadDirectory($mosConfig_absolute_path . $directory);
        $images = array(mosHTML::makeOption('', _BOOKLIBRARY_A_SELECT_IMAGE));
        foreach($imageFiles as $file) {
            if (preg_match("/bmp|gif|jpeg|jpg|png/i", $file)) {
                $images[] = mosHTML::makeOption($file);
            }
        }
        $images = mosHTML::selectList($images, $name, 'id="' . $name . 
        '" class="inputbox edit_cat_select" size="1" ' . $javascript, 'value', 'text', $active);
        return $images;
    }
}
/*
* function bookLibraryTreeRecurse ()
* Redefines a standard function to not display &nbsp;
*/
function publish_manage_review($bid, $publish, $option) {
    global $database;
    $database->setQuery("UPDATE #__booklibrary_review SET published = $publish WHERE id  = $bid ");
    $database->execute();

    mosRedirect("index.php?option=$option&task=manage_review");
}
function bookLibraryTreeRecurse($id, $indent, $list, &$children, $maxlevel = 9999, 
        $level = 0, $type = 1, $parents_list = '') {
    if (@$children[$id] && $level <= $maxlevel) {
        $parent_id = $id;
        foreach($children[$id] as $v) {
            $id = $v->id;
            if ($type) {
                $pre = 'L ';
                $spacer = '.      ';
                $parent_item = $parent_id;
            } else {
                $pre = '- ';
                $spacer = '  ';
            }
            if ($v->parent == 0) {
                $txt = $v->name;
            } else {
                $txt = $pre . $v->name;
            }
            $pt = $v->parent;
            $list[$id] = $v;
            $list[$id]->level = $level;
            $list[$id]->parents_list = $parents_list;
            $list[$id]->treename = "$indent$txt";
            $list[$id]->children = (isset($children[$id]) && is_array($children[$id])) ? count(@$children[$id]) : 0;
                $list[$id]->all_fields_in_list = count(@$children[$parent_id]);
            $list = bookLibraryTreeRecurse($id, $indent . $spacer, $list,
             $children, $maxlevel, $level + 1, $type, $parents_list." ".$parent_item);
        }
    }
    return $list;
}
function showCategories($option) {
    global $database, $my, $option, $menutype, $mainframe, $mosConfig_list_limit, $acl, $option;
    $grooups = get_group_children_bl();
    $section = "com_booklibrary";
    $sectionid = $mainframe->getUserStateFromRequest("sectionid{$section}{$section}", 'sectionid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$section}limitstart", 'limitstart', 0);
    $levellimit = $mainframe->getUserStateFromRequest("view{$option}limit$menutype", 
        'levellimit', 10);
    $langshow_filter = $mainframe->getUserStateFromRequest("langshow_filter{$option}", 
        'langshow_filter', '*');
    
    if ($langshow_filter != '*') {
        $lang = " AND c.language='$langshow_filter'";
    } else {
        $lang = '';
    }
    $query = "SELECT  c.*, c.checked_out as checked_out_contact_category, c.parent_id as parent, 
                      c.params, u.name AS editor, COUNT(bc.id) AS cc" . 
            "\n FROM #__booklibrary_main_categories AS c" . 
            "\n LEFT JOIN #__booklibrary_categories as bc ON bc.catid=c.id" . 
            "\n LEFT JOIN #__users AS u ON u.id = c.checked_out" . 
            "\n WHERE c.section='$section' $lang" . 
            "\n GROUP BY c.id " . 
            "\n ORDER BY parent_id DESC, ordering";
    try {
    $database->setQuery($query);
    $rows = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    foreach($rows as $k => $v) {
        $rows[$k]->ncourses = 0;
        foreach($rows as $k1 => $v1) {
            if ($v->id == $v1->parent) $rows[$k]->cc+= $v1->cc;
        }
        ($rows[$k]->cc == 0) ? "-" : "<a href=\"?option=com_booklibrary&section=book&catid=" . 
    $v->id . "\">" . ($v->cc) . "</a>"; 
        $curgroup = array();
        $ss = explode(',', $v->params);
        foreach($ss as $s) {
            if ($s == '') $s = '-2';
            $curgroup[] = $grooups[$s];
        }
        $rows[$k]->groups = implode(', ', $curgroup);
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    // if ($database->getErrorNum()) {
    
    //     echo $database->stderr();
    //     return false;
    // }
    // // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }

    $date = strtotime(JFactory::getDate()->toSQL());
    foreach($rows as $row) {
        if( !isset($row->checked_out_time) ) continue ;
        $check = strtotime($row->checked_out_time);
        $remain = ($check + 7200) - $date;
        if (($remain <= 0) && ($row->checked_out != 0)) {
            $database->setQuery("UPDATE #__booklibrary 
                                 SET checked_out=0,checked_out_time=0 
                                 WHERE id='" . $row->id . "'");
            $database->execute();
        }
    }

    // second pass - get an indent list of the items
    $list = bookLibraryTreeRecurse(0, '', array(), $children, max(0, $levellimit - 1));
    $total = count($list);
    $pageNav = new JPagination($total, $limitstart, $limit); 
    $levellist = mosHTML::integerSelectList(1, 20, 1, 'levellimit', 'size="1" 
        onchange="document.adminForm.submit();"', $levellimit);
    // slice out elements based on limits
    $list = array_slice($list, $pageNav->limitstart, $pageNav->limit);
    $count = count($list);
    // get list of sections for dropdown filter
    $javascript = 'onchange="document.adminForm.submit();"';
    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All languages');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow_filter = mosHTML::selectList($languages_row, 'langshow_filter', 
        'class="inputbox selectcat" 
        onchange="document.adminForm.submit();", size="1"', 'value', 'text', $langshow_filter);
    HTML_Categories::show($list, $my->id, $pageNav, $lists, 'other', $langshow_filter);
}
function editCategory($section = '', $uid = 0) {
    global $database, $my, $acl;
    global $mosConfig_absolute_path, $mosConfig_live_site;
    $type = mosGetParam($_REQUEST, 'type', '');
    $redirect = mosGetParam($_POST, 'section', '');
    $row = new mainBooklibraryCategories($database); 
    // load the row from the db table
    $row->load($uid);
    // fail if checked out not by 'me'
    if ($row->checked_out && $row->checked_out <> $my->id) {
        mosRedirect('index.php?option=com_booklibrary&task=categories', 'The category ' . $row->title . 
          ' is currently being edited by another administrator');
    }
    $is_new = false;

    if ($uid) {
        // existing record
        $row->checkout($my->id);
        // code for Link Menu
        
    } else {
        $is_new = true;
        // new record
        $row->section = $section;
        $row->published = 1;
    }

    

    function createAssociateArray($row, $database) {
        $associateArray = array();
        if ($row->id) {
            $query = "SELECT lang_code 
                      FROM `#__languages` 
                      WHERE 1";
            $database->setQuery($query);
            $allLanguages = $database->loadColumn();
            $query = "SELECT id,language,title 
                      FROM `#__booklibrary_main_categories` 
                      WHERE 1";
            $database->setQuery($query);
            $allInCategories = $database->loadObjectlist();
            $query = "select associate_category 
                      from `#__booklibrary_main_categories` 
                      where id =" . $row->id;
            $database->setQuery($query);
            $categoryAssociateCategory = $database->loadResult();
            if (!empty($categoryAssociateCategory)) {
                $categoryAssociateCategory = unserialize($categoryAssociateCategory);
            } else {
                $categoryAssociateCategory = array();
            }
            foreach($allLanguages as & $oneLang) {
                $associate_category = array();
                $associate_category[] = mosHtml::makeOption(0, 'select');
                $i = 0;
                foreach($allInCategories as & $oneCat) {
                    if ($oneLang == $oneCat->language && $oneCat->id != $row->id) {
                        $associate_category[] = mosHtml::makeOption(($oneCat->id), $oneCat->title);
                    }
                }
                if ($row->language != $oneLang) {
                    $associate_category_list = mosHTML::selectList($associate_category, 
                        'language_associate_category', 'class="inputbox edit_cat_select" size="1"', 
                        'value', 'text', "");
                } else {
                    $associate_category_list = null;
                }
                $associateArray[$oneLang]['list'] = $associate_category_list;
                if (isset($categoryAssociateCategory[$oneLang])) {
                    $associateArray[$oneLang]['assocId'] = $categoryAssociateCategory[$oneLang];
                } else {
                    $associateArray[$oneLang]['assocId'] = 0;
                }
            }
        }
        return $associateArray;
    }
    $associateArray = createAssociateArray($row, $database);
    // make order list
    $order = array();
    $database->setQuery("SELECT COUNT(*) 
                         FROM #__booklibrary_main_categories 
                         WHERE section='$row->section'"); 
    $max = intval($database->loadResult()) + 1;
    for ($i = 1;$i < $max;$i++) {
        $order[] = mosHTML::makeOption($i);
    }
    // build the html select list for ordering
    $query = "SELECT ordering AS value, title AS text" . "\n 
              FROM #__booklibrary_main_categories" . "\n 
              WHERE section = '$row->section'" . "\n 
              ORDER BY ordering";

    $lists['ordering'] = NUll;
    // build the select list for the image positions
    $active = ($row->image_position ? $row->image_position : 'left');
    $lists['image_position'] = NUll ;

    // Imagelist
    $lists['image'] = HTML::imageList('image', $row->image);
    // build the html radio buttons for published
    $lists['published'] = mosHTML::yesnoRadioList('published', 'class="inputbox"', $row->published);
    // build the html select list for paraent item
    $options = array();
    $options[] = mosHTML::makeOption('0', _BOOKLIBRARY_A_SELECT_TOP);
    //***********access category
    $gtree[] = mosHTML::makeOption('-2', 'Everyone');
    $gtree = get_group_children_tree_bl();
    $f = array();
    if ($row->params == null || trim($row->params) == '') $row->params = '-2';
    $s = explode(',', $row->params);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['category']['registrationlevel'] = mosHTML::selectList($gtree, 
        'category_registrationlevel[]', 'size="" multiple="multiple"', 'value', 'text', $f);
    //********end access category
    //-------langarray-------------
    $query = "SELECT lang_code, title 
              FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $lists['languages'] = mosHTML::selectList($languages_row, 'language', 
        'class="inputbox edit_cat_select" size="1"', 
    'value', 'text', $row->language);
    //    $retVal1 = mosBooklibraryOthers :: getLanguageArray();
    //
    //    $lang = null;
    //     for ($i = 0, $n = count($retVal1); $i < $n; $i++) {
    //         $help = $retVal1[$i];
    //         $lang[] = mosHTML :: makeOption($help[0], $help[1]);
    //     }
    //
    //     $lists['langlist'] = mosHTML :: selectList($lang, 'language', 
    /* 'class="inputbox" size="1"', 'value', 'text'/* , 
        $booklibrary_configuration['editbook']['default']['lang'] ); */
    //
    //
    //-----------------------------
    $lists['parent'] = HTML::categoryParentList($row->id, "", $is_new, $options);
    // $params2 = unserialize($row->params2);
    // $alone = '';
    // $view = '';
    // if ($uid != 0) {
    //     if (isset($params2->alone_category) or isset($params2->view_book)) {
    //         $alone = $params2->alone_category;
    //         $view = $params2->view_book;
    //     }
    // }



    if ( $row->id ) {
        $registry = new JRegistry($row->metadata); 
        $metadata = $registry->toArray() ;
        $row->metadata = array() ;
 
        $row->metadata['meta_title'] = 
            (isset($metadata['meta_title']) )?($metadata['meta_title']):("");
        $row->metadata['meta_keywords'] = 
            (isset($metadata['meta_keywords']) )?($metadata['meta_keywords']):("");
        $row->metadata['meta_description'] = 
            (isset($metadata['meta_description']) )?($metadata['meta_description']):("");
        $row->metadata['meta_robots'] = 
            (isset($metadata['meta_robots']) )?($metadata['meta_robots']):("");
    }else{
        $row->metadata = array() ;
        $row->metadata['meta_title']="";
        $row->metadata['meta_keywords']="";
        $row->metadata['meta_description']="";
        $row->metadata['meta_robots']="";
    }

    $meta_robots = null;
    $robots[] = JHtml::_('select.option',"", _BOOKLIBRARY_ROBOTS_USE_GLOBAL);
    $robots[] = JHtml::_('select.option',"index, follow", _BOOKLIBRARY_ROBOTS_INDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, follow", _BOOKLIBRARY_ROBOTS_NOINDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"index, nofollow", _BOOKLIBRARY_ROBOTS_INDEX_NOFOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, nofollow", _BOOKLIBRARY_ROBOTS_NOINDEX_NOFOLLOW);

    $meta_robots = JHtml::_('select.genericlist',$robots, "metadata[meta_robots]", 'class="inputbox" size="1"', 
        'value', 'text',  $row->metadata['meta_robots'] );

    /******** remove layouts from category settings ********/
    /*******************************************************/
    // $component_path = JPath::clean(JPATH_SITE . 
    //     '/components/com_booklibrary/views/showCategory/tmpl');
    // $component_layouts = array();
    // $options = array();
    // if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
    // '^[^_]*\.php$', false, true))) {
    //     $alone_category[] = JHtml::_('select.option', '', 'Use Global');
    //     foreach($component_layouts as $i => $file) {
    //         $select_file_name = pathinfo($file);
    //         $select_file_name = $select_file_name['filename'];
    //         $alone_category[] = JHtml::_('select.option', $select_file_name, $select_file_name);
    //     }
    // }
    // $lists['alone_category'] = mosHTML::selectList($alone_category, 'alone_category', 
    //    'class="inputbox edit_cat_select" size="1"', 'value', 'text', $alone 
       /* $params2->alone_category */
    // );
    // $component_path = JPath::clean(JPATH_SITE . '/components/com_booklibrary/views/view_book/tmpl');
    // $component_layouts = array();
    // $options = array();
    // if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
    //   '^[^_]*\.php$', false, true))) {
    //     $view_book[] = JHtml::_('select.option', '', 'Use Global');
    //     foreach($component_layouts as $i => $file) {
    //         $select_file_name = pathinfo($file);
    //         $select_file_name = $select_file_name['filename'];
    //         $view_book[] = JHtml::_('select.option', $select_file_name, $select_file_name);
    //     }
    // }
    // $lists['view_book'] = mosHTML::selectList($view_book, 'view_book', 
    //     'class="inputbox edit_cat_select" size="1"', 
    //  'value', 'text', $view 
     /* $params2->view_book */
    // );
    HTML_Categories::edit($row, $section, $lists, $redirect, $associateArray,$meta_robots);
}
function manageAuthor($option) {
    global $mosConfig_absolute_path;
    $mainframe = JFactory::getApplication();
    global $database, $my, $mosConfig_live_site, $mosConfig_list_limit, $booklibrary_configuration;
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    $srch_for = $mainframe->getUserStateFromRequest("srch_for{$option}", 'srch_for', '0'); //
    $search = $mainframe->getUserStateFromRequest("auth_search{$option}", 'auth_search', '');
    $langshow_filter = $mainframe->getUserStateFromRequest("langshow_filter{$option}", 
        'langshow_filter', '*');
  
    $where = array();
    if ($langshow_filter != '*') {
        array_push($where, "a.langshow='$langshow_filter'");
    }
    if ($search) {
        switch ($srch_for) {
            case 'autors':
                array_push($where, "LOWER(a.authors_name) LIKE '%$search%'");
            break;
            case 'id':
                array_push($where, "LOWER(a.id) LIKE '%$search%'");
            break;
            case 'title':
                array_push($where, "LOWER(b.title) LIKE '%$search%'");
            break;
            default:
                array_push($where, "(LOWER(a.authors_name) LIKE '%$search%' OR LOWER(a.id) LIKE 
                  '%$search%' OR LOWER(b.title) LIKE '%$search%')");
            break;
        }
    }

    $selectstring = " SELECT a.*, GROUP_CONCAT(b.title SEPARATOR ', ') AS book_title  
                      FROM `#__booklibrary_authors` a
                      LEFT JOIN `#__booklibrary_authors_connect` ac on   a.id = ac.fk_authorid  
                      LEFT JOIN   `#__booklibrary` b  ON ac.fk_bookid=b.id " . 
                      (count($where) ? "WHERE " . implode(' AND ', $where) : "") .
                      " GROUP BY a.id ";
    try {
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    $total = count($rows);

    $pageNav = new JPagination($total, $limitstart, $limit);
    $selectstring = " SELECT a.*, GROUP_CONCAT(b.title SEPARATOR ', ') AS book_title, u.name AS editor 
                      FROM `#__booklibrary_authors` a
                      LEFT JOIN `#__booklibrary_authors_connect` ac on   a.id = ac.fk_authorid  
                      LEFT JOIN   `#__booklibrary` b  ON ac.fk_bookid=b.id 
                      LEFT JOIN #__users AS u ON u.id = a.checked_out " . 
                      (count($where) ? "WHERE " . implode(' AND ', $where) : "").
                      " GROUP BY a.id " . 
                      " LIMIT $pageNav->limitstart, $pageNav->limit;";
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();

// print_r($selectstring); 
// print_r($rows); 
//exit;

    $date = strtotime(JFactory::getDate()->toSQL());
    foreach($rows as $row) {
        if( !isset($row->checked_out_time) ) continue ;
        $check = strtotime($row->checked_out_time);
        $remain = ($check + 7200) - $date;
        if (($remain <= 0) && ($row->checked_out != 0)) {
            $database->setQuery("UPDATE #__booklibrary_authors 
                                 SET checked_out=0,checked_out_time=0 
                                 WHERE id='" . $row->id . "'");
            $database->execute();
        }
    }

    $query = "SELECT lang_code, title 
              FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All languages');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }

    $langshow_filter = mosHTML::selectList($languages_row, 'langshow_filter', 
        'class="inputbox inputboxuathors" 
        onchange="document.adminForm.submit();", size="1"', 'value', 'text', $langshow_filter);
    $search_for[] = mosHTML::makeOption('0', _BOOKLIBRARY_SHOW_SEARCH_FOR_ALL);
    $search_for[] = mosHTML::makeOption('id', _BOOKLIBRARY_LABEL_AUTHOR_ID);
    $search_for[] = mosHTML::makeOption('autors', _BOOKLIBRARY_SHOW_SEARCH_FOR_AUTORS);
    $search_for[] = mosHTML::makeOption('title', _BOOKLIBRARY_LABEL_TITLE_BOOK);
    $search_for_list = mosHTML::selectList($search_for, 'srch_for', 'class="inputbox" size="1" ', 'value', 
          'text', $srch_for);
    HTML_booklibrary::showAuthors($option, $rows, $pageNav, $search, $search_for_list, 
        $langshow_filter);
           // print_r("2222222222222");exit();
}
function publish_manage_author($bid, $publish, $option) {
    global $database, $my;

    if (!is_array($bid) || count($bid) < 1) {
        $action = $publish ? 'publish' : 'unpublish';
        echo "<script> alert('Select an item to " . addslashes($action) . "'); 
               window.history.go(-1);</script>\n";
        exit;
    }
    $bids = implode(',', $bid);
    $database->setQuery("UPDATE #__booklibrary_authors SET published='$publish'" . 
            "\nWHERE id IN ($bids) AND (checked_out=0 OR (checked_out='$my->id'))");
    $database->execute();


    mosRedirect("index.php?option=$option&task=manage_author");
}
function removeAuthor($bid, $option) {
    global $database, $book, $mosConfig_absolute_path;
    if (!is_array($bid) || count($bid) < 1) {
        echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
        exit;
    }
    
        /****************************************************************************************/
    for ($i = 0;$i < count($bid);$i++) {
        $query = "select associate_authors 
                  from #__booklibrary_authors 
                  where id =" . $bid[$i];
        $database->setQuery($query);
        $AuthorAssociateAuthor = $database->loadResult();
        $assocAuthorObj = unserialize($AuthorAssociateAuthor);
        $idWhereChange = array();
        if (!empty($assocAuthorObj)) {
            foreach($assocAuthorObj as $key => $value) {
                if ($value == $bid[$i]) {
                    $assocAuthorObj[$key] = null;
                } else if ($value) {
                    $idWhereChange[] = $value;
                }
            }
            $stringIdWhereChange = implode(',', $idWhereChange);
            $newAssocSerialize = serialize($assocAuthorObj);
            if (!empty($stringIdWhereChange)) {
                $query = "update #__booklibrary_authors 
                          set associate_authors ='$newAssocSerialize' 
                          where id in($stringIdWhereChange)";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }
    /**********************************************************************************************/
    
    if (count($bid)) {
        foreach($bid as $id) {

        $selectstring = " SELECT ac.*  
                          FROM `#__booklibrary_authors_connect` ac
                           WHERE  ac.fk_authorid = " . $id . " " ;
    $database->setQuery($selectstring);

            $database->setQuery($selectstring);
            $exist_book = $database->loadObjectList();
            if (!empty($exist_book)) { ?> 
            <script type = "text/JavaScript" language = "JavaScript"> 
                alert('You cannot delete author with book'); 
                window.history.go(-1); 
            </script> 
            <?php
                exit;
            }

            $authors4del = new mosBookLibrary_authors($database);
            $authors4del->load($id);

            $query = "delete from #__booklibrary_authors_connect where fk_authorid='" . (int)$authors4del->id . "'";
            $database->setQuery($query);
            $database->execute();

            $imageURL = $authors4del->imageURL;
            $file_inf = pathinfo($imageURL);
            $file_type = '.' . $file_inf['extension'];
            $file_name = basename($imageURL, $file_type);
            $path = $mosConfig_absolute_path . '/components/com_booklibrary/covers';

            $authors4del->delete();

            if($file_name  == "" ) {
                continue ;
            }
            $check_files = JFolder::files($path, '^' . $file_name . '.*$', false, true);
            foreach($check_files as $check_file) {
                unlink($check_file);
            }
        }
    }
    mosRedirect("index.php?option=$option&task=manage_author");
}
function saveCategory($task) {
    global $database;
    $row = new mainBooklibraryCategories($database); 
    $jinput = JFactory::getApplication()->input;
    // $post = JRequest::get('post', JREQUEST_ALLOWHTML);
    $post = $jinput->getArray($_POST);
    
    $currentId = $post['id'];
    function saveAssociateBookQS($post, $database) {
        $currentId = $post['id'];
        if ($currentId) {
            $i = 1;
            $assocArray = array();
            $assocCategoryId = array();
            while (isset($post['associate_category' . $i])) {
                $langAssoc = $post['associate_category_lang' . $i];
                $valAssoc = $post['associate_category' . $i];
                $assocArray[$langAssoc] = $valAssoc;
                if ($valAssoc) {
                    $assocCategoryId[] = $valAssoc;
                }
                $i++;
            }
            $currentId = $post['id'];
            $currentLang = $post['language'];
            $assocArray[$currentLang] = $currentId;
            $assocStr = serialize($assocArray);
            $query = "select `associate_category` 
                      from `#__booklibrary_main_categories` 
                      where `id` = " . $currentId . "";
            $database->setQuery($query);
            $oldAssociate = $database->loadResult();
            $oldAssociateArray = unserialize($oldAssociate);
            if ($oldAssociateArray) {
                foreach($oldAssociateArray as $key => $value) {
                    if ($value && !isset($assocCategoryId[$value])) {
                        $assocCategoryId[] = $value;
                    }
                }
            }
            if (!isset($assocCategoryId[$currentId])) {
                $assocCategoryId[] = $currentId;
            }
            $idToChange = implode(',', $assocCategoryId);
            if (count($assocCategoryId) > 0 && !empty($idToChange)) {
                $query = "UPDATE #__booklibrary_main_categories 
                          SET `associate_category`='" . $assocStr . "' 
                          WHERE `id` in (" . $idToChange . ")";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }
    saveAssociateBookQS($post, $database);
    // $params2 = new stdClass();
    // $params2->alone_category = $post['alone_category'];
    // $params2->view_book = $post['view_book'];
    // $post['params2'] = serialize($params2);
    //if (!$row->bind($_POST)) {
    if (!$row->bind($post)) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); 
               window.history.go(-1); </script>\n";
        exit();
    }
    $row->title = $row->name;
    $row->description = $jinput->get('description', '', 'RAW');
    $row->section = 'com_booklibrary';
    $row->parent_id = $_REQUEST['parent_id'];
    $row->language = $_REQUEST['language'];
    if (!$row->check()) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); 
               window.history.go(-1); </script>\n";
        exit();
    }
    //****set access level
    $row->params = implode(',', mosGetParam($_POST, 'category_registrationlevel', array("-2"),"ARRAY" ));
    //****end set access level

    $registry = new JRegistry($row->metadata);     

    $row->metadata = $registry->toString() ;
    
    $row->publish_up = data_transformer($row->publish_up,"to");
    $row->publish_down = data_transformer($row->publish_down,"to");

    if (!$row->store()) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); 
               window.history.go(-1); </script>\n";
        exit();
    }
    $row->checkin();
    $row->updateOrder("section='com_booklibrary' AND parent_id='$row->parent_id'");
    switch ($task) {
        case 'apply':
            mosRedirect("index.php?option=com_booklibrary&section=categories&task=edit&bid[]=" . 
                $row->id);
        break;
        case 'save':
            mosRedirect('index.php?option=com_booklibrary&section=categories');
        break;
    }
}
//this function checks - is exist books in this folder and folders under this category
function is_exist_curr_and_subcategory_books($catid) {
    global $database, $my;
    $query = "SELECT *, COUNT(a.id) AS numlinks 
              FROM #__booklibrary_main_categories AS cc" . "\n  
              JOIN #__booklibrary_categories AS a ON a.catid = cc.id" . "\n 
              WHERE section='com_booklibrary' AND cc.id='$catid' " . "\n 
              GROUP BY cc.id" . "\n 
              ORDER BY cc.ordering";
    $database->setQuery($query);
    $categories = $database->loadObjectList();
    if (count($categories) != 0) return true;
    $query = "SELECT id " . "
              FROM #__booklibrary_main_categories AS cc " . " 
              WHERE section='com_booklibrary' AND parent_id='$catid' ";
    $database->setQuery($query);
    $categories = $database->loadObjectList();
    if (count($categories) == 0) return false;
    foreach($categories as $k) {
        if (is_exist_curr_and_subcategory_books($k->id)) return true;
    }
    return false;
}
//end function
function removeCategoriesFromDB($cid) {
    global $database, $my;
    $query = "SELECT id  " . "
              FROM #__booklibrary_main_categories AS cc " . "
             WHERE section='com_booklibrary' AND parent_id='$cid' ";
    $database->setQuery($query);
    $categories = $database->loadObjectList();
    if (count($categories) != 0) {
        //delete child
        foreach($categories as $k) {
            removeCategoriesFromDB($k->id);
        }
    }
    $sql = "DELETE FROM #__booklibrary_main_categories 
            WHERE id = $cid ";
    $database->setQuery($sql);
    $database->execute();
}
/**
 * Deletes one or more categories from the categories table
 *
 * @param string $ The name of the category section
 * @param array $ An array of unique category id numbers
 */
function removeCategories($section, $cid) {
    global $database;
    if (count($cid) < 1) {
        echo "<script> alert('Select a category to delete'); window.history.go(-1);</script>\\n";
        exit;
    }
    foreach($cid as $catid) {
        if (is_exist_curr_and_subcategory_books($catid)) {
            echo "<script> alert('\\nSome category from yours select contain books.\\n\\n' +
           'Please remove books first!'); window.history.go(-1); </script>";
            exit;
        }
    }
    foreach($cid as $catid) {
        removeCategoriesFromDB($catid);
    }
    $msg = (count($cid) > 1 ? "Categories " : _BOOKLIBRARY_CATEGORIES_NAME . " ") . 
        _BOOKLIBRARY_DELETED;
    mosRedirect('index.php?option=com_booklibrary&section=categories&mosmsg=' . $msg);
}
/**
 * Publishes or Unpublishes one or more categories
 *
 * @param string $ The name of the category extension
 * @param integer $ A unique category id (passed from an edit form)
 * @param array $ An array of unique category id numbers
 * @param integer $ 0 if unpublishing, 1 if publishing
 * @param string $ The name of the current user
 */
function publishCategories($extension, $categoryid = null, $cid = null, $publish = 1) {
    global $database, $my;
    if (!is_array($cid)) {
        $cid = array();
    }
    if ($categoryid) {
        $cid[] = $categoryid;
    }
    if (count($cid) < 1) {
        $action = $publish ? _BOOKLIBRARY_PUBLISH : _BOOKLIBRARY_DML_UNPUBLISH;
        echo "<script> alert('" . _BOOKLIBRARY_DML_SELECTCATTO . " $action');
               window.history.go(-1);</script>\n";
        exit;
    }
    $cids = implode(',', $cid);
    $query = "UPDATE #__booklibrary_main_categories 
              SET published='$publish'" . "\n
              WHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))";
    $database->setQuery($query);
    $database->execute();

    if (count($cid) == 1) {
        $row = new mainBooklibraryCategories($database); 
        $row->checkin($cid[0]);
    }
    mosRedirect('index.php?option=com_booklibrary&section=categories');
}
/**
 * Cancels an edit operation
 *
 * @param string $ The name of the category extension
 * @param integer $ A unique category id
 */
function cancelCategory() {
    global $database;
    $row = new mainBooklibraryCategories($database); 
    $row->bind($_POST);
    $row->checkin();
    mosRedirect('index.php?option=com_booklibrary&section=categories');
}
/**
 * Moves the order of a record
 *
 * @param integer $ The increment to reorder by
 */
function orderCategory($uid, $inc) {
    global $database;
    $row = new mainBooklibraryCategories($database); 
    $row->load($uid);
    if ($row->ordering == 1 && $inc == - 1) 
        mosRedirect('index.php?option=com_booklibrary&section=categories');
    $new_order = $row->ordering + $inc;
    //change ordering - for other element
    $query = "UPDATE #__booklibrary_main_categories 
              SET ordering='" . ($row->ordering) . "'"  . "\n
              WHERE parent_id = $row->parent_id and ordering=$new_order";
    ///
    $database->setQuery($query);
    $database->execute();
    //change ordering - for this element
    $query = "UPDATE #__booklibrary_main_categories 
              SET ordering='" . $new_order . "'"  . "\n
              WHERE id = $uid";
    $database->setQuery($query);
    $database->execute();
    mosRedirect('index.php?option=com_booklibrary&section=categories');
}
/**
 * changes the access level of a record
 *
 * @param integer $ The increment to reorder by
 */
function accessCategory($uid, $access) {
    global $database;
    $row = new mainBooklibraryCategories($database); 
    $row->load($uid);
    $row->access = $access;
    if (!$row->check()) {
        return $row->getError();
    }
    if (!$row->store()) {
        return $row->getError();
    }
    mosRedirect('index.php?option=com_booklibrary&extension=categories');
}
function update_review($title, $comment, $rating, $review_id) {
    global $database;
    $review = new mosBookLibrary_review($database);
    $review->load($review_id);
    if (!$review->bind($_POST)) {
        echo "<script> alert('" . $book->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }
    if (!$review->check()) {
        echo "<script> alert('" . $book->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }
    if (!$review->store()) {
        echo "<script> alert('" . $book->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }
}
function edit_review($option, $review_id, $book_id) {
    global $database;
    try {
        $database->setQuery("SELECT * 
                             FROM #__booklibrary_review 
                             WHERE id=" . $review_id . " ");
        $review = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    HTML_booklibrary::edit_review($option, $book_id, $review);
}
/*
* Add Nikolay.
* Function for delete coment
* (comment for every book)
* in database.
*/
function delete_review($option, $id) {
    global $database;
    try {
        $database->setQuery("DELETE FROM #__booklibrary_review 
                             WHERE #__booklibrary_review.id=" . $id . ";");
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
}
//*************************************************************************************************************
//*********************************   begin for manage reviews   **********************************************
//*************************************************************************************************************
function delete_manage_review($option, $id) {
    global $database;
    for ($i = 0;$i < count($id);$i++) {
        try {
            $database->setQuery("DELETE FROM #__booklibrary_review 
                                 WHERE #__booklibrary_review.id=" . $id[$i] . ";");
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    }
}
function edit_manage_review($option, $review_id) {
    global $database;
    if (count($review_id) > 1) {
        echo "<script> alert('Please select one review for edit!!!'); 
               window.history.go(-1); </script>\n";
    } else {
        try {
        $database->setQuery("SELECT * FROM #__booklibrary_review 
                             WHERE id=" . $review_id[0] . " ");
        $review = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        HTML_booklibrary::edit_manage_review($option, $review);
    }
}
//*********************************************************************************
//************************   end for manage reviews   *****************************
//*********************************************************************************
function showInfo($option, $bid) {
    if (is_array($bid) && count($bid) > 0) {
        $bid = $bid[0];
    }
    echo "Test: " . $bid;
}


function decline_lend_requests($option, $bids) {
    global $database, $booklibrary_configuration;
    $datas = array();
    //if (is_array($bids[0])) $bids = $bids[0];
    foreach($bids as $bid) {
        $lend_request = new mosBookLibrary_lend_request($database);
            // $a = $bid[0];
            // $bid = $a;
        $lend_request->load($bid);
        $tmp = $lend_request->decline();
        if ($tmp != null) {
            echo "<script> alert('" . addslashes($tmp) . "'); window.history.go(-1); </script>\n";
            exit();
        }
        $datas[] = array('email' => $lend_request->user_email, 'name' => $lend_request->user_name, 
          'id' => $lend_request->fk_bookid);
    }
    if ($booklibrary_configuration['lend_answer']) {
        sendMailLendRequest($datas, _BOOKLIBRARY_LENDREQUEST_EMAIL_DECLINED);
    }
    mosRedirect("index.php?option=$option&task=lend_requests");
}


function accept_lend_requests($option, $bids) {
    global $database, $booklibrary_configuration;
    $datas = array();
    //if (is_array($bids[0])) $bids = $bids[0];
    foreach($bids as $bid) {
        $lend_request = new mosBookLibrary_lend_request($database);
            // $a = $bid[0];
            // $bid = $a;
        $lend_request->load($bid);
        $tmp = $lend_request->accept();
        if ($tmp != null) {
            echo "<script> alert('" . addslashes($tmp) . "'); window.history.go(-1); </script>\n";
            exit();
        }
        $datas[] = array('email' => $lend_request->user_email, 
                         'name' => $lend_request->user_name, 
                         'id' => $lend_request->fk_bookid);
    }
    if ($booklibrary_configuration['lend_answer']) {
        sendMailLendRequest($datas, _BOOKLIBRARY_LENDREQUEST_EMAIL_ACCEPTED);
    }
    mosRedirect("index.php?option=$option&task=lend_requests");
}
//********************   begin add send mail for admin   ********
function sendMailLendRequest($datas, $answer) {
    global $database, $mosConfig_mailfrom, $booklibrary_configuration;
    
    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $app = JFactory::getApplication();
        $conf = $app->getConfig();
    } else {
        $conf = JFactory::getConfig(); //old 09/2022
    }    


    foreach($datas as $key => $data) {
        $mess = null;
        $zapros = "SELECT title 
                   FROM #__booklibrary 
                   WHERE id=" . $data['id'];
        try {
            $database->setQuery($zapros);
            $item = $database->loadResult();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        try {
            $database->setQuery("SELECT u.name AS ownername,rm.owneremail \n
                                 FROM #__users AS u \n
                                 LEFT JOIN #__booklibrary AS rm ON rm.owneremail=u.email \n
                                 WHERE rm.id=" . $data['id']);
            $ownerdata = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    
        $datas[$key]['title'] = $item;
        // mailLendRequestAnswer($data, $item, $answer);
        $message = _BOOKLIBRARY_EMAIL_NOTIFICATION_LEND_REQUEST_ANSWER;
        $message = str_replace("{title}", $datas[$key]['title'], $message);
        $message = str_replace("{answer}", $answer, $message);
        $message = str_replace("{username}", $datas[$key]['name'], $message);
        if ($answer == _BOOKLIBRARY_LENDREQUEST_EMAIL_ACCEPTED) {
            $message = str_replace("{ownername}", $ownerdata[0]->ownername, $message);
            $message = str_replace("{owneremail}", $ownerdata[0]->owneremail, $message);
        } else {
            $message = str_replace("{ownername}", '', $message);
            $message = str_replace("{owneremail}", '', $message);
        }
        mosMail($mosConfig_mailfrom, $conf->get('fromname'), $data['email'], 
        _BOOKLIBRARY_EMAIL_LEND_ANSWER_SUBJECT, $message, true);
    }
    //********************   end add send mail for admin   ****************
    
}
//*************************************************************************************************
//*********************************   begin add for button print in Manager Books   ***************
//*************************************************************************************************
function print_books($option) {
    global $mosConfig_live_site, $database, $mainframe, $mosConfig_list_limit,$bl_state;

    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }

    if (!array_key_exists('bid', $_POST)) {
        echo "<script> alert('Please select some book'); window.history.go(-1); </script>\n";
        exit;
    } else {
        $bid = $_POST['bid'];
        $bids = implode(',', $bid);
    }
    //**********************   begin for books request   ******************************************
    //     $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    //     $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    //     $catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', 0);
    //     $lend = $mainframe->getUserStateFromRequest("lend{$option}", 'lend', 0);
    //     $pub = $mainframe->getUserStateFromRequest("pub{$option}", 'pub', 0);
    //     $user = $mainframe->getUserStateFromRequest("user{$option}", 'user', 0);
    //
    //
    //     $search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');
    //     $search = $database->getEscaped(trim(strtolower($search)));
    //
    //     $where = array();
    //     if ($user == "user") {
    //         array_push($where, "a.checked_out <> 0");
    //     } else if ($user == "not_user") {
    //         array_push($where, "a.checked_out = 0");
    //     }
    //     if ($lend == "lend") {
    //         array_push($where, "a.fk_lendid <> 0");
    //     } else if ($lend == "not_lend") {
    //         array_push($where, "a.fk_lendid = 0");
    //     }
    //
    //     if ($pub == "pub") {
    //         array_push($where, "a.published = 1");
    //     } else if ($pub == "not_pub") {
    //         array_push($where, "a.published = 0");
    //     }
    //
    //     if ($catid > 0) {
    //         array_push($where, "a.catid='$catid'");
    //     }
    //
    //     if ($search) {
    //         array_push($where, "(LOWER(a.title) LIKE '%$search%' OR LOWER(a.authors) 
  //			LIKE '%$search%' OR LOWER(a.isbn) LIKE '%$search%' OR LOWER(a.comment) LIKE '%$search%')");
    //     }
    //
    //     $database->setQuery("SELECT count(*) FROM #__booklibrary AS a" .
    //             "\nLEFT JOIN #__booklibrary_lend AS l" .
    //             "\nON a.fk_lendid = l.id" .
    //             (count($where) ? "\nWHERE " . implode(' AND ', $where) : ""));
    //     $total = $database->loadResult();
    //
    //     $pageNav = new JPagination($total, $limitstart, $limit); 
    $selectstring = "SELECT a.*, GROUP_CONCAT(cc.title SEPARATOR ', ') AS category, 
                     l.id as lendid, l.lend_from as lend_from, 
                     l.lend_return as lend_return, l.lend_until as lend_until, u.name AS editor  
                     FROM #__booklibrary AS a 
                     LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=a.id 
                     LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = bc.catid 
                     LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id 
                     LEFT JOIN #__users AS u ON u.id = a.checked_out  
                     WHERE a.id IN ($bids)  
                     GROUP BY a.id";
    try {
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    // if ($database->getErrorNum()) {
    
    //     echo $database->stderr();
    //     return false;
    // }
    for ($i = 0;$i < count($rows);$i++) {
        if (isset($rows[$i]->lendid)) {
            $select_lend = "SELECT id, fk_userid, user_name, user_email, user_mailing" . "\n
                            FROM #__booklibrary_lend AS a" . "\n
                            WHERE a.id = " . $rows[$i]->lendid . ";";
            $database->setQuery($select_lend);
            $rows_add = $database->loadObjectList();
            // for register user
            if (isset($rows_add[0]->fk_userid)) {
                $select_lend_reg = "SELECT id, name, email" . "\n
                                    FROM #__users AS u" . "\n
                                    WHERE u.id = " . $rows_add[0]->fk_userid . ";";
                $database->setQuery($select_lend_reg);
                $rows_add_user = $database->loadObjectList();
                $rows[$i]->user_name = $rows_add[0]->user_name;
                $rows[$i]->user_email = $rows_add[0]->user_email;
                $rows[$i]->user_mailing = $rows_add[0]->user_mailing;
            } else {
                $rows[$i]->user_name = $rows_add[0]->user_name;
                $rows[$i]->user_email = $rows_add[0]->user_email;
                $rows[$i]->user_mailing = $rows_add[0]->user_mailing;
            }
        }
    }
    //**********************   end for books request   ****************************************
    HTML_booklibrary::showPrintBooks($rows);
}
//end print_books()
function print_item($option) {
    $rows = $_SESSION['rows'];
    HTML_booklibrary::showPrintItem($rows);
}
//*********************************   end add for button print in Manager Books   *************
function lend_requests($option, $bid) {
    global $database, $mainframe, $mosConfig_list_limit;
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    //var_dump($limitstart); exit();
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    try {
        $database->setQuery("SELECT count(*) 
                             FROM #__booklibrary AS a" . "\n
                             LEFT JOIN #__booklibrary_lend_request AS l" . "\n
                             ON l.fk_bookid = a.id" .  "\n
                             WHERE l.status = 0");
        $total = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // print_r($total);exit;

    $pageNav = new JPagination($total, $limitstart, $limit); 
    try {
        $database->setQuery("SELECT * 
                             FROM #__booklibrary AS a" . "\n
                             LEFT JOIN #__booklibrary_lend_request AS l" . "\n
                             ON l.fk_bookid = a.id" . "\n
                             WHERE l.status = 0" . "\n
                             ORDER BY l.lend_from, l.lend_until, l.user_name" . "\n
                             LIMIT $pageNav->limitstart,$pageNav->limit;");
        $lend_requests = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    
    try {
        $query = "SELECT fk_bookid 
                  FROM #__booklibrary_lend_request";
        $database->setQuery($query);
        $b_associated = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    $title_assoc = '';
    if ($b_associated) {
        $assoc_book = getAssociateBooks($b_associated);
        if ($assoc_book) {
            try {
                $database->setQuery("SELECT a.id, a.title 
                                     FROM #__booklibrary AS a" . "\n
                                     LEFT JOIN #__booklibrary_lend_request AS l 
                                     ON l.fk_bookid = a.id" . "\n
                                     WHERE a.id in ($assoc_book)");
                $title_assoc = $database->loadObjectList();
            } catch (RuntimeException $e) {
                echo $e->getMessage();
            }
        }
    }
    HTML_booklibrary::showRequestLendBooks($option, $lend_requests, $b_associated, 
        $title_assoc, $pageNav);
}

 function users_lend_history($option, $bid, $sorting){
    global $database, $my,$mainframe;
    $owner = $mainframe->getUserStateFromRequest("owner_h{$option}", 'owner_h', '-1'); //add nik    
    
    if ($sorting == '') {
        $sorting = 'title';
    }

    $ownerint = (int) $owner;
  
    $book = '';
    $alllend = '';

    if ($ownerint == 0) {

        $select = "SELECT l.lend_from as lend_from, " .
                  "b.title, b.bookid,l.lend_return as lend_return, l.lend_until as lend_until, " .
                  "l.user_name as user_name, l.user_email as user_email, l.user_mailing as user_mailing " . "\n 

                   FROM #__booklibrary_lend AS l" ."\n 

                   LEFT JOIN #__booklibrary AS b ON l.fk_bookid = b.id" ."\n

                   WHERE l.user_name = ".$database->Quote($owner). "\n
                   
                   ORDER BY " . $sorting ." ";

        try {
            $database->setQuery($select);
            $alllend = $database->loadObjectList(); 
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
       
    }
    elseif ($owner == -1) {
       $select = "SELECT l.lend_from as lend_from, " .
                  "b.title, b.bookid,l.lend_return as lend_return, l.lend_until as lend_until, " .
                  "l.user_name as user_name, l.user_email as user_email, l.user_mailing as user_mailing " . "\n 
                   FROM #__booklibrary_lend AS l" ."\n 
                   LEFT JOIN #__booklibrary AS b ON l.fk_bookid = b.id" ."\n 
                   ORDER BY " . $sorting ." ";

        try {
            $database->setQuery($select);
            $alllend = $database->loadObjectList(); 
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
          
    }

    else {
        $select = "SELECT l.lend_from as lend_from, " .
                  "b.title, b.bookid,l.lend_return as lend_return, l.lend_until as lend_until, " .
                  "l.user_name as user_name, l.user_email as user_email, l.user_mailing as user_mailing " . "\n 

                   FROM #__booklibrary_lend AS l" ."\n 

                   LEFT JOIN #__booklibrary AS b ON l.fk_bookid = b.id" ."\n
              
                   WHERE l.fk_userid = ".$database->Quote($ownerint) ."

                   OR l.user_name = ".$database->Quote($owner). "\n

                   ORDER BY " . $sorting ." ";

        try {
            $database->setQuery($select);
            $alllend = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        
    }
if (isset($alllend)) {
	for ($i = 0; $i < count($alllend); $i++) {
		$fromcut = explode(' ', $alllend[$i]->lend_from);
		$untilcut = explode(' ', $alllend[$i]->lend_until);
		$alllend[$i]->lend_from = $fromcut[0];  
		$alllend[$i]->lend_until = $untilcut[0]; 
	}
 }    
    $userlist[] = mosHTML :: makeOption('-1', 'Select User');
    $database->setQuery("SELECT DISTINCT fk_userid AS value, user_name AS text 
                         from #__booklibrary_lend 
                         ORDER BY user_name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    foreach ($userlist as $value) {
        if(!$value->value)
            $value->value = $value->text;
    }
    $usermenu = mosHTML::selectList($userlist, 'owner_h', 'class="inputbox" size="1" 
        onchange="document.adminForm.submit();"', 'value', 'text', $owner);

    HTML_booklibrary:: showUsersLendHistory($option, $alllend,  $usermenu);
}

 function lend_history($option, $bid){
    global $database, $my,$mainframe;
    
    if (!is_array($bid) || count($bid) !== 1){
      echo "<script> alert('Select one item to show'); window.history.go(-1);</script>\n";
      exit;
    }
    $bid_book = implode(',', $bid);
        $select = "SELECT a.*, l.id as lendid, l.lend_from as lend_from, " . 
                  "l.lend_return as lend_return,  
                  l.lend_until as lend_until, l.fk_userid as fk_userid, " . 
                  "l.user_name as user_name,  
                  l.user_email as user_email, u.name AS name, u.email as email" . "\n
                  FROM #__booklibrary AS a" . "\n
                  LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
                  LEFT JOIN #__users AS u ON u.id = l.fk_userid" . "\n
                  WHERE a.id = $bid_book";
    try {
        $database->setQuery($select);
        $books = $database->loadObject();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $bids = implode(',', $bid);
    $bids = getAssociateBooks($bids);
    $books_assoc[] = $books;
    if ($bids) {
        $select = "SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, " . 
                  "l.lend_return as lend_return, l.lend_until as lend_until, " . 
                  "l.user_name as user_name, l.user_email as user_email " . "\n
                  FROM #__booklibrary AS a" . "\n
                  LEFT JOIN #__booklibrary_categories as bc on bc.bookid = a.id" . "\n
                  LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = bc.catid" . "\n
                  LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
                  WHERE a.id in ($bids)";
        try {
            $database->setQuery($select);
            $books_assoc = $database->loadObjectList();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    }
    
    // get list of categories
    HTML_booklibrary:: showLendHistory($option, $books, $books_assoc);
}



// ------------------------- by Wonderer
function unsetCatId() {
    $option = 'com_booklibrary';
    $mainframe = JFactory::getApplication();
    $catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', '-1');
    unset($catid);
    showBooks($option);
}
/**
 * Compiles a list of records
 * @param database - A database connector object
 * select categories
 */
function showBooks($option) { // Display table n the Books Tab
    $mainframe = JFactory::getApplication();
    global $database, $mosConfig_list_limit;
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    $catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', '-1');
    $lend = $mainframe->getUserStateFromRequest("lend{$option}", 'lend', '-1');
    $pub = $mainframe->getUserStateFromRequest("pub{$option}", 'pub', '-1');
    $langshow_filter = $mainframe->getUserStateFromRequest("langshow_filter{$option}", 
        'langshow_filter', '*');
    $owneremail = $mainframe->getUserStateFromRequest("owneremail{$option}", 'owneremail', '-1');
    $srch_for = $mainframe->getUserStateFromRequest("srch_for{$option}", 'srch_for', '0'); //
    $search = addslashes($mainframe->getUserStateFromRequest("search{$option}", 'search', ''));
    $select_owner_id = protectInjectionWithoutQuote('select_owner_id',"-1") ;
    //var_dump($search); exit();
    //$search = $database->getEscaped(trim(strtolower($search)));
    $where = array();
    if ($select_owner_id !== "-1" && $select_owner_id !== "0") {
        array_push($where, "jei.owner_id = '" . $select_owner_id . "' ");
    }
    if ($lend == "lend") {
        array_push($where, "jei.fk_lendid <> 0");
    } else if ($lend == "not_lend") {
        array_push($where, "jei.fk_lendid = 0");
    }
    if ($pub == "pub") {
        array_push($where, "jei.published = 1");
    } else if ($pub == "not_pub") {
        array_push($where, "jei.published = 0");
    }
    if ($catid > 0 && !is_array($catid) ) {
        array_push($where, "jea.catid='$catid'");
    }
    if ($langshow_filter != '*') {
        array_push($where, "jei.langshow='$langshow_filter'");
    }
    if ($search) {
        switch ($srch_for) {
            case 'isbn':
                array_push($where, "LOWER(jei.isbn) LIKE '%$search%'");
            break;
            case 'title':
                array_push($where, "LOWER(jei.title) LIKE '%$search%'");
            break;
            case 'autors':
                array_push($where, "LOWER(a.authors_name) LIKE '%$search%'");
            break;
            case 'category':
                array_push($where, "LOWER(c.title) LIKE '%$search%'");
            break;
            case 'publisher':
                array_push($where, "LOWER(jei.manufacturer) LIKE '%$search%'");
            break;
            case 'description':
                array_push($where, "LOWER(jei.comment) LIKE '%$search%'");
            break;
            case 'id':
                array_push($where, "LOWER(jei.bookid) LIKE '%$search%'");
            break;
            default:
                array_push($where, "(LOWER(jei.isbn) LIKE '%$search%' 
                    OR LOWER(jei.title) LIKE '%$search%'  
                    OR LOWER(a.authors_name) LIKE '%$search%' 
                    OR LOWER(c.title) LIKE '%$search%' 
                    OR LOWER(jei.manufacturer) LIKE '%$search%' 
                    OR LOWER(jei.comment) LIKE '%$search%' 
                    OR LOWER(jei.bookid) LIKE '%$search%')");
            break;
        }
    }
    // $q = "SELECT count(*) 
    //       FROM #__booklibrary_categories AS jea" . " \n
    //       LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = jea.catid" . " \n
    //       LEFT JOIN #__booklibrary AS jei ON jei.id = jea.bookid" . " \n
    //       LEFT JOIN #__booklibrary_lend AS l" . " \nON jei.fk_lendid = l.id" . (count($where) ? "\n
    //       WHERE " . implode(' AND ', $where) : "");
    // $database->setQuery($q);
    // $total = $database->loadResult();
    $selectstring = "SELECT DISTINCT jei.*,blr2.rating2, GROUP_CONCAT( DISTINCT c.title SEPARATOR ', ') AS category, c.id AS category_id, 
                          c.ordering AS category_ordering, GROUP_CONCAT( DISTINCT a.authors_name SEPARATOR ', ')  AS authors, 
                          l.lend_from as lend_from, l.lend_return as lend_return, username AS owner_name
                          FROM #__booklibrary AS jei " . "\n
                          LEFT JOIN #__users AS usr ON usr.id = jei.owner_id
                          LEFT JOIN #__booklibrary_authors_connect as ac on ac.fk_bookid = jei.id" . "\n
                          LEFT JOIN #__booklibrary_authors as a on ac.fk_authorid = a.id" . "\n
                          LEFT JOIN #__booklibrary_categories AS jea ON jea.bookid = jei.id" . "\n
                          LEFT JOIN #__booklibrary_main_categories AS c ON jea.catid = c.id" . "\n
                          LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = jei.id and 
                            ( l.lend_return = '0000-00-00 00:00:00' or l.lend_return is null ) " . "\n
                          LEFT JOIN ( SELECT ROUND(avg(blr1.rating)) as rating2, fk_bookid   
                          FROM #__booklibrary as bl  
                          LEFT JOIN #__booklibrary_review as blr1 on blr1.fk_bookid = bl.id 
                          group by blr1.fk_bookid ) blr2  
                          ON  blr2.fk_bookid = jei.id" . ((count($where) ? "\n
                          WHERE " . implode(' AND ', $where) : "")) . "\n
                          GROUP BY jei.id" ;
    try {
        $database->setQuery($selectstring);
        $total = count($database->loadObjectList() );
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    // Sort start
    // SORTING parameters start
    $prefix = '';
    $item_session = JFactory::getSession();
    $item_sort_param = mosGetParam($_GET, 'sort', '');
    $item_sort_param = preg_replace('/[^A-Za-z0-9_]*/', '', $item_sort_param);
    if ($item_sort_param == '') {
        if (is_array($sort_arr = $item_session->get('bl_bn_booksort', ''))) {
            $sort_string = $sort_arr['field'] . " " . $sort_arr['direction'];
        } else {
            $sort_string = 'title';
            $sort_arr = array();
            $sort_arr['field'] = 'title';
            $sort_arr['direction'] = '';
            $item_session->set('bl_bn_booksort', $sort_arr);
        }
    } else {
        if (is_array($sort_arr = $item_session->get('bl_bn_booksort', ''))) {
            if ($item_sort_param == $sort_arr['field']) {
                if ($sort_arr['direction'] == 'DESC') $sort_arr['direction'] = '';
                else $sort_arr['direction'] = 'DESC';
            } else {
                $sort_arr['field'] = $item_sort_param;
                $sort_arr['direction'] = '';
            }
            if ($sort_arr['field'] != 'category') $prefix = 'jei.';
            $sort_string = $prefix . $sort_arr['field'] . " " . $sort_arr['direction'];
        } else {
            $sort_string = 'title';
            $sort_arr = array();
            $sort_arr['field'] = 'title';
            $sort_arr['direction'] = '';
        }
        $item_session->set('bl_bn_booksort', $sort_arr);
    }
    $sort_let = mosGetParam($_GET, 'sortlet', '');
    $value = $sort_let;
    if ($sort_let != '' and $sort_let != 'none') {
        switch ($sort_let) {
            case 'lend_out':
                $sort_string = "";
            break;
            case 'lend_out_desc':
                $sort_string = "";
            break;
            case 'lend_until':
                $sort_string = "lend_until";
            break;
            case 'lend_until_desc':
                $sort_string = "lend_until DESC";
            break;
            case 'lend_from':
                $sort_string = "lend_from";
            break;
            case 'lend_from_desc':
                $sort_string = "lend_from DESC";
            break;
        }
        $sort_arr['field'] = "";
    }
    // Sort end
    // print_r($where);exit;
    $pageNav = new JPagination($total, $limitstart, $limit);
    $selectstring = "SELECT DISTINCT jei.*,blr2.rating2, GROUP_CONCAT( DISTINCT c.title SEPARATOR ', ') AS category, c.id AS category_id, 
                          c.ordering AS category_ordering, GROUP_CONCAT( DISTINCT a.authors_name SEPARATOR ', ')  AS authors, 
                          l.lend_from as lend_from, l.lend_return as lend_return, usr.username AS owner_name,
                          usr2.name AS editor
                          FROM #__booklibrary AS jei " . "\n
                          LEFT JOIN #__users AS usr ON usr.id = jei.owner_id
                          LEFT JOIN #__users AS usr2 ON usr2.id = jei.checked_out
                          LEFT JOIN #__booklibrary_authors_connect as ac on ac.fk_bookid = jei.id" . "\n
                          LEFT JOIN #__booklibrary_authors as a on ac.fk_authorid = a.id" . "\n
                          LEFT JOIN #__booklibrary_categories AS jea ON jea.bookid = jei.id" . "\n
                          LEFT JOIN #__booklibrary_main_categories AS c ON jea.catid = c.id" . "\n
                          LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = jei.id 
                            and ( l.lend_return = '0000-00-00 00:00:00' or l.lend_return is null ) " . "\n
                          LEFT JOIN ( SELECT ROUND(avg(blr1.rating)) as rating2, fk_bookid   
                          FROM #__booklibrary as bl  
                          LEFT JOIN #__booklibrary_review as blr1 on blr1.fk_bookid = bl.id 
                          group by blr1.fk_bookid ) blr2  
                          ON  blr2.fk_bookid = jei.id" . ((count($where) ? "\n
                          WHERE " . implode(' AND ', $where) : "")) . "\n
                          GROUP BY jei.id" . "\n
                          ORDER BY $sort_string" . "\n
                          LIMIT $pageNav->limitstart,$pageNav->limit;"; 
    try {
        $database->setQuery($selectstring);
        $rows = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $date = strtotime(JFactory::getDate()->toSQL());
    foreach($rows as $row) {
        if( !isset($row->checked_out_time) ) continue ;
        $check = strtotime($row->checked_out_time);
        $remain = ($check + 7200) - $date;
        if (($remain <= 0) && ($row->checked_out != 0)) {
            try {
                $database->setQuery("UPDATE #__booklibrary 
                                     SET checked_out=0,checked_out_time=0 
                                     WHERE id='" . $row->id . "'");
                $database->execute();
            } catch (RuntimeException $e) {
                echo $e->getMessage();
            }
        }
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    // if ($database->getErrorNum()) {
    
    //     echo $database->stderr();
    //     return false;
    // }
    // get list of categories
    /*
    * select list treeSelectList
    */
    $categories[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
    $categories[] = mosHTML::makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_CATEGORIES);
    //*************   begin add for sub category in select in manager books   *************
    $options = $categories;
    $id = 0;
    $list = CAT_Utils::categoryArray();
    $cat = new mainBooklibraryCategories($database); 
    $cat->load($id);
    $this_treename = '';
    foreach($list as $item) {
        if ($this_treename) {
            if ($item->id != $cat->id && strpos($item->treename, $this_treename) === false) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            }
        } else {
            if ($item->id != $cat->id) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            } else {
                $this_treename = "$item->treename/";
            }
        }
    }
    
    $clist = mosHTML::selectList($options, 'catid', 'class="inputbox" size="1" 
      onchange="document.adminForm.submit();"', 'value', 'text', $catid);
      
    //new nik edit
    //*****  end add for sub category in select in manager books   **********
    $usermenu[] = mosHTML::makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_USERS);
    $usermenu[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_USER);
    $selectstring = "SELECT usr.id,jei.owner_id, jei.owneremail, usr.username 
                     FROM  #__booklibrary AS jei  \n
                     LEFT JOIN #__users AS usr ON usr.id = jei.owner_id" . " 
                     GROUP BY usr.id  " . "\n
                     ORDER BY usr.username ";
    // $database->setQuery($selectstring);
    // $users_list = $database->loadObjectList();
    // $useranonimus = new stdClass();
    // $useranonimus->username = 'anonymous';
    // $useranonimus->owneremail = 'anonymous';
    // if (count($users_list) > 1) {
    //     $users_list[count($users_list) ] = $useranonimus;
    // }
    // if (!isset($users_list[0]->username)) unset($users_list[0]);
    // if ($database->getErrorNum()) {
    //     echo $database->stderr();
    //     return false;
    // }
    // $startSelecterPosition = 0;
    // foreach($users_list as $item) {
    //     $usermenu[2 + $startSelecterPosition] = mosHTML::makeOption($item->owneremail, $item->username);
    //     $startSelecterPosition++;
    // }

    // $userlist = mosHTML::selectList($usermenu, 'owneremail', 
    //     'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $owneremail);
    try {
    $database->setQuery($selectstring);
    $users_list = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    $useranonimus = new stdClass();
    $useranonimus->username = 'anonymous';
    $useranonimus->owner_id = 'anonymous';
    if (count($users_list) >=1) {
        $users_list[] = $useranonimus;
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    // if ($database->getErrorNum()) {
    
    //     echo $database->stderr();
    //     return false;
    // }
    foreach($users_list as $item) {
        if ($item->owner_id == 0 || $item->username == '') continue;
        $usermenu[] = mosHTML::makeOption($item->owner_id, $item->username);
    }
    // print_r($usermenu);exit;
    $userlist = mosHTML::selectList($usermenu, 'select_owner_id', 'class="inputbox" size="1" 
        onchange="document.adminForm.submit();"', 'value', 'text', $select_owner_id);
    
    $lendmenu[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_TO_LEND);
    $lendmenu[] = mosHTML::makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_LEND);
    $lendmenu[] = mosHTML::makeOption('not_lend', _BOOKLIBRARY_LABEL_SELECT_NOT_LEND);
    $lendmenu[] = mosHTML::makeOption('lend', _BOOKLIBRARY_LABEL_SELECT_LEND);
    $lendlist = mosHTML::selectList($lendmenu, 'lend', 'class="inputbox" size="1" 
  onchange="document.adminForm.submit();"', 'value', 'text', $lend);
    $pubmenu[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_TO_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('not_pub', _BOOKLIBRARY_LABEL_SELECT_NOT_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('pub', _BOOKLIBRARY_LABEL_SELECT_PUBLIC);
    $publist = mosHTML::selectList($pubmenu, 'pub', 'class="inputbox" size="1" 
  onchange="document.adminForm.submit();"', 'value', 'text', $pub);
    $query = "SELECT lang_code, title
              FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All languages');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow_filter = mosHTML::selectList($languages_row, 'langshow_filter', 'class="inputbox" 
  onchange="document.adminForm.submit();", size="1"', 'value', 'text', $langshow_filter);
    $search_for[] = mosHTML::makeOption('0', _BOOKLIBRARY_SHOW_SEARCH_FOR_ALL);
    $search_for[] = mosHTML::makeOption('id', _BOOKLIBRARY_LABEL_BOOKID);
    $search_for[] = mosHTML::makeOption('isbn', _BOOKLIBRARY_SHOW_SEARCH_FOR_ISBN);
    $search_for[] = mosHTML::makeOption('title', _BOOKLIBRARY_SHOW_SEARCH_FOR_TITLE);
    $search_for[] = mosHTML::makeOption('autors', _BOOKLIBRARY_SHOW_SEARCH_FOR_AUTORS);
    $search_for[] = mosHTML::makeOption('category', _BOOKLIBRARY_SHOW_SEARCH_FOR_CATEGORY);
    $search_for[] = mosHTML::makeOption('publisher', _BOOKLIBRARY_SHOW_SEARCH_FOR_PUBLISHER);
    $search_for[] = mosHTML::makeOption('description', _BOOKLIBRARY_SHOW_SEARCH_FOR_DESCRIPTION);
    $search_for_list = mosHTML::selectList($search_for, 'srch_for', 'class="inputbox" size="1" ', 
    'value', 'text', $srch_for);
    HTML_booklibrary::showBooks($option, $rows, $clist, $lendlist, $userlist, $publist, $search, 
                $pageNav, $sort_arr, $search_for_list, $value, $langshow_filter);
}
/**
 * Compiles information to add or edit books
 * @param integer bid The unique id of the record to edit (0 if new)
 * @param array option the current options
 */

function CloneBook($bid, $option) {
    global $database, $my, $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration,$bl_state;

    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }

    if (count($bid) > 1) {
        echo "<script> alert('You can clone only one book'); window.history.go(-1); </script>\n";
        exit();
    }
    $bid = $bid[0];
    $book_true = new mosBookLibrary($database);
    // load the row from the db table
    $book_true->load(intval($bid));
    $book_true->setCategs();

    $book = clone $book_true;

    $book->id = null;
    $book->hits = 0;
    //$book->bookid = null;
    $book->store();

           // WHERE `id` = '".$book_true->id."'  ";
    $query = "SELECT `fk_authorid` FROM #__booklibrary_authors_connect
           WHERE `fk_bookid` = '".$book_true->id."'  ";

           $database->setQuery($query);
           $authorsid = $database->loadResult(); 

    $query = "INSERT INTO #__booklibrary_authors_connect 
             SET `fk_bookid` = '".$book->id."', `fk_authorid` = '". $authorsid ."' ";
    $database->setQuery($query)->execute();
            

    $book->id_true = $book_true->id;
    $book->saveCategs($book->categs);

    $database->execute() ;

    mosRedirect("index.php?option=$option", "Your book is clone");
    //print_r($book); exit;
/*   $numeric_bookids = array();
    if (empty($book->bookid)) {
        $database->setQuery("select bookid from #__booklibrary order by bookid");
        $bookids = $database->loadObjectList();
        
        foreach($bookids as $bookid) {
            if (!is_numeric($bookid->bookid)) {
                echo "<script> alert('You have no numeric BookId. Please set option  " . 
          _BOOKLIBRARY_ADMIN_CONFIG_BOOKID_AUTO_INCREMENT . " to \'No\' or change 
          all BookID to numeric '); window.history.go(-1); </script>\n";
                exit();
            }
            $numeric_bookids[] = intval($bookid->bookid);
        }

        if (count($bookids) > 0) {
            sort($numeric_bookids);
            for ($freeid = 1;in_array($freeid, $numeric_bookids);$freeid++) {
                //echo $freeid;
            }
            $book->bookid = $freeid;
        } else $book->bookid = 1;
        
    }
    
    // get list of categories
    $categories[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
    $query = "SELECT  id ,name, parent_id as parent" . "\n 
              FROM #__booklibrary_main_categories" . "\n 
              WHERE section='com_booklibrary'" . "\n AND published > 0" . "\n 
              ORDER BY parent_id, ordering";
    $database->setQuery($query);
    $rows = $database->loadObjectList();
    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }
    // second pass - get an indent list of the items
    $list = bookLibraryTreeRecurse(0, '', array(), $children);
    foreach($list as $i => $item) {
        $item->text = $item->treename;
        $item->value = $item->id;
        $list[$i] = $item;
    }
    $categories = array_merge($categories, $list);
    if (count($categories) <= 1) {
        mosRedirect("index.php?option=com_booklibrary&section=categories", 
            _BOOKLIBRARY_ADMIN_IMPEXP_ADD);
    }
    $query = "select catid from #__booklibrary_categories where bookid='" . $book->id . "'";
    $database->setQuery($query);
    $cat_idlist = $database->loadColumn();
    if (empty($cat_idlist)) $cat_idlist[0] = '0';
    $clist = mosHTML::selectList($categories, 'catid[]', 'class="inputbox"', 'value', 
        'text', $cat_idlist);
    // get list of WS
    $retVal = mosBooklibraryWS::getArray();
    $ws = null;
    for ($i = 0, $n = count($retVal);$i < $n;$i++) {
        $help = $retVal[$i];
        $ws[] = mosHTML::makeOption($help[0], $help[1]);
    }
    if ($bid == 0) {
        $wslist = mosHTML::selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 'value', 
        'text', intval($booklibrary_configuration['editbook']['default']['host']));
    } else $wslist = mosHTML::selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 'value', 
        'text', intval($book->informationFrom));
    //get language List
    
    $retVal1 = mosBooklibraryOthers::getLanguageArray();
    
    $lang = null;
    for ($i = 0, $n = count($retVal1);$i < $n;$i++) {
        $help = $retVal1[$i];
        $lang[] = mosHTML::makeOption($help[0], $help[1]);
    }
    if ($bid == 0) {
        $languages_lg = mosHTML::selectList($lang, 'language', 'class="inputbox" size="1"', 
            'value', 'text', '1');
    } else {
        $languages_lg = mosHTML::selectList($lang, 'language', 'class="inputbox" size="1"', 
            'value', 'text', 
    $book->language);
    }
    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All languages');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow = mosHTML::selectList($languages_row, 'langshow', 'class="inputbox" size="1"', 
            'value', 'text', 
        $book->langshow);
        
    //get Rating
    $retVal2 = mosBooklibraryOthers::getRatingArray();
    $rating = null;
    for ($i = 0, $n = count($retVal2);$i < $n;$i++) {
        $help = $retVal2[$i];
        $rating[] = mosHTML::makeOption($help[0], $help[1]);
    }
    $ratinglist = mosHTML::selectList($rating, 'rating', 'class="inputbox" size="1"', 'value', 'text', 
        $book->rating);
    if (!empty($book->id)) { //check ebook file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT * 
                       FROM #__booklibrary_files 
                       WHERE fk_book_id=" . $bid);
        $files = $db->loadObjectList();
    } else $files = array();
    
 ///////////START check video/audio files\\\\\\\\\\\\\\\\\\\\\\
    $tracks = array();
    $videos = array();
    $audios = array();
    
    if (!empty($book->id)) { 
      $database->setQuery("SELECT * 
                           FROM #__booklibrary_video_source 
                           WHERE fk_book_id=" . $bid);
      $videos = $database->loadObjectList();
    }
    
    $youtubeCode = "";
    for ($i = 0;$i < count($videos);$i++) {
        if (!empty($videos[$i]->youtube)) {
            $youtubeCode['youtube'] = $videos[$i]->youtube;
            unset($videos[$i]);
        }
    }
    $youtubeId = "";
    if (!empty($youtubeCode)) { //check video file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_video_source 
                       WHERE youtube = '" . 
        $youtubeCode['youtube'] . "'");
        $youtubeId = $db->loadResult();
    }

        
    if (!empty($book->id)) { //check audios file
      $database->setQuery("SELECT * 
                           FROM #__booklibrary_audio_source 
                           WHERE fk_book_id=" . $bid);
      $audios = $database->loadObjectList();
    }
    
    if (!empty($book->id)) { //check video file
      $database->setQuery("SELECT * 
                           FROM #__booklibrary_track_source 
                           WHERE fk_book_id=" . $bid);
      $tracks = $database->loadObjectList();
    }

    if(count($files)){
        for($i = 0; $i < count($files); $i++){
            $query = "INSERT INTO `#__booklibrary_files`
                      SET `fk_book_id` = ".$book->id.",
                          `location` = '".$files[$i]->location."',
                          `description` = '".$files[$i]->description."'";  
            $database->setQuery($query);
            $database->execute();
        }
    }
    
    if(count($audios)){
        for($i = 0; $i < count($audios); $i++){
            $query = "INSERT INTO `#__booklibrary_audio_source`
                      SET `fk_book_id` = ".$book->id.",
                          `sequence_number` = '".$audios[$i]->sequence_number."',
                          `fk_author_id` = '".$audios[$i]->fk_author_id."',
                          `src` = '".$audios[$i]->src."',
                          `type` = '".$audios[$i]->type."'";  
            $database->setQuery($query);
            $database->execute();
        }
    }
    
    if(count($videos)){
        for($i = 0; $i < count($videos); $i++){
            $query = "INSERT INTO `#__booklibrary_video_source`
                      SET `fk_book_id` = ".$book->id.",
                          `sequence_number` = '".$videos[$i]->sequence_number."',
                          `src` = '".$videos[$i]->src."',
                          `type` = '".$videos[$i]->type."',
                          `media` = '".$videos[$i]->media."',
                          `youtube` = '".$videos[$i]->youtube."'";  
            $database->setQuery($query);
            $database->execute();
        }
    }
    
    if(count($tracks)){
        for($i = 0; $i < count($tracks); $i++){
            $query = "INSERT INTO `#__booklibrary_track_source`
                      SET `fk_book_id` = ".$book->id.",
                          `sequence_number` = '".$tracks[$i]->sequence_number."',
                          `src` = '".$tracks[$i]->src."',
                          `kind` = '".$tracks[$i]->kind."',
                          `scrlang` = '".$tracks[$i]->scrlang."',
                          `label` = '".$tracks[$i]->label."'";
            $database->setQuery($query);
            $database->execute();
        }
    }
////////////////////////////////END check video/audio files \\\\\\\\\\\\\\\\\\
    
   
    if ($book->checked_out && $book->checked_out <> $my->id) {
        mosRedirect("index.php?option=$option", _BOOKLIBRARY_IS_EDITED);
    }
    if ($bid) {
        $book->checkout($my->id);
    } else {
        // initialise new record
        $book->published = 0;
        $book->approved = 0;
    }
    
    if (($book->owneremail) == '' || $bid == 0) {
        $book->owneremail = $my->email;
    }
    
    $database->setQuery("SELECT username AS owner 
                         FROM #__users" . "\n
                         WHERE email='$book->owneremail'");
    $book->owner = $database->loadResult();
    //*****************************   begin for reviews **************************/
    /*$database->setQuery("SELECT a.*, b.name from #__booklibrary_review a, #__users b" . "
                         WHERE a.fk_userid = b.id and a.fk_bookid=" . $bid . "
                         ORDER BY date ;");
    $reviews1 = $database->loadObjectList();
    //take review for anonymous users
    $database->setQuery("SELECT a.*, 'anonymous' as name from #__booklibrary_review as a  " . "
                         WHERE a.fk_userid = 0 and a.fk_bookid = " . $bid . "
                         ORDER BY date ;");
    $reviews2 = $database->loadObjectList();
    $reviews = array_merge($reviews1, $reviews2);
    //**********************   end for reviews   *****************************/
   /* $inp = new JFormFieldModal_Article_BL();
    $book->modal_article = $inp->getInput();

 //print_r($book); exit;
    /*HTML_booklibrary::editBook($option, $book, $clist, $wslist, $langshow, $languages_lg, $ratinglist, 
                 $delete_ebook, $reviews, $files, $videos, $audios, $tracks, 
                 $youtubeCode, $youtubeId, $associateArray, $reviews);*/
}
 

function cloneAuthor($bid, $option) {
    global $database, $my, $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration,$bl_state;

    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }

    if (count($bid) > 1) {
        echo "<script> alert('You can clone only one author'); window.history.go(-1); </script>\n";
        exit();
    }
    $bid = $bid[0];
    $author_true = new mosBookLibrary_authors($database);
    // load the row from the db table
    $author_true->load(intval($bid));
    $author = clone $author_true;
    $author->id = null;
    $rand = guid();
    $rand_value = substr($rand ,1,-1);
    $file_inf = pathinfo($author->imageURL);
    $file_name = $file_inf['filename'];
    $original_photo = $mosConfig_absolute_path . 
        '/components/com_booklibrary/covers/'. $file_inf['basename'];
    $copy_photo = $mosConfig_absolute_path . '/components/com_booklibrary/covers/'.
    $rand_value.'_'.$file_inf['basename'];
    copy($original_photo, $copy_photo);
    $author->imageURL = '/components/com_booklibrary/covers/' . $rand_value . '_' . $file_inf['basename'];
    $author->store();
    $author->id_true = $author_true->id;
    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow = mosHTML::selectList($languages_row, 'langshow', 'class="inputbox" size="1"', 'value', 
        'text', $author->langshow);
    if ($bid) {
        $author->checkout($my->id);
    } else {
        $author->published = 0;
        $author->approved = 0;
    }
    if (($author->owneremail) == '' || $bid == 0) {
        $author->owneremail = $my->email;
    }
    $database->setQuery("SELECT username AS owner FROM #__users" . 
                        "\nWHERE email='$author->owneremail'");
    $author->owner = $database->loadResult();
    HTML_booklibrary::editAuthor($option, $author, $langshow, $authors_name = true, $rows = true, 
        $ItemId_tmp_from_db = true, $books_titles  = true, $associateArray = true);
}


function randNumber() {
    $path = $_GET["path"];
    $filename = basename($_GET["file"]);
    $file = $path . $filename;
    if (file_exists($file)) {
        echo "The file with such name already is!";
    } else {
        echo "";
    }
}
function editAuthor($option, $bid) {
    global $mosConfig_absolute_path;
    global $database, $my, $mosConfig_live_site, $booklibrary_configuration;
    $author = new mosBookLibrary_authors($database);
    $author->load(intval($bid));
    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow = mosHTML::selectList($languages_row, 'langshow', 'class="inputbox" size="1"', 'value', 
        'text', $author->langshow);
        
    $zapros = "SELECT authors_name 
               FROM #__booklibrary_authors 
               WHERE id = '" . $bid . "';";
    $database->setQuery($zapros);
    $authors_name = $database->loadResult();
    $authors_name = addslashes($authors_name);
    $selectstring = "SELECT b.id,b.title,bc.catid 
                     FROM #__booklibrary AS b" . "\n
                     LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id" . "\n
                     LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid" . "\n
                     LEFT JOIN #__booklibrary_authors AS a ON a.id=b.fk_authors" . "\n 
                     WHERE authors_name LIKE '%" . $authors_name . "%' AND a.id = " . $bid . "\n 
                     GROUP BY id";
    try {
        $database->setQuery($selectstring);
        $rows = $database->loadObjectList();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    try {
        $database->setQuery("SELECT id  
                             FROM #__menu 
                             WHERE link 
                             LIKE 'index.php?option=com_booklibrary&view=categories%'  
                             or link 
                             LIKE 'index.php?option=com_booklibrary&task=categories%' ");
        $ItemId_tmp_from_db = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    $books_titles = '';
    foreach($rows as $row2) {
        $link1 = "index.php?option=com_booklibrary&amp;task=view_bl&amp;id=" . $row2->id . 
        "&amp;catid=" . $row2->catid . "&amp;Itemid=" . $ItemId_tmp_from_db;
        $books_titles.= '<a href="' . sefRelToAbs($mosConfig_live_site . "/" . $link1) . 
          '" target="_self">' . $row2->title . '</a><br/>';
    }
    $associateArray = array();
    if (!empty($bid)) {
        $access = true;
        $associateArray = edit_author_associate($author, $access);
    }
    
    if ($bid) {
        $author->checkout($my->id);
    } else {
        // initialise new record
        $author->published = 0;
        $author->approved = 0;
    }
    if (($author->owneremail) == '' || $bid == 0) {
        $author->owneremail = $my->email;
    }
    try {
    $database->setQuery("SELECT username AS owner FROM #__users" . 
                        "\nWHERE email='$author->owneremail'");
    $author->owner = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    
    if ( $author->id ) {
        $registry = new JRegistry($author->metadata); 
        $metadata = $registry->toArray() ;
        $author->metadata = array() ;
 
        $author->metadata['meta_title'] = 
            (isset($metadata['meta_title']) )?($metadata['meta_title']):("");
        $author->metadata['meta_keywords'] = 
            (isset($metadata['meta_keywords']) )?($metadata['meta_keywords']):("");
        $author->metadata['meta_description'] = 
            (isset($metadata['meta_description']) )?($metadata['meta_description']):("");
        $author->metadata['meta_robots'] = 
            (isset($metadata['meta_robots']) )?($metadata['meta_robots']):("");
    }else{
        $author->metadata = array() ;
        $author->metadata['meta_title']="";
        $author->metadata['meta_keywords']="";
        $author->metadata['meta_description']="";
        $author->metadata['meta_robots']="";
    }

    $meta_robots = null;
    $robots[] = JHtml::_('select.option',"", _BOOKLIBRARY_ROBOTS_USE_GLOBAL);
    $robots[] = JHtml::_('select.option',"index, follow", _BOOKLIBRARY_ROBOTS_INDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, follow", _BOOKLIBRARY_ROBOTS_NOINDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"index, nofollow", _BOOKLIBRARY_ROBOTS_INDEX_NOFOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, nofollow", _BOOKLIBRARY_ROBOTS_NOINDEX_NOFOLLOW);

    $meta_robots = JHtml::_('select.genericlist',$robots, "metadata[meta_robots]", 'class="inputbox" size="1"', 
        'value', 'text',  $author->metadata['meta_robots'] );

    
    HTML_booklibrary::editAuthor($option, $author, $langshow, $authors_name, $rows, 
        $ItemId_tmp_from_db, $books_titles, $associateArray,$meta_robots);
}

function editBook($option, $bid) {
    global $mosConfig_absolute_path;
    global $database, $my, $mosConfig_live_site, $booklibrary_configuration;
    $book = new mosBookLibrary($database);
    $book->load(intval($bid));
    $numeric_bookids = array();

     if (empty($book->bookid) && 
        $booklibrary_configuration['bookid']['auto-increment']['boolean'] == 1){
      $database->setQuery("select bookid 
                           from #__booklibrary 
                           order by bookid");
      $bookids = $database->loadObjectList();
      foreach ($bookids as $bookid) {
        if (is_numeric($bookid->bookid)){
          $numeric_bookids[] = intval($bookid->bookid);
        }
      }
      if (count($numeric_bookids) > 0) {
        sort($numeric_bookids);
        $book->bookid = $numeric_bookids[count($numeric_bookids) - 1] + 1;
      }
      else
        $book->bookid = 1;
    }
    
    /************************************    language     *****************************************/
    $associateArray = array();
    if (!empty($bid)) {
        $access = true;
        $associateArray = edit_book_associate($book, $access);
    }
    /**********************************************************************************************/
    // get list of categories
    $categories[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
    $query = "SELECT  id ,name, parent_id as parent" . "\n 
              FROM #__booklibrary_main_categories" . "\n 
              WHERE section='com_booklibrary'" . "\n AND published > 0" . "\n 
              ORDER BY parent_id, ordering";
    $database->setQuery($query);
    $rows = $database->loadObjectList();
    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }
    // second pass - get an indent list of the items
    $list = bookLibraryTreeRecurse(0, '', array(), $children);
    foreach($list as $i => $item) {
        $item->text = $item->treename;
        $item->value = $item->id;
        $list[$i] = $item;
    }

    $categories = array_merge($categories, $list);
    if (count($categories) <= 1) {
        mosRedirect("index.php?option=com_booklibrary&section=categories", 
            _BOOKLIBRARY_ADMIN_IMPEXP_ADD);
    }

    $query = "select catid from #__booklibrary_categories where bookid='" . $book->id . "'";
    $database->setQuery($query);
    $cat_idlist = $database->loadColumn();
    if (empty($cat_idlist)) $cat_idlist[0] = '0';
    $clist = mosHTML::selectList($categories, 'catid[]', 'class="inputbox" multiple', 'value', 
      'text', $cat_idlist);
    // end, get list of categories
    

    $query = "SELECT DISTINCT a.authors_name, a.id
              FROM #__booklibrary_authors AS a 
              order by authors_name";
    $database->setQuery($query);
    $authors = $database->loadObjectList();


    $authors_row[] = mosHTML::makeOption('', 'Selected');
    foreach($authors as $author) {
        $authors_row[] = mosHTML::makeOption($author->authors_name, $author->authors_name);
    } 
    // $authors_row[] = mosHTML::makeOption('0', 'Selected');
    // foreach($authors as $author) {
    //     $authors_row[] = mosHTML::makeOption($author->id, $author->authors_name);
    // }

    $query = "SELECT authors_name FROM `#__booklibrary_authors` ba
              WHERE ba.id in (SELECT fk_authorid FROM `#__booklibrary_authors_connect` 
              WHERE fk_bookid='" . $book->id . "')";   
    // $query = "select fk_authorid from #__booklibrary_authors_connect where fk_bookid='" . $book->id . "'";
    $database->setQuery($query);

    $authors_list = $database->loadColumn();

    if (empty($authors_list)) $authors_list = '';

    $authorsshow = mosHTML::selectList($authors_row, 'authors[]', 'class="inputbox" multiple', 'value', 
        'text', $authors_list);
    // get list of WS
    $retVal = mosBooklibraryWS::getArray();
    $ws = null;
    for ($i = 0, $n = count($retVal);$i < $n;$i++) {
        $help = $retVal[$i];
        $ws[] = mosHTML::makeOption($help[0], $help[1]);
    }

    if ($bid == 0) {
        $wslist = mosHTML::selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 
            'value', 'text',
          intval($booklibrary_configuration['editbook']['default']['host']));
    } else $wslist = mosHTML::selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 
        'value', 'text', intval($book->informationFrom));
    //get language List
    $retVal1 = mosBooklibraryOthers::getLanguageArray();
    $lang = null;
    for ($i = 0, $n = count($retVal1);$i < $n;$i++) {
        $help = $retVal1[$i];
        $lang[] = mosHTML::makeOption($help[0], $help[1]);
    }
    
    if ($bid == 0) {
        $languages_lg = mosHTML::selectList($lang, 'language', 'class="inputbox" size="1"', 
            'value', 'text', $booklibrary_configuration['editbook']['default']['lang'] );
    } else {
        $languages_lg = mosHTML::selectList($lang, 'language', 'class="inputbox" size="1"', 
            'value', 'text', $book->language);
    }
    
    $query = "SELECT lang_code, title 
              FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('*', 'All');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }
    $langshow = mosHTML::selectList($languages_row, 'langshow', 'class="inputbox" size="1"', 
        'value', 'text', 
    $book->langshow);
    //get Rating
    $retVal2 = mosBooklibraryOthers::getRatingArray();
    $rating = null;
    for ($i = 0, $n = count($retVal2);$i < $n;$i++) {
        $help = $retVal2[$i];
        $rating[] = mosHTML::makeOption($help[0], $help[1]);
    }
    $ratinglist = mosHTML::selectList($rating, 'rating', 'class="inputbox" size="1"', 
        'value', 'text',  $book->rating);
    if (!empty($book->id)) { //check ebook file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT * 
                       FROM #__booklibrary_files 
                       WHERE fk_book_id=" . $book->id);
        $files = $db->loadObjectList();
    } else $files = array();

    if (!empty($book->id)) { //check video file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT * 
                       FROM #__booklibrary_video_source 
                       WHERE fk_book_id=" . $book->id);
        $videos = $db->loadObjectList();
    } else $videos = array();

    $youtubeCode = array();
    for ($i = 0;$i < count($videos);$i++) {
        if (!empty($videos[$i]->youtube)) {
            $youtubeCode['youtube'] = $videos[$i]->youtube;
            unset($videos[$i]);
        }
    }
    $youtubeId = "";
    if (!empty($youtubeCode)) { //check video file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT id 
                       FROM #__booklibrary_video_source 
                       WHERE youtube = '" . 
          $youtubeCode['youtube'] . "'");
        $youtubeId = $db->loadResult();
    }
    if (!empty($book->id)) { //check audio file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT * 
                       FROM #__booklibrary_audio_source 
                       WHERE fk_book_id=" . $book->id);
        $audios = $db->loadObjectList();
    } else $audios = array();
    if (!empty($book->id)) { //check track file
        $db = JFactory::getDBO();
        $db->setQuery("SELECT * 
                       FROM #__booklibrary_track_source 
                       WHERE fk_book_id=" . $book->id);
        $tracks = $db->loadObjectList();
    } else $tracks = array();
    if ($book->checked_out && $book->checked_out <> $my->id) {
        mosRedirect("index.php?option=$option", _BOOKLIBRARY_IS_EDITED);
    }
    if ($bid) {
        $book->checkout($my->id);
    } else {
        // initialise new record
        $book->published = 0;
        $book->approved = 0;
    }
    if (($book->owneremail) == '' || $bid == 0) {
        $book->owneremail = $my->email;
    }
    $database->setQuery("SELECT username AS owner 
                         FROM #__users" . "\n
                         WHERE email='$book->owneremail'");
    $book->owner = $database->loadResult();
    //*****************************   begin for reviews **************************// 
    $database->setQuery("SELECT a.*, b.name 
                         FROM #__booklibrary_review a, #__users b" . "
                         WHERE a.fk_userid = b.id and a.fk_bookid=" . $bid . "
                         ORDER BY date ;");
    $reviews1 = $database->loadObjectList();
    //take review for anonymous users
    $database->setQuery("SELECT a.*, 'anonymous' as name 
                         FROM #__booklibrary_review as a  " . "
                         WHERE a.fk_userid = 0 and a.fk_bookid = " . $bid . "
                         ORDER BY date ;");
    $reviews2 = $database->loadObjectList();
    $reviews = array_merge($reviews1, $reviews2);
    //**********************   end for reviews   *****************************//
   
    $database->setQuery("SELECT name 
                         FROM #__users as a 
                         WHERE a.id = $my->id");
    $userName = $database->loadResult();

//field from select and create artcle. Required 2 classes (booklibrary.class.article and com_content/models/fields/modal/article.php)

    if (!empty($book->id_article_book) )  {
        $inp = new JFormFieldModal_Article_BL($book->id_article_book);
    } else {
        $inp = new JFormFieldModal_Article_BL();
    }
    
    $book->modal_article = $inp->getInput();


    if ( !empty($book->bookid) ) {
        $registry = new JRegistry($book->metadata); 
        $metadata = $registry->toArray() ;
        $book->metadata = array() ;
 
        $book->metadata['meta_title'] = 
            (isset($metadata['meta_title']) )?($metadata['meta_title']):("");
        $book->metadata['meta_keywords'] = 
            (isset($metadata['meta_keywords']) )?($metadata['meta_keywords']):("");
        $book->metadata['meta_description'] = 
            (isset($metadata['meta_description']) )?($metadata['meta_description']):("");
        $book->metadata['meta_robots'] = 
            (isset($metadata['meta_robots']) )?($metadata['meta_robots']):("");
    }else{
        $book->metadata = array() ;
        $book->metadata['meta_title']="";
        $book->metadata['meta_keywords']="";
        $book->metadata['meta_description']="";
        $book->metadata['meta_robots']="";
    }

    $meta_robots = null;
    $robots[] = JHtml::_('select.option',"", _BOOKLIBRARY_ROBOTS_USE_GLOBAL);
    $robots[] = JHtml::_('select.option',"index, follow", _BOOKLIBRARY_ROBOTS_INDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, follow", _BOOKLIBRARY_ROBOTS_NOINDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"index, nofollow", _BOOKLIBRARY_ROBOTS_INDEX_NOFOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, nofollow", _BOOKLIBRARY_ROBOTS_NOINDEX_NOFOLLOW);

    $meta_robots = JHtml::_('select.genericlist',$robots, "metadata[meta_robots]", 'class="inputbox" size="1"', 
        'value', 'text',  $book->metadata['meta_robots'] );

     


    HTML_booklibrary::editBook($option, $book, $clist, $wslist, $langshow, $languages_lg, $ratinglist, 
                 $delete_ebook, $reviews, $files, $videos, $audios, $tracks, $youtubeCode, 
                 $youtubeId, $associateArray, $authorsshow, $meta_robots);
}
function getTreeCateg(&$return = array(), $id = 0, $sublvl = '-1') {
    global $database;
    $sublvl++;
    $addpref = '';
    if ($sublvl) {
        $result->text = @$addpref . 'L&nbsp;' . $result->text;
    }
    $database->setQuery("SELECT id AS value, name AS text, parent_id 
                         FROM #__booklibrary_main_categories" . "\n
                         WHERE section='com_booklibrary' AND parent_id=$id 
                         ORDER BY ordering");
    $results = $database->loadObjectList();
    if (count($results)) {
        foreach($results as $result) {
            for ($c = 0;$c < $sublvl;$c++) {
                @$addpref.= '&nbsp;';
            }
            $return[] = $result;
            getTreeCateg($return, $result->value, $sublvl);
        }
    }
    return $return;
}
/**
 * Saves the record on an edit form submit
 * @param database A database connector object
 */
function saveBook($option, $task) {

    global $langlist, $database, $my, $mosConfig_absolute_path, $mosConfig_live_site, 
        $booklibrary_configuration,$bl_state;


    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }

     $jinput = JFactory::getApplication()->input;    
    

    // ini_set('error_reporting', E_ALL);
    // ini_set('display_errors', 1);
    // ini_set('display_startup_errors', 1);

    //check how the other info should be provided
    $book = new mosBookLibrary($database);
    if (!$book->bind($_POST)) {
        echo "<script> alert('" . addslashes($book->getError()) . "'); 
               window.history.go(-1); </script>\n";
        exit();
    }


    $registry = new JRegistry($book->metadata); 
    $book->metadata = $registry->toString() ;
    
    $book->publish_up = data_transformer($book->publish_up,"to");
    $book->publish_down = data_transformer($book->publish_down,"to");

    $book->catid = mosGetParam($_POST, 'catid', '');
    //fetch all information from the webservices if necessary
    $book = mosBooklibraryWS::fetchInfos($book);
    if (is_string($book)) {
        //there was an error while fetching!
        echo "<script> alert('" . addslashes($book) . "'); window.history.go(-1); </script>\n";
        exit();
    }    
    
    // $database->setQuery("SELECT owneremail, owner_id
    //                      FROM #__booklibrary 
    //                      WHERE id = '" . $_POST['owneremail'] . "'");
    // $own = $database->loadObjectList();
    
    // if ($own == "" || $own == NUll) {
    //     $book->owner_id = $my->id;
    // }
    
    $user = JFactory::getUser($my->id);
    $user->name;
    $owner_id =  $jinput->get('owner_id');
    if($owner_id) {
      $book->owner_id = $owner_id;
    } else {
      $book->owner_id = $my->id;
    }

	$book->bookid = mosGetParam($_REQUEST, 'bookid', '');

    $owner_owneremail =  mosGetParam($_REQUEST, 'owneremail', '');
    $book->owneremail = $owner_owneremail;
    
    if ($booklibrary_configuration['publish_on_add']['show']) {
        $book->published = 1;
    } else {
        $book->published = 0;
    }
    /*************Call function to Save changes for associated books*******************/
    save_book_associate();
 
    //
    //if ($_POST['ebook_Url'] != '')
    //    $book->ebookURL = $_POST['ebook_Url'];
    //
    ////delete ebook file if neccesary
    //$delete_ebook = mosGetParam($_POST, 'delete_ebook', 0);
    //
    //if ($delete_ebook != '0') {
    //
    //    $retVal = @unlink($mosConfig_absolute_path . $delete_ebook);
    //    $book->ebookURL = "";
    //}
    //
    ////storing e-book
    //$file = $_FILES['ebook_file'];
    ////check if fileupload is correct
    //
    //if ($booklibrary_configuration['ebooks']['allow']
    //        && intval($file['error']) > 0
    //        && intval($file['error']) < 4) {
    //    echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR .
    //    "'); window.history.go(-1); </script>\n";
    //    exit();
    //} else if ($booklibrary_configuration['ebooks']['allow']
    //        && intval($file['error']) != 4) {
    //    /* $file_new = $mosConfig_absolute_path . $booklibrary_configuration['ebooks']['location'] .
    //      $file['name']; */
    //    //---------------------
    //
    //    $uploaddir = $mosConfig_absolute_path . $booklibrary_configuration['ebooks']['location'];
    //    $file_new = $uploaddir . $_FILES['ebook_file']['name'];
    //    //echo $file_new;
    //
    //$ext = pathinfo($_FILES['ebook_file']['name'], PATHINFO_EXTENSION);
    //$allowed_exts = explode(",", $booklibrary_configuration['allowed_exts']);
    //$ext = strtolower($ext);
    //if (!in_array($ext, $allowed_exts)) {
    /*    echo "<script> alert(' File ext. not allowed to upload! - " . $edfile['name'] . "'); 
                 window.history.go(-1); </script>\n"; */
    //    exit();
    //}
    //    $db = JFactory::getDbo();
    /*    $db->setQuery("SELECT mime_type 
                         FROM #__booklibrary_mime_types 
                         WHERE `mime_ext` = " . $db->quote($ext)); */
    //    $file_db_mime = $db->loadResult();
    //    $file['type'] = $_FILES['ebook_file']['type'];
    //
    //    if ($file_db_mime != $file['type']) {
    /*       echo "<script> alert(' File mime type not match file ext. - " . $edfile['name'] . "'); 
                     window.history.go(-1); </script>\n"; */
    //        exit();
    //    }
    //    //----------------------
    /*    if (! move_uploaded_file($file['tmp_name'] copy($_FILES['ebook_file']['tmp_name'], 
                     $file_new)) { */
    //        echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR .
    //        "'); window.history.go(-1); </script>\n";
    //        exit();
    //    } else {
    //        $book->ebookURL = $mosConfig_live_site . $booklibrary_configuration['ebooks']['location'] .
    //                $file['name'];
    //    }
    //}
    //
       
    //online flip book link
    $fliphtml5 = mosGetParam($_REQUEST, 'fliphtml5', '');

    if ($fliphtml5 || $fliphtml5 == '') {
        
        $query = " UPDATE #__booklibrary SET flipHTML5 = '" . trim($fliphtml5) . "'  
        WHERE id='" . (int)$book->id . "' ";
        $database->setQuery($query);
        $database->execute();

		$book->flipHTML5 = $fliphtml5;

    }

    //add article book and delete article book

    $id_article_book = $jinput->get('OnlineArticle', '');

    if ($id_article_book) {
        
        $query = " UPDATE #__booklibrary 
                   SET id_article_book = '" . (int)$id_article_book. "' 
                   WHERE id='" . (int)$book->id . "' ";
        $database->setQuery($query);
        $database->execute();

        $book->id_article_book = $id_article_book;
    } 
    else {
        $query2 = "UPDATE #__booklibrary 
                   SET `id_article_book`= 0 
                       WHERE `id`='". (int)$book->id ."' ";
    
        $database->setQuery($query2);
        $database->execute();
    }
    
    // $id_article_book_del = mosGetParam($_REQUEST, 'article_book_del', ''); 
   
    // if ($id_article_book_del) {

        
    //     $query2 = "UPDATE #__booklibrary 
    //                SET `id_article_book`= 0 
    //                WHERE `id`='". (int)$id_article_book_del ."' ";
    
    //     $database->setQuery($query2);
    //     $database->execute();
    // }

    $author_own = mosGetParam($_REQUEST, 'authors', array(), 'ARRAY');
    $informationFrom = mosGetParam($_REQUEST, 'informationFrom', '');
    $author_fetchInfos = $book->authors;
    $book_title = $book->title;
    $own_title = mosGetParam($_REQUEST, 'title', '');

    //add new author
    $new_authors = mosGetParam($_REQUEST, 'new_authors', ''); 
    if (isset($_REQUEST['new_authors'])) {
      $author_own[] = $new_authors;
    } 

    if ( (is_array($author_own) && count($author_own)>0 )
             or (!empty($author_fetchInfos)) ) {

        if (!is_array($author_fetchInfos) && strpos($author_fetchInfos, ',') !== false) $author_fetchInfos =explode(',', $author_fetchInfos);

        if (!empty($author_fetchInfos) && $informationFrom != 0 ) {
            $authors = array();
            $find = null;
            if(is_array($author_fetchInfos)){
                foreach ($author_fetchInfos as $author_name) {
                    $find = findAuthorByName($author_name);
                    if ($find){
                        $authors[] = $find;   
                    } else {
                        $authors[] = createAuthorByName( $author_name);
                    }                    
                }  
            } else {
                $authors[] = findAuthorByName($author_fetchInfos) ? findAuthorByName($author_fetchInfos) : createAuthorByName($author_fetchInfos);
            }
            $book->authors = $authors; 
            unset($authors);
            unset($find);
        } else if (is_array($author_own) && count($author_own)>0 ) {
            $authors = array();
            $find = null;
            foreach ($author_own as $author_name) {
                if (empty($author_name) || $author_name == '') continue;
                $find = findAuthorByName($author_name);
                if ($find){
                    $authors[] = $find ;  
                } else {
                    $authors[] = createAuthorByName( $author_name);
                }
            } 
            $book->authors = $authors;
        } else if( !empty($author_fetchInfos) ){

            $authors = array();
            $find = null;
            if(is_array($author_fetchInfos)){
                foreach ($author_fetchInfos as $author_name) {
                    $find = findAuthorByName($author_name);
                    if ($find){
                        $authors[] = $find;   
                    } else {

                        $authors[] = createAuthorByName( $author_name);
                    }                    
                }  
            } else {
                $authors[] = findAuthorByName($author_fetchInfos) ? findAuthorByName($author_fetchInfos) : createAuthorByName($author_fetchInfos);
            }
            $book->authors = $authors; 
            unset($authors);
            unset($find);

        } else {
            //sanity test
            echo "set author errors";
            return;
        }
    }
 // print_r( $book->authors);
 // print_r("::11111s1111"); 
 // exit;

    $file = $_FILES['picture_file'];

    //-------------------
    if (intval($file['error']) != 4) {
        $ext = pathinfo($_FILES['picture_file']['name'], PATHINFO_EXTENSION);
        $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts_img']);
        $ext = strtolower($ext);
        if (!in_array($ext, $allowed_exts)) {
            echo "<script> alert(' File ext. not allowed to upload! - " . $file['name'] . "'); 
        window.history.go(-1); </script>\n";
            exit();
        }
    }


    //-------------------
    //check if fileupload is correct
    if ($file['size'] != 0 && ($file['error'] != 0 || strpos($file['type'], 'image') === false || 
    strpos($file['type'], 'image') === "")) {
        echo "<script> alert('" . _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD_ERROR . "'); 
      window.history.go(-1); </script>\n";
        exit();
    }


    //store pictures locally if neccesary, first check remote URL
    $retVal = null;
    if (intval($booklibrary_configuration['fetchImages']['boolean']) == 1 && trim($book->imageURL) != "" && 
    $file['size'] == 0) {
        $retVal = mosBooklibraryOthers::storeImageFile($book, null);
    }

    if (intval($booklibrary_configuration['fetchImages']['boolean']) == 1 && $file['size'] != 0) {
        $retVal = mosBooklibraryOthers::storeImageFile($book, $file);
        if ($retVal != null) {
            echo "<script> alert('" . addslashes($retVal) . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }


    if ($file['size'] == 0) {
        $file = null;
    }


    $book->date = date("Y-m-d H:i:s");
    if (!$book->check()) {
        echo "<script> alert('" . addslashes($book->getError()) . "');
               window.history.go(-1); </script>\n";
        exit();
    }


    if (!$book->store()) {
        echo "<script> alert('" . addslashes($book->getError()) . "'); 
               window.history.go(-1); </script>\n";
        exit();
    }
    $book->checkin();

    //*****************************************************start saving files**********************
    storeTrack($book);
    storeAudio($book);
    storeVideo($book);
    storeEbook($book);
    //*****************************************************end saving files************************
    $query = "delete from #__booklibrary_categories where bookid='" . (int)$book->id . "'";

    $database->setQuery($query);
    $database->execute();
    foreach($book->catid as $catitem) {
        $query = "insert into #__booklibrary_categories (bookid, catid) 
                  VALUES ('" . (int)$book->id . "','" . (int)$catitem . "')";
        $database->setQuery($query);
        $database->execute();
    } 

    $book->saveAuthors();

     deleteFiles($book->id);
     deleteVideos($book->id);
     deleteAudios($book->id);
     deleteTracks($book->id);

    PluginHelper::importPlugin('finder'); //init plugins group whereto we send event
    //need for check book state in Joomla smart search (finder plugin)
    $isNew = (intval($book->id) > 0 ) ? false : true ;
    //run reindex
    $results = JFactory::getApplication()->triggerEvent('onFinderAfterSave', array('com_booklibrary.book', $book,$isNew));


    switch ($task) {
    
        case 'apply':
            mosRedirect("index.php?option=" . $option . "&task=edit&bid[]=" . $book->id);
        break;
        case 'save':
            mosRedirect("index.php?option=" . $option);
        break;
    }
}
/**
 * Deletes one or more records
 * @param array - An array of unique category id numbers
 * @param string - The current author option
 */
function saveAuthor($option, $task) {
    global $database, $my, $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
    $author = new mosBookLibrary_authors($database);
    
    $idAuthor = mosGetParam($_POST, 'id', 0);
    $langshowAuthor = mosGetParam($_POST, 'langshow', 0);
    if (!$idAuthor) {
        $aut_name = JFactory::getApplication()->input->getString('authors_name', '');
        $aut_name = addslashes($aut_name);        
        $zap = "SELECT id,langshow 
                FROM #__booklibrary_authors 
                WHERE authors_name 
                LIKE '%" . $aut_name . "%' ";
        $database->setQuery($zap);
        $idAndLangshowAuthors = $database->loadAssocList();

        if (!empty($idAndLangshowAuthors) && ($langshowAuthor == '*')) {
            echo "<script> alert('" . _BOOKLIBRARY_ADMIN_CONFIG_CHECK_AUTHOR . "'); 
        window.history.go(-1); </script>\n";
            exit();
        } else if ($langshowAuthor != '*') {
          foreach ($idAndLangshowAuthors as $value) {
              if($value['langshow'] == $langshowAuthor) {
                echo "<script> alert('" . _BOOKLIBRARY_ADMIN_CONFIG_CHECK_AUTHOR_LANGUAGE . "'); 
                window.history.go(-1); </script>\n";
                exit();
              }
          }
        }
    }
    if (!$author->bind($_POST)) {
        echo "<script> alert('" . addslashes($author->getError()) . "');
               window.history.go(-1); </script>\n";
        exit();
    }

    $registry = new JRegistry($author->metadata); 
    $author->metadata = $registry->toString() ;
    
    $author->publish_up = data_transformer($author->publish_up,"to");
    $author->publish_down = data_transformer($author->publish_down,"to");

    /*************Call function to Save changes for associated books*******************/
    save_author_associate();
    /**********************************************************************************/
    $database->setQuery("SELECT owneremail, owner_id 
                         FROM #__booklibrary_authors 
                         WHERE id = '" . 
      $_POST['owneremail_author'] . "'");
    $own = $database->loadObjectList();
    if ($own == "" || $own == NUll) {
        $author->owner_id = $my->id;
    }
    if ($booklibrary_configuration['publish_on_add']['show']) {
        $author->published = 1;
    } else {
        $author->published = 0;
    }
    $database->setQuery("SELECT max(id) FROM #__booklibrary_authors");
    $max_id = $database->loadResult();
    $max_id = $max_id + 1;
    $file = $_FILES['picture_file_author'];
    //-------------------
    if (intval($file['error']) != 4) {
        $ext = pathinfo($_FILES['picture_file_author']['name'], PATHINFO_EXTENSION);
        $allowed_exts = explode(",", $booklibrary_configuration['allowed_exts_img']);
        $ext = strtolower($ext);
        if (!in_array($ext, $allowed_exts)) {
            echo "<script> alert(' File ext. not allowed to upload! - " . $file['name'] . "'); 
        window.history.go(-1); </script>\n";
            exit();
        }
    }
    //-------------------
    //check if fileupload is correct
    if ($file['size'] != 0 && ($file['error'] != 0 || strpos($file['type'], 'image') === false || 
    strpos($file['type'], 'image') === "")) {
        echo "<script> alert('" . _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD_ERROR . "'); 
       window.history.go(-1); </script>\n";
        exit();
    }
    $retVal = null;
    
    $database->setQuery("SELECT imageURL 
                         FROM #__booklibrary_authors 
                         WHERE id = '" . $author->id . "'");
    $imageURL = $database->loadResult();
    
    if (!empty($file['name']) && !empty($imageURL)) {
        $file_inf = pathinfo($imageURL);
        $file_type = '.' . $file_inf['extension'];
        $file_name = basename($imageURL, $file_type);
        $path = $mosConfig_absolute_path . '/components/com_booklibrary/covers';
        if($file_name  != "" ) {
            $check_files = JFolder::files($path, '^' . $file_name . '.*$', false, true);
            foreach($check_files as $check_file) {
                unlink($check_file);
            }
        }
    }
    
    if (intval($booklibrary_configuration['fetchImages']['boolean']) == 1 && 
        trim($author->imageURL) != "" && 
    $file['size'] == 0) {
        $retVal = mosBooklibraryOthers::storeImageFile($author, null, $max_id);
    }
    if (intval($booklibrary_configuration['fetchImages']['boolean']) == 1 && $file['size'] != 0) {
        $retVal = mosBooklibraryOthers::storeImageFile($author, $file, $max_id);
        if ($retVal != null) {
            echo "<script> alert('" . addslashes($retVal) . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }
    if ($file['size'] == 0) {
        $file = null;
    }
    $author->checkin();
    $author->date = date("Y-m-d H:i:s");
    if (!$author->check()) {
        echo "<script> alert('" . addslashes($author->getError()) . "'); window.history.go(-1); </script>\n";
        exit();
    }

    $author->checked_out_time = "0000-00-00 00:00:00" ;
    if (!$author->store()) {
        echo "<script> alert('" . addslashes($author->getError()) . "'); window.history.go(-1); </script>\n";
        exit();
    }
    switch ($task) {
        case 'apply_author':
            mosRedirect("index.php?option=" . $option . "&task=edit_author&bid[]=" . $author->id);
        break;
        case 'save_author':
            mosRedirect("index.php?option=" . $option . "&task=manage_author");
        break;
    }
}

function removeBooks($bid, $option) {
    global $database, $book;
    if (!is_array($bid) || count($bid) < 1) {
        echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
        exit;
    }
    /***********************************************************************************************/
    for ($i = 0;$i < count($bid);$i++) {
        $query = "SELECT associate_book 
                  FROM #__booklibrary 
                  WHERE id =" . $bid[$i];
        $database->setQuery($query);
        $bookAssociateBook = $database->loadResult();
        $assocBookObj = unserialize($bookAssociateBook);
        $idWhereChange = array();
        if (!empty($assocBookObj)) {
            foreach($assocBookObj as $key => $value) {
                if ($value == $bid[$i]) {
                    $assocBookObj[$key] = null;
                } else if ($value) {
                    $idWhereChange[] = $value;
                }
            }
            $stringIdWhereChange = implode(',', $idWhereChange);
            $newAssocSerialize = serialize($assocBookObj);
            if (!empty($stringIdWhereChange)) {
                $query = "UPDATE #__booklibrary 
                          SET associate_book ='$newAssocSerialize'
                          WHERE id IN($stringIdWhereChange)";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }
    /********************************************************************************************/
    if (count($bid)) {
        $removefile = 1;
        foreach($bid as $id) {
            deleteFiles($id, $removefile);
            deleteVideos($id, $removefile);
            deleteAudios($id, $removefile);
            deleteTracks($id, $removefile);
            $books4del = new mosBooklibrary($database);
            $books4del->load($id);
            $books4del->delete();

            $query = "delete from #__booklibrary_categories where bookid='" . (int)$books4del->id . "'";
            $database->setQuery($query);
            $database->execute();
            
            $query = "delete from #__booklibrary_authors_connect where fk_bookid='" . (int)$books4del->id . "'";
            $database->setQuery($query);
            $database->execute();            

            $query = "delete from #__booklibrary_authors_connect where 
                    NOT EXISTS ( select * from #__booklibrary as b where b.id = '" . (int)$books4del->id . "') and  #__booklibrary_authors_connect.fk_bookid = '" . (int)$books4del->id . "' ";
                    // echo $query;
                    // exit ;
            $database->setQuery($query);
            $database->execute();            
        }
    }
    mosRedirect("index.php?option=$option");
}
/**
 * Publishes or Unpublishes one or more records
 * @param array - An array of unique category id numbers
 * @param integer - 0 if unpublishing, 1 if publishing
 * @param string - The current author option
 */
function publishBooks($bid, $publish, $option) {
    global $database, $my;
    $catid = mosGetParam($_POST, 'catid', array(0),'ARRAY');
    if (!is_array($bid) || count($bid) < 1) {
        $action = $publish ? 'publish' : 'unpublish';
        echo "<script> alert('Select an item to " . addslashes($action) . "'); 
               window.history.go(-1);</script>\n";
        exit;
    }
    $bids = implode(',', $bid);
    $database->setQuery("UPDATE #__booklibrary SET published='$publish'" . 
            "\nWHERE id IN ($bids) AND (checked_out=0 OR (checked_out='$my->id'))");
    $database->execute();

    PluginHelper::importPlugin('finder'); //init plugins group whereto we send event
    if (count($bid) > 0) {
        foreach($bid as $id){
            $book = new mosBookLibrary($database);
            $book->load($id);
            $book->checkin($id);
    
            //need for check book state in Joomla smart search (finder plugin)
            //run reindex
            $results = JFactory::getApplication()->triggerEvent('onFinderChangeState', array('com_booklibrary.book', $bid, $publish ) ) ;

            unset($book);
        }
    }

    mosRedirect("index.php?option=$option");
}
/**
 * Approve or Unapprove one or more records
 * @param array - An array of unique category id numbers
 * @param integer - 0 if unapprove, 1 if approve
 * @param string - The current author option
 */
function approveBooks($bid, $approve, $option) {
    global $database, $my;
    $catid = mosGetParam($_POST, 'catid', array(0), 'ARRAY');
    if (!is_array($bid) || count($bid) < 1) {
        $action = $approve ? 'approve' : 'unapprove';
        echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
        exit;
    }
    $bids = implode(',', $bid);
    $database->setQuery("UPDATE #__booklibrary SET approved='$approve'" .
                 "\nWHERE id IN ($bids) AND (checked_out=0 OR (checked_out='$my->id'))");
    //$database->setQuery("UPDATE #__booklibrary 
    //                     SET published=$approve, approved='$approve'" . "\n
    //                     WHERE id IN ($bids) AND (checked_out=0 OR (checked_out='$my->id'))");
    $database->execute() ;



    PluginHelper::importPlugin('finder'); //init plugins group whereto we send event
    if (count($bid) > 0) {
        foreach($bid as $id){
            $book = new mosBookLibrary($database);
            $book->load($id);
            $book->checkin($id);

            //need for check book state in Joomla smart search (finder plugin)
            //run reindex
            $results = JFactory::getApplication()->triggerEvent('onFinderChangeState', array('com_booklibrary.book', $bid, $approve ) ) ;
            unset($book);
        }
    }

    mosRedirect("index.php?option=$option");
}
/**
 * Moves the order of a record
 * @param integer - The increment to reorder by
 */
function orderBooks($bid, $inc, $option) {
    global $database;
    $book = new mosBookLibrary($database);
    $book->load($bid);
    $book->move($inc);
    mosRedirect("index.php?option=$option");
}
/**
 * Cancels an edit operation
 * @param string - The current author option
 */
function cancelBook($option) {
    global $database;
    $row = new mosBookLibrary($database);
    $row->bind($_POST);
    $row->checkin();
    mosRedirect("index.php?option=$option");
}
 
function refetchInfo($option, $bid) {
    global $database, $my, $booklibrary_configuration;
    $informationFrom = mosGetParam($_POST, 'informationFrom');
    if (!is_array($bid) || count($bid) < 1) {
        echo "<script> alert('Select an item to refetch'); window.history.go(-1);</script>\n";
        exit;
    }
    $bids = implode(',', $bid);
    $database->setQuery("SELECT id, bookid, isbn, title, informationFrom 
                         FROM #__booklibrary 
                         WHERE id IN ($bids)");
    $database->execute();

    $books = $database->loadObjectList();
    // get list of WS
    $retVal = mosBooklibraryWS::getWSArray();
    $ws = null;
    for ($i = 0, $n = count($retVal);$i < $n;$i++) {
        $help = $retVal[$i];
        $ws[] = mosHTML::makeOption($help[0], $help[1]);
    }
    $wslist = mosHTML::selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 'value', 'text');
    if ($informationFrom == null) {
        //show fetching information
        HTML_booklibrary::refetchBoosks($option, $books, $wslist);
    } else {
        //fetching information
        $infos = array();
        $id = array_pop($bid);
        while ($id != null) {
            $book = new mosBookLibrary($database);
            $book->load($id);
            $book->informationFrom = $informationFrom;
            $book_tmp = $book;
            $book = mosBooklibraryWS::fetchInfos($book);
            if (is_string($book)) {
                //there was an error while fetching!
                array_push($infos, array($book_tmp->id, $book_tmp->bookid, $book_tmp->isbn, $book));
            } else {
                //storing pictures if neccesary
                $retVal = null;
                if (intval($booklibrary_configuration['fetchImages']['boolean']) == 1) {
                    $retVal = mosBooklibraryOthers::storeImageFile($book, null);
                }
                //fetching was OK!
                $book->date = date("Y-m-d H:i:s");
                if ($retVal != null) {
                    // error storing picture
                    array_push($infos, array($book->id, $book->bookid, $book->isbn, $retVal));
                } else if (!$book->check() || !$book->store()) {
                    //error while storing information!
                    array_push($infos, array($book->id, $book->bookid, $book->isbn, $book->getError()));
                } else {
                    array_push($infos, array($book->id, $book->bookid, $book->isbn, "OK"));


                    $author_fetchInfos = $book->authors;
                    if ( !empty($author_fetchInfos) ) {

                        if (strpos($author_fetchInfos, ',') !== false) $author_fetchInfos =explode(',', $author_fetchInfos);
                        
                        if (!empty($author_fetchInfos)) {
                            $authors = array();
                            if(is_array($author_fetchInfos)){
                                $find = null;
                                $count_authors = count($author_fetchInfos);
                                foreach ($author_fetchInfos as $author_name) {
                                    $find = findAuthorByName($author_name);
                                    if ($find){
                                      $authors = array_merge($authors, array_unique($find)) ;  
                                    }                    
                                }    
                                if (count($authors) == $count_authors) $author_id = array_unique($authors);
                            } else {
                                $author_id = findAuthorByName($author_fetchInfos);
                 
                            }
                            if (is_array($author_id) && count($author_id)>0  ) {
                                $book->authors  = $author_id;
                            } else {
                                if (is_array($author_fetchInfos)){
                                    foreach ($author_fetchInfos as $author_name) {
                                        if (findAuthorByName($author_name)) continue;
                                        else $authors[] = createAuthorByName( $author_name);
                                    } 
                                } else {
                                    $authors[] = createAuthorByName( $author_fetchInfos);
                                }
                                $book->authors = $authors; 
                            }    
                            unset($authors);
                            unset($find);
                            unset($count_authors);
                            
                            $book->saveAuthors();
                        }
                    }


                }
                $book->checkin();
                
                
            }
            $id = array_pop($bid);
        }
        $infos = array_reverse($infos);
        HTML_booklibrary::showInfoRefetchBooks($option, $infos, $wslist);
    }
}
function configure_list_set_value($parametr) {
    $str = "";
    if (isset($parametr) && $parametr != 0) {
        $str = implode(',', $parametr);
        return $str;
    } else return 0;
}
function configure_save_frontend($option) {
    global $my, $booklibrary_configuration, $mosConfig_absolute_path;

    $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_booklibrary/booklibrary_j3.xml");
    $booklibrary_configuration['release']['version'] = (string)$xml->version;
    $booklibrary_configuration['release']['date'] = (string)$xml->creationDate;
    unset($xml);

    $booklibrary_configuration['ebooks']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'ebooks_registrationlevel', 0));
    $booklibrary_configuration['reviews']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'reviews_registrationlevel', 0));
    $booklibrary_configuration['approve_review']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'approve_review_registrationlevel', 0));
    $booklibrary_configuration['litpage']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'litpage_registrationlevel', 0));
    $booklibrary_configuration['litpage_author']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'litpage_registrationlevel_author', 0));
    $booklibrary_configuration['litpage']['show'] = 
        mosGetParam($_POST, 'litpage_show', 0);
    $booklibrary_configuration['litpage_author']['show'] = 
        mosGetParam($_POST, 'litpage_show_author', 0);
    $booklibrary_configuration['lendrequest']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'lendrequest_registrationlevel', 0));
    $booklibrary_configuration['price']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'price_registrationlevel', 0));
    $booklibrary_configuration['advsearch']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'advsearch_registrationlevel', 0));
    $booklibrary_configuration['advsearch']['show'] = 
        mosGetParam($_POST, 'advsearch_show', 0);
    $booklibrary_configuration['search_field']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'search_field_registrationlevel', 0));
    $booklibrary_configuration['search_field']['show'] = 
        mosGetParam($_POST, 'search_field_show', 0);

    // add to wishlist button ------------------------------
    $booklibrary_configuration['addtowishlist_button']['allow']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'addtowishlist_button_registrationlevel', 0));
    $booklibrary_configuration['addtowishlist_button']['show'] = 
        mosGetParam($_POST, 'addtowishlist_button_show', 0);
    // end add to wishlist button ---------------------------
    $booklibrary_configuration['rss']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'rss_registrationlevel', 0));
    $booklibrary_configuration['rss']['show'] = 
        mosGetParam($_POST, 'rss_show', 0);
    $booklibrary_configuration['print_view']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'print_view_registrationlevel', 0));
    $booklibrary_configuration['print_view']['show'] = 
        mosGetParam($_POST, 'print_view_show', 0);
    $booklibrary_configuration['print_pdf']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'print_pdf_registrationlevel', 0));
    $booklibrary_configuration['print_pdf']['show'] = mosGetParam($_POST, 'print_pdf_show', 0);
    $booklibrary_configuration['buy_now']['allow']['categories'] = 
        configure_list_set_value(mosGetParam($_POST, 'buy_now_allow_categories', 0));
    $booklibrary_configuration['buy_now']['show'] = mosGetParam($_POST, 'buy_now_show', 0);
    $booklibrary_configuration['addbook_button']['allow']['categories'] = 
        configure_list_set_value(mosGetParam($_POST, 'addbook_button_allow_categories', 0));
    $booklibrary_configuration['addbook_button']['allow']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'addbook_button_registrationlevel', 0));
    $booklibrary_configuration['addbook_button']['show'] = 
        mosGetParam($_POST, 'addbook_button_show', 0);
    $booklibrary_configuration['cb_mybook']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'cb_mybook_registrationlevel', 0));
    $booklibrary_configuration['cb_edit']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'cb_edit_registrationlevel', 0));
    $booklibrary_configuration['cb_rent']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'cb_rent_registrationlevel', 0));
    $booklibrary_configuration['cb_history']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'cb_history_registrationlevel', 0));
    $booklibrary_configuration['cb']['show'] = mosGetParam($_POST, 'cb_show', 0);
    $booklibrary_configuration['cb_mybook']['show'] = mosGetParam($_POST, 'cb_show_mybook', 0);
    $booklibrary_configuration['cb_edit']['show'] = mosGetParam($_POST, 'cb_show_edit', 0);
    $booklibrary_configuration['cb_rent']['show'] = mosGetParam($_POST, 'cb_show_rent', 0);
    $booklibrary_configuration['cb_history']['show'] = mosGetParam($_POST, 'cb_show_history', 0);
    $booklibrary_configuration['add_suggest']['show'] = mosGetParam($_POST, 'add_suggest_show', 0);
    $booklibrary_configuration['my_books_button']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'my_books_button_registrationlevel', 0));
    $booklibrary_configuration['my_books_button']['show'] = 
        mosGetParam($_POST, 'my_books_button', 0);
    $booklibrary_configuration['reviews']['show'] = mosGetParam($_POST, 'reviews_show', 0);
    $booklibrary_configuration['approve_review']['show'] = mosGetParam($_POST, 'approve_review', 0);
    $booklibrary_configuration['lendstatus']['show'] = mosGetParam($_POST, 'lendstatus_show', 0);
    $booklibrary_configuration['ebooks']['show'] = mosGetParam($_POST, 'ebooks_show', 0);
    $booklibrary_configuration['price']['show'] = mosGetParam($_POST, 'price_show', 0);
    $booklibrary_configuration['foto']['high'] = mosGetParam($_POST, 'foto_high');
    $booklibrary_configuration['foto']['width'] = mosGetParam($_POST, 'foto_width');
    $booklibrary_configuration['foto']['high_author'] = mosGetParam($_POST, 'foto_high_author');
    $booklibrary_configuration['foto']['width_author'] = mosGetParam($_POST, 'foto_width_author');
    $booklibrary_configuration['page']['items'] = mosGetParam($_POST, 'page_items');
    $booklibrary_configuration['page']['items_author'] = mosGetParam($_POST, 'page_items_author');
    $booklibrary_configuration['author_photo']['show'] = mosGetParam($_POST, 'author_photo_show');
    $booklibrary_configuration['license']['show'] = mosGetParam($_POST, 'license_show');
    $booklibrary_configuration['cat_pic']['show'] = mosGetParam($_POST, 'cat_pic_show');
    $booklibrary_configuration['subcategory']['show'] = mosGetParam($_POST, 'subcategory_show');
    $booklibrary_configuration['category']['default_sort'] = 
        mosGetParam($_POST, 'category_default_sort');
    $booklibrary_configuration['show_metadata'] = 
        mosGetParam($_POST, 'show_metadata');
    $booklibrary_configuration['owner']['show'] = mosGetParam($_POST, 'owner_show');
    $booklibrary_configuration['all_categories'] = mosGetParam($_POST, 'all_categories');
    $booklibrary_configuration['view_type'] = mosGetParam($_POST, 'view_type');
    $booklibrary_configuration['view_book'] = mosGetParam($_POST, 'view_book');
    $booklibrary_configuration['search_lay'] = mosGetParam($_POST, 'search_lay');
    $booklibrary_configuration['books'] = mosGetParam($_POST, 'books');
    $booklibrary_configuration['ownerslist_page'] = mosGetParam($_POST, 'ownerslist_page');
    $booklibrary_configuration['approve_on_add']['show'] = mosGetParam($_POST, 'approve_on_add');
    $booklibrary_configuration['approve_on_add']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'approve_on_add_registrationlevel', 0));
    $booklibrary_configuration['publish_on_add']['show'] = mosGetParam($_POST, 'publish_on_add');
    $booklibrary_configuration['publish_on_add']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'publish_on_add_registrationlevel', 0));
    $booklibrary_configuration['ownerslist']['show'] = mosGetParam($_POST, 'ownerslist_show');
    $booklibrary_configuration['ownerslist']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'ownerslist_registrationlevel', 0));
    $booklibrary_configuration['allowed_exts'] = mosGetParam($_POST, 'allowed_exts', "");
    $booklibrary_configuration['allowed_exts_img'] = mosGetParam($_POST, 'allowed_exts_img', "");
    $booklibrary_configuration['allowed_exts_video'] = mosGetParam($_POST, 'allowed_exts_video', "");
    $booklibrary_configuration['allowed_exts_audio'] = mosGetParam($_POST, 'allowed_exts_audio', "");
    $booklibrary_configuration['allowed_exts_track'] = mosGetParam($_POST, 'allowed_exts_track', "");
    $booklibrary_configuration['price_format'] = $_POST['patern'];
    $booklibrary_configuration['date_format'] = mosGetParam($_POST, 'date_format');
    $booklibrary_configuration['datetime_format'] = mosGetParam($_POST, 'datetime_format');
    $booklibrary_configuration['price_unit_show'] = $_POST['price_unit_show'];
    $booklibrary_configuration['cb_access']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'cb_access_registrationlevel', 0));
    $booklibrary_configuration['cb_access']['show'] = mosGetParam($_POST, 'cb_show_access', 0);
    // print_r($booklibrary_configuration['cb_access']['show']);exit;
    if (isset($_REQUEST['add_suggest_registrationlevel'])) $booklibrary_configuration['add_suggest']['registrationlevel'] = 
            configure_list_set_value(mosGetParam($_POST, 'add_suggest_registrationlevel', 0));
    else $booklibrary_configuration['add_suggest']['registrationlevel'] = 0;
    if (isset($_POST['LicenseField'])) {
        $booklibrary_configuration['license']['text'] = str_replace("\\", "", $_POST['LicenseField']);
    }
    mosBooklibraryOthers::setParams();
    configure_frontend($option);
}
function configure_save_backend($option) {
    global $my, $booklibrary_configuration, $mosConfig_absolute_path;
    //**********   begin add merge description  *****************************
    $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_booklibrary/booklibrary_j3.xml");
    $booklibrary_configuration['release']['version'] = (string)$xml->version;
    $booklibrary_configuration['release']['date'] = (string)$xml->creationDate;
    unset($xml);

    $str = '';
    $supArr = mosGetParam($_POST, 'merge_description_registrationlevel', 0);
    $str = implode(',', $supArr);
    $booklibrary_configuration['merge_description']['registrationlevel'] = $str;
    $booklibrary_configuration['merge_description']['use'] = 
        mosGetParam($_POST, 'merge_description_use', 0);
    //*********   end add merge description   *********
    //**********   begin add Online Read book from Article  *****************************
    $str = '';
    $supArr = mosGetParam($_POST, 'online_book_from_article_registrationlevel', 0);
    $str = implode(',', $supArr);
    $booklibrary_configuration['online_book_from_article']['registrationlevel'] = $str;
    $booklibrary_configuration['online_book_from_article']['allow'] = 
        mosGetParam($_POST, 'online_book_from_article_allow', 0);
    //*********   end add Online Read book from Article   *********
    //**********   begin add Online read book flip  *****************************
    $str = '';
    $supArr = mosGetParam($_POST, 'online_book_flip_registrationlevel', 0);
    $str = implode(',', $supArr);
    $booklibrary_configuration['online_book_flip']['registrationlevel'] = $str;
    $booklibrary_configuration['online_book_flip']['allow'] = 
        mosGetParam($_POST, 'online_book_flip_allow', 0);
    //*********   end add Online read book flip   *********
    //configure_backend_value('1');
    $booklibrary_configuration['review_added_email']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'review_added_email_registrationlevel', 0));
    $booklibrary_configuration['review_added_email']['show'] = 
        mosGetParam($_POST, 'review_added_email_show', 0);
    $booklibrary_configuration['review_email']['address'] = 
        mosGetParam($_POST, 'review_email_address', ""); //back--1
    $booklibrary_configuration['suggest_email']['address'] = 
        mosGetParam($_POST, 'suggest_email_address', "");
    $booklibrary_configuration['lendrequest_email']['address'] = 
        mosGetParam($_POST, 'lendrequest_email_address', "");
    $booklibrary_configuration['addbook_email']['address'] = 
        mosGetParam($_POST, 'addbook_email_address', "");
    $booklibrary_configuration['bookid']['auto-increment']['boolean'] = 
        mosGetParam($_POST, 'bookid_auto_increment_boolean', 0);
    $booklibrary_configuration['fetchImages']['boolean'] = 
        mosGetParam($_POST, 'fetchImages_boolean', 0);
    $booklibrary_configuration['ebooks']['allow'] = mosGetParam($_POST, 'ebooks_allow', 0);
    $booklibrary_configuration['videos_tracks']['allow'] = 
        mosGetParam($_POST, 'videos_tracks_allow', 0);
    $booklibrary_configuration['audios']['allow'] = mosGetParam($_POST, 'audios_allow', 0);
    $booklibrary_configuration['ws']['amazon']['tag'] = 
        mosGetParam($_POST, 'ws_amazon_tag', "gerdsaurer-20");
    $booklibrary_configuration['ws']['amazon']['devtag'] = 
        mosGetParam($_POST, 'ws_amazon_devtag');
    $booklibrary_configuration['ws']['amazon']['secret_key'] = 
        mosGetParam($_POST, 'ws_amazon_secret_key');
    $booklibrary_configuration['editbook']['check']['isbn'] = 
        mosGetParam($_POST, 'editbook_check_isbn', 0); //back--7
    $booklibrary_configuration['editbook']['default']['host'] = 
        mosGetParam($_POST, 'editbook_default_host', 0);
    $booklibrary_configuration['editbook']['default']['lang'] = 
        mosGetParam($_POST, 'editbook_default_lang', 0);
    $booklibrary_configuration['suggest_added_email']['show'] = 
        mosGetParam($_POST, 'suggest_added_email_show', 0);
    $booklibrary_configuration['proxy_server']['address'] = 
        mosGetParam($_POST, 'proxy_server_adress', "");
    $booklibrary_configuration['port_proxy_server']['address'] = 
        mosGetParam($_POST, 'port_proxy_server_adress', "");
    $booklibrary_configuration['login_proxy_server']['address'] = 
        mosGetParam($_POST, 'login_proxy_server_adress', "");
    $booklibrary_configuration['password_proxy_server']['address'] = 
        mosGetParam($_POST, 'password_proxy_server_adress', "");
    $booklibrary_configuration['suggest_added_email']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'suggest_added_email_registrationlevel', 0));
    $booklibrary_configuration['lendrequest_admin_decline_accept'] = 
        mosGetParam($_POST, 'lendrequest_admin_decline_accept', "");
    $booklibrary_configuration['lendrequest_email']['show'] = 
        mosGetParam($_POST, 'lendrequest_email_show', 0);
    $booklibrary_configuration['update'] = mosGetParam($_POST, 'update', "no");
    $booklibrary_configuration['lend_answer'] = mosGetParam($_POST, 'lend_answer', 0);
    //$booklibrary_configuration['lend_form'] = str_replace("\\", "", $_REQUEST['lend_form']);
    $booklibrary_configuration['lend_before_end_notify'] = 
        mosGetParam($_POST, 'lend_before_end_notify', 0);
    $booklibrary_configuration['lend_before_end_notify_days'] = 
        mosGetParam($_POST, 'lend_before_end_notify_days', "2");
    $booklibrary_configuration['lend_before_end_notify_email'] = 
        mosGetParam($_POST, 'lend_before_end_notify_email', "");
    $booklibrary_configuration['lendrequest_email']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'lendrequest_email_registrationlevel', 0));
    $booklibrary_configuration['addbook_email']['show'] = 
        mosGetParam($_POST, 'addbook_email_show', 0);
    $booklibrary_configuration['addbook_email']['registrationlevel'] = 
        configure_list_set_value(mosGetParam($_POST, 'addbook_email_registrationlevel', 0));
    mosBooklibraryOthers::setParams();
    $s = $_FILES['yaz_connection_file'];
    if ((isset($_FILES['yaz_connection_file']['name'])) AND 
            ($_FILES['yaz_connection_file']['name'] != "")) {
        $tmpName = $_FILES['yaz_connection_file']['tmp_name'];
        $newName = $mosConfig_absolute_path . 
            '/administrator/components/com_booklibrary/exports/dbz3950.csv';
        if (!is_uploaded_file($tmpName) || !move_uploaded_file($tmpName, $newName)) {
            echo "<script> alert('FAILED TO UPLOAD " . $_FILES['yaz_connection_file']['name'] . 
                "<br>Temporary Name: $tmpName <br>'); window.history.go(-1);</script>\n";
            exit;
        }
    }
    configure_backend($option);
}
function configure_frontend($option) {
    global $my, $booklibrary_configuration, $acl, $database;
    global $mosConfig_absolute_path;
    $yesno[] = mosHTML::makeOption('1', _BOOKLIBRARY_YES);
    $yesno[] = mosHTML::makeOption('0', _BOOKLIBRARY_NO);
    $gtree[] = mosHTML::makeOption('-2', 'Everyone');
    $gtree = get_group_children_tree_bl();
    $lists = array();
    $f = array();
    $s = explode(',', $booklibrary_configuration['reviews']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['reviews']['show'] = mosHTML::RadioList($yesno, 'reviews_show', 'class="inputbox"', 
        $booklibrary_configuration['reviews']['show'], 'value', 'text');
    $lists['reviews']['registrationlevel'] = mosHTML::selectList($gtree, 'reviews_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['litpage']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['litpage']['show'] = mosHTML::RadioList($yesno, 'litpage_show', 'class="inputbox"', 
        $booklibrary_configuration['litpage']['show'], 'value', 'text');
    $lists['litpage']['registrationlevel'] = mosHTML::selectList($gtree, 'litpage_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['litpage_author']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['litpage_author']['show'] = mosHTML::RadioList($yesno, 'litpage_show_author', 
        'class="inputbox"', $booklibrary_configuration['litpage_author']['show'], 'value', 'text');
    $lists['litpage_author']['registrationlevel'] = mosHTML::selectList($gtree, 
        'litpage_registrationlevel_author[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['lendrequest']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['lendstatus']['show'] = mosHTML::RadioList($yesno, 'lendstatus_show', 'class="inputbox"', 
        $booklibrary_configuration['lendstatus']['show'], 'value', 'text');
    $lists['lendrequest']['registrationlevel'] = mosHTML::selectList($gtree, 
        'lendrequest_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['ebooks']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['ebooks']['registrationlevel'] = mosHTML::selectList($gtree, 'ebooks_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['ebooks']['show'] = mosHTML::RadioList($yesno, 'ebooks_show', 'class="inputbox"', 
        $booklibrary_configuration['ebooks']['show'], 'value', 'text');
    $f = array();
    $s = explode(',', $booklibrary_configuration['price']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['price']['show'] = mosHTML::RadioList($yesno, 'price_show', 'class="inputbox"', 
        $booklibrary_configuration['price']['show'], 'value', 'text');
    $lists['price']['registrationlevel'] = mosHTML::selectList($gtree, 'price_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    // _______________- community builder section -_______________
    $f = array();
    $s = explode(',', $booklibrary_configuration['cb_mybook']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['cb_mybook']['show'] = mosHTML::RadioList($yesno, 'cb_show_mybook', 'class="inputbox"', 
        $booklibrary_configuration['cb_mybook']['show'], 'value', 'text');
    $lists['cb_mybook']['registrationlevel'] = mosHTML::selectList($gtree, 
        'cb_mybook_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['cb_edit']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['cb_edit']['show'] = mosHTML::RadioList($yesno, 'cb_show_edit', 'class="inputbox"', 
        $booklibrary_configuration['cb_edit']['show'], 'value', 'text');
    $lists['cb_edit']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_edit_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['cb_rent']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['cb_rent']['show'] = mosHTML::RadioList($yesno, 'cb_show_rent', 'class="inputbox"', 
        $booklibrary_configuration['cb_rent']['show'], 'value', 'text');
    $lists['cb_rent']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_rent_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['cb_history']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['cb_history']['show'] = mosHTML::RadioList($yesno, 'cb_show_history', 'class="inputbox"', 
        $booklibrary_configuration['cb_history']['show'], 'value', 'text');
    $lists['cb_history']['registrationlevel'] = mosHTML::selectList($gtree, 
        'cb_history_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //user access
    $f = array();
    $s = explode(',', $booklibrary_configuration['cb_access']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['cb_access']['show'] = mosHTML::RadioList($yesno, 'cb_show_access', 'class="inputbox"', 
        $booklibrary_configuration['cb_access']['show'], 'value', 'text');
    $lists['cb_access']['registrationlevel'] = mosHTML::selectList($gtree, 
        'cb_access_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    // _______________- end community builder section -_______________
    $f = array();
    $s = explode(',', $booklibrary_configuration['search_field']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['search_field']['show'] = mosHTML::RadioList($yesno, 'search_field_show', 
        'class="inputbox"', $booklibrary_configuration['search_field']['show'], 'value', 'text');
    $lists['search_field']['registrationlevel'] = mosHTML::selectList($gtree, 
        'search_field_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['advsearch']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['advsearch']['show'] = mosHTML::RadioList($yesno, 'advsearch_show', 'class="inputbox"', 
        $booklibrary_configuration['advsearch']['show'], 'value', 'text');
    $lists['advsearch']['registrationlevel'] = mosHTML::selectList($gtree, 
        'advsearch_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** RSS ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['rss']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['rss']['show'] = mosHTML::RadioList($yesno, 'rss_show', 'class="inputbox"', 
        $booklibrary_configuration['rss']['show'], 'value', 'text');
    $lists['rss']['registrationlevel'] = mosHTML::selectList($gtree, 'rss_registrationlevel[]', 
        'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END RSS ************
    //********** SHOW MY BOOKS ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['my_books_button']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['my_books_button']['registrationlevel'] = mosHTML::selectList($gtree, 
        'my_books_button_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['my_books_button']['show'] = mosHTML::RadioList($yesno, 'my_books_button', 
        'class="inputbox"', $booklibrary_configuration['my_books_button']['show'], 'value', 'text');
    //********** END SHOW MY BOOKS ************
    //********** PUBLISH ADDED BOOK ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['publish_on_add']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['publish_on_add']['registrationlevel'] = mosHTML::selectList($gtree, 
        'publish_on_add_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['publish_on_add']['show'] = mosHTML::RadioList($yesno, 'publish_on_add', 
        'class="inputbox"', $booklibrary_configuration['publish_on_add']['show'], 'value', 'text');
    //********** END PUBLISH ADDED BOOK ************
    //----------------------------------------
    //********** PDF  VIEW ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['print_pdf']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['print_pdf']['show'] = mosHTML::RadioList($yesno, 'print_pdf_show', 'class="inputbox"', 
        $booklibrary_configuration['print_pdf']['show'], 'value', 'text');
    $lists['print_pdf']['registrationlevel'] = mosHTML::selectList($gtree, 
        'print_pdf_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END PDF VIEW ************
    //********** PRINT VIEW ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['print_view']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['print_view']['show'] = mosHTML::RadioList($yesno, 'print_view_show', 'class="inputbox"', 
        $booklibrary_configuration['print_view']['show'], 'value', 'text');
    $lists['print_view']['registrationlevel'] = mosHTML::selectList($gtree, 
        'print_view_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END PRINT VIEW ************
    //********   begin add button 'buy now'   ************************
    $ctree[] = mosHTML::makeOption('-2', 'All Categories');
    $id = 0;
    $list = CAT_Utils::categoryArray();
    $cat = new mainBooklibraryCategories($database); 
    $cat->load($id);
    $this_treename = '';
    $options = array();
    foreach($list as $item) {
        if ($this_treename) {
            if ($item->id != $cat->id && strpos($item->treename, $this_treename) === false) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            }
        } else {
            if ($item->id != $cat->id) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            } else {
                $this_treename = "$item->treename/";
            }
        }
    }
    //$ctree = array_merge($ctree, $options);
    if (count($options) > 0) $ctree = array_merge($ctree, $options);
    $f = array();
    $s = explode(',', $booklibrary_configuration['buy_now']['allow']['categories']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['buy_now']['show'] = mosHTML::RadioList($yesno, 'buy_now_show', 'class="inputbox"', 
        $booklibrary_configuration['buy_now']['show'], 'value', 'text');
    $lists['buy_now']['allow']['categories'] = mosHTML::selectList($ctree, 
        'buy_now_allow_categories[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*************   end add button 'buy now'   ************************

    //******   begin add for Manager Suggestion: button 'Suggest a book'   *****
    $f_r = array();
    $s = explode(',', $booklibrary_configuration['addbook_button']['allow']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f_r[] = mosHTML::makeOption($s[$i]);
    unset($f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['addbook_button']['allow']['categories']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['addbook_button']['show'] = mosHTML::RadioList($yesno, 'addbook_button_show', 
        'class="inputbox"', $booklibrary_configuration['addbook_button']['show'], 'value', 'text');
    $lists['addbook_button']['allow']['categories'] = mosHTML::selectList($ctree, 
        'addbook_button_allow_categories[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['addbook_button']['allow']['registrationlevel'] = mosHTML::selectList($gtree, 
        'addbook_button_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f_r);
    //*************   end add button 'buy now'   ************************
    //********** begin add button 'add to wishlist' **********************
    $f = array();
    $s = explode(',', $booklibrary_configuration['addtowishlist_button']['allow']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['addtowishlist_button']['show'] = mosHTML::RadioList($yesno, 'addtowishlist_button_show', 'class="inputbox"', $booklibrary_configuration['addtowishlist_button']['show'], 'value', 'text');
    $lists['addtowishlist_button']['allow']['registrationlevel'] = mosHTML::selectList($gtree, 'addtowishlist_button_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*********************************************************************
    //******   begin add for Manager Suggestion: button 'Suggest a book'   *****
    $f = array();
    $s = explode(',', $booklibrary_configuration['add_suggest']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['add_suggest']['show'] = mosHTML::RadioList($yesno, 'add_suggest_show', 
        'class="inputbox"', $booklibrary_configuration['add_suggest']['show'], 'value', 'text');
    $lists['add_suggest']['registrationlevel'] = mosHTML::selectList($gtree, 
        'add_suggest_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*******   end add for Manager Suggestion: button 'Suggest a book'   *******
    $query = 'show columns from #__booklibrary';
    $database->setQuery($query);
    $columns = $database->loadObjectList();

    $col_list[] = mosHTML::makeOption('title', 'title');
    $col_list[] = mosHTML::makeOption('authors', 'authors');
    $col_list[] = mosHTML::makeOption('rating', 'rating');
    $col_list[] = mosHTML::makeOption('hits', 'hits');
    $lists['category']['default_sort'] = mosHTML::selectList($col_list, 'category_default_sort', '', 
        'value', 'text', $booklibrary_configuration['category']['default_sort']);

    $m_list[] = mosHTML::makeOption('0', _BOOKLIBRARY_NOT_ADD_META);
    $m_list[] = mosHTML::makeOption('1', _BOOKLIBRARY_ADD_META_MANUAL);
    $m_list[] = mosHTML::makeOption('2', _BOOKLIBRARY_AUTOMATIC_GENERATE_META);
    $m_list[] = mosHTML::makeOption('3', _BOOKLIBRARY_AUTOMATIC_GENERATE_META_FOR_EMPTY);
    $lists['show_metadata'] = mosHTML::selectList($m_list, 'show_metadata', '', 
        'value', 'text', $booklibrary_configuration['show_metadata']);
    
    $lists['foto']['high'] = '<input type="text" name="foto_high" value="' . 
        $booklibrary_configuration['foto']['high'] . '" class="inputbox" size="4" maxlength="4" title="" />';
    $lists['foto']['width'] = '<input type="text" name="foto_width" value="' . 
        $booklibrary_configuration['foto']['width'] . '" class="inputbox" size="4" maxlength="4" title="" />';
    $lists['foto']['high_author'] = '<input type="text" name="foto_high_author" value="' . 
        $booklibrary_configuration['foto']['high_author'] . '" class="inputbox" size="4" maxlength="4" title="" />';
    $lists['foto']['width_author'] = '<input type="text" name="foto_width_author" value="' . 
        $booklibrary_configuration['foto']['width_author'] . '" class="inputbox" size="4" maxlength="4" title="" />';
    $lists['page']['items'] = '<input type="text" name="page_items" value="' . 
        $booklibrary_configuration['page']['items'] . '" class="inputbox" size="3" maxlength="3" title="" />';
    $lists['page']['items_author'] = '<input type="text" name="page_items_author" value="' . 
        $booklibrary_configuration['page']['items_author'] . '" class="inputbox" size="3" maxlength="3" title="" />';
    $lists['license']['show'] = mosHTML::RadioList($yesno, 'license_show', 'class="inputbox"', 
        $booklibrary_configuration['license']['show'], 'value', 'text');
    $txt = $booklibrary_configuration['license']['text'];
    $lists['author_photo']['show'] = mosHTML::RadioList($yesno, 'author_photo_show', 'class="inputbox"', 
        $booklibrary_configuration['author_photo']['show'], 'value', 'text');
    $txt = $booklibrary_configuration['author_photo']['show'];
    //add for show in category picture
    $lists['cat_pic']['show'] = mosHTML::RadioList($yesno, 'cat_pic_show', 'class="inputbox"', 
        $booklibrary_configuration['cat_pic']['show'], 'value', 'text');
    //add for show subcategory
    $lists['subcategory']['show'] = mosHTML::RadioList($yesno, 'subcategory_show', 'class="inputbox"', 
        $booklibrary_configuration['subcategory']['show'], 'value', 'text');
    $lists['owner']['show'] = mosHTML::RadioList($yesno, 'owner_show', 'class="inputbox"', 
        $booklibrary_configuration['owner']['show'], 'value', 'text');
    //******   begin approve_on_add  *****
    $f = array();
    $s = explode(',', $booklibrary_configuration['approve_on_add']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['approve_on_add']['show'] = mosHTML::RadioList($yesno, 'approve_on_add', 'class="inputbox"', 
        $booklibrary_configuration['approve_on_add']['show'], 'value', 'text');
    $lists['approve_on_add']['registrationlevel'] = mosHTML::selectList($gtree, 
        'approve_on_add_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*******   end approve_on_add   *******
    //********** Owners list ************
    $f = array();
    $s = explode(',', $booklibrary_configuration['ownerslist']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['ownerslist']['show'] = mosHTML::RadioList($yesno, 'ownerslist_show', 'class="inputbox"', 
        $booklibrary_configuration['ownerslist']['show'], 'value', 'text');
    $lists['ownerslist']['registrationlevel'] = mosHTML::selectList($gtree, 
        'ownerslist_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //***************************************************
    $component_path = JPath::clean(JPATH_SITE . '/components/com_booklibrary/views/categories/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $all_categories[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    $lists['all_categories'] = mosHTML::selectList($all_categories, 'all_categories', 'size="1" ', 
        'value', 'text', $booklibrary_configuration['all_categories']);
    $component_path = JPath::clean(JPATH_SITE . 
        '/components/com_booklibrary/views/showCategory/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
            '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $view_type[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    $lists['view_type'] = mosHTML::selectList($view_type, 'view_type', 'size="1" ', 'value', 'text', 
        $booklibrary_configuration['view_type']);
    // ---------Layouts for search-------------
    $component_path = JPath::clean(JPATH_SITE . 
        '/components/com_booklibrary/views/show_search_book/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
            '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $search_lay[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    $lists['search_lay'] = mosHTML::selectList($search_lay, 'search_lay', 'size="1" ', 'value', 'text', 
        $booklibrary_configuration['search_lay']);
    //************************
    $component_path = JPath::clean(JPATH_SITE . 
        '/components/com_booklibrary/views/owners_list/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
            '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $ownerslist_page[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    if( isset($ownerslist_page) ) 
        $lists['ownerslist_page'] = mosHTML::selectList($ownerslist_page, 'ownerslist_page', 'size="1" ', 
        'value', 'text', $booklibrary_configuration['ownerslist_page']);
    // ----------end------------
    $component_path = JPath::clean(JPATH_SITE . '/components/com_booklibrary/views/view_book/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
            '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $view_book[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    $lists['view_book'] = mosHTML::selectList($view_book, 'view_book', 'size="1" ', 'value', 'text', 
        $booklibrary_configuration['view_book']);
    //***************************************************
    $component_path = JPath::clean(JPATH_SITE . '/components/com_booklibrary/views/books/tmpl');
    $component_layouts = array();
    $options = array();
    if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, 
            '^[^_]*\.php$', false, true))) {
        foreach($component_layouts as $i => $file) {
            $select_file_name = pathinfo($file);
            $select_file_name = $select_file_name['filename'];
            $books[] = JHtml::_('select.option', $select_file_name, $select_file_name);
        }
    }
    $lists['books'] = mosHTML::selectList($books, 'books', 'size="1" ', 'value', 'text', 
        $booklibrary_configuration['books']);
    //---------------------------------
    $money_ditlimer = array();
    $money_ditlimer[] = JHtml::_('select.option', ".", "Point (12.134.123,12)");
    $money_ditlimer[] = JHtml::_('select.option', ",", "Comma (12,134,123.12)");
    $money_ditlimer[] = JHtml::_('select.option', "space", "Space (12 134 123,12)");
    $money_ditlimer[] = JHtml::_('select.option', "other", "Youre ditlimer: ");
    $price_unit_show[] = mosHTML::makeOption('1', _BOOKLIBRARY_PRICE_UNIT_SHOW_AFTER);
    $price_unit_show[] = mosHTML::makeOption('0', _BOOKLIBRARY_PRICE_UNIT_SHOW_BEFORE);
    $selecter = '';
    switch ($booklibrary_configuration['price_format']) {
        case '.':
            $selecter = '.';
        break;
        case ',':
            $selecter = ',';
        break;
        case '&nbsp;':
            $selecter = 'space';
        break;
        default:
            $selecter = 'other';
    }
    // 1 - affter 0 - beffore
    $lists['price_unit_show'] = mosHTML::RadioList($price_unit_show, 'price_unit_show', 
        'class="inputbox"', $booklibrary_configuration['price_unit_show'], 'value', 'text');
    $lists['money_ditlimer'] = mosHTML::selectList($money_ditlimer, 'money_select', 'size="1" 
        onchange="set_pricetype(this)"', 'value', 'text', $selecter);
    $lists['date_format'] = '<input type="text" name="date_format" value="' . 
        $booklibrary_configuration['date_format'] . '" class="inputbox"  title="" />';
    $lists['datetime_format'] = '<input type="text" name="datetime_format" value="' . 
        $booklibrary_configuration['datetime_format'] . '" class="inputbox" title="" />';
    //----------------------
    $lists['allowed_exts'] = '<input type="text" name="allowed_exts" value="' . 
        $booklibrary_configuration['allowed_exts'] . 
        '" class="inputbox" size="30" maxlength="1500" title=""/>';
    $lists['allowed_exts_img'] = '<input type="text" name="allowed_exts_img" value="' . 
        $booklibrary_configuration['allowed_exts_img'] . 
        '" class="inputbox" size="30" maxlength="1500" title=""/>';
    $lists['allowed_exts_video'] = '<input type="text" name="allowed_exts_video" value="' . 
        $booklibrary_configuration['allowed_exts_video'] . 
        '" class="inputbox" size="30" maxlength="1500" title=""/>';
    $lists['allowed_exts_audio'] = '<input type="text" name="allowed_exts_audio" value="' . 
        $booklibrary_configuration['allowed_exts_audio'] . 
        '" class="inputbox" size="30" maxlength="1500" title=""/>';
    $lists['allowed_exts_track'] = '<input type="text" name="allowed_exts_track" value="' . 
        $booklibrary_configuration['allowed_exts_track'] . 
        '" class="inputbox" size="30" maxlength="1500" title=""/>';
    //----------------------
    //******   begin approve_review  *****
    $f = array();
    $s = explode(',', $booklibrary_configuration['approve_review']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['approve_review']['show'] = mosHTML::RadioList($yesno, 'approve_review', 
        'class="inputbox"', $booklibrary_configuration['approve_review']['show'], 'value', 'text');
    $lists['approve_review']['registrationlevel'] = mosHTML::selectList($gtree, 
        'approve_review_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*******   end approve_review   *******
    HTML_booklibrary::showConfiguration_frontend($lists, $option, $txt);
}
function cutSlash($S) {
    $S2 = '';
    for ($i = 0;$i < strlen($S);$i++) {
        if ($S[$i] != '\\') {
            $S2.= $S[$i];
        } else {
            $i++;
            if ($S[$i] == '"') {
                $S2.= '&#34';
            } else {
                $S2.= $S[$i];
            }
        }
    }
    return $S2;
}
function configure_backend($option) {
    global $my, $booklibrary_configuration, $acl;
    global $mosConfig_absolute_path;
    $yesno[] = mosHTML::makeOption('1', _BOOKLIBRARY_YES);
    $yesno[] = mosHTML::makeOption('0', _BOOKLIBRARY_NO);
    $gtree[] = mosHTML::makeOption('-2', 'Everyone');
    $gtree = get_group_children_tree_bl();
    $lists = array();
    $f = array();
    $s = explode(',', $booklibrary_configuration['review_added_email']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['review_added_email']['registrationlevel'] = mosHTML::selectList($gtree, 
        'review_added_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['review_added_email']['show'] = mosHTML::RadioList($yesno, 'review_added_email_show', 
        'class="inputbox"', $booklibrary_configuration['review_added_email']['show'], 'value', 'text');
    $f = array();
    $s = explode(',', $booklibrary_configuration['suggest_added_email']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['suggest_added_email']['show'] = mosHTML::RadioList($yesno, 'suggest_added_email_show', 
        'class="inputbox"', $booklibrary_configuration['suggest_added_email']['show'], 'value', 'text', 
        $booklibrary_configuration['suggest_added_email']['show']);
    $lists['suggest_added_email']['registrationlevel'] = mosHTML::selectList($gtree, 
        'suggest_added_email_registrationlevel[] ', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['lendrequest_email']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['lendrequest_email']['show'] = mosHTML::RadioList($yesno, 'lendrequest_email_show', 
        'class="inputbox"', $booklibrary_configuration['lendrequest_email']['show'], 'value', 'text');
    $lists['lendrequest_email']['registrationlevel'] = mosHTML::selectList($gtree, 
        'lendrequest_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $f = array();
    $s = explode(',', $booklibrary_configuration['addbook_email']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['addbook_email']['show'] = mosHTML::RadioList($yesno, 'addbook_email_show', 
        'class="inputbox"', $booklibrary_configuration['addbook_email']['show'], 'value', 'text');
    $lists['addbook_email']['registrationlevel'] = mosHTML::selectList($gtree, 
        'addbook_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['review_email']['address'] = '<input type="text" name="review_email_address" value="' . 
        $booklibrary_configuration['review_email']['address'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />'; //back--1
    $lists['suggest_email']['address'] = '<input type="text" name="suggest_email_address" value="' . 
        $booklibrary_configuration['suggest_email']['address'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['lendrequest_email']['address'] = '<input type="text" name="lendrequest_email_address" value="' . 
        $booklibrary_configuration['lendrequest_email']['address'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['addbook_email']['address'] = '<input type="text" name="addbook_email_address" value="' . 
        $booklibrary_configuration['addbook_email']['address'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['lendrequest_admin_decline_accept'] = mosHTML::RadioList($yesno, 
        'lendrequest_admin_decline_accept', 'class="inputbox"', 
        $booklibrary_configuration['lendrequest_admin_decline_accept'], 'value', 'text');
    $lists['bookid']['auto-increment']['boolean'] = mosHTML::RadioList($yesno, 
        'bookid_auto_increment_boolean', 'class="inputbox"', 
        $booklibrary_configuration['bookid']['auto-increment']['boolean'], 'value', 'text');
    //********   begin add merge description   ************************
    $f = array();
    $s = explode(',', $booklibrary_configuration['merge_description']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['merge_description']['use'] = mosHTML::RadioList($yesno, 'merge_description_use', 
        'class="inputbox"', $booklibrary_configuration['merge_description']['use'], 'value', 'text');
    $lists['merge_description']['registrationlevel'] = mosHTML::selectList($gtree, 
        'merge_description_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********   end add merge description  **********************
    $lists['fetchImages']['boolean'] = mosHTML::RadioList($yesno, 'fetchImages_boolean', 
        'class="inputbox"', $booklibrary_configuration['fetchImages']['boolean'], 'value', 'text');
    $lists['fetchImages']['location'] = '<input disabled="disabled" type="text" 
        name="fetchImages_location" value="' . 
        $booklibrary_configuration['fetchImages']['location'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['ebooks']['allow'] = mosHTML::RadioList($yesno, 'ebooks_allow', 'class="inputbox"', 
        $booklibrary_configuration['ebooks']['allow'], 'value', 'text');
    $lists['videos_tracks']['allow'] = mosHTML::RadioList($yesno, 'videos_tracks_allow', 
        'class="inputbox"', $booklibrary_configuration['videos_tracks']['allow'], 'value', 'text');
    $lists['audios']['allow'] = mosHTML::RadioList($yesno, 'audios_allow', 'class="inputbox"', 
        $booklibrary_configuration['audios']['allow'], 'value', 'text');
    $lists['ebooks']['location'] = '<input disabled="disabled" type="text" name="ebooks_location" value="' . 
        $booklibrary_configuration['ebooks']['location'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['videos']['location'] = '<input disabled="disabled" type="text" name="videos_location" value="' . 
        $booklibrary_configuration['videos']['location'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['tracks']['location'] = '<input disabled="disabled" type="text" name="tracks_location" value="' . 
        $booklibrary_configuration['tracks']['location'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['audios']['location'] = '<input disabled="disabled" type="text" name="audios_location" value="' . 
        $booklibrary_configuration['audios']['location'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    //********   begin add allow Online Read book from Article   ************************
    $f = array();
    $s = explode(',', $booklibrary_configuration['online_book_from_article']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['online_book_from_article']['allow'] = mosHTML::RadioList($yesno, 'online_book_from_article_allow', 
        'class="inputbox"', $booklibrary_configuration['online_book_from_article']['allow'], 'value', 'text');
    $lists['online_book_from_article']['registrationlevel'] = mosHTML::selectList($gtree, 
        'online_book_from_article_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********   end allow Online Read book from Article  **********************
    //********   begin add allow Online read book flip   ************************
    $f = array();
    $s = explode(',', $booklibrary_configuration['online_book_flip']['registrationlevel']);
    for ($i = 0;$i < count($s);$i++) $f[] = mosHTML::makeOption($s[$i]);
    $lists['online_book_flip']['allow'] = mosHTML::RadioList($yesno, 'online_book_flip_allow', 
        'class="inputbox"', $booklibrary_configuration['online_book_flip']['allow'], 'value', 'text');
    $lists['online_book_flip']['registrationlevel'] = mosHTML::selectList($gtree, 
        'online_book_flip_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********   end allow Online read book flip  **********************
    $lists['ws']['amazon']['tag'] = '<input type="text" name="ws_amazon_tag" value="' . 
        $booklibrary_configuration['ws']['amazon']['tag'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['ws']['amazon']['devtag'] = '<input type="text" name="ws_amazon_devtag" value="' . 
        $booklibrary_configuration['ws']['amazon']['devtag'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    $lists['ws']['amazon']['secret_key'] = '<input type="text" name="ws_amazon_secret_key" value="' . 
        $booklibrary_configuration['ws']['amazon']['secret_key'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    @$lists['editbook']['check']['isbn'] = mosHTML::RadioList($yesno, 'editbook_check_isbn', 'class="inputbox"', 
        $booklibrary_configuration['editbook']['check']['isbn'], 'value', 'text'); //back--7
    ///////////////////////////////ANTON CODE////////////////////////////////////
    /////////////Proxy Relase
    $lists['proxy_server']['address'] = '<input type="text" name="proxy_server_adress" value="' . 
        $booklibrary_configuration['proxy_server']['address'] . 
        '"class="inputbox" size="30" maxlength="100" title="" />';
    $lists['port_proxy_server']['address'] = '<input type="text" name="port_proxy_server_adress" value="' . 
        $booklibrary_configuration['port_proxy_server']['address'] . 
        '"class="inputbox" size="30" maxlength="100" title="" />';
    $lists['login_proxy_server']['address'] = '<input type="text" name="login_proxy_server_adress" value="' . 
        $booklibrary_configuration['login_proxy_server']['address'] . 
        '"class="inputbox" size="30" maxlength="100" title="" />';
    $lists['password_proxy_server']['address'] = '<input type="text" name="password_proxy_server_adress" value="' . 
        $booklibrary_configuration['password_proxy_server']['address'] . 
        '"class="inputbox" size="30" maxlength="100" title="" />';
    /////////////////////////////////ANTON CODE////////////////////////////////////
    $lists['yaz']['connection_string'] = '<input class="inputbox" type="file" 
        name="yaz_connection_file" value="" size="30" maxlength="250" />';
    $lists['update'] = mosHTML::RadioList($yesno, 'update', 'class="inputbox"', 
        $booklibrary_configuration['update'], 'value', 'text');
    //get language List
    $retVal1 = mosBooklibraryOthers::getLanguageArray();
    $lang = null;
    for ($i = 0, $n = count($retVal1);$i < $n;$i++) {
        $help = $retVal1[$i];
        $lang[] = mosHTML::makeOption($help[0], $help[1]);
    }
    $lists['editbook']['default']['lang'] = mosHTML::selectList($lang, 'editbook_default_lang', 
        'class="inputbox" size="1"', 'value', 'text', 
        $booklibrary_configuration['editbook']['default']['lang']);
    //get host List
    $retVal = mosBooklibraryWS::getArray();
    $ws = null;
    for ($i = 0, $n = count($retVal);$i < $n;$i++) {
        $help = $retVal[$i];
        $ws[] = mosHTML::makeOption($help[0], $help[1]);
    }
    $lists['editbook']['default']['host'] = mosHTML::selectList($ws, 'editbook_default_host', 
        'class="inputbox" size="1"', 'value', 'text', 
        intval($booklibrary_configuration['editbook']['default']['host']));
    $lists['lend_answer'] = mosHTML::RadioList($yesno, 'lend_answer', 'class="inputbox"', 
        $booklibrary_configuration['lend_answer'], 'value', 'text');
    $lists['lend_form'] = $booklibrary_configuration['lend_form'];
    $lists['ebooks']['registrationlevel'] = mosHTML::selectList($gtree, 'ebooks_registrationlevel', 
        'size="4"', 'value', 'text', $my->id); //(rus)--i tam i tam nado navernoe!
    $lists['lend_before_end_notify'] = mosHTML::RadioList($yesno, 'lend_before_end_notify', 
        'class="inputbox"', $booklibrary_configuration['lend_before_end_notify'], 'value', 'text');
    $lists['lend_before_end_notify_days'] = '<input type="text" name="lend_before_end_notify_days" value="' . 
        $booklibrary_configuration['lend_before_end_notify_days'] . 
        '" class="inputbox" size="2" maxlength="2" title="" />';
    $lists['lend_before_end_notify_email'] = '<input type="text" name="lend_before_end_notify_email" value="' . 
        $booklibrary_configuration['lend_before_end_notify_email'] . 
        '" class="inputbox" size="30" maxlength="100" title="" />';
    HTML_booklibrary::showConfiguration_backend($lists, $option);
}
//*****************************   end  moe   *********************
//****************   begin for manage reviews   *******************
function manage_review_s($option, $sorting) {
    global $database, $mainframe, $mosConfig_list_limit,$bl_state;

    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }

    global $table_prefix;
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    try {
        $database->setQuery("SELECT count(*) 
                             FROM #__booklibrary_review;");
        $total = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $pageNav = new JPagination($total, $limitstart, $limit); 
    //********************   begin request for reviews manager   **********************
    //if for sorting
    if (isset($_COOKIE['TestCookie']) and $_COOKIE['TestCookie'] == $sorting) {
        $sorting.= ' DESC';
        setcookie("TestCookie", $sorting, time() - 3600);
    } else {
        setcookie("TestCookie", $sorting, time() + 3600);
    }
    if ($sorting != "") {
        $request_string = "SELECT b.id as fk_bookid, a.id as review_id, b.isbn, b.title as title_book, 
                           GROUP_CONCAT(c.title  SEPARATOR ', ') as title_catigory, 
                           a.title as title_review, a.comment, e.user_name, a.date, 
                           a.rating, a.published" . "\n
                           FROM  
                           {$table_prefix}booklibrary_review as a,  
                           {$table_prefix}booklibrary as b,  
                           {$table_prefix}booklibrary_main_categories as c,  
                           {$table_prefix}booklibrary_categories AS w, 
                          (SELECT DISTINCT d.name as user_name, a.fk_userid  
                           FROM {$table_prefix}booklibrary_review as a,  
                           {$table_prefix}users as d  
                           WHERE d.id = a.fk_userid" . "\n
                           union all" . "\n
                           SELECT DISTINCT 'anonymous' as user_name, a.fk_userid  
                           FROM {$table_prefix}booklibrary_review as a  
                           WHERE a.fk_userid = 0) as e" . "\n
                           WHERE a.fk_bookid = b.id AND b.id = w.bookid AND w.catid = c.id 
                           AND a.fk_userid = e.fk_userid
                           GROUP BY review_id 
                           ORDER by $sorting" . "\n
                           LIMIT $pageNav->limitstart,$pageNav->limit;";
    } else {
        $request_string = " SELECT  b.id AS fk_bookid, a.id AS review_id, b.isbn, b.title AS title_book,  
                            GROUP_CONCAT(c.title  SEPARATOR ', ') AS title_catigory,  
                            a.title AS title_review, a.comment, e.user_name, a.date, a.rating, 
                            a.published" . "\n 
                            FROM  
                            #__booklibrary_review AS a,  
                            #__booklibrary AS b,  
                            #__booklibrary_main_categories AS c,  
                            #__booklibrary_categories AS w, 
                           (SELECT DISTINCT d.name AS user_name, a.fk_userid  
                            FROM #__booklibrary_review AS a,  #__users AS d  
                            WHERE d.id = a.fk_userid" . "\n 
                            UNION all \n" . 
                            "SELECT DISTINCT 'anonymous' AS user_name, a.fk_userid 
                            FROM #__booklibrary_review AS a   
                            WHERE a.fk_userid = 0) AS e" . "\n 
                            WHERE a.fk_bookid = b.id  
                            AND b.id = w.bookid AND w.catid = c.id AND a.fk_userid = e.fk_userid 
                            GROUP BY review_id 
                            ORDER by date" . "\n LIMIT $pageNav->limitstart,$pageNav->limit;";
    }
    $database->setQuery($request_string);
    $reviews = $database->loadObjectList();
    //**************   end request for reviews manager   ***************************
    HTML_booklibrary::showManageReviews($option, $pageNav, $reviews);
}
//*********************   end for manage reviews   ****************************
//****************   begin for manage suggestion    ***************************
function manage_suggestion($option) {
    global $database, $mainframe, $mosConfig_list_limit,$bl_state;

    if(!isset($bl_state->data) ){
        echo '<script>alert("'._BOOKLIBRARY_YOUR_LICENSE_NEED_ACTIVE.'"); history.back(); </script>';
        return ;
    }


    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    try {
        $database->setQuery("SELECT count(*) FROM #__booklibrary_suggestion;");
        $total = $database->loadResult();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $pageNav = new JPagination($total, $limitstart, $limit); 
    $request_suggestion = "select b.email, d.*  
                           from (SELECT a.id, a.title, a.comment, e.user_name, a.date, a.fk_userid 
                           FROM #__booklibrary_suggestion AS a, 
                          (SELECT DISTINCT d.name AS user_name, a.fk_userid 
                           FROM #__booklibrary_suggestion AS a, #__users AS d 
                           WHERE d.id = a.fk_userid 
                           union all
                           SELECT DISTINCT 'anonymous' AS user_name, a.fk_userid  
                           FROM #__booklibrary_suggestion AS a 
                           WHERE a.fk_userid = 0) as e" . "\n 
                           WHERE  a.fk_userid = e.fk_userid ORDER by date) as d 
                           left join #__users AS b on  d.fk_userid = b.id" . "\n 
                           LIMIT $pageNav->limitstart,$pageNav->limit;";
    $database->setQuery($request_suggestion);
    $suggestion = $database->loadObjectList();
    HTML_booklibrary::showManageSuggestion($option, $pageNav, $suggestion);
}
//end manage_suggestion($option)
/*
* function for delete one
* or all suggestion in 'Manage Suggestions'
*/
function delete_suggestion($option, $id) {
    global $database;
    for ($i = 0;$i < count($id);$i++) {
        try {
            $database->setQuery("DELETE FROM #__booklibrary_suggestion 
                                 WHERE #__booklibrary_suggestion.id=" . $id[$i] . ";");
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    }
}
/*
* add Nikolay
* function for view one
* suggestion in 'Manage Suggestions'
*/
function view_suggestion($option, $id) {
    global $database;
    if (count($id) > 1) {
        echo "<script> alert('Please select one suggestion for view!!!'); 
               window.history.go(-1); </script>\n";
    } else {
        $request_suggestions = "select b.email, d.*  
                                from (SELECT a.id, a.title, a.comment, e.user_name, a.date, a.fk_userid
                                FROM #__booklibrary_suggestion AS a, 
                               (SELECT DISTINCT d.name AS user_name, a.fk_userid  
                                FROM #__booklibrary_suggestion AS a,  #__users AS d 
                                WHERE d.id = a.fk_userid union all 
                                SELECT DISTINCT 'anonymous' AS user_name, a.fk_userid  
                                FROM #__booklibrary_suggestion AS a 
                                WHERE a.fk_userid = 0) as e" . "\n 
                                WHERE  a.fk_userid = e.fk_userid 
                                ORDER by date) as d 
                                left join #__users AS b on  d.fk_userid = b.id;";
        $database->setQuery($request_suggestions);
        $suggestions = $database->loadObjectList();
        $suggestion = "";
        //select one item suggestion
        for ($i = 0;$i < count($suggestions);$i++) {
            if ($suggestions[$i]->id == $id[0]) {
                $suggestion = $suggestions[$i];
            }
        }
        if ($suggestion != "") HTML_booklibrary::showViewSuggestion($option, $suggestion);
        else mosRedirect('index.php?option=com_booklibrary&task=manage_suggestion');
    } //end else
    
}
//*************************************************************************************************************
//*********************************   end for manage suggestion    ********************************************
//*************************************************************************************************************
function lend($option, $bid) {
    global $database, $my;
    if (!is_array($bid) || count($bid) !== 1) {
        echo "<script> alert('" . _BOOKLIBRARY_SELECT_ONE_ITEM_TO_LEND . "'); 
               window.history.go(-1);</script>\n";
        exit;
    }
    $bid_book = implode(',', $bid);
    $select = "SELECT a.*, l.id as lendid, l.lend_from as lend_from, " . "l.lend_return as lend_return,  
               l.lend_until as lend_until, l.fk_userid as fk_userid, " . "l.user_name as user_name,  
               l.user_email as user_email, u.name AS name, u.email as email" . "\n
               FROM #__booklibrary AS a" . "\n
               LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
               LEFT JOIN #__users AS u ON u.id = l.fk_userid" . "\n
               WHERE a.id = $bid_book";
    $database->setQuery($select);
    $books = $database->loadObject();
    
    $bids = implode(',', $bid);
    $bids = getAssociateBooks($bids);
    $books_assoc[] = $books;
    if ($bids) {
        $select = "SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, " . 
                  "l.lend_return as lend_return, l.lend_until as lend_until, " . 
                  "l.user_name as user_name, l.user_email as user_email " . "\n
                  FROM #__booklibrary AS a" . "\n
                  LEFT JOIN #__booklibrary_categories as bc on bc.bookid = a.id" . "\n
                  LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = bc.catid" . "\n
                  LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
                  WHERE a.id in ($bids)";
        $database->setQuery($select);
        $books_assoc = $database->loadObjectList();
    }
    
    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text 
                         FROM #__users 
                         ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 
        'value', 'text', '-1');
    HTML_booklibrary::showLendBooks($option, $books, $books_assoc, $usermenu, "lend");
}
function edit_lend($option, $bid) {
    global $database, $my;
    if (!is_array($bid) || count($bid) !== 1) {
        echo "<script> alert('" . _BOOKLIBRARY_SELECT_ONE_ITEM_TO_LEND . "'); 
               window.history.go(-1);</script>\n";
        exit;
    }
    $bid_book = implode(',', $bid);
    //for databases without subselect
    $select = "SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, " . 
              "l.lend_return as lend_return, l.lend_until as lend_until, " . 
              "l.user_name as user_name, l.user_email as user_email " . "\n
              FROM #__booklibrary AS a" . "\n
              LEFT JOIN #__booklibrary_categories as hc on hc.bookid = a.id" . "\n
              LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = hc.catid" . "\n
              LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n

              WHERE a.id = $bid_book and ( l.lend_return = '0000-00-00 00:00:00' or l.lend_return is null ) ";
    $database->setQuery($select);
    $books = $database->loadObject();

    if ( !(($books->lend_return) == '') and !($books->lend_return == '0000-00-00 00:00:00') ) {
?> 
            <script type = "text/JavaScript" language = "JavaScript"> 
                alert('You edit book that were not lend out'); 
                window.history.go(-1); 
            </script> 
            <?php
        exit;
    }
    $bids = implode(',', $bid);
    $bids = getAssociateBooks($bids);
    if ($bids == "") $bids = implode(',', $bid);
    $books_lends_assoc = array();
    $title_assoc = array();
    if ($bids) {
        $select = "SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, " . 
                  "l.lend_return as lend_return, l.lend_until as lend_until, " . 
                  "l.user_name as user_name, l.user_email as user_email " . "\n
                   FROM #__booklibrary AS a" . "\n
                   LEFT JOIN #__booklibrary_categories as hc on hc.bookid = a.id" . "\n
                   LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = hc.catid" . "\n
                   LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
                   WHERE a.id in (" . $bids . ")";
        $database->setQuery($select);
        $books_lends_assoc = $database->loadObjectList();
		if (isset ($books_lends_assoc)) {
            for ($i = 0; $i < count($books_lends_assoc); $i++) {
                $cutfrom = explode(' ', $books_lends_assoc[$i]->lend_from);
                $cutuntil = explode(' ', $books_lends_assoc[$i]->lend_until);

                $books_lends_assoc[$i]->lend_from = $cutfrom[0];
                $books_lends_assoc[$i]->lend_until = $cutuntil[0];
            }
        }   
        $select = "SELECT a.id, a.title " . "\nFROM #__booklibrary AS a" . 
          "\nLEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id " . 
          "\nWHERE a.id in ($bids) and ( l.lend_return = '0000-00-00 00:00:00' or l.lend_return is null )  ";
        $database->setQuery($select);
        $title_assoc = $database->loadObjectList();
        $is_lend_out = false;
        for ($i = 0;$i < count($books_lends_assoc);$i++) {
            if ( ($books_lends_assoc[$i]->lend_return == '') || ($books_lends_assoc[$i]->lend_return == '0000-00-00 00:00:00') ) {
                $is_lend_out = true;
                break;
            }
        }

        if (!$is_lend_out) {
?> 
            <script type = "text/JavaScript" language = "JavaScript"> 
                alert("<?php echo _BOOKLIBRARY_YOU_EDIT_BOOK_THAT_WERE_NOT_LENT_OUT ?>"); 
                window.history.go(-1); 
            </script> 
            <?php
            exit;
        }

        $ids = explode(',', $bids);
        $lend_count = - 1;
        $all_assosiate_lend = array();
        $count = count($ids);
        for ($i = 0;$i < $count;$i++) {
            $query = "SELECT * 
                      FROM #__booklibrary_lend 
                      WHERE fk_bookid = " . $ids[$i] . 
                     " and ( lend_return = '0000-00-00 00:00:00' or lend_return is null )  
                      ORDER BY lend_from";       
            $database->setQuery($query);
            $all_assosiate_lend_item = $database->loadObjectList();
            if ($lend_count != - 1 && $lend_count != count($all_assosiate_lend_item)) {
?> 
                 
                <script type = "text/JavaScript" language = "JavaScript"> 
                    alert("<?php echo _BOOKLIBRARY_ERROR_IN_LEND_FOR_ASSOCIATED ?>"); 
                    window.history.go(-1); 
                </script> 
                 
                <?php
                exit;
            }
            $lend_count = count($all_assosiate_lend_item);
            $all_assosiate_lend[] = $all_assosiate_lend_item;
        }
    }	
		if (isset($all_assosiate_lend)) {
            for ($i = 0; $i < count($all_assosiate_lend[0]); $i++) {
                $cutfrom = explode(' ', $all_assosiate_lend[0][$i]->lend_from);
                $cutuntil = explode(' ', $all_assosiate_lend[0][$i]->lend_until);

                $all_assosiate_lend[0][$i]->lend_from = $cutfrom[0];
                $all_assosiate_lend[0][$i]->lend_until = $cutuntil[0];
            }
	}
    // get list of users
    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text 
                         FROM #__users 
                         ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 
        'value', 'text', '-1');
    HTML_booklibrary::editLendBooks($option, $books, $books_lends_assoc, $title_assoc, $usermenu, 
                  $all_assosiate_lend, "edit_lend");
}
function lend_return($option, $bid) {
    global $database, $my;
    if (!is_array($bid) || count($bid) !== 1) {
        echo "<script> alert('" . _BOOKLIBRARY_SELECT_ONE_ITEM_TO_LEND . "'); 
               window.history.go(-1);</script>\n";
        exit;
    }
    $bid_book = implode(',', $bid);
    //for databases without subselect
    $select = "SELECT a.*, l.id as lendid, l.lend_from as lend_from, " . 
        "l.lend_return as lend_return, l.lend_until as lend_until, 
              l.fk_userid as fk_userid, " . "l.user_name as user_name, l.user_email as user_email, 
        u.name AS name, u.email as email" . 
        "\nFROM #__booklibrary AS a" . 
        " LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id " .

        "\nLEFT JOIN #__users AS u ON u.id = l.fk_userid" . 
        "\nWHERE a.id = $bid_book and ( l.lend_return = '0000-00-00 00:00:00' or l.lend_return is null )";
    $database->setQuery($select);
    $books = $database->loadObject();
    if ( !(($books->lend_return) == '') and !($books->lend_return == '0000-00-00 00:00:00') ) {        
?> 
            <script type = "text/JavaScript" language = "JavaScript"> 
                alert('You cannot return books that were not lend out'); 
                window.history.go(-1); 
            </script> 
            <?php
        exit;
    }
    $bids = implode(',', $bid);
    $bids = getAssociateBooks($bids);
    if ($bids == "") $bids = implode(',', $bid);
    $books_lends_assoc = array();
    $title_assoc = array();
    if ($bids) {
        $select = "SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, " . 
                  "l.lend_return as lend_return,l.lend_until as lend_until, " . 
                  "l.user_name as user_name, l.user_email as user_email " . "\n
                  FROM #__booklibrary AS a" . "\n
                  LEFT JOIN #__booklibrary_categories as hc on hc.bookid = a.id" . "\n
                  LEFT JOIN #__booklibrary_main_categories AS cc ON cc.id = hc.catid" . "\n
                  LEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . "\n
                  WHERE a.id in (" . $bids . ")";
        $database->setQuery($select);
        $books_lends_assoc = $database->loadObjectList();
		if (isset ($books_lends_assoc)) {
            for ($i = 0; $i < count($books_lends_assoc); $i++) {
                $cutfrom = explode(' ', $books_lends_assoc[$i]->lend_from);
                $cutuntil = explode(' ', $books_lends_assoc[$i]->lend_until);

                $books_lends_assoc[$i]->lend_from = $cutfrom[0];
                $books_lends_assoc[$i]->lend_until = $cutuntil[0];
            }

        }		
        $select = "SELECT a.id, a.title " . "\nFROM #__booklibrary AS a" . 
          "\nLEFT JOIN #__booklibrary_lend AS l ON l.fk_bookid = a.id" . 
          "\nWHERE a.id in ($bids)";
        $database->setQuery($select);
        $title_assoc = $database->loadObjectList();
        $is_lend_out = false;
        for ($i = 0;$i < count($books_lends_assoc);$i++) {
            if ( ($books_lends_assoc[$i]->lend_return == '') || ($books_lends_assoc[$i]->lend_return == '0000-00-00 00:00:00') ) {                
                $is_lend_out = true;
                break;
            }
        }
        if (!$is_lend_out) {
?> 
            <script type = "text/JavaScript" language = "JavaScript"> 
                alert("<?php echo _BOOKLIBRARY_CANNOT_RETURN_BOOK_THAT_WERE_NOT_LEND_OUT; ?>"); 
                window.history.go(-1); 
            </script> 
            <?php
            exit;
        }
        //check lend_return == null count for all assosiate
        $ids = explode(',', $bids);
        $lend_count = - 1;
        $all_assosiate_lend = array();
        $count = count($ids);
        for ($i = 0;$i < $count;$i++) {
            $query = "SELECT * 
                      FROM #__booklibrary_lend 
                      WHERE fk_bookid = " . $ids[$i] . 
                     " AND ( lend_return = '0000-00-00 00:00:00' or lend_return is null )  ORDER BY lend_from";
            $database->setQuery($query);
            $all_assosiate_lend_item = $database->loadObjectList();
            if ($lend_count != - 1 && $lend_count != count($all_assosiate_lend_item)) {
?> 
                <script type = "text/JavaScript" language = "JavaScript"> 
                    alert("<?php echo _BOOKLIBRARY_ERROR_IN_LEND_FOR_ASSOCIATED; ?>"); 
                    window.history.go(-1); 
                </script> 
                <?php
                exit;
            }
            $lend_count = count($all_assosiate_lend_item);
            $all_assosiate_lend[] = $all_assosiate_lend_item;
        }
    }
    // get list of users
    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text         
                         FROM #__users 
                         ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 
        'value', 'text', '-1');

	if (isset($all_assosiate_lend)) {
            for ($i = 0; $i < count($all_assosiate_lend[0]); $i++) {
                $cutfrom = explode(' ', $all_assosiate_lend[0][$i]->lend_from);
                $cutuntil = explode(' ', $all_assosiate_lend[0][$i]->lend_until);

                $all_assosiate_lend[0][$i]->lend_from = $cutfrom[0];
                $all_assosiate_lend[0][$i]->lend_until = $cutuntil[0];
            }
    }

    HTML_booklibrary::editLendBooks($option, $books, $books_lends_assoc, $title_assoc, $usermenu, 
                  $all_assosiate_lend, "lend_return");
}
function saveLend($option, $bids, $task = "") {
    global $database;

	$user_name1 = protectInjectionWithoutQuote('user_name', '');
    $user_mail1 = protectInjectionWithoutQuote('user_email', ''); 
    $userID = protectInjectionWithoutQuote('userid', '');
   
    if (empty($user_name1) && $userID == -1) {
            echo "<script> alert('" . _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_NAME . "'); 
                   window.history.go(-1);</script>\n";
        exit;
    }

    $mailvalid = strpos($user_mail1, '@');
    if ((empty($user_mail1) || $mailvalid === false) && $userID == -1) {
            echo "<script> alert('" . _BOOKLIBRARY_INFOTEXT_JS_LEND_REQ_EMAIL . "'); 
                   window.history.go(-1);</script>\n";
        exit;
    }

    $checkh = mosGetParam($_POST, 'checkbook');
    $id = mosGetParam($_POST, 'id');
    $ids[] = $id;
    $ids = implode(',', $ids);
    $ids = getAssociateBooks($ids);
    if ($ids == "") $ids = $id;
    $ids = explode(',', $ids);
    $data = JFactory::getDBO();
    $bookid = mosGetParam($_POST, 'bookid');
    for ($i = 0, $n = count($ids);$i < $n;$i++) {
        $query = "SELECT * 
                  FROM #__booklibrary_lend 
                  WHERE fk_bookid= " . $ids[$i] . 
                 " AND ( lend_return = '0000-00-00 00:00:00' or lend_return is null )  ";
        $data->setQuery($query);
        $lendTerm = $data->loadObjectList();
        if (!is_array($bids) || count($bids) < 1) {
            echo "<script> alert('" . _BOOKLIBRARY_SELECT_AN_ITEM_TO_LEND . "'); 
                   window.history.go(-1);</script>\n";
            exit;
        }
        $lend = new mosBookLibrary_lend($database);
        if ($task == "edit_lend") $lend->load($bids[0]);
        $lend_from = mosGetParam($_POST, 'lend_from');
        $lend_until = mosGetParam($_POST, 'lend_until');
        /*if ($lend_from > $lend_until) {
            echo "<script> alert('" . $lend_from . " more then " . $lend_until . "'); 
                   window.history.go(-1); </script>\n";
            exit();
        }*/
        $lend_from = substr($lend_from, 0, 10);
        $lend_until = substr($lend_until, 0, 10);
        if (isset($lendTerm[0])) {
            for ($e = 0, $m = count($lendTerm);$e < $m;$e++) {
                if ($task == "edit_lend" && $bids[0] == $lendTerm[$e]->id) continue;
                $lendTerm[$e]->lend_from = substr($lendTerm[$e]->lend_from, 0, 10);
                $lendTerm[$e]->lend_until = substr($lendTerm[$e]->lend_until, 0, 10);
                //lend check
          //       if (($lend_from >= $lendTerm[$e]->lend_from && $lend_from <= $lendTerm[$e]->lend_until) || 
          // ($lend_from <= $lendTerm[$e]->lend_from && $lend_until >= $lendTerm[$e]->lend_until) || 
          // ($lend_until >= $lendTerm[$e]->lend_from && $lend_until <= $lendTerm[$e]->lend_until)) {
          //           echo "<script> alert('" . _BOOKLIBRARY_SORRY_OBJECT_ALREADY_LEND_OUT . 
          // $lendTerm[$e]->lend_from . " to " . $lendTerm[$e]->lend_until . "'); 
          // window.history.go(-1); </script>\n";
          //           exit();
          //       }
                checkLendOutTermBL($lend_from, $lend_until, $lendTerm[$e]->lend_from, $lendTerm[$e]->lend_until);
            }
        }
        if (mosGetParam($_POST, 'lend_from') != "") {
            $lend->lend_from = mosGetParam($_POST, 'lend_from');
        } else {
            $lend->lend_from = null;
        }
        if (mosGetParam($_POST, 'lend_until') != "") {
            $lend->lend_until = mosGetParam($_POST, 'lend_until');
        } else {
            $lend->lend_until = null;
        }
        $lend->fk_bookid = $ids[$i];
        $userid = mosGetParam($_POST, 'userid');
        if ($userid == "-1") {
            $lend->user_name = mosGetParam($_POST, 'user_name', '');
            $lend->user_email = mosGetParam($_POST, 'user_email', '');
        } else {
            $lend->getLendTo(intval($userid));
        }
        if (!$lend->check($lend)) {
            echo "<script> alert('" . $lend->getError() . "'); window.history.go(-1); </script>\n";
            exit();
        }
        if (!$lend->store()) {
            echo "<script> alert('" . $lend->getError() . "'); window.history.go(-1); </script>\n";
            exit();
        }
        $lend->checkin();
        $book = new mosBookLibrary($database);
        $book->load($ids[$i]);
        $book->fk_lendid = $lend->id;
        $book->store();
        $book->checkin();
    }
    mosRedirect("index.php?option=$option");
}
function saveLend_return($option, $lids) {
    global $database, $my;
    $id = mosGetParam($_POST, 'id');
    $check_ids = implode(',', $lids);
    if ($check_ids == 0 || count($lids) > 1) {
        echo "<script> alert('Select an item to return'); window.history.go(-1);</script>\n";
        exit;
    }
    $b_ids = explode(',', $lids[0]);
    $lend = new mosBookLibrary_lend($database);
    for ($i = 0, $n = count($b_ids);$i < $n;$i++) {
        $lend->load($b_ids[$i]);
        $lend->lend_return = date("Y-m-d H:i:s");
        if (!$lend->check($lend)) {
            echo "<script> alert('" . addslashes($lend->getError()) . "'); 
                   window.history.go(-1); </script>\n";
            exit();
        }
        if (!$lend->store()) {
            echo "<script> alert('" . addslashes($lend->getError()) . "'); 
                   window.history.go(-1); </script>\n";
            exit();
        }
        $lend->checkin();
        $is_update_book_lend = true;
        if ($is_update_book_lend) {
            $book = new mosBooklibrary($database);
            $book->load($id);
            $query = "SELECT * 
                       FROM #__booklibrary_lend 
                       WHERE fk_bookid=" . $id . 
                      " AND ( lend_return = '0000-00-00 00:00:00' or lend_return is null )  ";
            $database->setQuery($query);
            $check_lends = $database->loadObjectList();
            if (isset($check_lends[0])) {
                $book->fk_lendid = $check_lends[0]->id;
                $is_update_book_lend = false;
            } else {
                //$book->load($lend->fk_bookid);
                $book->fk_lendid = 0;
            }
            $book->store();
            $book->checkin();
        }
    }
    mosRedirect("index.php?option=$option");
}
function import($option) {
    global $database, $my;
    $file = file($_FILES['import_file']['tmp_name']);
    $catid = mosGetParam($_POST, 'import_catid');
    $type = mosGetParam($_POST, 'import_type');
    //***********************   begin add for XML format   ***************************************
    switch ($type) {
            //CSV=='1' XML=='2'
            
        case '1':
            $retVal = mosBooklibraryImportExport::importBooksFullCSV($file, $catid);
            HTML_booklibrary::showImportResult($retVal, $option);
        break;
        default:
            $retVal = mosBooklibraryImportExport::importBooksFullXML($_FILES['import_file']['tmp_name'], $catid);
            HTML_booklibrary::showImportResult($retVal, $option);
        break;
    }
}
function export($option) {
    global $database, $my, $mainframe, $booklibrary_configuration;
    $catid = mosGetParam($_POST, 'export_catid', 0);
    //$lend = mosGetParam($_POST, 'export_lend', null);
    //$pub = mosGetParam($_POST, 'export_pub', null);
    $type = mosGetParam($_POST, 'export_type', 0);
    $where = array();
    $wherecatid = '';
    if ($catid > 0) {
        array_push($where, "ac.catid='$catid'");
        $wherecatid = " AND c.id ='$catid'";
    }
    if(count($where) > 0 )
    {
        $selectstring = "SELECT a.id 
         FROM #__booklibrary AS a \n 
         LEFT JOIN #__booklibrary_categories AS ac ON a.id = ac.bookid " . 
         (count($where) ? "\n
         WHERE " . implode(' AND ', $where) : "") . "\n
         GROUP BY ac.bookid" . "\n
         ORDER BY a.ordering";
    
    } else {
        $selectstring = "SELECT a.id 
         FROM #__booklibrary AS a ";

    }
    
    try {
        $database->setQuery($selectstring);
        $booksids = $database->loadColumn();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "SELECT a.id FROM #__booklibrary_authors AS a  
            \nORDER BY a.id";
    try {
        $database->setQuery($query);
        $authorsids = $database->loadColumn();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    /********************************************************************************************/
    $cats = '';
    if ($type == '4') {
        $selectstring = "SELECT c.* 
                         FROM #__booklibrary_main_categories AS c" . "\n
                         WHERE c.section='com_booklibrary' " . $wherecatid . "\n
                         ORDER BY c.parent_id";
        $database->setQuery($selectstring);
        $cats = $database->loadAssocList();
    }
    $authors = '';
    if ($type == '4') {
        $selectstring = "SELECT a.* 
                         FROM #__booklibrary_authors AS a" . "\n
                         ORDER BY a.id";
        $database->setQuery($selectstring);
        $authors = $database->loadAssocList();
    }
    $efiles = '';
    /*     $selectstring = "SELECT c.* 
                            FROM #__booklibrary_files AS c" . "\n 
                            ORDER BY c.id"; */
    $database->setQuery($selectstring);
    $efiles = $database->loadAssocList();
    $order = array("\r\n", "\n", "\r");
    $strXmlDoc = "";
    $strXmlDoc.= "<?xml version='1.0' encoding='utf-8' ?>\n";
    $strXmlDoc.= "<data>\n";
    $strXmlDoc.= "<version>" . $booklibrary_configuration['release']['version'] . "</version>\n";
    $strXmlDoc.= "<books>\n";
    foreach($booksids as $bid) {
        $tmp = new mosBooklibrary($database);
        if ($tmp->load(intval($bid))) {
            $tmp->title = str_replace('|', '-', $tmp->title);
            $tmp->title = str_replace('\n', ' ', $tmp->title);
            $tmp->title = str_replace('\r', ' ', $tmp->title);
            $tmp->comment = str_replace('|', '-', $tmp->comment);
            $tmp->comment = str_replace('\n', ' ', $tmp->comment);
            $tmp->comment = str_replace('\r', ' ', $tmp->comment);
            $tmp->featured_clicks = str_replace('|', '-', $tmp->featured_clicks);
            $tmp->featured_clicks = str_replace($order, ' ', $tmp->featured_clicks);
            $tmp->featured_shows = str_replace('|', '-', $tmp->featured_shows);
            $tmp->featured_shows = str_replace($order, ' ', $tmp->featured_shows);
            $tmp->associate_book = str_replace('|', '-', $tmp->associate_book);
            $tmp->associate_book = str_replace($order, ' ', $tmp->associate_book);
            $tmp->fk_authors = str_replace('|', '-', $tmp->fk_authors);
            $tmp->fk_authors = str_replace($order, ' ', $tmp->fk_authors);
            if ($catid > 0) {
                $tmp->categs = array($catid);
            }
            $strXmlDoc.= $tmp->toXML2();
        }
        unset($tmp);
    }
    $strXmlDoc.= "</books>\n";


    $strXmlDoc.= "<authors>\n";
    foreach($authorsids as $aid) {
        $tmp2 = new mosBooklibrary_authors($database);
        if ($tmp2->load(intval($aid))) {
            $strXmlDoc.= $tmp2->toXML2();
        }
            unset($tmp2);
    }
    $strXmlDoc.= "</authors>\n";

    $strXmlDoc2 = "";
    $strXmlDoc2.= "<categories>\n";
    if ($type == '4') {
        foreach($cats as $cat) {
            $strXmlDoc2.= "<category>\n";
            foreach($cat as $field => $value) {
                $strXmlDoc2.= '<' . $field . '><![CDATA[' . $value . ']]></' . $field . ">\n";
            }
            $strXmlDoc2.= "</category>\n";
        }
    }
    $strXmlDoc2.= "</categories>\n";
    if ($type == '4') {
        $strXmlDoc.= $strXmlDoc2;
    }
    $strXmlDoc.= "</data>\n";
    
    // $books = array();
    // $order = array("\r\n", "\n", "\r");
    
    // foreach($booksids as $bid){
    //     $tmp = new mosBooklibrary($database); // __constructor JTable
    //     if($tmp->load(intval($bid))){
    //         $books[]=$tmp;
    //     }
    // }
    
    //parsing in title and commenr symbol '|'
    
    // foreach ($books as $key => $book) {
    //     $books[$key]->title = str_replace('|', '-', $book->title);
    //     $books[$key]->title = str_replace('\n', ' ', $book->title);
    //     $books[$key]->title = str_replace('\r', ' ', $book->title);
    //     $books[$key]->comment = str_replace('|', '-', $book->comment);
    //     $books[$key]->comment = str_replace('\n', ' ', $book->comment);
    //     $books[$key]->comment = str_replace('\r', ' ', $book->comment);
    //     $books[$key]->featured_clicks = str_replace('|', '-', $books[$key]->featured_clicks);
    //     $books[$key]->featured_clicks = str_replace($order, ' ', $books[$key]->featured_clicks);
    //     $books[$key]->featured_shows = str_replace('|', '-', $books[$key]->featured_shows);
    //     $books[$key]->featured_shows = str_replace($order, ' ', $books[$key]->featured_shows);
    //     if ($catid > 0){
    //         $books[$key]->categs = array($catid);
    //     }
    // }
    
    $cats = '';
    
    if ($type == '4') {
        $selectstring = "SELECT c.* FROM #__booklibrary_main_categories AS c" .
        "\nWHERE c.section='com_booklibrary' " . $wherecatid .
        "\nORDER BY c.parent_id";
        $database->setQuery($selectstring);
        $cats = $database->loadAssocList();
    }
    //$retVal = mosBooklibraryImportExport :: exportBooksXML($books, $cats);
    $retVal = $strXmlDoc;
    $type2 = 'xml';
    switch ($type) {
        case '1':
            $type2 = 'csv';
        break;
        case '2':
            $type2 = 'xml';
        break;
    }
    $InformationArray = mosBooklibraryImportExport::storeExportFile($retVal, $type2);
    HTML_booklibrary::showExportResult($InformationArray, $option);
}
function importExportBooks($option) {
    global $database;
    $q = "SELECT id AS value, title AS text 
            FROM #__booklibrary_main_categories 
            WHERE section = '" . $option . "' 
            ORDER BY ordering"; 
    // get list of categories
    $categories[] = mosHTML::makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
    $database->setQuery($q); 
    $categories = array_merge($categories, $database->loadObjectList());
    if (count($categories) < 1) {
        mosRedirect("index.php?option=com_booklibrary&section=categories", 
            _BOOKLIBRARY_ADMIN_IMPEXP_ADD);
    }
    $impclist = mosHTML::selectList($categories, 'import_catid', 'class="inputbox"  
                                      size="1" id="import_catid"', 'value', 'text', 0);
    $expclist = mosHTML::selectList($categories, 'export_catid', 'class="inputbox"  
                                      size="1" id="export_catid"', 'value', 'text', 0);
    $params = array();
    $params['import']['category'] = $impclist;
    $params['export']['category'] = $expclist;
    $importtypes[0] = mosHTML::makeOption('0', _BOOKLIBRARY_ADMIN_PLEASE_SEL);
    $importtypes[1] = mosHTML::makeOption('1', _BOOKLIBRARY_ADMIN_FORMAT_CSV);
    $importtypes[2] = mosHTML::makeOption('2', _BOOKLIBRARY_ADMIN_FORMAT_XML);
    //$importtypes[3] = mosHTML :: makeOption('3', _BOOKLIBRARY_ADMIN_ENTIRE_RECOVER);
    $importtypes[4] = mosHTML::makeOption('4', _BOOKLIBRARY_ADMIN_FULL_IMPORT);
    $params['import']['type'] = mosHTML::selectList($importtypes, 'import_type', 'id="import_type"
      class="inputbox" size="1" onchange = "impch();"', 'value', 'text', 0);
    $exporttypes[0] = mosHTML::makeOption('0', _BOOKLIBRARY_ADMIN_PLEASE_SEL);
    $exporttypes[1] = mosHTML::makeOption('1', _BOOKLIBRARY_ADMIN_FORMAT_CSV);
    $exporttypes[2] = mosHTML::makeOption('2', _BOOKLIBRARY_ADMIN_FORMAT_XML);
    //$exporttypes[3] = mosHTML :: makeOption('3', _BOOKLIBRARY_ADMIN_ENTIRE_BU);
    $exporttypes[4] = mosHTML::makeOption('4', _BOOKLIBRARY_ADMIN_FULL_EXPORT);
    $params['export']['type'] = mosHTML::selectList($exporttypes, 'export_type', 'id="export_type" 
      class="inputbox" size="1" onchange="expch();"', 'value', 'text', 0);
    HTML_booklibrary::showImportExportBooks($params, $option);
}
// LANGUAGE MANAGER
function showLanguageManager($option) {
    global $database, $mainframe, $mosConfig_list_limit, $menutype, $mosConfig_absolute_path;
    $jinput = JFactory::getApplication()->input;

    $section = "com_booklibrary";
    $search['const'] = mosGetParam($_POST, 'search_const', '');
    $search['const_value'] = mosGetParam($_POST, 'search_const_value', '');
    $search['languages'] = mosGetParam($_POST, 'search_languages', '');
    $search['sys_type'] = mosGetParam($_POST, 'search_sys_type', '');
    $where_query = array();
    if ($search['const'] != '') $where_query[] = "c.const LIKE '%" . $search['const'] . "%'";
    if ($search['const_value'] != '') $where_query[] = "cl.value_const LIKE '%" . 
        $search['const_value'] . "%'";
    if ($search['languages'] != '') $where_query[] = "cl.fk_languagesid = " . $search['languages'] . " ";
    if ($search['sys_type'] != '') $where_query[] = "c.sys_type LIKE '%" . $search['sys_type'] . "%'";
    $where = "";
    $i = 0;
    if (count($where_query) > 0) $where = "WHERE ";
    foreach($where_query as $item) {
        if ($i == 0) $where.= "( $item ) ";
        else $where.= "AND ( $item ) ";
        $i++;
    }
    $query = "SELECT cl.id, cl.value_const, c.sys_type, l.title, c.const ";
    $query.= "FROM #__booklibrary_const_languages as cl ";
    $query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
    $query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id $where";
    $database->setQuery($query);
    $const_languages = $database->loadObjectList();
    $sectionid = $mainframe->getUserStateFromRequest("sectionid{$section}{$section}", 'sectionid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$section}limitstart", 'limitstart', 0);
    $levellimit = $mainframe->getUserStateFromRequest("view{$option}limit$menutype", 'levellimit', 10);
    $total = count($const_languages);
    $pageNav = new JPagination($total, $limitstart, $limit); 
    $const_languages = array_slice($const_languages, $pageNav->limitstart, $pageNav->limit);
    $query = "SELECT sys_type FROM #__booklibrary_const GROUP BY sys_type";
    $database->setQuery($query);
    $sys_types = $database->loadObjectList();
    $sys_type_row[] = mosHTML::makeOption('', '--Select sys type--');
    foreach($sys_types as $sys_type) {
        $sys_type_row[] = mosHTML::makeOption($sys_type->sys_type, $sys_type->sys_type);
    }
    $search['sys_type'] = mosHTML::selectList($sys_type_row, 'search_sys_type', 
    'class="inputbox input-medium" size="1"  
        onchange="document.adminForm.submit();"', 'value', 'text', $search['sys_type']);
    $query = "SELECT id, title 
              FROM #__booklibrary_languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();
    $languages_row[] = mosHTML::makeOption('', '--Select language--');
    foreach($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->id, $language->title);
    }
    
    $search['languages'] = mosHTML::selectList($languages_row, 'search_languages', 
    'class="inputbox input-medium" size="1" 
        onchange="document.adminForm.submit();"', 'value', 'text', $search['languages']);
       
    if($jinput->get('task','') == 'loadLang'){
        
        loadConstBooklibrary();
        language_check_booklib();  
    }

    HTML_booklibrary::showLanguageManager($const_languages, $pageNav, $search);
}

function editLanguageManager($section = '', $uid = 0) {
    global $database, $my, $acl, $booklibrary_configuration;
    global $mosConfig_absolute_path, $mosConfig_live_site;
    $row = new mosBooklibrary_language($database); 
    // load the row from the db table
    $row->load($uid);
    $query = "SELECT * 
              FROM #__booklibrary_const 
              WHERE id = " . $row->fk_constid;
    $database->setQuery($query);
    $const = $database->loadObject();
    $lists['const'] = $const->const;
    $lists['sys_type'] = $const->sys_type;
    $query = "SELECT title 
              FROM #__booklibrary_languages 
              WHERE id = " . $row->fk_languagesid;
    $database->setQuery($query);
    $language = $database->loadResult();
    $lists['languages'] = $language;
    HTML_booklibrary::editLanguageManager($row, $lists);
}
function saveLanguageManager() {
    global $database, $mosConfig_absolute_path;
    $row = new mosBooklibrary_language($database);
    $jinput = JFactory::getApplication()->input;
    // $post = JRequest::get('post', JREQUEST_ALLOWHTML);
    //$post = $jinput->getArray($_POST);
    $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw');
    if (!$row->bind($post)) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }
    if (!$row->check()) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }
    if (!$row->store()) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }
    mosRedirect('index.php?option=com_booklibrary&section=language_manager');
}

function cancelLanguageManager() {
    global $database, $mosConfig_absolute_path;
    mosRedirect('index.php?option=com_booklibrary&section=language_manager');
}

function modalArticle ($option) {

    global $mosConfig_absolute_path;
   
    $inp = new JFormFieldModal_Article_BL();
   
    JFormHelper::addFieldPath($mosConfig_absolute_path . 
        "/components/com_booklibrary");
    $inp = JFormHelper::loadFieldType('Modal_Article_BL', false);
    echo $inp->getInput();

}
