<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Pro
 *
 */
 if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');
$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/compat.joomla1.5.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.impexp.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.conf.php");
require_once ($mosConfig_absolute_path . 
    "/administrator/components/com_booklibrary/admin.booklibrary.class.others.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/booklibrary.class.php");
require_once ($mosConfig_absolute_path . 
    "/components/com_booklibrary/functions.php");


$GLOBALS['booklibrary_configuration'] = $booklibrary_configuration;
if (!defined('_JLEGACY')) {
    $GLOBALS['path'] = $mosConfig_live_site . "/components/com_booklibrary/images/";
} else {
    $GLOBALS['path'] = $mosConfig_live_site . "/administrator/components/com_booklibrary/images/";
}

$path = $GLOBALS['path'];

function update_to_version_6_2() {
    global $database;

    //echo "Creating table for sef urls... ";
    $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_sef_urls` (
        `id` int(11) unsigned NOT NULL auto_increment,
        `ser_url_segments` blob,
        `hash_url_segments` varchar(35) NOT NULL default '',
        `ser_vars` blob ,
        `hash_vars` varchar(35) NOT NULL default '',
        `lang` varchar(55) NOT NULL default '',
        `date` datetime ,
        `hits` int(11) NOT NULL default '0',
        `published` tinyint(1) NOT NULL default '1',
        PRIMARY KEY  (`id`),
        INDEX (`hash_url_segments`),
        INDEX (`hash_vars`),
        INDEX (`date`),
        INDEX (`date`,`hits`),
        INDEX (`lang`)
        ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARACTER SET utf8 ";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

}

function update_to_version_6_1() {
    global $database;

    $query = "ALTER TABLE `#__booklibrary_authors` 
        CHANGE `date` `date` datetime,
        CHANGE `checked_out_time` `checked_out_time` datetime,
        CHANGE `description` `description` TEXT,
        CHANGE `auto_gener_description` `auto_gener_description` TEXT,
        CHANGE `birthday` `birthday` datetime ,
        CHANGE `date_of_death` `date_of_death` datetime ";
    $database->setQuery($query);
    $database->execute();

    // $query = "UPDATE #__booklibrary 
    //     SET checked_out_time = NULL
    //     WHERE checked_out_time = '0000-00-00 00:00:00'";
    // $database->setQuery($query);
    // $database->execute(); 

    $query = "UPDATE #__booklibrary 
        SET featured_clicks = 0
        WHERE featured_clicks = ''";
    $database->setQuery($query);
    $database->execute(); 

    $query = "UPDATE #__booklibrary 
        SET featured_shows = 0
        WHERE featured_shows = ''";
    $database->setQuery($query);
    $database->execute(); 


    $query = "ALTER TABLE `#__booklibrary` 
        CHANGE `featured_clicks` `featured_clicks` BIGINT(100) default 0,
        CHANGE `featured_shows` `featured_shows` BIGINT(100) default 0,
        CHANGE `date` `date` datetime,
        CHANGE `checked_out_time` `checked_out_time` datetime,
        CHANGE `comment` `comment` TEXT ";
    $database->setQuery($query);
    $database->execute();


    $query = "ALTER TABLE `#__booklibrary_main_categories` 
        CHANGE `checked_out_time` `checked_out_time` datetime,
        CHANGE `description` `description` TEXT,
        CHANGE `params` `params` TEXT,
        CHANGE `params2` `params2` TEXT ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE `#__booklibrary_lend` 
        CHANGE `lend_from` `lend_from` datetime,
        CHANGE `lend_until` `lend_until` datetime,
        CHANGE `lend_return` `lend_return` datetime,
        CHANGE `checked_out_time` `checked_out_time` datetime ,
        CHANGE `user_mailing` `user_mailing` TEXT ";
    $database->setQuery($query);
    $database->execute();
 

    $query = "ALTER TABLE `#__booklibrary_lend_request` 
        CHANGE `lend_from` `lend_from` date,
        CHANGE `lend_until` `lend_until` date,
        CHANGE `lend_request` `lend_request` datetime,
        CHANGE `checked_out_time` `checked_out_time` datetime ,
        CHANGE `user_mailing` `user_mailing` TEXT ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE `#__booklibrary_review` 
        CHANGE `date` `date` datetime ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE `#__booklibrary_suggestion` 
        CHANGE `date` `date` datetime ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE `#__booklibrary_mime_types` 
        CHANGE `mime_ext` `mime_ext` text,
        CHANGE `mime_type` `mime_type` text ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE #__booklibrary  
            ADD COLUMN `metadata` TEXT ,  
            ADD COLUMN `publish_up` datetime, 
            ADD COLUMN `publish_down` datetime ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE #__booklibrary_main_categories  
            ADD COLUMN `metadata` TEXT ,  
            ADD COLUMN `publish_up` datetime, 
            ADD COLUMN `publish_down` datetime ";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE #__booklibrary_authors  
            ADD COLUMN `metadata` TEXT ,  
            ADD COLUMN `publish_up` datetime, 
            ADD COLUMN `publish_down` datetime ";
    $database->setQuery($query);
    $database->execute();    

}

function update_to_version_6_0() {
}

function update_to_version_5_0() {
    global $database;

    // $query = "ALTER TABLE #__booklibrary  
    //         ADD COLUMN `id_article_book` int(10) default null";
    // $database->setQuery($query);
    // $database->execute();

    // $query = "ALTER TABLE #__booklibrary  
    //         ADD COLUMN `flipHTML5` varchar(255) default null";
    // $database->setQuery($query);
    // $database->execute();
    
    $query = "INSERT INTO `#__booklibrary_mime_types` (`mime_ext`, `mime_type`) VALUES 
            ('mp3', 'audio/mp3'),
            ('mp3', 'audio/x-mpeg'),
            ('mp3', 'audio/x-mp3'),
            ('mp3', 'audio/mpeg3'),
            ('mp3', 'audio/x-mpeg3'),
            ('mp3', 'audio/mpg'),
            ('mp3', 'audio/x-mpg'),
            ('mp3', 'audio/x-mpegaudio'),
            ('vtt', 'text/plain');";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "CREATE TABLE IF NOT EXISTS  `#__booklibrary_api` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `service` varchar(255) NOT NULL,
            `key` text,
            PRIMARY KEY  (`id`)
        ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci;";
    $database->setQuery($query);
    $database->execute();    


}

function update_to_version_4_0() {
	global $database;

	$query = "ALTER TABLE #__booklibrary  
            ADD COLUMN `id_article_book` int(10) default null";
    $database->setQuery($query);
    $database->execute();

	$query = "ALTER TABLE #__booklibrary  
            ADD COLUMN `flipHTML5` varchar(255) default null";
    $database->setQuery($query);
    $database->execute();
}


function update_to_version_3_6() {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_authors_connect ( 
                    `id` int(11) NOT NULL auto_increment, 
                    `fk_bookid` int(11) DEFAULT NULL, 
                    `fk_authorid` int(11) DEFAULT NULL, 
                     FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`), 
                     FOREIGN KEY (`fk_authorid`) REFERENCES #__booklibrary_authors(`id`), 
                     PRIMARY KEY (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
    $database->setQuery($query);
    $database->execute();
    $query = "INSERT INTO #__booklibrary_authors_connect (fk_bookid, fk_authorid)
    SELECT #__booklibrary.id, #__booklibrary_authors.id
    FROM #__booklibrary JOIN #__booklibrary_authors ON #__booklibrary.fk_authors = #__booklibrary_authors.id";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_users_favorits ( 
                    `id` int(11) NOT NULL auto_increment, 
                    `fk_bookid` int(11) DEFAULT NULL, 
                    `fk_userid` int(11) DEFAULT NULL, 
                     FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`), 
                     FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`), 
                     PRIMARY KEY (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
}

function update_to_version_3_5() {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_authors ( 
                    `id` int(11) unsigned NOT NULL auto_increment,     
                    `date` datetime , 
                    `hits` int(11) NOT NULL default '0', 
                    `associate_authors` varchar(255) default null, 
                    `published` tinyint(1) NOT NULL default '0', 
                    `checked_out` int(11) NOT NULL default '0', 
                    `checked_out_time` datetime, 
                    `approved` tinyint(1) NOT NULL default '1', 
                    `authors_name` varchar(200) default '', 
                    `description` text , 
                    `auto_gener_description` text , 
                    `imageURL` varchar(200) default '', 
                    `langshow` varchar(100) default '*', 
                    `owneremail` VARCHAR(50), 
                    `owner_id` int(10) default '0', 
                    `alias` varchar(200) default '', 
                    `birthday` datetime , 
                    `birthplace` varchar(200) default '', 
                    `date_of_death` datetime , 
                    `nationality` varchar(200) default '', 
                    `citizenship` varchar(200) default '', 
                    `language_works` varchar(200) default '', 
                    `occupation` varchar(200) default '', 
                    `years_of_activity` varchar(200) default '', 
                    `direction` varchar(200) default '', 
                    `genre` varchar(200) default '', 
                    `magnum_opus` varchar(200) default '', 
                    `premiums` varchar(200) default '', 
                    `autograph` varchar(200) default '', 
                    PRIMARY KEY  (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_video_source ( 
                    `id` int(11) unsigned NOT NULL auto_increment, 
                    `sequence_number` int(11) DEFAULT NULL, 
                    `fk_book_id` int(11) DEFAULT NULL, 
                    `fk_author_id`int(11) DEFAULT NULL, 
                    `src` varchar(255) DEFAULT NULL, 
                    `type` varchar(255) DEFAULT NULL, 
                    `media`varchar(255) DEFAULT NULL, 
                    `youtube`varchar(255) DEFAULT NULL, 
                     FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                     FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                     PRIMARY KEY (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_track_source ( 
                    `id` int(11) unsigned NOT NULL auto_increment, 
                    `sequence_number` int(11) DEFAULT NULL, 
                    `fk_book_id` int(11) DEFAULT NULL, 
                    `fk_author_id`int(11) DEFAULT NULL, 
                    `src` varchar(255) DEFAULT NULL, 
                    `kind` varchar(255) DEFAULT NULL, 
                    `scrlang` varchar(255) DEFAULT NULL, 
                    `label` varchar(255) DEFAULT NULL, 
                     FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                     FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                     PRIMARY KEY (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_audio_source ( 
                    `id` int(11) unsigned NOT NULL auto_increment, 
                    `sequence_number` int(11) DEFAULT NULL, 
                    `fk_book_id` int(11) DEFAULT NULL, 
                    `fk_author_id`int(11) DEFAULT NULL, 
                    `src` varchar(255) DEFAULT NULL, 
                    `type`varchar(255) DEFAULT NULL, 
                     FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                     FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                     PRIMARY KEY  (`id`) 
                    ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    // deprecated in Joomla 4.0 - Use PHP exceptions try { ... } catch { ... } like above |^|
    $query = "ALTER TABLE #__booklibrary                 
                ADD COLUMN fk_authors varchar(100) NOT NULL default 0, 
                ADD COLUMN associate_book varchar(255) default 0, 
                ADD FOREIGN KEY (`fk_authors`) REFERENCES #__booklibrary_authors(`id`)";
    try {
        $database->setQuery($query); 
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "ALTER TABLE #__booklibrary_main_categories  
            ADD COLUMN `associate_category` varchar(255) default null";
    $database->setQuery($query);
    $database->execute();
    
    $query = "ALTER TABLE #__booklibrary_const ADD UNIQUE (`const`)";
    $database->setQuery($query);
    $database->execute();

    $query = "ALTER TABLE #__booklibrary_languages ADD UNIQUE (`lang_code`)";
    $database->setQuery($query);
    $database->execute();
    
    update_authors_for_3_5();
}

function  update_authors_for_3_5() {
    global $booklibrary_configuration, $mosConfig_absolute_path,$database;
    $query = "SELECT * FROM `#__booklibrary`";
    $database->setQuery($query);
    $allbook = $database->loadObjectList();
    foreach ($allbook as $book) {
        $result = '';
        $query = "SELECT id FROM #__booklibrary_authors 
            WHERE #__booklibrary_authors.authors_name=" . $database->Quote($book->authors) . "";
        $database->setQuery($query);
        $result = $database->loadResult();
        if (!$result) {
            $query = "INSERT INTO #__booklibrary_authors (authors_name)
                VALUE (" . $database->Quote($book->authors) . ")" ;
            $database->setQuery($query);
            $database->execute();

            $query = "UPDATE #__booklibrary 
                SET fk_authors = (SELECT id FROM #__booklibrary_authors
                    WHERE #__booklibrary_authors.authors_name = " . $database->Quote( $book->authors ) . ")
                WHERE #__booklibrary.id = '" . $book->id . "'";
            $database->setQuery($query);
            $database->execute(); 
        } else {

            $query = "UPDATE #__booklibrary 
                SET fk_authors = (SELECT id FROM #__booklibrary_authors
                    WHERE #__booklibrary_authors.authors_name = " . $database->Quote($book->authors) . ")
                WHERE #__booklibrary.id = '" . $book->id . "'";
            $database->setQuery($query);
            $database->execute(); 

            // $query = "delete from #__booklibrary_authors_connect where fk_bookid='" . (int)$book->id . "'";
            // $database->setQuery($query);
            // $database->execute();

            // $query = "INSERT INTO #__booklibrary_authors_connect 
            //      SET `fk_bookid` = '".$book->id."', `fk_authorid` = '". (int)$result  ."' ";
               
            // $database->setQuery($query)->execute();
        }
    }
}

function updateBooklibraryConfigurationVersion() {
    global $booklibrary_configuration, $mosConfig_absolute_path;
    $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_booklibrary/booklibrary_j3.xml");
    $version = (string)$xml->version;
    $booklibrary_configuration['release']['version'] = $version;
    $booklibrary_configuration['release']['date'] = (string)$xml->creationDate;
    mosBooklibraryOthers::setParams();
    unset($xml);
}

function updateBooklibraryVersion() {
    global $database, $booklibrary_configuration;
    updateBooklibraryConfigurationVersion();
    $bl_version = explode(' ', $booklibrary_configuration['release']['version']);
    $query = "UPDATE #__booklibrary_version 
              SET version = '$bl_version[0]', number = '$bl_version[1]' 
              WHERE id = 2";
    $database->setQuery($query);
    $database->execute();
}

function AddMimeTypes() {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
    $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_mime_types` ( 
            `mime_ext` text, 
            `mime_type` text 
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "delete from `#__booklibrary_mime_types`";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    $query = "INSERT INTO `#__booklibrary_mime_types` (`mime_ext`, `mime_type`) VALUES 
    ('atom', 'application/atom+xml'),
    ('atomcat', 'application/atomcat+xml'),
    ('atomsvc', 'application/atomsvc+xml'),
    ('ccxml', 'application/ccxml+xml'),
    ('epub', 'application/epub+zip'),
    ('jar', 'application/java-archive'),
    ('js', 'application/javascript'),
    ('json', 'application/json'),
    ('jsonml', 'application/jsonml+json'),
    ('mads', 'application/mads+xml'),
    ('mathml', 'application/mathml+xml'),
    ('mbox', 'application/mbox'),
    ('mscml', 'application/mediaservercontrol+xml'),
    ('metalink', 'application/metalink+xml'),
    ('meta4', 'application/metalink4+xml'),
    ('mods', 'application/mods+xml'),
    ('doc', 'application/msword'),
    ('dot', 'application/msword'),
    ('bin', 'application/octet-stream'),
    ('so', 'application/octet-stream'),
    ('pkg', 'application/octet-stream'),
    ('dump', 'application/octet-stream'),
    ('elc', 'application/octet-stream'),
    ('deploy', 'application/octet-stream'),
    ('oxps', 'application/oxps'),
    ('pdf', 'application/pdf'),
    ('asc', 'application/pgp-signature'),
    ('sig', 'application/pgp-signature'),
    ('prf', 'application/pics-rules'),
    ('cer', 'application/pkix-cert'),
    ('crl', 'application/pkix-crl'),
    ('ai', 'application/postscript'),
    ('eps', 'application/postscript'),
    ('ps', 'application/postscript'),
    ('rdf', 'application/rdf+xml'),
    ('rs', 'application/rls-services+xml'),
    ('rsd', 'application/rsd+xml'),
    ('rss', 'application/rss+xml'),
    ('rtf', 'application/rtf'),
    ('fxp', 'application/vnd.adobe.fxp'),
    ('fxpl', 'application/vnd.adobe.fxp'),
    ('xdp', 'application/vnd.adobe.xdp+xml'),
    ('xfdf', 'application/vnd.adobe.xfdf'),
    ('ahead', 'application/vnd.ahead.space'),
    ('azf', 'application/vnd.airzip.filesecure.azf'),
    ('azs', 'application/vnd.airzip.filesecure.azs'),
    ('azw', 'application/vnd.amazon.ebook'),
    ('mpkg', 'application/vnd.apple.installer+xml'),
    ('m3u8', 'application/vnd.apple.mpegurl'),
    ('sc', 'application/vnd.ibm.secure-container'),
    ('org', 'application/vnd.lotus-organizer'),
    ('scm', 'application/vnd.lotus-screencam'),
    ('flo', 'application/vnd.micrografx.flo'),
    ('igx', 'application/vnd.micrografx.igx'),
    ('xul', 'application/vnd.mozilla.xul+xml'),
    ('cab', 'application/vnd.ms-cab-compressed'),
    ('xls', 'application/vnd.ms-excel'),
    ('xlm', 'application/vnd.ms-excel'),
    ('xla', 'application/vnd.ms-excel'),
    ('xlc', 'application/vnd.ms-excel'),
    ('xlt', 'application/vnd.ms-excel'),
    ('xlw', 'application/vnd.ms-excel'),
    ('chm', 'application/vnd.ms-htmlhelp'),
    ('thmx', 'application/vnd.ms-officetheme'),
    ('cat', 'application/vnd.ms-pki.seccat'),
    ('ppt', 'application/vnd.ms-powerpoint'),
    ('pps', 'application/vnd.ms-powerpoint'),
    ('pot', 'application/vnd.ms-powerpoint'),
    ('mpp', 'application/vnd.ms-project'),
    ('mpt', 'application/vnd.ms-project'),
    ('docm', 'application/vnd.ms-word.document.macroenabled.12'),
    ('dotm', 'application/vnd.ms-word.template.macroenabled.12'),
    ('wps', 'application/vnd.ms-works'),
    ('wks', 'application/vnd.ms-works'),
    ('wcm', 'application/vnd.ms-works'),
    ('wdb', 'application/vnd.ms-works'),
    ('wpl', 'application/vnd.ms-wpl'),
    ('xps', 'application/vnd.ms-xpsdocument'),
    ('edm', 'application/vnd.novadigm.edm'),
    ('edx', 'application/vnd.novadigm.edx'),
    ('ext', 'application/vnd.novadigm.ext'),
    ('odc', 'application/vnd.oasis.opendocument.chart'),
    ('otc', 'application/vnd.oasis.opendocument.chart-template'),
    ('odb', 'application/vnd.oasis.opendocument.database'),
    ('odf', 'application/vnd.oasis.opendocument.formula'),
    ('odft', 'application/vnd.oasis.opendocument.formula-template'),
    ('odg', 'application/vnd.oasis.opendocument.graphics'),
    ('otg', 'application/vnd.oasis.opendocument.graphics-template'),
    ('odi', 'application/vnd.oasis.opendocument.image'),
    ('oti', 'application/vnd.oasis.opendocument.image-template'),
    ('odp', 'application/vnd.oasis.opendocument.presentation'),
    ('otp', 'application/vnd.oasis.opendocument.presentation-template'),
    ('ods', 'application/vnd.oasis.opendocument.spreadsheet'),
    ('ots', 'application/vnd.oasis.opendocument.spreadsheet-template'),
    ('odt', 'application/vnd.oasis.opendocument.text'),
    ('odm', 'application/vnd.oasis.opendocument.text-master'),
    ('ott', 'application/vnd.oasis.opendocument.text-template'),
    ('oth', 'application/vnd.oasis.opendocument.text-web'),
    ('oxt', 'application/vnd.openofficeorg.extension'),
    ('pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation'),
    ('sldx', 'application/vnd.openxmlformats-officedocument.presentationml.slide'),
    ('ppsx', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow'),
    ('potx', 'application/vnd.openxmlformats-officedocument.presentationml.template'),
    ('xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'),
    ('xltx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'),
    ('docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
    ('dotx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'),
    ('mgp', 'application/vnd.osgeo.mapguide.package'),
    ('vcx', 'application/vnd.vcx'),
    ('vsd', 'application/vnd.visio'),
    ('vst', 'application/vnd.visio'),
    ('vss', 'application/vnd.visio'),
    ('vsw', 'application/vnd.visio'),
    ('vsf', 'application/vnd.vsf'),
    ('wbxml', 'application/vnd.wap.wbxml'),
    ('xar', 'application/vnd.xara'),
    ('vxml', 'application/voicexml+xml'),
    ('wgt', 'application/widget'),
    ('hlp', 'application/winhlp'),
    ('wsdl', 'application/wsdl+xml'),
    ('7z', 'application/x-7z-compressed'),
    ('abw', 'application/x-abiword'),
    ('ace', 'application/x-ace-compressed'),
    ('bz', 'application/x-bzip'),
    ('bz2', 'application/x-bzip2'),
    ('boz', 'application/x-bzip2'),
    ('vcd', 'application/x-cdlink'),
    ('cfs', 'application/x-cfs-compressed'),
    ('chat', 'application/x-chat'),
    ('pgn', 'application/x-chess-pgn'),
    ('nsc', 'application/x-conference'),
    ('cpio', 'application/x-cpio'),
    ('csh', 'application/x-csh'),
    ('deb', 'application/x-debian-package'),
    ('udeb', 'application/x-debian-package'),
    ('dgc', 'application/x-dgc-compressed'),
    ('ncx', 'application/x-dtbncx+xml'),
    ('dtb', 'application/x-dtbook+xml'),
    ('res', 'application/x-dtbresource+xml'),
    ('dvi', 'application/x-dvi'),
    ('gsf', 'application/x-font-ghostscript'),
    ('psf', 'application/x-font-linux-psf'),
    ('otf', 'application/x-font-otf'),
    ('pcf', 'application/x-font-pcf'),
    ('snf', 'application/x-font-snf'),
    ('ttf', 'application/x-font-ttf'),
    ('ttc', 'application/x-font-ttf'),
    ('woff', 'application/x-font-woff'),
    ('arc', 'application/x-freearc'),
    ('gca', 'application/x-gca-compressed'),
    ('ulx', 'application/x-glulx'),
    ('gnumeric', 'application/x-gnumeric'),
    ('gramps', 'application/x-gramps-xml'),
    ('gtar', 'application/x-gtar'),
    ('hdf', 'application/x-hdf'),
    ('install', 'application/x-install-instructions'),
    ('iso', 'application/x-iso9660-image'),
    ('jnlp', 'application/x-java-jnlp-file'),
    ('latex', 'application/x-latex'),
    ('lzh', 'application/x-lzh-compressed'),
    ('lha', 'application/x-lzh-compressed'),
    ('prc', 'application/x-mobipocket-ebook'),
    ('mobi', 'application/x-mobipocket-ebook'),
    ('application', 'application/x-ms-application'),
    ('crd', 'application/x-mscardfile'),
    ('clp', 'application/x-msclip'),
    ('exe', 'application/x-msdownload'),
    ('dll', 'application/x-msdownload'),
    ('com', 'application/x-msdownload'),
    ('bat', 'application/x-msdownload'),
    ('msi', 'application/x-msdownload'),
    ('pub', 'application/x-mspublisher'),
    ('rar', 'application/x-rar-compressed'),
    ('sh', 'application/x-sh'),
    ('shar', 'application/x-shar'),
    ('swf', 'application/x-shockwave-flash'),
    ('sql', 'application/x-sql'),
    ('srt', 'application/x-subrip'),
    ('t3', 'application/x-t3vm-image'),
    ('tar', 'application/x-tar'),
    ('tcl', 'application/x-tcl'),
    ('tex', 'application/x-tex'),
    ('texinfo', 'application/x-texinfo'),
    ('texi', 'application/x-texinfo'),
    ('obj', 'application/x-tgif'),
    ('src', 'application/x-wais-source'),
    ('der', 'application/x-x509-ca-cert'),
    ('crt', 'application/x-x509-ca-cert'),
    ('xpi', 'application/x-xpinstall'),
    ('xz', 'application/x-xz'),
    ('xaml', 'application/xaml+xml'),
    ('xdf', 'application/xcap-diff+xml'),
    ('xht', 'application/xhtml+xml'),
    ('xml', 'application/xml'),
    ('xsl', 'application/xml'),
    ('dtd', 'application/xml-dtd'),
    ('xop', 'application/xop+xml'),
    ('xpl', 'application/xproc+xml'),
    ('xslt', 'application/xslt+xml'),
    ('xspf', 'application/xspf+xml'),
    ('zip', 'application/zip'),
    ('zip', 'application/x-zip'),
    ('zip', 'application/x-zip-compressed'),
    ('adp', 'audio/adpcm'),
    ('au', 'audio/basic'),
    ('snd', 'audio/basic'),
    ('mid', 'audio/midi'),
    ('midi', 'audio/midi'),
    ('kar', 'audio/midi'),
    ('rmi', 'audio/midi'),
    ('mp4a', 'audio/mp4'),
    ('mpga', 'audio/mpeg'),
    ('mp2', 'audio/mpeg'),
    ('mp2a', 'audio/mpeg'),
    ('mp3', 'audio/mpeg'),
    ('m2a', 'audio/mpeg'),
    ('m3a', 'audio/mpeg'),
    ('oga', 'audio/ogg'),
    ('ogg', 'audio/ogg'),
    ('spx', 'audio/ogg'),
    ('s3m', 'audio/s3m'),
    ('sil', 'audio/silk'),
    ('uva', 'audio/vnd.dece.audio'),
    ('uvva', 'audio/vnd.dece.audio'),
    ('eol', 'audio/vnd.digital-winds'),
    ('dra', 'audio/vnd.dra'),
    ('dts', 'audio/vnd.dts'),
    ('dtshd', 'audio/vnd.dts.hd'),
    ('lvp', 'audio/vnd.lucent.voice'),
    ('pya', 'audio/vnd.ms-playready.media.pya'),
    ('rip', 'audio/vnd.rip'),
    ('weba', 'audio/webm'),
    ('aac', 'audio/x-aac'),
    ('aif', 'audio/x-aiff'),
    ('aiff', 'audio/x-aiff'),
    ('aifc', 'audio/x-aiff'),
    ('caf', 'audio/x-caf'),
    ('flac', 'audio/x-flac'),
    ('mka', 'audio/x-matroska'),
    ('m3u', 'audio/x-mpegurl'),
    ('wax', 'audio/x-ms-wax'),
    ('wma', 'audio/x-ms-wma'),
    ('ram', 'audio/x-pn-realaudio'),
    ('ra', 'audio/x-pn-realaudio'),
    ('rmp', 'audio/x-pn-realaudio-plugin'),
    ('wav', 'audio/x-wav'),
    ('xm', 'audio/xm'),
    ('cdx', 'chemical/x-cdx'),
    ('cif', 'chemical/x-cif'),
    ('cmdf', 'chemical/x-cmdf'),
    ('cml', 'chemical/x-cml'),
    ('csml', 'chemical/x-csml'),
    ('xyz', 'chemical/x-xyz'),
    ('bmp', 'image/bmp'),
    ('cgm', 'image/cgm'),
    ('g3', 'image/g3fax'),
    ('gif', 'image/gif'),
    ('ief', 'image/ief'),
    ('jpeg', 'image/jpeg'),
    ('jpg', 'image/jpeg'),
    ('jpe', 'image/jpeg'),
    ('ktx', 'image/ktx'),
    ('png', 'image/png'),
    ('btif', 'image/prs.btif'),
    ('sgi', 'image/sgi'),
    ('svg', 'image/svg+xml'),
    ('svgz', 'image/svg+xml'),
    ('tiff', 'image/tiff'),
    ('tif', 'image/tiff'),
    ('psd', 'image/vnd.adobe.photoshop'),
    ('uvi', 'image/vnd.dece.graphic'),
    ('uvvi', 'image/vnd.dece.graphic'),
    ('uvg', 'image/vnd.dece.graphic'),
    ('uvvg', 'image/vnd.dece.graphic'),
    ('sub', 'text/vnd.dvb.subtitle'),
    ('djvu', 'image/vnd.djvu'),
    ('djv', 'image/vnd.djvu'),
    ('dwg', 'image/vnd.dwg'),
    ('dxf', 'image/vnd.dxf'),
    ('fbs', 'image/vnd.fastbidsheet'),
    ('fpx', 'image/vnd.fpx'),
    ('fst', 'image/vnd.fst'),
    ('mmr', 'image/vnd.fujixerox.edmics-mmr'),
    ('rlc', 'image/vnd.fujixerox.edmics-rlc'),
    ('mdi', 'image/vnd.ms-modi'),
    ('wdp', 'image/vnd.ms-photo'),
    ('npx', 'image/vnd.net-fpx'),
    ('wbmp', 'image/vnd.wap.wbmp'),
    ('xif', 'image/vnd.xiff'),
    ('webp', 'image/webp'),
    ('3ds', 'image/x-3ds'),
    ('ras', 'image/x-cmu-raster'),
    ('cmx', 'image/x-cmx'),
    ('fh', 'image/x-freehand'),
    ('fhc', 'image/x-freehand'),
    ('fh4', 'image/x-freehand'),
    ('fh5', 'image/x-freehand'),
    ('fh7', 'image/x-freehand'),
    ('ico', 'image/x-icon'),
    ('sid', 'image/x-mrsid-image'),
    ('pcx', 'image/x-pcx'),
    ('pic', 'image/x-pict'),
    ('pct', 'image/x-pict'),
    ('pnm', 'image/x-portable-anymap'),
    ('pbm', 'image/x-portable-bitmap'),
    ('pgm', 'image/x-portable-graymap'),
    ('ppm', 'image/x-portable-pixmap'),
    ('rgb', 'image/x-rgb'),
    ('tga', 'image/x-tga'),
    ('xbm', 'image/x-xbitmap'),
    ('xpm', 'image/x-xpixmap'),
    ('xwd', 'image/x-xwindowdump'),
    ('eml', 'message/rfc822'),
    ('mime', 'message/rfc822'),
    ('igs', 'model/iges'),
    ('iges', 'model/iges'),
    ('msh', 'model/mesh'),
    ('mesh', 'model/mesh'),
    ('ics', 'text/calendar'),
    ('ifb', 'text/calendar'),
    ('css', 'text/css'),
    ('csv', 'text/csv'),
    ('html', 'text/html'),
    ('htm', 'text/html'),
    ('txt', 'text/plain'),
    ('text', 'text/plain'),
    ('conf', 'text/plain'),
    ('def', 'text/plain'),
    ('list', 'text/plain'),
    ('log', 'text/plain'),
    ('sgml', 'text/sgml'),
    ('sgm', 'text/sgml'),
    ('man', 'text/troff'),
    ('ttl', 'text/turtle'),
    ('uri', 'text/uri-list'),
    ('uris', 'text/uri-list'),
    ('urls', 'text/uri-list'),
    ('vcard', 'text/vcard'),
    ('curl', 'text/vnd.curl'),
    ('dcurl', 'text/vnd.curl.dcurl'),
    ('scurl', 'text/vnd.curl.scurl'),
    ('mcurl', 'text/vnd.curl.mcurl'),
    ('fly', 'text/vnd.fly'),
    ('flx', 'text/vnd.fmi.flexstor'),
    ('gv', 'text/vnd.graphviz'),
    ('3dml', 'text/vnd.in3d.3dml'),
    ('spot', 'text/vnd.in3d.spot'),
    ('jad', 'text/vnd.sun.j2me.app-descriptor'),
    ('wml', 'text/vnd.wap.wml'),
    ('wmls', 'text/vnd.wap.wmlscript'),
    ('s', 'text/x-asm'),
    ('asm', 'text/x-asm'),
    ('c', 'text/x-c'),
    ('cc', 'text/x-c'),
    ('cxx', 'text/x-c'),
    ('cpp', 'text/x-c'),
    ('h', 'text/x-c'),
    ('hh', 'text/x-c'),
    ('dic', 'text/x-c'),
    ('f', 'text/x-fortran'),
    ('for', 'text/x-fortran'),
    ('f77', 'text/x-fortran'),
    ('f90', 'text/x-fortran'),
    ('java', 'text/x-java-source'),
    ('opml', 'text/x-opml'),
    ('p', 'text/x-pascal'),
    ('pas', 'text/x-pascal'),
    ('nfo', 'text/x-nfo'),
    ('etx', 'text/x-setext'),
    ('sfv', 'text/x-sfv'),
    ('uu', 'text/x-uuencode'),
    ('vcs', 'text/x-vcalendar'),
    ('vcf', 'text/x-vcard'),
    ('3gp', 'video/3gpp'),
    ('3g2', 'video/3gpp2'),
    ('h261', 'video/h261'),
    ('h263', 'video/h263'),
    ('h264', 'video/h264'),
    ('jpgv', 'video/jpeg'),
    ('jpm', 'video/jpm'),
    ('jpgm', 'video/jpm'),
    ('mj2', 'video/mj2'),
    ('mjp2', 'video/mj2'),
    ('mp4', 'video/mp4'),
    ('mp4v', 'video/mp4'),
    ('mpg4', 'video/mp4'),
    ('mpeg', 'video/mpeg'),
    ('mpg', 'video/mpeg'),
    ('mpe', 'video/mpeg'),
    ('m1v', 'video/mpeg'),
    ('m2v', 'video/mpeg'),
    ('ogv', 'video/ogg'),
    ('qt', 'video/quicktime'),
    ('mov', 'video/quicktime'),
    ('uvh', 'video/vnd.dece.hd'),
    ('uvvh', 'video/vnd.dece.hd'),
    ('uvm', 'video/vnd.dece.mobile'),
    ('uvvm', 'video/vnd.dece.mobile'),
    ('uvp', 'video/vnd.dece.pd'),
    ('uvvp', 'video/vnd.dece.pd'),
    ('uvs', 'video/vnd.dece.sd'),
    ('uvvs', 'video/vnd.dece.sd'),
    ('uvv', 'video/vnd.dece.video'),
    ('uvvv', 'video/vnd.dece.video'),
    ('dvb', 'video/vnd.dvb.file'),
    ('fvt', 'video/vnd.fvt'),
    ('mxu', 'video/vnd.mpegurl'),
    ('m4u', 'video/vnd.mpegurl'),
    ('pyv', 'video/vnd.ms-playready.media.pyv'),
    ('uvu', 'video/vnd.uvvu.mp4'),
    ('uvvu', 'video/vnd.uvvu.mp4'),
    ('viv', 'video/vnd.vivo'),
    ('webm', 'video/webm'),
    ('f4v', 'video/x-f4v'),
    ('fli', 'video/x-fli'),
    ('flv', 'video/x-flv'),
    ('m4v', 'video/x-m4v'),
    ('mkv', 'video/x-matroska'),
    ('mk3d', 'video/x-matroska'),
    ('mks', 'video/x-matroska'),
    ('mng', 'video/x-mng'),
    ('asf', 'video/x-ms-asf'),
    ('asx', 'video/x-ms-asf'),
    ('vob', 'video/x-ms-vob'),
    ('wm', 'video/x-ms-wm'),
    ('wmv', 'video/x-ms-wmv'),
    ('wmx', 'video/x-ms-wmx'),
    ('wvx', 'video/x-ms-wvx'),
    ('avi', 'video/x-msvideo'),
    ('movie', 'video/x-sgi-movie'),
    ('smv', 'video/x-smv'),
    ('ice', 'x-conference/x-cooltalk');";
    try {
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
}

function com_install2() {
    
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
    //*******************************   begin check version PHP   **********************************
    $is_warning = false;
    if ((phpversion()) < 5) {
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code>Installation status: <font color="red">fault</font></code> 
                    </td> 
                </tr> 
                <tr> 
                    <td> 
                        <code><font color="red">This component works correctly 
                                    under PHP version 5.0 and higher.</font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 

        <?php
        return '<h2><font color="red">Component installation fault</font></h2>';
    }
    //********************************   end check version PHP   ***********************************
    

 
    //********************************   begin check xsl extension   *******************************
    if (!(class_exists('XsltProcessor'))) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code><font color="red">XSL extension not found! 
                                    In order for csv export to work, 
                                    you need to compile PHP5 with support for the XSL extension!
                        </font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check xsl extension   *********************************
    //********************************   begin check php-xml extension   ***************************
    if (!(class_exists('domDocument'))) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code><font color="red">PHP-XML extension not found! 
                                    In order for xml export to work, 
                                    you need to compile PHP5 with support for the PHP-XML extension
                        !</font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check xsl extension   *********************************
    //********************************   begin check CURL extension   *******************************
    if (!(function_exists('curl_init'))) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code><font color="red">CURL extension not found! 
                                    In order for book cover download to work, 
                                    you need to compile PHP5 with support for the CURL extension!
                        </font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check CURL extension   *********************************
    //********************************   begin check GD extension   *******************************
    if (!(function_exists('imagefontwidth'))) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code><font color="red">GD extension not found! 
                                    In order for CAPTCHA picture works correctly, 
                                    you need to compile PHP5 with support for the GD extension!
                        </font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check GD extension   *********************************
    //*******************************   begin check Yaz component   *******************************
    if (!extension_loaded('yaz')) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code>Installation status: <font color="red">Warning!</font></code> 
                    </td> 
                </tr> 
                <tr> 
                    <td> 
                        <code><font color="red">This component need the PHP YAZ extension 
                                    for fetch books with the z39.50 protocol. 
                                    Please recompile your PHP with the YAZ extension. If you no need this - please ignore.
                        </font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check Yaz component   *******************************
    //*******************************   begin check MB_String component   *******************************
    if (!function_exists('mb_substr')) {
        $is_warning = true;
?> 
        <center> 
            <table width="100%" border="0"> 
                <tr> 
                    <td> 
                        <code>Installation status: <font color="red">fault</font></code> 
                    </td> 
                </tr> 
                <tr> 
                    <td> 
                        <code><font color="red">This component need the PHP MB_String extension 
                                    Please recompile your PHP with the MB_String extension.
                        </font></code> 
                    </td> 
                </tr> 
            </table> 
        </center> 
        <?php
    }
    //********************************   end check MB_String component   *******************************
        //******************** Cheking version+install database**********
    $tableList = $database->getTableList();
    echo 'cheking database<br/>';
    $table_prefix = $database->getPrefix();

    $version = array();
    if (array_search($table_prefix . 'booklibrary_version', $tableList)) {
        $database->setQuery("SELECT * FROM #__booklibrary_version");
        $version = $database->loadAssoc();
    }

    // if (array_search($table_prefix . 'booklibrary', $tableList)) {
    //     $database->setQuery("SELECT * FROM #__booklibrary");
    //     $booklibr = $database->loadResult();
    // } else $booklibr = '';

    $bl_version = explode(' ', $booklibrary_configuration['release']['version']);
    if (count($version) > 0 ) {
        $tmp_ver = explode('.',$version['version'] );
        if(count($tmp_ver) > 1 )   $tmp_ver2 = $tmp_ver[0] . '.' .  $tmp_ver[1] ;
        else $tmp_ver2 = $tmp_ver[0] ;

        switch ($tmp_ver2) {
            case 2:
            case 2.2:
                $query = "ALTER TABLE #__booklibrary_version                
                          MODIFY version varchar(11) NOT NULL";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
        
                $query = "INSERT INTO #__booklibrary_version (`version`,`number`) 
                          VALUES ('$bl_version[0]','$bl_version[1]')";
                $database->setQuery($query);
                $database->execute();                

                $query = "ALTER TABLE #__booklibrary                 
                          ADD COLUMN owner_id int(10) NOT NULL default 0, 
                          ADD FOREIGN KEY (`fk_authors`) REFERENCES #__booklibrary_authors(`id`)";
                try {
                    $database->setQuery($query); 
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                $query = "ALTER TABLE #__booklibrary_main_categories                
                          ADD COLUMN params2  text ";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                $query = "ALTER TABLE #__booklibrary_review 
                          ADD COLUMN published  int(11) default '0'";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                //create table efiles
                $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_files` ( 
                         `id` int(11) unsigned NOT NULL AUTO_INCREMENT, 
                         `fk_book_id` int(11) DEFAULT NULL, 
                         `location` varchar(250) DEFAULT NULL, 
                         `description` varchar(250) DEFAULT NULL, 
                         PRIMARY KEY (`id`), 
                         UNIQUE KEY `id` (`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
                //end
                //*************************add constant and language***********************

                $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_const ( 
                         `id` int(11) unsigned NOT NULL auto_increment, 
                         `const` varchar(250) default '', 
                         `sys_type` varchar(250) default '', 
                         PRIMARY KEY  (`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
                $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_const_languages ( 
                         `id` int(11) unsigned NOT NULL auto_increment, 
                         `fk_constid` int(11) NOT NULL default 0, 
                         `fk_languagesid` int(11) NOT NULL default 0, 
                         `value_const` varchar(2000) default '',                 
                         PRIMARY KEY  (`id`), 
                         UNIQUE (`fk_constid`,`fk_languagesid`), 
                         FOREIGN KEY (`fk_constid`) REFERENCES #__booklibrary_const(`id`), 
                         FOREIGN KEY (`fk_languagesid`) REFERENCES #__booklibrary_languages(`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
                $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_languages ( 
                         `id` int(11) unsigned NOT NULL auto_increment, 
                         `lang_code` char(7), 
                         `title` varchar(250) default '', 
                         `sef` char(7), 
                         PRIMARY KEY  (`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }
                $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_const_languages ( 
                         `id` int(11) unsigned NOT NULL auto_increment, 
                         `fk_constid` int(11) NOT NULL default 0, 
                         `fk_languagesid` int(11) NOT NULL default 0, 
                         `value_const` varchar(2000) default '',                 
                         PRIMARY KEY  (`id`), 
                         UNIQUE (`fk_constid`,`fk_languagesid`), 
                         FOREIGN KEY (`fk_constid`) REFERENCES #__booklibrary_const(`id`), 
                         FOREIGN KEY (`fk_languagesid`) REFERENCES #__booklibrary_languages(`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                AddMimeTypes();
                update_to_version_3_5();
                update_to_version_3_6();
                update_to_version_4_0();
                update_to_version_5_0();
                update_to_version_6_0();
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;                

               break;
            case 3.0:
                $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_files` ( 
                         `id` int(11) unsigned NOT NULL AUTO_INCREMENT, 
                         `fk_book_id` int(11) DEFAULT NULL, 
                         `location` varchar(250) DEFAULT NULL, 
                         `description` varchar(250) DEFAULT NULL, 
                         PRIMARY KEY (`id`), 
                         UNIQUE KEY `id` (`id`) 
                         ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
                try {
                    $database->setQuery($query);
                    $database->execute();
                } catch (RuntimeException $e) {
                    echo $e->getMessage();
                }

                AddMimeTypes();
                update_to_version_3_5();
                update_to_version_3_6();
                update_to_version_4_0();
                update_to_version_5_0();
                update_to_version_6_0();
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;

            case 3.1:
                AddMimeTypes();
                update_to_version_3_5();
                update_to_version_3_6();
                update_to_version_4_0();
                update_to_version_5_0();
                update_to_version_6_0();
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;

            case 3.5:
            case 3.6:
                AddMimeTypes();
                update_to_version_4_0();
                update_to_version_5_0();
                update_to_version_6_0();
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;

            case 4.0:
            case 4.1:
                update_to_version_5_0();
                update_to_version_6_0();
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;
            case 5.0:
            case 5.1:
            case 6.0:
                update_to_version_6_1();
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;

            case 6.1:
                update_to_version_6_2();
                loadConstBooklibrary();
                updateBooklibraryVersion();
                break;
    
            default:
                echo "Updated";
                loadConstBooklibrary();
                break;
                echo 'end upgrading database';
        }
        echo ' database already exist<br/>';
        echo 'version is ';
        print_r($version['version']);



    } elseif (isset($version['version']) and $version['version'] == $bl_version[0]) {
        echo "already updated";
        echo 'version is ';
        print_r($version['version']);
    } else if (isset($version['version']) and $version['version'] != $bl_version[0]) {
        echo "Sanity test, some error in version check";
        echo 'version is ';
        print_r($version['version']);
     
    } else { 
        echo 'install database <br/>';
        
        $query = "DROP TABLES IF EXISTS #__booklibrary, #__booklibrary_main_categories,  
                 #__booklibrary_files,  
                 #__booklibrary_lend, #__booklibrary_lend_request, 
                 #__booklibrary_review, #__booklibrary_suggestion, 
                 #__booklibrary_categories, #__booklibrary_version, 
                 #__booklibrary_mime_types, #__booklibrary_const, 
                 #__booklibrary_authors, #__booklibrary_authors_connect,
                 #__booklibrary_const_languages,#__booklibrary_languages,
                 #__booklibrary_video_source, #__booklibrary_track_source, 
                 #__booklibrary_audio_source, #__booklibrary_users_favorits,
                 #__booklibrary_api, #__booklibrary_sef_urls";

        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_authors_connect ( 
                `id` int(11) NOT NULL auto_increment, 
                `fk_bookid` int(11) DEFAULT NULL, 
                `fk_authorid` int(11) DEFAULT NULL, 
                 FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`), 
                 FOREIGN KEY (`fk_authorid`) REFERENCES #__booklibrary_authors(`id`), 
                 PRIMARY KEY (`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_authors ( 
                  `id` int(11) unsigned NOT NULL auto_increment,     
                  `date` datetime, 
                  `hits` int(11) NOT NULL default '0', 
                  `associate_authors` varchar(255) default null, 
                  `published` tinyint(1) NOT NULL default '0', 
                  `checked_out` int(11) NOT NULL default '0', 
                  `checked_out_time` datetime, 
                  `approved` tinyint(1) NOT NULL default '1', 
                  `authors_name` varchar(200) default '', 
                  `description` text, 
                  `auto_gener_description` text, 
                  `imageURL` varchar(200) default '', 
                  `langshow` varchar(100) default '*', 
                  `owneremail` VARCHAR(50), 
                  `owner_id` int(10) default '0', 
                  `alias` varchar(200) default '', 
                  `birthday` datetime , 
                  `birthplace` varchar(200) default '', 
                  `date_of_death` datetime , 
                  `nationality` varchar(200) default '', 
                  `citizenship` varchar(200) default '', 
                  `language_works` varchar(200) default '', 
                  `occupation` varchar(200) default '', 
                  `years_of_activity` varchar(200) default '', 
                  `direction` varchar(200) default '', 
                  `genre` varchar(200) default '', 
                  `magnum_opus` varchar(200) default '', 
                  `premiums` varchar(200) default '', 
                  `autograph` varchar(200) default '', 
                    metadata TEXT,  
                    publish_up datetime,
                    publish_down datetime,

                  PRIMARY KEY  (`id`) 
                  ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }



        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.', 
                 `bookid` varchar(20) NOT NULL default '0',             
                 `isbn` varchar(20) NOT NULL default '', 
                 `date` datetime  , 
                 `hits` int(11) NOT NULL default '0', 
                 `published` tinyint(1) NOT NULL default '0', 
                 `checked_out` int(11) NOT NULL default '0', 
                 `checked_out_time` datetime , 
                 `ordering` int(11) NOT NULL default '0', 
                 `archived` tinyint(1) NOT NULL default '0', 
                 `approved` tinyint(1) NOT NULL default '1', 
                 `fk_authors` int(11) NOT NULL default '0',  
                 `authors` varchar(200) default '', 
                 `associate_book` varchar(255) default null, 
                 `title` varchar(200) default '', 
                 `imageURL` varchar(200) default '', 
                 `URL` varchar(250) default '', 
                 `rating` int(2) default '0', 
                 `manufacturer` varchar(200) default '', 
                 `comment` TEXT, 
                 `informationFrom` int(11) default '0', 
                 `language` varchar(45) default '', 
                 `langshow` varchar(100) default '*', 
                 `fk_lendid` int(11) default '0', 
                 `release_Date` VARCHAR(45), 
                 `edition` VARCHAR(45), 
                 `featured_clicks` varchar(100) default '', 
                 `featured_shows` varchar(100) default '', 
                 `price` VARCHAR(15), 
                 `user_name` varchar(100) default '', 
                 `priceunit` VARCHAR(6), 
                 `ebookURL` VARCHAR(250),
                 `vm_id_product` int(11) default '0', 
                 `numberOfPages` int(6) default '0', 
                 `owneremail` VARCHAR(50), 
                 `owner_id` int(10) default '0',
				 `id_article_book` int(10), 
				 `flipHTML5` VARCHAR(255),
                 metadata TEXT,  
                 publish_up datetime,
                 publish_down datetime,
                 FOREIGN KEY (`fk_authors`) REFERENCES #__booklibrary_authors(`id`), 
                 FOREIGN KEY (`fk_lendid`) REFERENCES #__booklibrary_lend(`id`), 
                 PRIMARY KEY  (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }


        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_main_categories ( 
                  `id` int(11) NOT NULL AUTO_INCREMENT, 
                  `parent_id` int(11) NOT NULL DEFAULT '0', 
                  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.', 
                  `associate_category` varchar(255) default null, 
                  `title` varchar(255) NOT NULL DEFAULT '', 
                  `name` varchar(255) NOT NULL DEFAULT '', 
                  `alias` varchar(255) NOT NULL DEFAULT '', 
                  `image` varchar(255) NOT NULL DEFAULT '', 
                  `section` varchar(50) NOT NULL DEFAULT '', 
                  `image_position` varchar(30) NOT NULL DEFAULT '', 
                  `description` text , 
                  `published` tinyint(1) NOT NULL DEFAULT '0', 
                  `checked_out` int(11) unsigned NOT NULL DEFAULT '0', 
                  `checked_out_time` datetime , 
                  `editor` varchar(50) DEFAULT NULL, 
                  `ordering` int(11) NOT NULL DEFAULT '0', 
                  `access` tinyint(3) unsigned NOT NULL DEFAULT '0', 
                  `count` int(11) NOT NULL DEFAULT '0', 
                  `params` text, 
                  `params2` text , 
                  `language` varchar(100) NOT NULL DEFAULT '*', 
                  `langshow` varchar(100) NOT NULL DEFAULT '*', 
                     metadata TEXT,  
                     publish_up datetime,
                     publish_down datetime,

                  PRIMARY KEY (`id`), 
                  KEY `cat_idx` (`section`,`published`,`access`), 
                  KEY `idx_access` (`access`), 
                  KEY `idx_checkout` (`checked_out`) 
                 ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=46 ; ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        echo "Creating table for const ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_const ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `const` varchar(250) default '', 
                 `sys_type` varchar(250) default '', 
                 UNIQUE (`const`),
                 PRIMARY KEY  (`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        if (array_search($database->getPrefix() . 
            "booklibrary_const", $database->getTableList(), true)) echo "[Ok]<br />";
        else exit;
        echo "Creating table for languages ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_languages ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `lang_code` char(7), 
                 `title` varchar(250) default '', 
                 `sef` char(7),
                  UNIQUE (`lang_code`),
                 PRIMARY KEY  (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    
        if (array_search($database->getPrefix() . "booklibrary_languages", 
            $database->getTableList(), true)) echo "[Ok]<br />";
        else exit;
        echo "Creating table for const ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_const_languages ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `fk_constid` int(11) NOT NULL default 0, 
                 `fk_languagesid` int(11) NOT NULL default 0, 
                 `value_const` varchar(2000) default '',                 
                 PRIMARY KEY  (`id`), 
                 UNIQUE (`fk_constid`,`fk_languagesid`), 
                 FOREIGN KEY (`fk_constid`) REFERENCES #__booklibrary_const(`id`), 
                 FOREIGN KEY (`fk_languagesid`) REFERENCES #__booklibrary_languages(`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        if (array_search($database->getPrefix() . 
            "booklibrary_const_languages", $database->getTableList(), true)) echo "[Ok]<br />";
        else exit;

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_lend ( 
                  `id` int(11) unsigned NOT NULL auto_increment, 
                  `fk_bookid` int(11) NOT NULL default 0, 
                  `fk_userid` int(11), 
                  `lend_from` datetime , 
                  `lend_until` datetime, 
                  `lend_return` datetime, 
                  `checked_out` int(11) NOT NULL default 0, 
                  `checked_out_time` datetime , 
                  `user_name` varchar(250) default '', 
                  `user_email` varchar(250) default '', 
                  `user_mailing` TEXT, 
                  PRIMARY KEY  (`id`), 
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`), 
                  FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`) 
                  ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_lend_request ( 
                  `id` int(11) unsigned NOT NULL auto_increment, 
                  `fk_bookid` int(11) NOT NULL default 0, 
                  `fk_userid` int(11), 
                  `lend_from` date , 
                  `lend_until` date, 
                  `lend_request` datetime , 
                  `checked_out` int(11) NOT NULL default 0, 
                  `checked_out_time` datetime , 
                  `user_name` varchar(250) default '', 
                  `user_email` varchar(250) default '', 
                  `user_mailing` TEXT, 
                  `status` int(1) default 0, 
                  PRIMARY KEY  (`id`), 
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`), 
                  FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`) 
                  ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_review ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `fk_bookid` int(11) NOT NULL default 0, 
                 `fk_userid` int(11), 
                 `date` datetime , 
                 `rating` int(2) default 0, 
                 `title` varchar(250) default '', 
                 `comment` TEXT, 
                 `published` int(11) NOT NULL default 0, 
                 PRIMARY KEY  (`id`), 
                 FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`), 
                 FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_categories ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `bookid` int(11) NOT NULL default 0, 
                 `catid` int(11), 
                  PRIMARY KEY  (`id`), 
                  FOREIGN KEY (`bookid`) REFERENCES #__booklibrary(`id`), 
                  FOREIGN KEY (`catid`) REFERENCES #__booklibrary_main_categories(`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
 
        $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_files` ( 
                 `id` int(11) unsigned NOT NULL AUTO_INCREMENT, 
                 `fk_book_id` int(11) DEFAULT NULL, 
                 `location` varchar(250) DEFAULT NULL, 
                 `description` varchar(250) DEFAULT NULL, 
                  PRIMARY KEY (`id`), 
                  UNIQUE KEY `id` (`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_version ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `version` varchar(11) NOT NULL default 0, 
                 `number` varchar(11), 
                  PRIMARY KEY  (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_suggestion ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `fk_userid` int(11), 
                 `date` datetime , 
                 `title` varchar(250) default '', 
                 `comment` TEXT, 
                  PRIMARY KEY  (`id`), 
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_mime_types` ( 
                 `mime_ext` text, 
                 `mime_type` text 
                 ) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
            $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_video_source ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `sequence_number` int(11) DEFAULT NULL, 
                 `fk_book_id` int(11) DEFAULT NULL, 
                 `fk_author_id`int(11) DEFAULT NULL, 
                 `src` varchar(255) DEFAULT NULL, 
                 `type` varchar(255) DEFAULT NULL, 
                 `media`varchar(255) DEFAULT NULL, 
                 `youtube`varchar(255) DEFAULT NULL, 
                  FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                  FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                  PRIMARY KEY (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_track_source ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `sequence_number` int(11) DEFAULT NULL, 
                 `fk_book_id` int(11) DEFAULT NULL, 
                 `fk_author_id`int(11) DEFAULT NULL, 
                 `src` varchar(255) DEFAULT NULL, 
                 `kind` varchar(255) DEFAULT NULL, 
                 `scrlang` varchar(255) DEFAULT NULL, 
                 `label` varchar(255) DEFAULT NULL, 
                  FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                  FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                  PRIMARY KEY (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_audio_source ( 
                 `id` int(11) unsigned NOT NULL auto_increment, 
                 `sequence_number` int(11) DEFAULT NULL, 
                 `fk_book_id` int(11) DEFAULT NULL, 
                 `fk_author_id`int(11) DEFAULT NULL, 
                 `src` varchar(255) DEFAULT NULL, 
                 `type`varchar(255) DEFAULT NULL, 
                  FOREIGN KEY (`fk_author_id`) REFERENCES #__booklibrary_authors(`id`), 
                  FOREIGN KEY (`fk_book_id`) REFERENCES #__booklibrary(`id`), 
                  PRIMARY KEY (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
    
        $query = "CREATE TABLE IF NOT EXISTS #__booklibrary_users_favorits ( 
                 `id` int(11) NOT NULL auto_increment, 
                 `fk_bookid` int(11) DEFAULT NULL, 
                 `fk_userid` int(11) DEFAULT NULL, 
                  FOREIGN KEY (`fk_bookid`) REFERENCES #__booklibrary(`id`), 
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`), 
                  PRIMARY KEY (`id`) 
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        $query = "CREATE TABLE IF NOT EXISTS  `#__booklibrary_api` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `service` varchar(255) NOT NULL,
                    `key` text NOT NULL,
                    PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci;";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }



        //echo "Creating table for sef urls... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__booklibrary_sef_urls` (
            `id` int(11) unsigned NOT NULL auto_increment,
            `ser_url_segments` blob,
            `hash_url_segments` varchar(35) NOT NULL default '',
            `ser_vars` blob ,
            `hash_vars` varchar(35) NOT NULL default '',
            `lang` varchar(55) NOT NULL default '',
            `date` datetime ,
            `hits` int(11) NOT NULL default '0',
            `published` tinyint(1) NOT NULL default '1',
            PRIMARY KEY  (`id`),
            INDEX (`hash_url_segments`),
            INDEX (`hash_vars`),
            INDEX (`date`),
            INDEX (`date`,`hits`),
            INDEX (`lang`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARACTER SET utf8 ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }


        AddMimeTypes();
        //******************************************add constant and language***********
        loadConstBooklibrary(); 
        //******************************************end add constant and language*******
        
        
        $vers = explode(' ', $booklibrary_configuration['release']['version']);
        $query = "INSERT INTO #__booklibrary_version (`version`,`number`) 
                  VALUES ('$vers[0]','$vers[1]')";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }

        updateBooklibraryVersion();

        echo "end install <b>database</b> <br />";
    }
    //add simple data
    $database->setQuery("SELECT * 
                         FROM #__booklibrary");
    $booklibrary = $database->loadResult();
    if (!isset($booklibrary)) {
        echo 'install complete 1; ';
        // @mosBooklibraryImportExport::importBooksFullXML($mosConfig_absolute_path . 
        //     "/administrator/components/com_booklibrary/exports/sample_data.xml", null);
        mosBooklibraryImportExport::importBooksFullXML($mosConfig_absolute_path . 
            "/administrator/components/com_booklibrary/exports/sample_data.xml", null);
        echo 'install complete 2;';
        echo "<p>Sample data loaded</p>";
    } else {
        echo "<p>Updated!</p>";
    }
    
    //**************************
    

    $database->setQuery("UPDATE #__menu 
                         SET alias='Users Lend History' 
                         WHERE title 
                         LIKE 'Users Lend%'");
    $database->execute();
    updateBooklibraryConfigurationVersion();
    # Show installation result to user

?> 
    <center> 
        <table width="100%" border="0"> 
            <tr> 
                <td> 
                    <strong>BookLibrary</strong><br/> 
                    <br/> 
                    This component is published under the <a 
                    href="<?php echo $mosConfig_live_site . 
                    "/administrator/components/com_booklibrary/doc/LICENSE.txt"; ?>" 
                     target="new">License</a>. 
                </td> 
            </tr> 
            <tr> 
                <td> 
                    <code>Installation: <font color="green">successful</font></code> 
                </td> 
            </tr> 
        </table> 
    </center> 

    <?php
    if ($is_warning) return '<h2><font color="red">The BookLibrary Component installed with 
                                                   a warning about a missing PHP extension! 
                                                   Please read carefully and uninstall BookLibrary. 
                                                   Next fix your PHP installation and then 
                                                   install BookLibrary again.</font></h2>';
}


