<?php
class com_jcommentsInstallerScript
{
	protected $postInstallUrl = 'index.php?option=com_jcomments&task=postinstall';

	public function __constructor($parent)        {
		return true;
	}

	public function preflight($type, $parent)
	{
		JError::setErrorHandling(E_ALL ^ E_ERROR, 'ignore');
	}

	public function install($parent)
	{
		$app = JFactory::getApplication();
		$app->setUserState('com_installer.message', '');
		$app->setUserState('com_installer.extension_message', '');
		$app->setUserState('com_installer.redirect_url', $this->postInstallUrl);
		$parent->getParent()->set('redirect_url', $this->postInstallUrl);
	}

	public function update($parent)
	{
		self::clearUpdatesCache();
		self::install($parent);
	}

	public function uninstall($parent)
	{
		JError::setErrorHandling(E_ALL ^ E_ERROR, 'ignore');
	}

	public function postflight($type, $parent)
	{
		// update menu items (admin menu)
		$db = JFactory::getDBO();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS', alias='JComments', path='JComments' WHERE client_id = '1' AND link='index.php?option=com_jcomments'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_COMMENTS', alias='Comments', path='JComments/Comments' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=comments'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_SETTINGS', alias='Settings', path='JComments/Settings' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=settings'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_SMILES', alias='Smiles', path='JComments/Smiles' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=smiles'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_SUBSCRIPTIONS', alias='Subscriptions', path='JComments/Subscriptions' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=subscriptions'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_CUSTOM_BBCODE', alias='Custom BBCode', path='JComments/Custom BBCode' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=custombbcodes'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_BLACKLIST', alias='Blacklist', path='JComments/Blacklist' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=blacklist'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_IMPORT', alias='Import', path='JComments/Import' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=import'");
		$db->execute();
		$db->setQuery("UPDATE `#__menu` SET title='COM_JCOMMENTS_ABOUT', alias='About JComments', path='JComments/About JComments' WHERE client_id = '1' AND link='index.php?option=com_jcomments&task=about'");
		$db->execute();

		// small hack to allow correct JComments update
		$task = JFactory::getApplication()->input->get('task', '');
		if ($task == 'update' || $task == 'update.update') {
			self::clearUpdatesCache();

			$app = JFactory::getApplication();
			$app->setRedirect($this->postInstallUrl);
			$app->redirect();
		}
	}

	public function clearUpdatesCache()
	{
		$db = JFactory::getDBO();
		$db->setQuery('TRUNCATE TABLE #__updates');
		$db->execute();
	}
}

?>