<?php
/**
 * @package         Cache Cleaner
 * @version         9.7.5
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Module\CacheCleaner\Administrator\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use RegularLabs\Library\Parameters as RL_Parameters;
use RegularLabs\Module\CacheCleaner\Administrator\Helper\CacheCleaner as CacheCleanerHelper;

defined('_JEXEC') or die;

class Dispatcher extends AbstractModuleDispatcher
{
    public function dispatch()
    {
        parent::dispatch();

        $params = RL_Parameters::getPlugin('cachecleaner');

        if ( ! $params->display_statusbar_button && ! $params->display_toolbar_button)
        {
            return;
        }

        CacheCleanerHelper::addScriptsAndStyles();

        if ($params->display_toolbar_button)
        {
            CacheCleanerHelper::addToolbarButton();
        }
    }

    protected function getLayoutData()
    {
        $params = RL_Parameters::getPlugin('cachecleaner');

        if ( ! $params->display_statusbar_button)
        {
            return false;
        }

        return parent::getLayoutData();
    }
}
