<?php
/**
 *
 * @package BookLibrary
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 * @version: 6.0 BookLibrary Pro
 *
 */
if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . 
    basename(__FILE__) . ' is not allowed.');

class BookLibraryHelperRoute {

  /**
   * Tries to load the router for the component and calls it. Otherwise calls getRoute.
   *
   * @param   integer  $id  The ID of the book
   *
   * @return  string  URL link to pass to the router
   *
   */
  public static function getBookRoute($id,$catid)
  {
    $needles = array(
      'book'  => array((int) $id)
    );

    if ($id < 1)
    {
      $link = '';
    }
    else
    {
      $link = 'index.php?option=com_booklibrary&view=view_bl&id=' . $id."&catid=".$catid;

      if ($item = self::_findItem($needles))
      {
        $link .= '&Itemid=' . $item;
      }
      else
      {
        $needles = array('booklibrary' => array(1, 0));

        if ($item = self::_findItem($needles))
        {
          $link .= '&Itemid=' . $item;
        }
      }
    }

    return $link;
  }


    protected static $lookup = array();
    protected static $lang_lookup = array();

    public static function getAuthorAssocRoute($id, $task) {
        $database = JFactory::getDBO();
        $link = array();
        $bookIdArr = array();
        $associate_author = array();

                //----------------------------
        $arr_params =  array() ;
        $arr_params['task'] = $task;
        $arr_params['id'] = $id;
        $link_params = BookLibraryHelperRoute::getBLOtherRoute($arr_params);
         // print_r($link_params);exit;
        //----------------------------


        if (isset($id)) {
            $query = "SELECT associate_authors
                      FROM #__booklibrary_authors 
                      WHERE id = $id";
            $database->setQuery($query);
            $associate_aut = $database->loadResult();
            if ($associate_aut != "") $associate_author = unserialize($associate_aut);
            if (count($associate_author) > 0) {
                foreach($associate_author as $oneAuthor) {
                    if ($oneAuthor != 0) {
                        $AuthorIdArr[] = $oneAuthor;
                    }
                }
                $AuthorIdArr = implode(',', $AuthorIdArr);
                $query = "SELECT id, langshow
                             FROM #__booklibrary_authors  
                             WHERE id in ($AuthorIdArr)";
                $database->setQuery($query);
                $assocAuthor = $database->loadAssocList();
                foreach($assocAuthor as $value) {
                    $lang = $value['langshow'];
                    $CurId = $value['id'];
                    $link[$lang] = "index.php?option=com_booklibrary&task=view_author&id=$CurId";
                    
                    $needles = array();
                    $needles['view'] = 'view_author';
                    $app    = JFactory::getApplication();
                    $menus    = $app->getMenu('site');
                    $active = $menus->getActive();
                    if(isset($active) && isset($active->query['view_author']))
                     $needles[$active->query['view_author']] = $active->query['view_author'];
                    
                    if ($lang != "*" && JLanguageMultilang::isEnabled()) {
                        self::buildLanguageLookup();
                        if (isset(self::$lang_lookup[$lang])) {
                            $link[$lang].= '&lang=' . self::$lang_lookup[$lang];
                            $needles['language'] = $lang;
                        }
                    }

                    if ($item = self::_findItem($needles)) {
                        $link[$lang].= '&Itemid=' . $item;
                    }
                }
            }
        }
        foreach ($link_params as $key => $value) {
          if (!array_key_exists($key, $link)) {
            $link[$key] = $value;
          }
        }

        return $link;
    }
    
    public static function getBookAssocRoute($id, $task, $catid) {
        // print_r($task);exit;
        $database = JFactory::getDBO();
        $link = array();
        $bookIdArr = array();
        $associate_book = array();

        //----------------------------
        $arr_params =  array() ;
        $arr_params['task'] = $task;
        $arr_params['id'] = $id;
        $arr_params['catid'] = $catid;
        $link_params = BookLibraryHelperRoute::getBLOtherRoute($arr_params);
         // print_r($link_params);exit;
        //----------------------------

        if (isset($id)) {
            $query = "SELECT associate_book 
                      FROM #__booklibrary 
                      WHERE id = $id";
            $database->setQuery($query);
            $associate_bk = $database->loadResult();
            if ($associate_bk != "") $associate_book = unserialize($associate_bk);
            if (count($associate_book) > 0) {
                foreach($associate_book as $oneBook) {
                    if ($oneBook != 0) {
                        $bookIdArr[] = $oneBook;
                    }
                }
                $bookIdArr = implode(',', $bookIdArr);
                $query = "SELECT id, langshow
                          FROM #__booklibrary  
                          WHERE id in ( $bookIdArr )";
                $database->setQuery($query);
                $assocBook = $database->loadAssocList();
                foreach($assocBook as $value) {
                    $lang = $value['langshow'];
                    //print_r("<br> ->" . $lang);
                    $CurId = $value['id'];
                    if (isset($assocBook)) {
                        $query = "SELECT catid
                                  FROM #__booklibrary_categories  
                                  WHERE bookid = $CurId";
                        $database->setQuery($query);
                        $assocBookCat = $database->loadResult();

                       // print_r("<br> catid -> " . $assocBookCat);exit;
                    }
                    $link[$lang] = "index.php?option=com_booklibrary&task=view&catid=$assocBookCat&id=$CurId";

                   // print_r("<br> link ->" . $lang);
                    
                    $needles = array();
                    $needles['view'] = 'view';
                    $app    = JFactory::getApplication();
                    $menus    = $app->getMenu('site');
                    $active = $menus->getActive();
                    if(isset($active)){
                      $needles[$active->query['view']] = $active->query['view'];
                    }
                    
                    if ($lang != "*" && JLanguageMultilang::isEnabled()) {
                        self::buildLanguageLookup();
                        //print_r("2134235" . $lang_lookup[$lang]);exit;
                        if (isset(self::$lang_lookup[$lang])) {
                            $link[$lang].= '&lang=' . self::$lang_lookup[$lang];
                            $needles['language'] = $lang;
                        }
                    }
                    if ($item = self::_findItem($needles)) {
                        $link[$lang].= '&Itemid=' . $item;
                    }
                }
            }
        }
        foreach ($link_params as $key => $value) {
          if (!array_key_exists($key, $link)) {
            $link[$key] = $value;
          }
        }
        // print_r($link);exit;
        return $link;
    }



    public static function getBookCategoryRoute($catid) {

        $database = JFactory::getDBO();
        $link = array();
        $catIdArr = array();
        $assos_ids = array();
        //----------------------------
        $arr_params =  array() ;
        $arr_params['task'] = 'showCategory' ;
        $arr_params['catid'] = $catid ;
        $link_params = BookLibraryHelperRoute::getBLOtherRoute($arr_params);
        // print_r($link_params);exit;
        //----------------------------

        if (isset($catid)) {
            $query = "SELECT associate_category 
                      FROM #__booklibrary_main_categories 
                      WHERE id = $catid";
            $database->setQuery($query);
            $ids = $database->loadResult();
            if ($ids != "") $assos_ids = unserialize($ids);
            if (count($assos_ids) > 0) {
                foreach($assos_ids as $oneCat) {
                    if ($oneCat != 0) {
                        $catIdArr[] = $oneCat;
                    }
                }
                $catIdStr = implode(',', $catIdArr);
                $query = "SELECT id, language
                          FROM #__booklibrary_main_categories  
                          WHERE id in ($catIdStr)";
                $database->setQuery($query);
                $assocCategory = $database->loadAssocList();
                foreach($assocCategory as $value) {
                    
                    $lang = $value['language'];
                    $CurId = $value['id'];
                    $link[$lang] = "index.php?option=com_booklibrary&task=showCategory&catid=$CurId";
                    
                    $needles['showCategory'] = 'showCategory';
                    $app    = JFactory::getApplication();
                    $menus    = $app->getMenu('site');
                    $active = $menus->getActive();
                    if(isset($active)){
                      $needles[$active->query['view']] = $active->query['view'];
                    }
                    
                    if ($lang != "*" && JLanguageMultilang::isEnabled()) {
                        self::buildLanguageLookup();
                        if (isset(self::$lang_lookup[$lang])) {
                            $link[$lang].= '&lang=' . self::$lang_lookup[$lang];
                            $needles['language'] = $lang;
                        }
                    }
                    if ($item = self::_findItem($needles)) {
                        $link[$lang].= '&Itemid=' . $item;
                    }
                } 
            } 
        }

        foreach ($link_params as $key => $value) {
          if (!array_key_exists($key, $link)) {
            $link[$key] = $value;
          }
        }

        //print_r($link);exit;
        return $link;
    }

    protected static function buildLanguageLookup() {
        if (count(self::$lang_lookup) == 0) {
            $db = JFactory::getDbo();
            $query = $db->getQuery(true)->select('a.sef AS sef')->select('a.lang_code 
                AS lang_code')->from('#__languages AS a');
            $db->setQuery($query);
            $langs = $db->loadObjectList();
            foreach($langs as $lang) {
                self::$lang_lookup[$lang->lang_code] = $lang->sef;

            }
        }
    }

        public static function getBLOtherRoute ($arr_params) {
        $link = array();
        $needles = array();
        foreach ($arr_params as $key => $value) {
          $needles[$key] = $value;
        }
        $app    = JFactory::getApplication();
        $menus    = $app->getMenu('site');
        $active = $menus->getActive();
        if(isset($active) && isset($active->query['layout']) )
          $needles[$active->query['layout']] = $active->query['layout'];

        self::buildLanguageLookup();
        foreach(self::$lang_lookup AS $lang =>$lang_value ){
          $link[$lang] = "index.php?option=com_booklibrary" ;
          foreach ($arr_params as $key => $value) {
            $link[$lang] .= "&".$key ."=".$value;
          }
          if ( JLanguageMultilang::isEnabled()) {
              if (isset(self::$lang_lookup[$lang])) {
                  $link[$lang].= '&lang=' . self::$lang_lookup[$lang];
                  $needles['language'] = $lang;
              }
          }
          if ($item = self::_findItem($needles)) {
              $link[$lang].= '&Itemid=' . $item;
          }
        }

        return $link;
    }

    
    protected static function _findItem($needles = null){

    $app      = JFactory::getApplication();
    $menus    = $app->getMenu('site');
    $language = isset($needles['language']) ? $needles['language'] : '*';


    $active = $menus->getActive();
    //get associated menus 
    if(isset($active) && JLanguageAssociations::isEnabled() ) {
      $menu_associations = JLanguageAssociations::getAssociations('com_menu', '#__menu', 'com_menus.item', $active->id , 'id','','') ;

      if($language != "" && $language != "*" &&  array_key_exists($language, $menu_associations) )
       return $menu_associations[$language]->id ;
    } 

    // Prepare the reverse lookup array.
    if (!isset(self::$lookup[$language]))
    {
      self::$lookup[$language] = array();

      $component  = JComponentHelper::getComponent('com_booklibrary');

      $attributes = array('component_id');
      $values     = array($component->id);

      if ($language != '*')
      {
        $attributes[] = 'language';
        $values[]     = array($needles['language'], '*');
      }

      $items = $menus->getItems($attributes, $values);

      foreach ($items as $item)
      {
        if (isset($item->query) && (isset($item->query['view']) || isset($item->query['task'] ) ) )
        {
          if ( isset($item->query['view'] ) )  $view = $item->query['view'];
          else $view = $item->query['task'];

          if (!isset(self::$lookup[$language][$view]))
          {
            self::$lookup[$language][$view] = array();
          }

          if (isset($item->id))
          {
            /**
             * Here it will become a bit tricky
             * language != * can override existing entries
             * language == * cannot override existing entries
             */
            if (!isset(self::$lookup[$language][$view][$item->id]) || $item->language != '*')
            {
              self::$lookup[$language][$view][$item->id] = $item->id;
            }
          }
        }
      }
    }
    //check item with exectly view
    if ($needles)
    {
      foreach ($needles as $view => $ids)
      {
        if (isset(self::$lookup[$language][$view]))
        {

          foreach (self::$lookup[$language][$view] as $id)
          {
            if (isset(self::$lookup[$language][$view][(int) $id]))
            {
              return self::$lookup[$language][$view][(int) $id];
            }
          }
        }
      }
    }
    //check any item from our component
    if ($needles)
    {
      foreach (self::$lookup[$language] as $view => $ids)
      {
        if (isset(self::$lookup[$language][$view]))
        {
          foreach (self::$lookup[$language][$view] as $id)
          {
            if (isset(self::$lookup[$language][$view][(int) $id]))
            {
              return self::$lookup[$language][$view][(int) $id];
            }
          }
        }
      }
    }
    // Check if the active menuitem matches the requested language
    $active = $menus->getActive();
    if ($active && $active->component == 'com_booklibrary' &&
      ($language == '*' || in_array($active->language, array('*', $language)) || 
        !JLanguageMultilang::isEnabled()))
    {
      return $active->id;
    }
    // If not found, return language specific home link
    $default = $menus->getDefault($language);
    return !empty($default->id) ? $default->id : null;
  }
}
