<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:atom="http://www.w3.org/2005/Atom" xmlns:dc="http://purl.org/dc/elements/1.1/" version="1.0">  
<xsl:output method="xml"/>
<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
<meta charset="UTF-8"/>
<meta name="viewport" content="width=device-width"/>
<title><xsl:value-of select="rss/channel/link/a"/></title>
<style><![CDATA[html{margin:0;pdding:0;background:#eaeaea}body{position:relative;border-radius:4px;-webkit-box-shadow:1px 1px 12px rgba(150,150,150,1);box-shadow:1px 1px 12px rgba(150,150,150,1);background:#fff;color:#1f7e7e;font-family:Helvetica,Arial,sans-serif;font-size:17px;line-height:1.4;margin:2% auto;max-width:38rem;padding:1rem 3rem}input{min-width:20rem;margin-left:.2rem;padding-left:.2rem;padding-right:.2rem}ol{list-style-type:none;padding-left:0}h2{font-size:22px;font-weight:inherit}a{color:#4570ea;text-decoration:none}h1{border-bottom:1px solid #999;padding-bottom:2rem}ol li{border-bottom:1px solid #999;margin-bottom:2rem;padding-bottom:1rem}h1{border-bottom:1px solid #999}h3{margin:40px 0 0}ol li p{margin-top:0}html:before{display:block;content:"";position:absolute;width:100%;height:10rem;left:0;right:0;top:0;background:rgba(179,220,237,1);background:-moz-linear-gradient(top,rgba(179,220,237,1) 0,#4570ea 0,rgba(234,234,234,1) 100%);background:-webkit-gradient(left top,left bottom,color-stop(0,rgba(179,220,237,1)),color-stop(0,#4570ea),color-stop(100%,rgba(234,234,234,1)));background:-webkit-linear-gradient(top,rgba(179,220,237,1) 0,rgba(41,184,229,1) 0,rgba(234,234,234,1) 100%);background:-o-linear-gradient(top,rgba(179,220,237,1) 0,#4570ea 0,rgba(234,234,234,1) 100%);background:-ms-linear-gradient(top,rgba(179,220,237,1) 0,#4570ea 0,rgba(234,234,234,1) 100%);background:linear-gradient(to bottom,rgba(179,220,237,1) 0,#4570ea 0,rgba(234,234,234,1) 100%);filter:progid:DXImageTransform.Microsoft.gradient( startColorstr='#b3dced', endColorstr='#eaeaea', GradientType=0 );}}}]]></style>

<xsl:if test="system-property('xsl:vendor')='Transformiix'">
    <!-- Mozilla ignores disable-output-escaping -->
    <script type="text/javascript">
      function onload_cb() {
          var elements = document.getElementsByTagName('p');
          for (var i = 0; i &lt; elements.length; i++) {
              var el = elements[i];
              if (el.className == 'description') {
                el.innerHTML = el.firstChild.data;
              }
          }
      }
    </script>
</xsl:if>

</head>

<body>
  
  <xsl:if test="system-property('xsl:vendor')='Transformiix'">
    <xsl:attribute name="onload">onload_cb()</xsl:attribute>
  </xsl:if>
  
  <h1><xsl:value-of select="rss/channel/link/a"/></h1>
  <!-- <p>This is an <abbr title="Really Simple Syndication">RSS</abbr> feed. To subscribe to it, copy its address and paste it when your feed reader asks for it. It will be updated periodically in your reader. New to feeds? <a href="https://duckduckgo.com/?q=how+to+get+started+with+rss+feeds" title="Search on the web to learn more">Learn more</a>.</p> -->
  <ol>
    <xsl:for-each select="rss/channel/item">
      <li>
        <h3>
          <a>
            <xsl:attribute name="href"><xsl:value-of select="link"/></xsl:attribute>
            <xsl:value-of select="title"/>
          </a>
        </h3>
        <p class="description">
          <xsl:value-of select="description" disable-output-escaping="yes" />
        </p>
      </li>
    </xsl:for-each>
  </ol>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
