<?php
// ensure this file is being included by a parent file
(defined('_VALID_MOS') OR defined('_JEXEC')) or die('Direct Access to this location is not allowed.');
/*
*
* Comment item template. Repesents one comment item. Results of rendering used in tpl_list.php
*
* Шаблон отображения комментария.
*
* Результат обработки данного шаблона используется позже для наполнения списка.
* Таким образом, если необходимо изменить внешний вид самого комментария
* (например, отображение имени автора), то менять надо этот шаблон.
* Иначе - шаблон списка (tpl_list.php) или шаблон дерева (tpl_tree.php).
*
* А вообще, довольно многого можно добиться посредством CSS ;)
*
*/
class jtt_tpl_comment extends JoomlaTuneTemplate
{
	function render()
	{
		$comment = $this->getVar('comment');

		if (isset($comment)) {
			if ($this->getVar('get_comment_vote', 0) == 1) {
				// return comment vote
				$this->getCommentVoteValue( $comment );
			} else if ($this->getVar('get_comment_body', 0) == 1) {
				// return only comment body (for example after quick edit)
				echo $comment->comment;
			}
			else
			{
				// return all comment item
?>
<div class="post">
	<div class="inner"><span class="corners-top"><span></span></span>
	<div class="postbody">
<?php
	// show frontend moderation panel
	$this->getCommentAdministratorPanel($comment);
	
	$comment_number = $this->getVar('comment-number', 1);
	$thisurl = $this->getVar('thisurl', '');
	
	if (($this->getVar('comment-show-title') > 0) && ($comment->title != ''))
	{
?>
		<h3><a href="<?php echo $thisurl; ?>#comment-<?php echo $comment->id; ?>"><?php echo $comment->title; ?></a></h3>
<?php
	} else {
		echo '<h3></h3>'."\n";
	}
?>
		<p class="author">
			<a href="<?php echo $thisurl; ?>#comment-<?php echo $comment->id; ?>" id="comment-<?php echo $comment->id; ?>" title="#<?php echo $comment_number ?>" ><img src="<?php echo $this->getVar('siteurl').'/components/com_jcomments/tpl/'.$this->getVar('template').'/images/jc_target.gif'; ?>" alt="#<?php echo $comment_number ?>" /></a>
			<strong><?php echo $comment->author; ?></strong>
			&raquo;
			<?php echo JCommentsText::formatDate($comment->datetime, JText::_('DATETIME_FORMAT')); ?>
		</p>
		<div class="content" id="comment-body-<?php echo $comment->id; ?>"><?php echo $comment->comment; ?></div>
	</div>
	
	<dl class="postprofile">
<?php
if ($this->getVar('comment-show-vote', 0) == 1) {
	$this->getCommentVote( $comment );
}
?>
		<dt>
			<?php if ($this->getVar('avatar') == 1) { echo $comment->avatar; } ?><br />
			<strong><?php echo $comment->author; ?></strong>
		</dt>
<?php if (($this->getVar('comment-show-email') == 1) || ($this->getVar('comment-show-homepage') == 1)) { ?>
		<dd>
			<ul class="profile-icons">
<?php if ($this->getVar('comment-show-email') == 1) { ?>
				<li class="email-icon"><a href="mailto:<?php echo $comment->email; ?>" title="<?php echo 'e-mail: '.$comment->email; ?>"><img src="<?php echo $this->getVar('siteurl').'/components/com_jcomments/tpl/'.$this->getVar('template').'/images/jc_email.gif'; ?>" alt="@" title="<?php echo 'e-mail: '.$comment->email; ?>" /></a></li>
<?php } ?>
<?php if ($this->getVar('comment-show-homepage') == 1) { ?>
				<li class="web-icon"><a href="<?php echo $comment->homepage; ?>" rel="nofollow" title="<?php echo 'WWW: '.$comment->homepage; ?>"><img src="<?php echo $this->getVar('siteurl').'/components/com_jcomments/tpl/'.$this->getVar('template').'/images/jc_www.gif'; ?>" alt="WWW"  title="<?php echo 'WWW: '.$comment->homepage; ?>" /></a></li>
<?php } ?>
			</ul>
		</dd>
<?php } ?>
	</dl>
	<span class="corners-bottom"><span></span></span></div>
</div>
<hr class="divider" />
<?php
			}
		}
	}

	/*
	*
	* Displays comment's administration panel
	*
	* Отображает панель управления комментарием. Данная панель содержит кнопки
	* для редактирования, удаления и публикации комментария. Если каких-то кнопок
	* не видно - значит у пользователя отсутствую права на эти функции.
	*
	*/
	function getCommentAdministratorPanel( &$comment )
	{
		if ($this->getVar('comments-panel-visible', 0) == 1)
		{
			$imagesPath = $this->getVar('siteurl').'/components/com_jcomments/tpl/'.$this->getVar('template').'/images';
?>
<ul class="profile-icons" id="comment-toolbar-<?php echo $comment->id; ?>">
<?php
if ($this->getVar('button-edit') == 1) { ?>
	<li class="edit-icon"><img src="<?php echo $imagesPath.'/jc_edit.gif'; ?>" onclick="jcomments.editComment(<?php echo $comment->id; ?>);" alt="<?php echo JText::_('EDIT'); ?>" title="<?php echo JText::_('EDIT'); ?>" /></li>
<?php
}

if ($this->getVar('button-delete') == 1) { ?>
	<li class="delete-icon"><img src="<?php echo $imagesPath.'/jc_delete.gif'; ?>" onclick="if (confirm('<?php echo JText::_('CONFIRM_DELETE'); ?>')){jcomments.deleteComment(<?php echo $comment->id; ?>);}" alt="<?php echo JText::_('DELETE'); ?>" title="<?php echo JText::_('DELETE'); ?>" /></li>
<?php
}

if ($this->getVar('button-publish') == 1) {
	$text = $comment->published ? JText::_('UNPUBLISH') : JText::_('PUBLISH');
	$image = $comment->published ? $imagesPath.'/jc_publish.gif' : $imagesPath.'/jc_unpublish.gif';
?>
	<li class="report-icon"><img src="<?php echo $image; ?>" onclick="jcomments.publishComment(<?php echo $comment->id; ?>);" alt="<?php echo $text; ?>" title="<?php echo $text; ?>" /></li>
<?php
}

if ($this->getVar('button-ip') == 1) {
?>
	<li class="info-icon"><img src="<?php echo $image = $imagesPath.'/jc_ip.gif'; ?>" onclick="jcomments.go('http://www.ripe.net/perl/whois?searchtext=<?php echo $comment->ip; ?>');" alt="<?php echo JText::_('IP').' '.$comment->ip; ?>" title="<?php echo JText::_('IP').' '.$comment->ip; ?>" /></li>
<?php
}

if (($this->getVar('button-reply') == 1) || ($this->getVar('button-quote') == 1))
{
	if ($this->getVar('button-reply') == 1) {
?>
	<li class="reply-icon"><img src="<?php echo $imagesPath.'/jc_reply.gif'; ?>" onclick="jcomments.showReply(<?php echo $comment->id; ?>); return false;" alt="<?php echo JText::_('Reply'); ?>" title="<?php echo JText::_('Reply'); ?>" /></li>
<?php
	}
	if ($this->getVar('button-quote') == 1) {
?>
	<li class="reply-quote-icon"><img src="<?php echo $imagesPath.'/jc_reply_quote.gif'; ?>" onclick="jcomments.showReply(<?php echo $comment->id; ?>, 1); return false;" alt="<?php echo JText::_('Reply with quote'); ?>" title="<?php echo JText::_('Reply with quote'); ?>" /></li>
<?php
	}
}

if ($this->getVar('button-quote') == 1) {
?>
	<li class="quote-icon"><img src="<?php echo $imagesPath.'/jc_quote.gif'; ?>" onclick="jcomments.quoteComment(<?php echo $comment->id; ?>); return false;" alt="<?php echo JText::_('Quote'); ?>" title="<?php echo JText::_('Quote'); ?>" /></li>
<?php
}
?>
</ul>
<?php
		}
	}
	
	
	function getCommentVote( &$comment )
	{
		$imagesPath = $this->getVar('siteurl').'/components/com_jcomments/tpl/'.$this->getVar('template').'/images';
		$value = intval($comment->isgood) - intval($comment->ispoor);

		if ($value == 0 && $this->getVar('button-vote', 0) == 0) {
			return;
		}
?>
	<dd class="vote-icons">
	<span id="comment-vote-holder-<?php echo $comment->id; ?>">
<?php
		echo $this->getCommentVoteValue( $comment );
		if ($this->getVar('button-vote', 0) == 1)
		{
?>
		<img src="<?php echo $imagesPath.'/jc_vote_good.gif'; ?>" alt="+" title="<?php echo JText::_('VOTE_GOOD'); ?>" onclick="jcomments.voteComment(<?php echo $comment->id;?>, 1); return false;" /><img src="<?php echo $imagesPath.'/jc_vote_poor.gif'; ?>" alt="&minus;" title="<?php echo JText::_('VOTE_POOR'); ?>" onclick="jcomments.voteComment(<?php echo $comment->id;?>, -1); return false;" />
<?php
		}
?>
	</span>
	</dd>
<?php
	}

	function getCommentVoteValue( &$comment )
	{
		$value = intval($comment->isgood - $comment->ispoor);

		if ($value == 0 && $this->getVar('button-vote', 0) == 0 && $this->getVar('get_comment_vote', 0) == 0) {
			// if current value is 0 and user has no rights to vote - hide 0
			return;
		}

		if ($value < 0) {
			$class = 'poor';
			$value = '&minus;'.abs($value);
		} else if ($value > 0) {
			$class = 'good';
			$value = '+' . $value;
		} else {
			$class = 'none';
		}
?>
<span class="vote-<?php echo $class; ?>"><?php echo $value; ?></span>
<?php
	}
}
?>