<?php
// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/mappings.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/groups.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/users.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/shop.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/points.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/mailinglist.php');

require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/joomlagroups.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_joomdle/helpers/forum.php');


    function getUserInfo($method, $params)
    {
		$username = $params[0];
		if (array_key_exists (1, $params))
			$app = $params[1];
		else $app = '';
        $user_info = JoomdleHelperMappings::get_user_info ($params[0], $app);
        return $user_info;
    }

	function test ()
	{
		return "It works";
	}

    /* Web service used to log in from Moodle */
    function login ($method, $params)
    {
		$username = $params[0];
		$password = $params[1];

        $mainframe =& JFactory::getApplication('site');

        $options = array ( 'skip_joomdlehooks' => '1', 'silent' => 1);
        $credentials = array ( 'username' => $username, 'password' => $password);
        if ($mainframe->login( $credentials, $options ))
            return true;
        return false;
	}

	function getDefaultItemid ()
    {
        $comp_params = JComponentHelper::getParams( 'com_joomdle' );
        $default_itemid = $comp_params->get( 'default_itemid' );
        return $default_itemid;
    }


  function confirmJoomlaSession($method, $params)
    {
		$username = $params[0];
		$token = $params[1];

        $db = &JFactory::getDBO();
        $query = 'SELECT session_id' .
                ' FROM #__session' .
                " WHERE username = ". $db->Quote($username). " and  md5(session_id) = ". $db->Quote($token);
        $db->setQuery( $query );
 //       $sessions = $db->loadObjectList();
        $session = $db->loadResult();


		if ($session)
			return true;
		else
			return false;
    }

	function logout($method, $params)
    {
		$username = $params[0];

        $mainframe =& JFactory::getApplication('site');

        $id = JUserHelper::getUserId($username);

        $error = $mainframe->logout($id, array ( 'clientid' => 0, 'skip_joomdlehooks' => 1));

        $r = JApplication::getHash('JLOGIN_REMEMBER');
        return $r;
    }

	function createUser ($method, $params)
    {
		$user_info = $params[0];
        return JoomdleHelperUsers::create_joomla_user ($user_info);
//        return JoomdleHelperMappings::save_user_info ($user_info);
    }

    function activateJoomlaUser ($method, $params)
    {
		$username = $params[0];

        $username = utf8_decode ($username);

        return JoomdleHelperUsers::activate_joomla_user ($username);
    }

    function updateUser ($method, $params)
    {
		$user_info = $params[0];
        return JoomdleHelperMappings::save_user_info ($user_info, false);
    }

    function changePassword ($method, $params)
    {
		$username = $params[0];
		$password = $params[1];

        $username = utf8_decode ($username);

		$user_id = JUserHelper::getUserId($username);
        $user =& JFactory::getUser($user_id);


        $salt           = JUserHelper::genRandomPassword(32);
		$crypt          = JUserHelper::getCryptedPassword($password, $salt);
        $password_crypt       = $crypt.':'.$salt;

        $user->password = $password_crypt;
        @$user->save();

        return true;
    }

	function deleteUser ($method, $params)
    {
		$username = $params[0];
        $username = utf8_decode ($username);

        $user_id = JUserHelper::getUserId($username);
        $user =& JFactory::getUser($user_id);
        $user->delete();
    }


	function addActivityCourse ($method, $params)
    {
		$id = $params[0];
		$name = $params[1];
		$desc = $params[2];
		$cat_id = $params[3];
		$cat_name = $params[4];
        require_once( JPATH_ROOT . '/components/com_community/libraries/core.php' );

        CFactory::load ( 'libraries', 'activities' );

        $cat_slug = JFilterOutput::stringURLSafe ($cat_name);
        $course_slug = JFilterOutput::stringURLSafe ($name);

    //  $cat_name = utf8_encode ($cat_name);
        $mainframe =& JFactory::getApplication('site');
        $mainframe->initialise();

        /* Kludge para que no pete el call_method */
        if ($desc == ' ')
            $desc = '';

        $user_id = JoomdleHelperSystem::get_admin_id ();

        /* It seems JS re-encodes this or something ... */
//        $name = utf8_decode ($name);
 //       $desc = utf8_decode ($desc);
  //      $cat_name = utf8_decode ($cat_name);

        $act = new stdClass();

       // $message                = JText::_('New course available').' ';
        $message                = JText :: _ ('COM_JOOMDLE_NEW_COURSE_AVAILABLE'). '';

        $link = ("index.php?option=com_joomdle&view=detail&cat_id=$cat_id:$cat_slug&course_id=$id:$course_slug");
        $message                .= ' <a href="' . $link .'">' . $name . '</a> ';

        $cat_link = ("index.php?option=com_joomdle&view=coursecategory&cat_id=$cat_id:$cat_slug");
        $message                .= JText::_('COM_JOOMDLE_IN_CATEGORY')." ";
        $message                .= ' <a href="' . $cat_link .'">' . $cat_name . '</a> ';

        $act->cmd               = 'joomdle.create';
        $act->actor     = $user_id;
        $act->access     = 0;
        $act->target    = 0;
        $act->title             = JText::_( $message );
        $act->content   = $desc;
        $act->app               = 'joomdle';
        $act->cid               = 0;
        CActivityStream::add( $act );

        return "OK";
    }

	function addActivityCourseEnrolment ($method, $params)
    {
		$username = $params[0];
		$course_id = $params[1];
		$course_name = $params[2];
		$cat_id = $params[3];
		$cat_name = $params[4];

        require_once( JPATH_ROOT . '/components/com_community/libraries/core.php' );

        CFactory::load ( 'libraries', 'activities' );

        $course_slug = JFilterOutput::stringURLSafe ($course_name);

        $cat_slug = JFilterOutput::stringURLSafe ($cat_name);

        $user_id = JUserHelper::getUserId($username);

        $mainframe =& JFactory::getApplication('site');
        $mainframe->initialise();

        $act = new stdClass();

//        $username = utf8_decode ($username);
 //       $course_name = utf8_decode ($course_name);
 //       $cat_name = utf8_decode ($cat_name);

       //$message                = JText::_('{actor} enroled into the course').' ';
		$message                = JText::_('COM_JOOMDLE_USER_ENROLED_INTO_THE_COURSE').' ';


        $link = ("index.php?option=com_joomdle&view=detail&cat_id=$cat_id:$cat_slug&course_id=$course_id:$course_slug");
        $message                .= ' <a href="' . $link .'">' . $course_name . '</a> ';

        $act->cmd               = 'joomdle.enrolment';
        $act->actor     = $user_id;
        $act->access     = 0;
        $act->target    = 0;
        $act->title             = JText::_( $message );
        $act->content   = '';
        $act->app               = 'joomdle';
        $act->cid = 0;
        CActivityStream::add( $act );

        return "OK";

    }


	function getJSGroupId ($method, $params)
    {
		$name = $params[0];
        return JoomdleHelperGroups::get_js_group_by_name ($name);
    }

    function getJSGroupImageLink ($method, $params)
    {
		$name = $params[0];
        return JoomdleHelperGroups::get_js_group_image_link ($name);
    }

    function addJSGroup ($method, $params)
    {
		$name = $params[0];
		$description = $params[1];
		$course_id = $params[2];
		$website = $params[3];

   //     $name = utf8_decode ($name);
   //     $description = utf8_decode ($description);

        return JoomdleHelperGroups::addJSGroup ($name, $description, $course_id, $website);
    }

    function updateJSGroup ($method, $params)
    {
		$name = $params[0];
		$description = $params[1];
		$course_id = $params[2];
		$website = $params[3];

 //       $name = utf8_decode ($name);
 //       $description = utf8_decode ($description);

        return JoomdleHelperGroups::updateJSGroup ($name, $description, $course_id, $website);
    }

    function removeJSGroup ($method, $params)
    {
		$name = $params[0];
        return JoomdleHelperGroups::removeJSGroup ($name);
    }


   function addJSGroupMember ($method, $params)
    {
		$group_name = $params[0];
		$username = $params[1];
		$permissions = $params[2];
		$course_id = $params[3];

        $username = utf8_decode ($username);
        $group_name = utf8_decode ($group_name);

        return JoomdleHelperGroups::addJSGroupMember ($group_name, $username, $permissions, $course_id);
    }

    function removeJSGroupMember ($method, $params)
    {
		$group_name = $params[0];
		$username = $params[1];

//        $username = utf8_decode ($username);

        return JoomdleHelperGroups::removeJSGroupMember ($group_name, $username);
    }

    function addPoints ($action, $params)
    {
		$action = $params[0];
		$username = $params[1];
		$courseid = $params[2];
		$course_name = $params[3];

        $username = utf8_decode ($username);
        $course_name = utf8_decode ($course_name);

        return JoomdleHelperPoints::addPoints ($action, $username, $courseid, $course_name);
    }

	function addActivityQuizAttempt ($username, $params)
    {
		$username = $params[0];
		$course_id = $params[1];
		$course_name = $params[2];
		$quiz_name = $params[3];

        require_once( JPATH_ROOT . '/components/com_community/libraries/core.php' );

        CFactory::load ( 'libraries', 'activities' );

        $course_slug = JFilterOutput::stringURLSafe ($course_name);

        $user_id = JUserHelper::getUserId($username);

        $mainframe =& JFactory::getApplication('site');
        $mainframe->initialise();

        $act = new stdClass();

//        $username = utf8_decode ($username);
//        $course_name = utf8_decode ($course_name);
//        $quiz_name = utf8_decode ($quiz_name);


       //$message                = JText::_('{actor} enroled into the course').' ';
        $message                = JText::_('COM_JOOMDLE_USER_QUIZ_ATTMPT_SUBMITTED').' ';

        $message                = JText::_('COM_JOOMDLE_USER_QUIZ_ATTEMPT_SUBMITTED').' ' . $quiz_name . ' ';


        $message                .= JText::_('COM_JOOMDLE_IN_COURSE')." ";
        $link = ("index.php?option=com_joomdle&view=detail&course_id=$course_id:$course_slug");
        $message                .= ' <a href="' . $link .'">' . $course_name . '</a> ';

        $act->cmd               = 'joomdle.quizattempt';
        $act->actor     = $user_id;
        $act->access     = 0;
        $act->target    = 0;
        $act->title             = JText::_( $message );
        $act->content   = '';
        $act->app               = 'joomdle';
        $act->cid = 0;
        CActivityStream::add( $act );

        return "OK";
    }


    function addMailingSub ($action, $params)
    {
		$username = $params[0];
		$course_id = $params[1];
		$type = $params[2];

        $username = utf8_decode ($username);

		return JoomdleHelperMailinglist::add_list_member ($username, $course_id, $type);
    }

    function removeMailingSub ($action, $params)
    {
		$username = $params[0];
		$course_id = $params[1];
		$type = $params[2];

        $username = utf8_decode ($username);

		return JoomdleHelperMailinglist::remove_list_member ($username, $course_id, $type);
    }

    function addUserGroups ($action, $params)
    {
		$course_id = $params[0];
		$course_name = $params[1];

        $course_name = utf8_decode ($course_name);

		return JoomdleHelperJoomlagroups::add_course_groups ($course_id, $course_name);
    }

    function removeUserGroups ($action, $params)
    {
		$course_id = $params[0];

		return JoomdleHelperJoomlagroups::remove_course_groups ($course_id);
    }

    function addGroupMember ($action, $params)
    {
		$course_id = $params[0];
		$username = $params[1];
		$type = $params[2];

        $username = utf8_decode ($username);

		return JoomdleHelperJoomlagroups::add_group_member ($course_id, $username, $type);
    }

    function removeGroupMember ($action, $params)
    {
		$course_id = $params[0];
		$username = $params[1];
		$type = $params[2];

        $username = utf8_decode ($username);

		return JoomdleHelperJoomlagroups::remove_group_member ($course_id, $username, $type);
    }

    function addForum ($action, $params)
    {
		$course_id = $params[0];
		$forum_id = $params[1];
		$forum_name = $params[2];

        $forum_name = utf8_decode ($forum_name);

		return JoomdleHelperForum::add_forum ($course_id, $forum_id, $forum_name);
    }

    function removeForum ($action, $params)
    {
		$course_id = $params[0];
		$forum_id = $params[1];

		return JoomdleHelperForum::remove_forum ($course_id, $forum_id);
    }

    function addForumsModerator ($action, $params)
    {
		$course_id = $params[0];
		$username = $params[1];

        $username = utf8_decode ($username);

		return JoomdleHelperForum::add_forums_moderator ($course_id, $username);
    }

    function removeForumsModerator ($action, $params)
    {
		$course_id = $params[0];
		$username = $params[1];

        $username = utf8_decode ($username);

		return JoomdleHelperForum::remove_forums_moderator ($course_id, $username);
    }

    function removeCourseForums ($action, $params)
    {
		$course_id = $params[0];

		return JoomdleHelperForum::remove_course_forums ($course_id);
    }

    function getSellUrl ($action, $params)
    {
		$course_id = $params[0];

        return JoomdleHelperShop::get_sell_url ($course_id);
    }


class JoomdleControllerWs extends JControllerLegacy
{
	function check_origin ()
    {
        $request_ip = JRequest::getVar ('REMOTE_ADDR', '', 'server');
        $comp_params = JComponentHelper::getParams( 'com_joomdle' );

        $internal_ip = $comp_params->get( 'internal_ip' );
		if ($internal_ip)
		{
			$moodle_ip = $internal_ip;
		}
		else
		{
			$moodle_url = $comp_params->get( 'MOODLE_URL' );
			$url = parse_url ($moodle_url);
			$domain = $url['host'];
			$moodle_ip = gethostbyname ($domain);
		}

        return  ($request_ip == $moodle_ip);
    }

	public function server ()
    {
		if (!$this->check_origin ())
		{
			print_r (xmlrpc_encode ( "XML-RPC Error (1): Access Denied" . JRequest::getVar ('REMOTE_ADDR', '', 'server')));
			return;
		}


	$document = JFactory::getDocument();
	$document->setMimeEncoding('text/xml') ;

	$xmlrpc_server = xmlrpc_server_create();

	xmlrpc_server_register_method($xmlrpc_server, "joomdle.getUserInfo", "getUserInfo");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.test", "test");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.login", "login");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.confirmJoomlaSession", "confirmJoomlaSession");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.getDefaultItemid", "getDefaultItemid");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.logout", "logout");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.createUser", "createUser");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.activateUser", "activateJoomlaUser");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.updateUser", "updateUser");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.changePassword", "changePassword");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.deleteUser", "deleteUser");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addActivityCourse", "addActivityCourse");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addActivityCourseEnrolment", "addActivityCourseEnrolment");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.getJSGroupId", "getJSGroupId");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.getJSGroupImageLink", "getJSGroupImageLink");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addJSGroup", "addJSGroup");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.updateJSGroup", "updateJSGroup");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeJSGroup", "removeJSGroup");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addJSGroupMember", "addJSGroupMember");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeJSGroupMember", "removeJSGroupMember");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addPoints", "addPoints");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addActivityQuizAttempt", "addActivityQuizAttempt");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addMailingSub", "addMailingSub");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeMailingSub", "removeMailingSub");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addUserGroups", "addUserGroups");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeUserGroups", "removeUserGroups");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addGroupMember", "addGroupMember");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeGroupMember", "removeGroupMember");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addForum", "addForum");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeForum", "removeForum");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.addForumsModerator", "addForumsModerator");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeForumsModerator", "removeForumsModerator");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.removeCourseForums", "removeCourseForums");
	xmlrpc_server_register_method($xmlrpc_server, "joomdle.getSellUrl", "getSellUrl");

	//$request_xml = $HTTP_RAW_POST_DATA;
	$request_xml = @file_get_contents('php://input');

	$response = xmlrpc_server_call_method($xmlrpc_server, $request_xml, '');
	print_r ( $response );
	//echo xmlrpc_encode ($response);

//	$xmlrpc_server->service($response);

	exit ();

    }


}

?>
