<?php
/* This file has been prefixed by <PHP-Prefixer> for "XT Adaptive Images" */

/*
 * @package     XT Adaptive Images
 *
 * @author      Extly, CB. <team@extly.com>
 * @copyright   Copyright (c)2012-2022 Extly, CB. All rights reserved.
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 *
 * @see         https://www.extly.com
 */

namespace XTP_BUILD\Extly\AdaptiveImages\Common;

use XTP_BUILD\Extly\Infrastructure\Creator\CreatorTrait;

class FileCacheHelper
{
    use CreatorTrait;

    /**
     * isCacheFresh - refreshes the cached image if it's outdated.
     *
     * @param string $sourceFile Params
     * @param int    $cacheFile  Params
     *
     * @return int
     */
    public function isCacheFresh($sourceFile, $cacheFile)
    {
        if (file_exists($cacheFile)) {
            // Not modified
            if (filemtime($cacheFile) >= filemtime($sourceFile)) {
                return $cacheFile;
            }

            // Modified, clear it
            unlink($cacheFile);

            return false;
        }

        return true;
    }
}
