<?php
defined('_JEXEC') or die('Restricted access');
global $booklibrary_configuration;  
/**
 *
 * @package Booklibrary
 * @copyright 2012 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com)
 * Homepage: http://www.ordasoft.com
 * @version: 3.5 FREE
 *
 * */
$database = JFactory::getDBO();
$languagelocale = "";
$query = "SELECT l.title, l.lang_code, l.sef ";
$query.= "FROM #__booklibrary_const_languages as cl ";
$query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
$query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id ";
$query.= "GROUP BY  l.title";
$database->setQuery($query);
$languages = $database->loadObjectList();

$lang = JFactory::getLanguage(); 
foreach($lang->getLocale() as $locale) {
    foreach($languages as $language) {
        if (strtolower($locale) == strtolower($language->title) 
            || strtolower($locale) == strtolower($language->lang_code) 
            || ( isset($language->sef) && strtolower($locale) == strtolower($language->sef) ) ) {
            $mosConfig_lang = $locale;
            $languagelocale = $language->lang_code;
            break;
        }
    }
}
if ($languagelocale == '') $languagelocale = "en-GB";
global $langContent;
$langContent = substr($languagelocale, 0, 2);
$query = "SELECT c.const, cl.value_const ";
$query.= "FROM #__booklibrary_const_languages as cl ";
$query.= "LEFT JOIN #__booklibrary_languages AS l ON cl.fk_languagesid=l.id ";
$query.= "LEFT JOIN #__booklibrary_const AS c ON cl.fk_constid=c.id ";
$query.= "WHERE l.lang_code = '$languagelocale'";
$database->setQuery($query);
$langConst = $database->loadObjectList();
foreach($langConst as $item) {
    if (!defined($item->const)) define($item->const, $item->value_const); // $database->quote()
}

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::root(true) . '/components/com_booklibrary/includes/booklibrary.css');

//Common parameters
$sort_top_by = $params->def('sort_by_top_author', 0); 
$show_published = $params->get('only_published_author');
$show_image = $params->get('image_author');
$image_height = $params->get('image_height_author');
$image_width = $params->get('image_width_author');
$show_hits = $params->get('hits_author');
$desc_author = $params->get('desc_author',0);
$desc_length = $params->get('desc_length',0);
$show_ranking = $params->get('ranking_author');
$displaytype_author = $params->get('displaytype_booklib_author');
$moduleclass_sfx = $params->get('moduleclass_sfx');
$layout = $params->get('layout', 'default');

//Individual parameters
$count_authors = intval($params->get('authors', 1));
//Check if only display published items
if ($show_published == 1) {
    $sql_published = "a.published=1 ";
    $where[] = $sql_published;
} else {
    $sql_published = "";
}

$author_with_most_hits_books = " ";
$author_with_most_rating_books = " ";
$random_author = " ";
$sql_where_query = " ";

switch ($sort_top_by) {
    case 0:
        $sql_sort_top = "hits";
        break;
    case 1:
        $sql_sort_top = "date";
        break;
    case 2:
        $author_with_most_hits_books = 1;
        break;
    case 3:
        $author_with_most_rating_books = 1;
        break;
   case 4:
        $random_author = 1;
        break;
}

$database->setQuery("SELECT COUNT(id) FROM #__booklibrary_authors");
$countauthors = $database->loadResult();
$rowses = array();
$rows = array();

for ($i = 0; $i < $countauthors; $i+=$count_authors) {
    if ($count_authors != '' && $count_authors != 0 && $sql_published == ""
        && $author_with_most_hits_books == 0 && $author_with_most_rating_books == 0 && $random_author == 0) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description
                       \nFROM #__booklibrary_authors AS a
                       \nGROUP BY a.id ORDER BY $sql_sort_top DESC LIMIT 0," . $count_authors;
        $database->setQuery($selectstring);
        $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $author_with_most_hits_books == 0 
               && $author_with_most_rating_books == 0 && $random_author == 0) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description
                       \nFROM #__booklibrary_authors AS a
                       \nWHERE " . implode(" AND ", $where) . $sql_where_query . "
                       \nGROUP BY a.id ORDER BY $sql_sort_top DESC LIMIT 0," . $count_authors;
        $database->setQuery($selectstring);
        $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $sql_published == "" && $author_with_most_hits_books == 1) {
     $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description, SUM(b.hits) AS hits_books " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "GROUP by a.id ORDER BY hits_books DESC LIMIT 0," . $count_authors;          
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $author_with_most_hits_books == 1) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description, SUM(b.hits) AS hits_books " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "\nWHERE " . implode(" AND ", $where) . $sql_where_query .
                      "GROUP by a.id ORDER BY hits_books DESC LIMIT 0," . $count_authors;          
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    }
    else if($count_authors != '' && $count_authors != 0 && $sql_published == "" && $author_with_most_rating_books == 1) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description, SUM(b.rating) AS rating_books " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "GROUP by a.id ORDER BY rating_books DESC LIMIT 0," . $count_authors;
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $author_with_most_rating_books == 1) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description, SUM(b.rating) AS rating_books " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "\nWHERE " . implode(" AND ", $where) . $sql_where_query .
                      "GROUP by a.id ORDER BY rating_books DESC LIMIT 0," . $count_authors;
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $sql_published == "" && $random_author == 1) {
         $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "GROUP by a.id ORDER BY RAND() DESC LIMIT 0," . $count_authors;
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    } else if ($count_authors != '' && $count_authors != 0 && $random_author == 1) {
        $selectstring = "SELECT a.id, a.authors_name, a.hits, a.imageURL, a.description " . 
                      "FROM  #__booklibrary_authors as a " .
                      "LEFT JOIN #__booklibrary as b ON b.fk_authors = a.id " .
                      "\nWHERE " . implode(" AND ", $where) . $sql_where_query .
                      "GROUP by a.id ORDER BY RAND() DESC LIMIT 0," . $count_authors;
      $database->setQuery($selectstring);
      $rows_author = $database->loadObjectList();
    } else {
        $rows_author = "";
        break;
    }
    $rowses = $rows_author;
    if (count($rowses) >= $count_authors) {
        break;
    }
}

if (count($rowses) > 0 and $count_authors > 0) {
    $rows = array_slice($rowses, 0, $count_authors);
}

$query = "SELECT id FROM #__menu WHERE link='index.php?option=com_booklibrary'";
$database->setQuery($query);
$ItemId_tmp = $database->loadResult();
require(JModuleHelper::getLayoutPath('mod_booklibrary_featured_authors', $layout));    
?>