/*
* @version 2.2FREE
* @package Booklibrary - property slideShow
* @copyright 2012 OrdaSoft
* @author 2012 Andrey Kvasnekskiy (akbet@ordasoft.com )
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @description Booklibrary - property slideShow for Book Library Component
*/

!function($){

var BookSlideShow = {

    init: function(slideshowLoader){

		slideshowLoader.data();
		var settings = slideshowLoader.data('bookslideshow');
		var options = slideshowLoader.data('animation');
		slideshowLoader.removeAttr('data-djslider');
		slideshowLoader.removeAttr('data-animation');

        var slider_size = 0;
        var loaded_images = 0;
        var max_slides = 0;
        var current_slide = 0;
        var slider = $('#slider' + settings.id);
        var cssTransition = settings.css3=='1' ? support('transition') : false
        var autoplay = options.auto;
        var stop = 0;
        var show_nav = 0;
		var is_fading = false;
        
        var slides = $(slider).children('li');
        slider_size = settings.slide_size * slides.length;
        loaded_images = slides.length;

        max_slides = loaded_images - settings.visible_slides;
		
        slider.css('position', 'relative');
		
        var slideImages;
		if (settings.slider_type == 2) { // fade
			slides.css('position', 'absolute');
			slides.css('top', 0);
			slides.css('left', 0);
			$(slider).css('width', settings.slide_size);
			slides.css('opacity',0);
			$(slides[0]).css('opacity',1);
			$(slides[0]).css('z-index','10');
			$('#navigation' + settings.id).css('z-index',20);
			if(cssTransition) slides.css(cssTransition, 'opacity '+options.duration+'ms '+options.css3transition);
						
		} else if (settings.slider_type == 1) { // vertical
            $(slider).css('top', 0);
            $(slider).css('height', slider_size);
            if(cssTransition) slider.css(cssTransition, 'top '+options.duration+'ms '+options.css3transition);
        }
        else { // horizontal
            $(slider).css('left', 0);
            $(slider).css('width', slider_size);
            if(cssTransition) slider.css(cssTransition, 'top '+options.duration+'ms '+options.css3transition);
        }
        
        $('#next' + settings.id).on('click', function(){
            if (settings.show_buttons==1) hideNavigation();
            nextSlide();
        });        
        $('#prev' + settings.id).on('click', function(){
            if (settings.show_buttons==1) hideNavigation();
            prevSlide();
        });        
        $('#play' + settings.id).on('click', function(){
            changeNavigation();
            autoplay = 1;
        });        
        $('#pause' + settings.id).on('click', function(){
            changeNavigation();
            autoplay = 0;
        });
        
		slider.on({
            'mouseenter': function(e){
                if (!$(e.relatedTarget).hasClass('navigation-container')) {
                    if (settings.show_buttons==1) showNavigation();
    				if (settings.show_arrows==1) {
        		        $('#next' + settings.id).fadeIn();
    	    		    $('#prev' + settings.id).fadeIn();
    				}
    				stop = 1;
                }
            },
            'mouseleave': function(e){
                if (!$(e.relatedTarget).hasClass('navigation-container')) {
                    if (settings.show_buttons==1) hideNavigation();
    				if (settings.show_arrows==1) {
        		        $('#next' + settings.id).fadeOut();
    	    		    $('#prev' + settings.id).fadeOut();
    				}
    				stop = 0;
                }
            }
        });
		
		var buttons = $('#cust-navigation' + settings.id).children('.load-button')
			.on('click', function(e){
				if (!is_fading && !el.hasClass('load-button-active')) {
					loadSlide(index);
				}
			});

		function updateActiveButton(active){
			buttons.each(function(index,button){
				$(button).removeClass('load-button-active');
				if(index==active) $(button).addClass('load-button-active');
			});			
		}
		
		function support(p) {
			
			var b = document.body || document.documentElement,
			s = b.style;
			
			// No css support detected
			if(typeof s == 'undefined') return false;
			
			// Tests for standard prop
			if(typeof s[p] == 'string') return p;
			
			// Tests for vendor specific prop
			v = ['Moz', 'Webkit', 'Khtml', 'O', 'ms', 'Icab'],
			pu = p.charAt(0).toUpperCase() + p.substr(1);
			for(var i=0; i<v.length; i++) {
				//console.log(v[i] + pu);
				if(typeof s[v[i] + pu] == 'string') return ('-' + v[i].toLowerCase() + '-' + p);
			}
			
			return false;
		}
		
		
		function loadSlide(i) {
			if (settings.slider_type == 2) {
				if(is_fading) return;
				is_fading = true;
				prev_slide = current_slide;
				current_slide = i;
				makeFade(prev_slide);
				
			}
			else {
				current_slide = i;
				slideImages.start(-settings.slide_size * current_slide);
				updateActiveButton(current_slide);
			}
		}
		
        function nextSlide(){
			if (settings.slider_type == 2)
				nextFade();
			else {
				if (current_slide < max_slides) 
					current_slide++;
				else 
					current_slide = 0;
				slideImages.start(-settings.slide_size * current_slide);
				updateActiveButton(current_slide);
			}
        }
        
        function prevSlide(){
			if (settings.slider_type == 2) {
				prevFade();
			}
			else {
				if (current_slide > 0) {
					current_slide--;
				}
				else {
					current_slide = max_slides;
				}
				slideImages.start(-settings.slide_size * current_slide);
				updateActiveButton(current_slide);
			}
        }
        
		function nextFade(){
			if(is_fading) return;
			is_fading = true;
			prev_slide = current_slide;
			if (current_slide < max_slides) {
				current_slide++;
			}
			else {
				current_slide = 0;
			}
				
			makeFade(prev_slide);
		}
		
		function prevFade(){
			if(is_fading) return;
			is_fading = true;
			prev_slide = current_slide;
			if (current_slide > 0) {
				current_slide--;
			}
			else {
				current_slide = max_slides;
			}
			
			makeFade(prev_slide);			
		}
		
		function makeFade(prev_slide){
			$(slides[current_slide]).css('visibility','visible');
			if(cssTransition) {
				$(slides[current_slide]).css('opacity',1);
				$(slides[prev_slide]).css('opacity',0);
			} else {				
				$(slides[current_slide]).animate({opacity: 1}, options.duration, options.transition);
				$(slides[prev_slide]).animate({opacity: 0}, options.duration, options.transition);
			}
			setTimeout(function(){
				$(slides[prev_slide]).css('visibility','hidden');
				is_fading = false;
			}, options.duration);
			updateActiveButton(current_slide);
		}
		
        function hideNavigation(){
            if (!autoplay) {
                $('#play' + settings.id).fadeOut(200, function(){
                    if (!show_nav) 
                        $('#play' + settings.id).hide();
                });
            }
            else {
                $('#pause' + settings.id).fadeOut(200, function(){
                    if (!show_nav) 
                        $('#pause' + settings.id).hide();
                });
            }
            show_nav = 0;
        }
        
        function showNavigation(){
            if (!autoplay) {
                $('#play' + settings.id).show().fadeIn(200);
            }
            else {
                $('#pause' + settings.id).show().fadeIn(200);
            }
            show_nav = 1;
        }
        function changeNavigation(){
            if (autoplay) {
                $('#pause' + settings.id).hide();
                if (settings.show_buttons==1) $('#pause' + settings.id).fadeOut();
                $('#play' + settings.id).show();
                if (settings.show_buttons==1) $('#play' + settings.id).fadeIn();
            }
            else {
                $('#play' + settings.id).hide();
                if (settings.show_buttons==1) $('#play' + settings.id).fadeOut();
                $('#pause' + settings.id).show();
                if (settings.show_buttons==1) $('#pause' + settings.id).fadeIn();
            }
        }
        
        function slidePlay(){
            setTimeout(function(){
                if (autoplay && !stop) 
                    nextSlide();
                slidePlay();
            }, options.delay);
        }
		
		function sliderLoaded(){
			// hide loader and show slider
			//$('#bookslideshow' + settings.id).css('opacity',0);
			//$('#bookslideshow' + settings.id).show();
			//$('#bookslideshow-loader' + settings.id).css('background','url(blank.gif)');
			
			//$('#bookslideshow' + settings.id).fadeIn();
			
			// count and change bookslideshow dimensions
			buttons_height = $('#next' + settings.id).height()
			buttons_height = Math.max(buttons_height, $('#prev' + settings.id).height());
			$('#navigation' + settings.id).height(buttons_height);
        	button_pos = $('#navigation' + settings.id).css('top');
        	bookslideshow_height = $('#bookslideshow' + settings.id).height();
			if(button_pos > 0) {
				new_height = buttons_height + button_pos;
			} else {
				new_height = bookslideshow_height - button_pos;
			}        	
        	if (new_height > bookslideshow_height) {
            	$('#bookslideshow' + settings.id).height(new_height);
				$('#bookslideshow-loader' + settings.id).height(new_height);
        		if (button_pos < 0) {
					$('#navigation' + settings.id).css('top', 0);
					$('#slider-container' + settings.id).css('top', -button_pos);
				}
        	}
			buttons_margin = $('#navigation' + settings.id).css('margin-left') + $('#navigation' + settings.id).css('margin-right');
			bookslideshow_width = $('#bookslideshow' + settings.id).width();
			if(buttons_margin < 0) {
				$('#bookslideshow-loader' + settings.id).css('width', bookslideshow_width - buttons_margin);
			}
			nav_width = $('#navigation' + settings.id).width();
			play_width = $('#play' + settings.id).width();
			$('#play' + settings.id).css('left',(nav_width/2 - play_width/2));
			pause_width = $('#play' + settings.id).width();
			$('#pause' + settings.id).css('left',(nav_width/2 - pause_width/2));
			
			if(autoplay) {
				$('#play' + settings.id).hide();
			} else {
				$('#pause' + settings.id).hide();
			}
			
			// start autoplay
			slidePlay();
		}
		
		/*if(settings.preload) sliderLoaded.delay(settings.preload);
		else if (DocumentLoaded) sliderLoaded();
		else window.addEvent('load', sliderLoaded);*/
        sliderLoaded();
    }
    
};


$(document).ready(function(){
	
	$('[data-bookslideshow]').each(function(){
		BookSlideShow.init($(this));
	});
	
});

}(jQuery);