/*
	HTML5 CLOUD
	Copyright 2011: Thorsten Riemer 
	http://bl.t4ri.de/?tag=cumulus
		
    HTML5 Cloud is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This software is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
	  <http://www.gnu.org/licenses/>

    HTML5 CLOUD as a rotating 3D cumulus or cloud, realized with SVG
    the code development based on:
    blog.massivecube.com : uniform distribution in spheric coordinates - this page is no longer active
    www.kirupa.com/developer/actionscript/rotation_center.htm : Rotation around a common center
    www.roytanck.com :  tag cloud flash version
    code.google.com/p/flexcloud : flex tag cloud flash version
   	code.google.com/p/svgtagcloud/ : SVG tag cloud
*/

// function tag - creates a new tag object
function tag(px,py,pz,name) {
	this.stopped = false;
	
	this.cx = px;
	this.cy = py;
	this.cz = pz;
	this.dx = 0;
	this.dy = 0;
	
	this.scale = 1;
	this.alpha = 1;
	
	this.txt = name;
}


// tag position update - cyclic tag position update
function updateTags() {
	
	var a;
	var b;
	
	if( mactive ) {
		rotx = Math.min(Math.max((centery - mousey),-focalLen),focalLen); 
		rotx *= mousecorr;
		roty = Math.min(Math.max((mousex - centerx),-focalLen),focalLen);
		roty *= mousecorr;
	} else {
		roty *= slowdown;
		rotx *= slowdown;
	}
	
	// if rot under threshold, skip motion calculations to free up the processor
	if( Math.abs(rotx) > thrshold || Math.abs(roty) > thrshold ) {
		var sx = Math.sin(rotx);
		var cx = Math.cos(rotx);
		var sy = Math.sin(roty);
		var cy = Math.cos(roty);
		var j;
		
		for( j=0; j<tags.length; j++ ) {
			var t = tags[j];
			// rotation around x
			var xy = cx * t.cy - sx * t.cz;
			var xz = sx * t.cy + cx * t.cz;
			
			// rotation around y
			var yz = cy * xz - sy * t.cx;
			var yx = sy * xz + cy * t.cx;
			
			// scale
			t.scale = focalLen / (focalLen + yz * radius);
			
			// alpha
			t.alpha = t.scale / 2;
			
			// delta
			t.dx = yx * t.scale * radius - t.cx;
			t.dy = xy * t.scale * radius - t.cy;
			
			// new 3D coordinates
			t.cx = yx;
			t.cy = xy;
			t.cz = yz;
		}
		
		tags.sort( tagscomp );
	
		// start redrawing
		ctx.clearRect(0, 0, width, height);
		for( j=0; j<tags.length; j++ ) {
			var t = tags[j];
			var color = getColorFromGradient( fillcolor, backcolor, t.alpha );
			// new position and scale the object
			ctx.save();
			ctx.translate(centerx+t.dx,centery+t.dy);
			ctx.scale(t.scale, t.scale);
			ctx.fillStyle = color;
			ctx.font="20px Arial";
			ctx.fillText(t.txt, 0, 0);
			ctx.restore();
		}
	}
}

// sort function - sort help function
function tagscomp(a,b) {
	return b.cz - a.cz;
}

// get color from gradient - calculates the color background
function getColorFromGradient( color1, color2, perc ) {
	
	var r1 = parseInt(color1.substr(1,2),16);
	var g1 = parseInt(color1.substr(3,2),16);
	var b1 = parseInt(color1.substr(5,2),16);
	var r2 = parseInt(color2.substr(1,2),16);
	var g2 = parseInt(color2.substr(3,2),16);
	var b2 = parseInt(color2.substr(5,2),16);
	var r = ( perc * r1) + ( (1-perc) * r2 );
	var g = ( perc * g1 ) + ( (1-perc) * g2 );
	var b = ( perc * b1 ) + ( (1-perc) * b2 );
	r = Number(r.toFixed(0));
	g = Number(g.toFixed(0));
	b = Number(b.toFixed(0));
	
	var ret = "#"+r.toString(16)+g.toString(16)+b.toString(16);
	
	return ret;
}

// mouse events - handling mouse moves
window.onmousemove = function (evt){ 
	mactive = true; 
	mousex = evt.pageX; 
	mousey = evt.pageY;
}
window.onmouseout = function (evt){ mactive = false; }
