<?php
/**
 * fw Tags Joomulus Module for Joomla! 3.1
 * @package     Joomla.Site
 * @subpackage  mod_fwTagsJoomulus
 *
 * @copyright   Copyright (C) 2009 - 2013 faresweb.net.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Helper for mod_fwTagsJoomulus
 *
 * @package     Joomla.Site
 * @subpackage  mod_fwTagsJoomulus
 * @since       3.1
 */
class ModFwTagsJoomulusHelper {

	/**
	 *
	 * Get Tags list from com_tags component
	 *
	 */     
	public static function &getList(&$params) {
		
		$criteria = $params->get('criteria', 'default');
		
		switch($criteria) {
			case 'mostpopular':
				$rows = self::getMostPopular($params);
				break;
			case 'mostread':
				$rows = self::getMostRead($params);
				break;
			case 'latest':
				$rows = self::getLatest($params);
				break;
			case 'default':
				require_once (JPATH_SITE.'/components/com_tags/models/tags.php');
				$model = new TagsModelTags();
				$rows = $model->getItems();
		}
				
		if(isset($rows)&&!empty($rows)) {
			$count = count($rows);
			for ($index = 0; $index < $count; $index++) {

				$row = &$rows[$index];
				//$row->link = JRoute::_('index.php?option=com_tags&view=tag&id='.$row->id, false);
				$row->link = JURI::base().substr(JRoute::_('index.php?option=com_tags&view=tag&id='.$row->id), strlen(JURI::base(true)) + 1);

				//if ($params->get('mostread')) {
					$row->size = 10 + ($row->hits * .5);
				//} else {
					//$row->size = 10 + ($row->ct * 0.5);
				//}

				//$row->name = JoomlaTagsHelper::ucwords($row->name);
			}
		}		
		return $rows;
	}
	
	public static function getMostPopular($params) {
		
		$db		= JFactory::getDbo();
		$app	= JFactory::getApplication();
		$user	= JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels());
		$max	= $params->get('count', 10);

		$query	= $db->getQuery(true);

		//$query->select(array($db->quoteName('tag_id'), $db->quoteName('type_alias'), $db->quoteName('content_item_id'), ' COUNT(*) AS count', 't.title', 't.access', 't.alias'));
		$query->select('t.*');
		$query->from($db->quoteName('#__tags').' AS t');
		$query->where('t.id <> 1'); // remove ROOT node
		$query->where('t.access IN (' . $groups . ')');
		$query->order('t.hits DESC LIMIT 0,' . $max);
		$db->setQuery($query);
		$results = $db->loadObjectList();

		return $results;
	}
	
	public static function getMostRead($params) {
		
		$db		= JFactory::getDbo();
		$app	= JFactory::getApplication();
		$user	= JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels());
		$max	= $params->get('count', 10);

		$query	= $db->getQuery(true);

		//$query->select(array($db->quoteName('tag_id'), $db->quoteName('type_alias'), $db->quoteName('content_item_id'), ' COUNT(*) AS count', 't.title', 't.access', 't.alias'));
		$query->select('t.*');
		$query->from($db->quoteName('#__tags').' AS t');
		$query->where('t.id <> 1'); // remove ROOT node
		$query->where('t.access IN (' . $groups . ')');
		$query->order('t.checked_out DESC LIMIT 0,' . $max);
		$db->setQuery($query);
		$results = $db->loadObjectList();

		return $results;
	}

	public static function getLatest($params) {
		
		$db			= JFactory::getDbo();
		$app		= JFactory::getApplication();
		$user		= JFactory::getUser();
		$groups		= implode(',', $user->getAuthorisedViewLevels());
		$date		= JFactory::getDate();
		$timeframe	= $params->get('timeframe', 'alltime');
		$max		= $params->get('count', 10);

		$query		= $db->getQuery(true);

		//$query->select(array($db->quoteName('tag_id'), $db->quoteName('type_alias'), $db->quoteName('content_item_id'), ' COUNT(*) AS count', 't.title', 't.access', 't.alias'));
		$query->select('t.*');
		$query->from('#__tags AS t');
		$query->join('LEFT','#__contentitem_tag_map AS ct ON t.id=ct.tag_id');
		$query->where('t.id <> 1'); // remove ROOT node
		$query->where('t.access IN (' . $groups . ')');

		if ($timeframe != 'alltime' ) {
			switch($timeframe) {
				case 'hour':
					$query->where( $db->quoteName('tag_date') . ' > ' . $query->currentTimestamp() . ' - INTERVAL 1 HOUR ');
					break;
				case 'day':
					$query->where( $db->quoteName('tag_date') . ' > ' . $query->currentTimestamp() . '  - INTERVAL 1 DAY');
					break;
				case 'month':
					$query->where( $db->quoteName('tag_date') . ' > ' . $query->currentTimestamp() . ' - INTERVAL 1 MONTH');
					break;
				case 'year':
					$query->where( $db->quoteName('tag_date') . ' > ' . $query->currentTimestamp(). '  - INTERVAL 1 YEAR');
			}
		}

		//$query->order('count DESC LIMIT 0,' . $max);
		$query->group($db->quoteName('t.id'));
		$db->setQuery($query);
		$results = $db->loadObjectList();

		return $results;
	}

}
