<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_fwTagsJoomulus
 *
 * @copyright   Copyright (C) 2009 - 2013 www.faresweb.net. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

global $modCount;
$name = 'fwTagsJoomulus';
$divname = $name.$modCount;
$classvalue = $name.'_'.$moduleclass_sfx;

$ie9jslink = '<!--[if lt IE 9]><script type="text/javascript" src="modules/mod_fwtagsjoomulus/assets/excanvas.min.js"></script><![endif]-->';

$document = JFactory::getDocument();

//$document->addCustomTag($ie9jslink);

if($params->get('jslibrary') == 'jQuery') {
	JHTML::_('behavior.jquery');
	//JHTML::script('jquery.js','media/system/js/',false);
}

$document->addScript('modules/mod_fwtagsjoomulus/assets/tagcanvas.js');

$document->addScriptDeclaration(
    "window.addEvent('load', function() {\n".
        "try {\n".
            "TagCanvas.Start('myCanvas','tags',{\n".
                "initial:            ".$params->get('initial').",\n".
                "textColour:         '#".$params->get('tcolor')."',\n".
                "textFont:           '".$params->get('textFont')."',\n".
                "outlineColour:      '#".$params->get('hicolor')."',\n".
                "outlineMethod:      '".$params->get('outlineMethod')."',\n".
                "outlineThickness:   ".$params->get('outlineThickness').",\n".
                "outlineOffset:      ".$params->get('outlineOffset').",\n".
                "freezeActive:       ".$params->get('freezeActive').",\n".
                "frontSelect:        ".$params->get('frontSelect').",\n".
                "txtOpt:             ".$params->get('txtOpt').",\n".
                "reverse:            ".$params->get('reverse').",\n".
                "shadow:             '".$params->get('shadow')."',\n".
                "shadowBlur:         ".$params->get('shadowBlur').",\n".
                "shadowOffset:       ".$params->get('shadowOffset').",\n".
                "weight:             ".$params->get('weight').",\n".
                "weightMode:         '".$params->get('weightMode')."',\n".
                "weightSize:         ".$params->get('weightSize').",\n".
                "weightGradient:     ".$params->get('weightGradient').",\n".
                "weightFrom:         'size'/*,\n".
                "lock:               '".$params->get('lock')."'*/\n".
            "});\n".
        "} catch(e) {\n".
    		"document.getElementById('myCanvasContainer').style.display = 'none';\n".
        "}\n".
    "});\n"
);

/*$document->addScriptDeclaration(
    'jQuery(document).ready(function(){jQuery("a[rel^=\'tagcanvas-layer\']").prettyPhoto({social_tools:false});});'."\n".
    'function openLayer(url) {'."\n".
        'jQuery.prettyPhoto.open(url+\'&iframe=true&width=90%&height=90%\',\'\',\'\');'."\n".
    '}'
);*/

?>

<div class="tagcloud<?php echo $moduleclass_sfx; ?>">
	<div id="myCanvasContainer">
		<canvas id="myCanvas" 
				height="<?php echo $params->get('height'); ?>"
				width="<?php echo $params->get('width'); ?>"
				style="background-color:<?php echo $params->get('bgcolor'); ?>">
			<p>Anything in here will be replaced on browsers that support the canvas element</p>
		</canvas>
	</div>
	<div id="tags">
	  <ul>
	      <?php
	      
	      $count = count($tagcloud);
		
	      for ($i = 0; $i < $count; $i++) {
	
	        $tag = $tagcloud[$i];
	
	        $link = $tag->link;
	        if (empty($link)) {
	            $link = str_replace('http://','',JURI::base().'index.php?option=com_search&searchfrase=all&searchword='.$tag);
	        }
	
	        $size = $tag->size;
	
	        $target = $params->get('target');
	
	        switch ($target) {
	            case '_self':
	                $target = 'target="_self"';
	                //$tmplink = 'http://'.$link;
	                //$link = $tmplink;
	                break;
	            /*case 'layer':
	                $target = 'rel="tagcanvas-layer"';
	                $tmplink = 'javascript:openLayer(\'http://'.$link.'\');';
	                $link = $tmplink;
	                break;*/
	            case '_blank':
	            default:
	                $target = 'target="_blank"';
	                //$tmplink = 'http://'.$link;
	                //$link = $tmplink;
	        }
	
	        $title = $tag->title;
	
	        echo '<li><a href="'.$link.'" '
	            .'size="'
	            .str_replace(array('px','pt'), array('',''), $size)
	            .'" '.$target.'>';
	
            echo $title;
	
	        echo '</a></li>';
	      }
	
	      ?>
	  </ul>
	</div>
</div>