<?php
/**
 * @package     Tags.Cloud
 * @subpackage  mod_tags_cloud
 *
 * @copyright   Copyright (C) 2013 vovoware.com
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Helper for mod_tags_cloud
 *
 * @package     Tags.Cloud
 * @subpackage  mod_tags_cloud
 * @since       3.1
 */
abstract class ModTagsCloudHelper
{
	public static function getList($params)
	{
		$db        = JFactory::getDbo();
		$user      = JFactory::getUser();
		$groups    = implode(',', $user->getAuthorisedViewLevels());
		$maximum   = $params->get('maximum', 50);
		$source    = $params->get('source', 'tags');

		if ($source == 'tags') {
			$query = $db->getQuery(true)
				->select(
					array(
						'MAX(' . $db->quoteName('tag_id') . ') AS tag_id',
						' COUNT(*) AS count', 'MAX(t.title) AS title',
						'MAX(' .$db->quoteName('t.access') . ') AS access',
						'MAX(' .$db->quoteName('t.alias') . ') AS alias'
					)
				)
				->group($db->quoteName(array('tag_id', 't.title', 't.access', 't.alias')))
				->from($db->quoteName('#__contentitem_tag_map'))
				->where($db->quoteName('t.access') . ' IN (' . $groups . ')');

			// Only return published tags
			$query->where($db->quoteName('t.published') . ' = 1 ');
			$query->where($db->quoteName('c.state') . ' = 1 ');

			// Optionally filter on language
			$language = JComponentHelper::getParams('com_tags')->get('tag_list_language_filter', 'all');

			if ($language != 'all')
			{
				if ($language == 'current_language')
				{
					$language = JHelperContent::getCurrentLanguage();
				}
				$query->where($db->quoteName('t.language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
			}

			$query->join('INNER', $db->quoteName('#__tags', 't') . ' ON ' . $db->quoteName('tag_id') . ' = t.id')
				->join('INNER', $db->quoteName('#__content', 'c') . ' ON ' . $db->quoteName('content_item_id') . ' = c.id')
				->order('title ASC');
			$db->setQuery($query, 0, $maximum);
			$results = $db->loadObjectList();
		} else {
			$query = $db->getQuery(true)
				->select(
					array(
						$db->quoteName('term') . ' AS title',
						$db->quoteName('term_id') . ' AS tag_id',
						'round(' . $db->quoteName('weight') . ' * ' . $db->quoteName('links') . ') AS count'
					)
				)
				->from($db->quoteName('#__finder_terms'))
				->where($db->quoteName('common') . ' = 0')
				->where($db->quoteName('phrase') . ' = 0')
				->where($db->quoteName('soundex') . ' <> ""');

			// Optionally filter on language
			$language = JComponentHelper::getParams('com_tags')->get('tag_list_language_filter', 'all');

			if ($language != 'all')
			{
				if ($language == 'current_language')
				{
					$language = JHelperContent::getCurrentLanguage();
				}
				$query->where($db->quoteName('language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
			}

			$query->order('count DESC');
			$db->setQuery($query, 6, $maximum);
			$results = $db->loadObjectList();
			sort($results);
		}

		return $results;
	}

	public static function getStyles($params)
	{
		$maxlevels = $params->get('maxlevels', 5);
		$linkcolor = $params->get('linkcolor', '#ffffff');
		$mincolor  = $params->get('mincolor', '#6abaf8');
		$maxcolor  = $params->get('maxcolor', '#426683');
		$minsize   = $params->get('minsize', 100);
		$maxsize   = $params->get('maxsize', 200);

		$styles = '.tagscloud ul {background-color:'.$mincolor.';';
		if($params->get('fadeback')) {
			$styles .= 'background-image: -moz-linear-gradient(top,'.$maxcolor.','.$mincolor.');';
			$styles .= 'background-image: -webkit-gradient(linear,0 0,0 100%,from('.$maxcolor.'),to('.$mincolor.'));';
			$styles .= 'background-image: -webkit-linear-gradient(top,'.$maxcolor.','.$mincolor.');';
			$styles .= 'background-image: -o-linear-gradient(top,'.$maxcolor.','.$mincolor.');';
			$styles .= 'background-image: linear-gradient(to bottom,'.$maxcolor.','.$mincolor.');';
			$styles .= 'background-repeat: repeat-x;';
		}
		$styles .= '}'."\n".'.tagscloud li a {color:'.$linkcolor.'}'."\n";
		for($i = 0; $i < $maxlevels; $i++) {
			$styles .= '.tagscloud .tag'.($i + 1).' {font-size:'.($minsize + $i * ($maxsize-$minsize) / ($maxlevels - 1)).'%;}'."\n";
			$styles .= '.tagscloud .list .tag'.($i + 1).' {background-color:'.blendColors($maxcolor, $mincolor,$i/($maxlevels-1)).';font-size:100%;}'."\n";
		}

		return $styles;
	}
}

function blendColors($color1, $color2, $percent)
{
	if ($percent >= 1) return $color1;
	if ($percent <= 0) return $color2;

	$color1_red   = hexdec(substr($color1, 1, 2));
	$color1_green = hexdec(substr($color1, 3, 2));
	$color1_blue  = hexdec(substr($color1, 5, 2));
 
	$color2_red   = hexdec(substr($color2, 1, 2));
	$color2_green = hexdec(substr($color2, 3, 2));
	$color2_blue  = hexdec(substr($color2, 5, 2));
 
	$blend_red    = round($color1_red   * $percent + $color2_red   * (1 - $percent));
	$blend_green  = round($color1_green * $percent + $color2_green * (1 - $percent));
	$blend_blue   = round($color1_blue  * $percent + $color2_blue  * (1 - $percent));

	return sprintf("#%02X%02X%02X", $blend_red, $blend_green, $blend_blue);
}