<?php
/**
 * @package     Tags.Cloud
 * @subpackage  mod_tags_cloud
 *
 * @copyright   Copyright (C) 2013 vovoware.com
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Include the syndicate functions only once
require_once __DIR__ . '/helper.php';

$cacheparams = new stdClass;
$cacheparams->cachemode = 'safeuri';
$cacheparams->class = 'ModTagsCloudHelper';
$cacheparams->method = 'getList';
$cacheparams->methodparams = $params;
$cacheparams->modeparams = array('id' => 'array', 'Itemid' => 'int');

$list = JModuleHelper::moduleCache($module, $params, $cacheparams);

if (!count($list))
{
	return;
}

JHtml::stylesheet('mod_tags_cloud/cloud.css', false, true, false);

$cacheparams->method = 'getStyles';

$styles = JModuleHelper::moduleCache($module, $params, $cacheparams);

if ($styles)
{
	$document = JFactory::getDocument();
	$document->addStyleDeclaration($styles);
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

require JModuleHelper::getLayoutPath('mod_tags_cloud', $params->get('layout', 'default'));