<?php
/**
 * @package     Tags.Cloud
 * @subpackage  mod_tags_cloud
 *
 * @copyright   Copyright (C) 2013 vovoware.com
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$maxlevels = $params->get('maxlevels');
$format = $params->get('format', 'toggle');
$source = $params->get('source', 'tags');
$max = 0;
$min = 1000;

foreach ($list as $item)
{
  if ($item->count > $max) $max = $item->count;
  if ($item->count < $min && $item->count > 0) $min = $item->count;
}
$diff = ($max - $min) / $maxlevels;

JLoader::register('TagsHelperRoute', JPATH_BASE . '/components/com_tags/helpers/route.php'); 

?>
<div class="tagscloud<?php echo $moduleclass_sfx; ?>">
<ul class="<?php echo $format; ?>">
<?php foreach ($list as $item) : 
  if ($item->count > 0) : 
  $level = ($item->count == $min) ? 1 : ceil(($item->count - $min) / $diff); ?>
  <li class="tag<?php echo $level; ?>" ><?php $route = new TagsHelperRoute; ?>
<?php if ($source == 'tags') { ?><a href="<?php echo JRoute::_(TagsHelperRoute::getTagRoute($item->tag_id . ':' . $item->alias)); ?>"><?php echo htmlspecialchars($item->title); ?></a>
<?php } else { ?><a href="/component/search?searchword=<?php echo $item->title; ?>"><?php echo htmlspecialchars($item->title); ?></a>
<?php } ?>
  </li>
  <?php endif;
endforeach; ?>
</ul>
</div>
<?php if ($format == 'toggle') : ?>
<script type="text/javascript">
jQuery(document).ready(function() {
  var switcher = jQuery('<a href="javascript:void(0)" class="btn pull-right"><i class="icon-eye"></i></a>')
      .click(function(){
        jQuery(".tagscloud ul").toggleClass("list");
      });
   jQuery('.tagscloud').prepend(switcher);  
});
</script>
<?php endif; ?>