<?php
/***************************************************************************************************
 Title          PureView - Content Plugin for Joomla
 Author         Nathanael Klassen
 Version        1.0
 Copyright      © by Nathanael Klassen
 **************************************************************************************************
*/
defined( '_JEXEC' ) or die( 'Restricted access' );

class PlgContentPureView extends JPlugin {

	function onContentPrepare($context, &$article, &$params, $page = 0)
	{
		$minimumLength = $this->params->get('minimum_length');
		if ($context == 'com_content.article' && strlen($article->text) > $minimumLength ) {
			
			$tooltipText = $this->params->get('tooltip_text');
			$linkText    = $this->params->get('link_text');
			$linkColor   = $this->params->get('link_color');
			$iconSize    = $this->params->get('icon_size');
			$iconAlign   = $this->params->get('icon_align');
			$appendTo    = $this->params->get('append_element');
			
                        JHtml::_('jquery.framework');
			JHTML::script('plg_pureview/pureview.js', false, true);
			JHTML::script('plg_pureview/jquery.mousewheel.min.js', false, true);
			JHTML::script('plg_pureview/jquery.touchSwipe-uncompressed.js', false, true);
			//JHTML::script('plg_pureview/jquery.touch.js', false, true);
			//JHTML::script('plg_pureview/jquery.swipe.js', false, true);
			
			$document = JFactory::getDocument();			
			$document->addStyleDeclaration(
				".pureViewLink { display: inline-block; }\n" .
				".pureViewLink img { height: {$iconSize}px; vertical-align: {$iconAlign}; }\n" .
				".pureViewLink a { text-decoration: none; color: {$linkColor}; }" );
			
			$document->addScriptDeclaration("
				jQuery(document).ready(function() 
				{
				    if( jQuery( '.pureViewLink' ).length > 0 ) return;
				    
				    var readerLink = jQuery( '<div class=\"pureViewLink\">' +
				                                  '<a href=\"#\" title=\"{$tooltipText}\">'+
				                                  //<img src=\"media/plg_pureview/img/read.svg\" alt=\"column view icon\" />' +
				                                  '<em>{$linkText}</em></a>' +
				                              '</div>' );
				    jQuery( '{$appendTo}' ).append( readerLink );			    
				    jQuery( '.pureViewLink a' ).click( function( event )
				    {
				        event.preventDefault();
				        var av = new PureView();
				        av.activate();
				    });
				});
			");
		}
	}
}