<?php
/**
 * @package     BookLibrary Joomla.Plugin
 * @subpackage  Finder.BookLibrary
 *
 * @copyright   (C) https://ordasoft.com/book-library-joomla-ebook-software-for-create-book-library-website
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// use Joomla\CMS\Component\ComponentHelper;
// use Joomla\CMS\Table\Table;
// use Joomla\Component\Finder\Administrator\Indexer\Adapter;
// use Joomla\Component\Finder\Administrator\Indexer\Helper;
// use Joomla\Component\Finder\Administrator\Indexer\Indexer;
// use Joomla\Component\Finder\Administrator\Indexer\Result;
// //use Joomla\Component\BookLibrary\Site\Helper\RouteHelper;
// //use Joomla\Component\BookLibrary\Site\Helper\BookLibraryHelperRoute;
// use Joomla\Database\DatabaseQuery;
// use Joomla\Registry\Registry;

require_once (JPATH_SITE . "/components/com_booklibrary/helpers/route.php");

use Joomla\Registry\Registry;

JLoader::register('FinderIndexerAdapter', JPATH_ADMINISTRATOR . '/components/com_finder/helpers/indexer/adapter.php');

/**
 * Finder adapter for Joomla Tag.
 */
//class PlgFinderBookLibrary extends Adapter 
class PlgFinderBookLibrary extends FinderIndexerAdapter 

{
	/**
	 * The plugin identifier.
	 *
	 * @var    string
	 */
	protected $context = 'Books';

	/**
	 * The extension name.
	 *
	 * @var    string
	 */
	protected $extension = 'com_booklibrary';

	/**
	 * The sublayout to use when rendering the results.
	 *
	 * @var    string
	 */
	protected $layout = 'view_book';

	/**
	 * The type of content that the adapter indexes.
	 *
	 * @var    string
	 */
	protected $type_title = 'Book';

	/**
	 * The table name.
	 *
	 * @var    string
	 */
	protected $table = '#__booklibrary';

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 */
	protected $autoloadLanguage = true;

	/**
	 * The field the published state is stored in.
	 *
	 * @var    string
	 */
	protected $state_field = 'published';


	/**
	 * Method to remove the link information for items that have been deleted.
	 *
	 * @param   string  $context  The context of the action being performed.
	 * @param   Table   $table    A Table object containing the record to be deleted
	 *
	 * @return  void
	 *
	 * @throws  Exception on database error.
	 */
	public function onFinderAfterDelete($context, $table): void
	{

		if ($context === 'com_booklibrary.book')
		{
			$id = $table->id;
		}
		elseif ($context === 'com_finder.index')
		{
			$id = $table->link_id;
		}
		else
		{
			return;
		}

		// Remove the items.
		$this->remove($id);
	}

	/**
	 * Method to determine if the access level of an item changed.
	 *
	 * @param   string   $context  The context of the content passed to the plugin.
	 * @param   Table    $row      A Table object
	 * @param   boolean  $isNew    If the content has just been created
	 *
	 * @return  void
	 *
	 * @throws  Exception on database error.
	 */
	public function onFinderAfterSave($context, $row, $isNew): void
	{
		// every time run reindex
		if ($context === 'com_booklibrary.book')
		{

			if(!$isNew){
				$pks = array();
				$pks[] = $row->id ;
				$state = $row->published & $row->approved ;
				//this not work, becouse in "index" method we call "getListQuery" and in that method we set Published or not 
				$this->itemStateChange($pks, $state);
			}

			$this->reindex($row->id);
		}
	}

	/**
	 * Method to reindex the link information for an item that has been saved.
	 * This event is fired before the data is actually saved so we are going
	 * to queue the item to be indexed later.
	 *
	 * @param   string   $context  The context of the content passed to the plugin.
	 * @param   Table    $row      A Table object
	 * @param   boolean  $isNew    If the content is just about to be created
	 *
	 * @return  boolean  True on success.
	 *
	 * @throws  Exception on database error.
	 */
	public function onFinderBeforeSave($context, $row, $isNew)
	{
		//we not use, 

		return true;
	}
	

	/**
	 * Method to update the link information for items that have been changed
	 * from outside the edit screen. This is fired when the item is published,
	 * unpublished, archived, or unarchived from the list view.
	 *
	 * @param   string   $context  The context for the content passed to the plugin.
	 * @param   array    $pks      A list of primary key ids of the content that has changed state.
	 * @param   integer  $value    The value of the state that the content has been changed to.
	 *
	 * @return  void
	 *
	 */
	public function onFinderChangeState($context, $pks, $value)
	{

		// We only want to handle books here
		if ($context === 'com_booklibrary.book')
		{
			//this not work becouse, in "index" method we call "getListQuery" and in that method we set Published or not 
			$this->itemStateChange($pks, $value);
		}

		// Handle when the plugin is disabled
		if ($context === 'com_plugins.plugin' && $value === 0)
		{
			$this->pluginDisable($pks);
		}
	}

	/**
	 * Method to index an item. The item must be a Result object.
	 *
	 * @param   Result  $item  The item to index as a Result object.
	 *
	 * @return  void
	 *
	 * @throws  Exception on database error.
	 */
	//protected function index(Result $item)
	protected function index(FinderIndexerResult $item, $format = 'html')	
	{

		// Check if the extension is enabled
//		if (ComponentHelper::isEnabled($this->extension) === false)
		if (JComponentHelper::isEnabled($this->extension) === false)
		{
			return;
		}

		$item->setLanguage();

		// Initialize the item parameters.
		$registry = new Registry($item->params);
//		$item->params = ComponentHelper::getParams('com_booklibrary', true);
		$item->params = JComponentHelper::getParams('com_booklibrary', true);
		$item->params->merge($registry);

		$item->metadata = new Registry($item->metadata);

		// Trigger the onContentPrepare event.
		$item->summary = FinderIndexerHelper::prepareContent($item->summary, $item->params, $item);
		$item->body    = FinderIndexerHelper::prepareContent($item->body, $item->params, $item);		

		// Create a URL as identifier to recognise items again.
		$item->url = $this->getUrl($item->id, $this->extension, $this->layout);

		// Build the necessary route and path information.
		$item->route = BookLibraryHelperRoute::getBookRoute($item->id,$item->catid);

		// Get the menu title if it exists.
		$title = $this->getItemMenuTitle($item->url);

		// Adjust the title if necessary.
		if (!empty($title) && $this->params->get('use_menu_title', true))
		{
			$item->title = $title;
		}

		// Add the meta author.
		$item->metaauthor = $item->metadata->get('author');

		// Handle the link to the metadata.
		// $item->addInstruction(Indexer::META_CONTEXT, 'link');
		// $item->addInstruction(Indexer::META_CONTEXT, 'metakey');
		// $item->addInstruction(Indexer::META_CONTEXT, 'metadesc');
		// $item->addInstruction(Indexer::META_CONTEXT, 'metaauthor');
		// $item->addInstruction(Indexer::META_CONTEXT, 'author');
		// $item->addInstruction(Indexer::META_CONTEXT, 'created_by_alias');

		$item->addInstruction(FinderIndexer::META_CONTEXT, 'link');
		$item->addInstruction(FinderIndexer::META_CONTEXT, 'metakey');
		$item->addInstruction(FinderIndexer::META_CONTEXT, 'metadesc');
		$item->addInstruction(FinderIndexer::META_CONTEXT, 'metaauthor');
		$item->addInstruction(FinderIndexer::META_CONTEXT, 'author');
		$item->addInstruction(FinderIndexer::META_CONTEXT, 'created_by_alias');

		// Add the type taxonomy data.
		$item->addTaxonomy('Type', 'Book');

		// Add the author taxonomy data.
		if (!empty($item->author) || !empty($item->created_by_alias))
		{
			$item->addTaxonomy('Author', !empty($item->created_by_alias) ? $item->created_by_alias : $item->author);
		}

		// Add the language taxonomy data.
		$item->addTaxonomy('Language', $item->language);

		// Get content extras.
//		Helper::getContentExtras($item);
		FinderIndexerHelper::getContentExtras($item);


		// Index the item.
		$this->indexer->index($item);
	}

	/**
	 * Method to setup the indexer to be run.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   3.1
	 */
	protected function setup()
	{
		return true;
	}

	/**
	 * Method to get the SQL query used to retrieve the list of content items.
	 *
	 * @param   mixed  $query  A DatabaseQuery object or null.
	 *
	 * @return  DatabaseQuery  A database object.
	 *
	 * @since   3.1
	 */
	protected function getListQuery($query = null)
	{

		$db = $this->db;

		// Check if we can use the supplied SQL query.
		$query = $query instanceof DatabaseQuery ? $query : $db->getQuery(true)
			->select('a.id, a.title, a.comment AS body, a.comment AS summary')
			->select('a.date AS start_date, a.owner_id AS created_by')
			->select('a.langshow AS language');
			//->select('a.metakey, a.metadesc, a.metadata, a.language, a.access')
			//->select('a.modified_time AS modified, a.modified_user_id AS modified_by')

		$case_when_item_alias = ' CASE ';
		$case_when_item_alias .= ' WHEN ';
		$case_when_item_alias .= ' a.published = 1 && a.approved = 1 ';
		$case_when_item_alias .= ' THEN "1" ';
		$case_when_item_alias .= ' ELSE ';
		$case_when_item_alias .= ' "0" ';
		$case_when_item_alias1 = ' END as state ';
		$query->select($case_when_item_alias . $case_when_item_alias1 );

		$case_when_item_alias2 = ' END as access ';
		$query->select($case_when_item_alias . $case_when_item_alias2 )
			->from('#__booklibrary AS a');

		// $a_id = $query->castAsChar('a.id');
		// $item_slug = $query->concatenate(array($a_id, 'a.bookid'), ':');
		// $item_slug .= ' as slug';
		// $query->select($item_slug)
		//	->from('#__booklibrary AS a');

		$query->select("mc.id as catid" )
		 	->join('LEFT', '#__booklibrary_categories AS bc ON bc.bookid = a.id ')
		 	->join('LEFT', '#__booklibrary_main_categories AS mc ON bc.catid=mc.id ');

		// // Join the #__users table
		// $query->select('u.name AS author')
		// 	->join('LEFT', '#__users AS u ON u.id = a.created_user_id');

		// Exclude the ROOT item
		$query->where($db->quoteName('a.id') . ' > 1');
		
		return $query;
	}

	/**
	 * Method to get a SQL query to load the published and access states for the given book item.
	 *
	 * @return  DatabaseQuery  A database object.
	 *
	 */
	protected function getStateQuery()
	{
		$query = $this->db->getQuery(true);
		$query->select($this->db->quoteName('a.id'))
			->select('NULL AS cat_state, NULL AS cat_access');

		// Handle the alias CASE WHEN portion of the query
		$case_when_item_alias = ' CASE ';
		$case_when_item_alias .= ' WHEN ';
		$case_when_item_alias .= ' a.published = 1 && a.approved = 1 ';
		$case_when_item_alias .= ' THEN "1" ';
		$case_when_item_alias .= ' ELSE ';
		$case_when_item_alias .= ' "0" ';
		$case_when_item_alias1 = ' END as state ';
		$query->select($case_when_item_alias . $case_when_item_alias1 );

		$case_when_item_alias2 = ' END as access ';
		$query->select($case_when_item_alias . $case_when_item_alias2 );

		$case_when_item_alias3 = ' END as cat_state ';
		$query->select($case_when_item_alias . $case_when_item_alias3 );

		$case_when_item_alias4 = ' END as cat_access ';
		$query->select($case_when_item_alias . $case_when_item_alias4 )
			->from($this->db->quoteName($this->table, 'a'));

	
	// CASE
  //   	WHEN a.published = 1 && a.approved = 1 THEN "1"
  //   	ELSE "0"
	// END
	
		return $query;

	}

	/**
	 * Method to get the query clause for getting items to update by time.
	 *
	 * @param   string  $time  The modified timestamp.
	 *
	 * @return  DatabaseQuery  A database object.
	 *
	 */
	protected function getUpdateQueryByTime($time)
	{

		// Build an SQL query based on the modified time.
		$query = $this->db->getQuery(true)
			->where('a.date >= ' . $this->db->quote($time));

		return $query;
	}
}
