<?php
/* This file has been prefixed by <PHP-Prefixer> for "XT Adaptive Images" */

/*
 * @package     XT Adaptive Images
 *
 * @author      Extly, CB. <team@extly.com>
 * @copyright   Copyright (c)2012-2022 Extly, CB. All rights reserved.
 * @license     https://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
 *
 * @see         https://www.extly.com
 */

use XTP_BUILD\Extly\Infrastructure\Service\Cms\Joomla\PluginHelper;
use Joomla\CMS\Factory as CMSFactory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri as CMSUri;

defined('_JEXEC') || exit;

/**
 * PlgSystemAdaptiveImagesForJoomla class.
 *
 * @since       1.0
 */
class PlgSystemAdaptiveImagesForJoomla extends CMSPlugin
{
    private $passed = false;

    private $adaptiveImagesHelper;

    /**
     * onBeforeCompileHead.
     */
    public function onBeforeCompileHead()
    {
        if ((CMSFactory::getApplication()->isClient('administrator')) || (!$this->getHelper())) {
            return;
        }

        $this->adaptiveImagesHelper->addScripts();
    }

    /**
     * onAfterRender.
     */
    public function onAfterRender()
    {
        if ((CMSFactory::getApplication()->isClient('administrator')) || (!$this->getHelper())) {
            return;
        }

        $this->adaptiveImagesHelper->apply();

        $this->passed = true;
    }

    /**
     * Create the helper object.
     *
     * @return object The plugins helper object
     */
    private function getHelper()
    {
        if ($this->passed) {
            return null;
        }

        if (!@include_once(JPATH_ROOT.'/libraries/xtplatform2/vendor/autoload.php')) {
            return;
        }

        $url = CMSUri::getInstance()->toString();

        if (!PluginHelper::isPluginEnabledUrl($this->params, $url)) {
            $this->passed = true;

            return null;
        }

        // Already initialized, so return
        if ($this->adaptiveImagesHelper) {
            return $this->adaptiveImagesHelper;
        }

        require_once 'helper.php';

        $this->adaptiveImagesHelper = new AdaptiveImagesForJoomlaHelper($this->params);

        return $this->adaptiveImagesHelper;
    }
}
