<?php
/**
 * @package         Cache Cleaner
 * @version         9.7.5
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\System\CacheCleaner\Extension;

use RegularLabs\Library\Plugin\System as RL_SystemPlugin;
use RegularLabs\Plugin\System\CacheCleaner\Cache;
use RegularLabs\Plugin\System\CacheCleaner\Helpers\CurrentArticle;
use RegularLabs\Plugin\System\CacheCleaner\Helpers\Params;
use RegularLabs\Plugin\System\CacheCleaner\Replace;

defined('_JEXEC') or die;

final class CacheCleaner extends RL_SystemPlugin
{
    public $_enable_in_admin = true;
    public $_lang_prefix     = 'CC';
    public $_page_types      = ['html', 'ajax', 'json', 'raw'];

    protected function changeFinalHtmlOutput(string &$html): bool
    {
        return true;
    }

    protected function handleOnAfterRoute(): void
    {
        Cache::clean($this->_id);
    }
}
