<?php

/**
 * @version    CVS: 1.65.0.1
 * @package    com_yoursites
 * @author     Geraint Edwards
 * @copyright  2017-YOURSITES_COPYRIGHT GWE Systems Ltd
 * @license    GNU General Public License version 3 or later; see LICENSE.txt
 */
defined( 'JPATH_BASE' ) or die;

/*
 * Joomla 3.7.x and earlier don't support these - leave them out until we MUST have them for Joomla 4.x
 * But Joomla 5 load compatibility code later than us so we must use these!
 */

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Session\Session;
use Joomla\Filesystem\File;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Form\Form;
Use Joomla\Filesystem\Path;
Use Joomla\Filesystem\Folder;

class plgSystemYourSites extends CMSPlugin {
    /**
     * Application object.
     *
     * @var    CMSApplication
     * @since  3.5
     */
    protected $app;

    public function __construct( &$subject, $config ) {
        parent::__construct( $subject, $config );

        $input = Factory::getApplication()->input;
        /*
                if ($input->get('._ysts_diagnose', 0))
                {
                    include_once 'yoursites_getupdatedata.php';
                    set_exception_handler(array("YourSitesDiagnosis", 'captureException'));
                    set_error_handler(array("YourSitesDiagnosis",'captureFatalError'));
                }
        */
        $task = $input->get( 'task', $input->get( 'typeaheadtask', '', 'cmd' ), 'cmd' );

        if ( $task != "gwejson" && $task != "yoursites" )
        {
            return true;
        }

        // Special handling for migration
        $file   = $input->get( 'file', '', 'cmd' );
        $folder = $input->get( 'folder', '', 'cmd' );
        $plugin = $input->get( 'plugin', '', 'cmd' );

        if ( $file == "getupdatedata" && $folder == "yoursites" && $plugin == "handler" )
        {
            $input->set( 'task', 'yoursites' );
            $input->set( 'folder', 'system' );
            $input->set( 'plugin', 'yoursites' );
        }

        // special trap for Falang and extension updates causing table #__extensions not locked error !
        try
        {
            $requestData = $input->get( 'json', '', 'raw' );
            if ( empty( $requestData ) )
            {
                $requestData = @base64_decode( $input->get( 'json64', '', 'raw' ) );
            }
            if ( is_string( $requestData ) )
            {
                $requestData = json_decode( $requestData );
                if ( $requestData && isset( $requestData->task ) && $requestData->task === "updateextension" )
                {
                    $plugin = PluginHelper::getPlugin( "system", "falangdriver" );
                    if ( $plugin )
                    {
                        $plugin->name .= "dummy";
                    }
                }
            }
        }
        catch ( Exception $e )
        {

        }
        // Do we have uploaded files?
        if ( isset( $_FILES["install_package"] ) )
        {
            $this->uploadedFile = $_FILES["install_package"];
            unset( $_FILES["install_package"] );
        }
        //$this->uploadedFile = $input->files->get("install_package", false, "raw");

    }

    // override edit article page and menu item edit page
    public function onContentPrepareForm( $form, $data ) {

        if ( ! ( $form instanceof Form ) )
        {
            $this->_subject->setError( 'JERROR_NOT_A_FORM' );

            return false;
        }

        $name = $form->getName();

        if ( $name != 'com_plugins.plugin' || ! isset( $data->element ) || $data->element != 'yoursites' || ! isset( $data->folder ) || $data->folder != 'system' )
        {
            // When saving in Joomla 4 data->element and folder are not yet set
            $input = Factory::getApplication()->input;
            if ( ! $input->post->getRaw( 'jform', false ) )
            {
                return true;
            }
            else
            {
                $jform = $input->post->get( 'jform', array(), 'array' );
                if ( ! isset( $jform['element'] ) || $jform['element'] != 'yoursites' || ! isset( $jform['folder'] ) || $jform['folder'] != 'system' )
                {
                    return true;
                }
            }
        }

        if ( Factory::getApplication()->isClient( 'administrator' ) )
        {

            $configFiles = Folder::files( JPATH_PLUGINS . "/system/yoursites/customactions/", 'config_*.xml' );

            foreach ( $configFiles as $configFile )
            {
                if ( file_exists( JPATH_PLUGINS . "/system/yoursites/customactions/" . $configFile ) )
                {
                    $lang = Factory::getLanguage();
                    $lang->load( "plg_yoursites_" . str_replace( "_config.xml", "", $configFile ), JPATH_PLUGINS . "/system/yoursites/customactions", null, false, true );

                    $loaded = $form->loadFile( JPATH_PLUGINS . "/system/yoursites/customactions/" . $configFile, false );
                }
            }
        }
    }

    /**
     * Capture core Joomla error
     *
     * @since version 1.11
     */
    public function onError( $event ) {
        $session = Factory::getSession();
        if ( $session->get( 'ysts_debug', 0 ) )
        {

            $data           = new stdClass();
            $data->messages = array( 'COM_YOURSITES_FATAL_ERROR_INFORMATION' );
            if ( method_exists( $event, 'getError' ) )
            {
                $error = $event->getError();
            }
            else
            {
                $error = $event;
            }

            $data->messages[]   = $error->getMessage();
            $data->messages[]   = $error->getFile() . " : " . $error->getLine();
            $data->log['file']  = $error->getFile();
            $data->log['line']  = $error->getLine();
            $data->log['trace'] = $error->getTrace();

            $data->warning = 1;

            header( "Content-Type: application/javascript" );
            // Must suppress any error messages
            @ob_end_clean();
            echo json_encode( $data );
            exit( 0 );
        }

        return true;
    }

    /**
     * Method to catch the onAfterInitialise event.
     *
     * @return  boolean  True on success
     *
     */
    public
    function onAfterInitialise() {

        $input = Factory::getApplication()->input;

        try
        {
            $aliases = $this->params->get( 'clonealiases', array() );
            if ( ! is_array( $aliases ) )
            {
                $aliases = (array) $aliases;
            }
            if ( count( $aliases ) )
            {
                $current   = Uri::current();
                $parts     = \Joomla\Uri\UriHelper::parse_url( $current );
                $path      = trim( $parts['path'], "/" );
                $extrapath = "";
                if ( strpos( $path, "/" ) > 0 )
                {
                    $extrapath = substr( $path, strpos( $path, "/" ) );
                    $path      = substr( $path, 0, strpos( $path, "/" ) );
                }
                if ( is_array( $parts ) && isset( $parts['path'] ) && ! empty( $path ) && in_array( $path, $aliases ) )
                {
                    $path = array_search( $path, $aliases );
                    Factory::getApplication()->redirect( $path . $extrapath );
                }

                // Alternative is clone is clone of a sub-folder
                $pathParts = explode( "/", $parts['path'] );
                $changed   = false;
                foreach ( $aliases as $key => $alias )
                {
                    if ( ! empty( $alias ) && in_array( $alias, $pathParts ) )
                    {
                        $pathParts[array_search( $alias, $pathParts )] = $key;
                        $changed                                       = true;
                    }
                }
                if ( $changed )
                {
                    $parts['path'] = implode( "/", $pathParts );
                    Factory::getApplication()->redirect( $parts['path'] );
                }

            }
        }
        catch ( Exception $e )
        {

        }

        if ( isset( $this->uploadedFile ) )
        {
            $_FILES["install_package"] = $this->uploadedFile;
        }
        $task = $input->get( 'task', $input->get( 'typeaheadtask', '', 'cmd' ), 'cmd' );
        // in frontend SEF
        if ( $task != "yoursites" )
        {
            return true;
        }

        $file = $input->get( 'file', '', 'cmd' );
        // Library file MUST start with "yoursites_" for security reasons to stop other files being included maliciously
        if ( $file == "" )
        {
            return true;
        }
        if ( strpos( $file, "yoursites_" ) !== 0 )
        {
            $file = "yoursites_" . $file;
        }

        $path  = $input->get( 'path', 'site', 'cmd' );
        $paths = array( "site"    => JPATH_SITE,
                        "admin"   => JPATH_ADMINISTRATOR,
                        "plugin"  => JPATH_SITE . "/plugins",
                        "module"  => JPATH_SITE . "/modules",
                        "library" => JPATH_LIBRARIES
        );
        if ( ! in_array( $path, array_keys( $paths ) ) )
        {
            return true;
        }
        $folder = $input->get( 'folder', '', 'string' );
        if ( $path == "plugin" )
        {
            $plugin = $input->get( 'plugin', '', 'string' );
            if ( $folder == "" || $plugin == "" )
            {
                return true;
            }
            $path = $paths[$path] . "/$folder/$plugin/";
        }
        else if ( $path == "module" || $path == "library" )
        {
            if ( $folder == "" )
            {
                return true;
            }
            $path = $paths[$path] . "/$folder/";
        }
        else
        {
            $extension = $input->get( 'option', $input->get( 'ttoption', '', 'cmd' ), 'cmd' );
            if ( $extension == "" )
            {
                return true;
            }
            if ( $folder == "" )
            {
                $path = $paths[$path] . "/components/$extension/libraries/";
            }
            else
            {
                $path = $paths[$path] . "/components/$extension/$folder/";
            }
        }

        jimport( 'joomla.filesystem.file' );
        // Check for a custom version of the file first!
        $custom_file = str_replace( "yoursites_", "yoursites_custom_", $file );
        if ( is_file( $path . $custom_file . ".php" ) )
        {
            $file = $custom_file;
        }
        if ( ! is_file( $path . $file . ".php" ) )
        {
            PlgSystemyoursites::throwAjaxError( "Whoops we could not find the file: " . $path . $file . ".php" );

            return true;
        }

        include_once( $path . $file . ".php" );

        if ( ! function_exists( "yoursites_skiptoken" ) || ! yoursites_skiptoken() )
        {
            $token = Session::getFormToken();;
            if ( $token != $input->get( 'token', '', 'string' ) )
            {
                if ( $input->get( 'json', '', 'raw' ) )
                {

                }
                PlgSystemyoursites::throwAjaxError( "There was an error - bad token.  Please refresh the page and try again." );
            }
        }

        // we don't want any modules etc.
        //$input->set('tmpl', 'component');
        $input->set( 'format', 'json' );

        ini_set( "display_errors", 0 );

        // When setting typeahead in the post it overrides the GET value which the prepare function doesn't replace for some reason :(
        if ( $input->get( 'typeahead', '', 'string' ) != "" || $input->get( 'prefetch', 0, 'int' ) )
        {
            try
            {
                $requestObject            = new stdClass();
                $requestObject->typeahead = $input->get( 'typeahead', '', 'string' );
                $data                     = null;
                $data                     = ProcessYstsJsonRequest( $requestObject, $data );
            }
            catch ( Exception $e )
            {
                PlgSystemyoursites::throwAjaxError( "There was an exception (1) " . addslashes( $e->getMessage() ) );
            }
        }

        // Get JSON data
        else if ( $input->get( 'json', '', 'raw' ) || $input->get( 'json64', '', 'raw' ) )
        {
            // Create JSON data structure
            $data         = new stdClass();
            $data->error  = 0;
            $data->result = "ERROR";
            $data->user   = "";

            $requestData = $input->get( 'json', '', 'raw' );
            if ( empty( $requestData ) )
            {
                $requestData = @base64_decode( $input->get( 'json64', '', 'raw' ) );
            }

            if ( isset( $requestData ) && ! empty( $requestData ) )
            {
                try
                {
                    if ( ini_get( "magic_quotes_gpc" ) )
                    {
                        $requestData = stripslashes( $requestData );
                    }

                    $requestObject = @json_decode( $requestData, 0 );
                    if ( ! $requestObject )
                    {
                        $requestObject = @json_decode( utf8_encode( $requestData ), 0 );
                    }
                }
                catch ( Exception $e )
                {
                    PlgSystemyoursites::throwAjaxError( "There was an exception" );
                }

                if ( ! $requestObject )
                {
                    //file_put_contents(dirname(__FILE__) . "/cache/error.txt", var_export($requestData, true));
                    PlgSystemyoursites::throwAjaxError( "There was an error - no request object " );
                }
                else if ( isset( $requestObject->error ) && $requestObject->error )
                {
                    PlgSystemyoursites::throwAjaxError( "There was an error - Request object error " . $requestObject->error );
                }
                else
                {
                    try
                    {
                        $data = ProcessYstsJsonRequest( $requestObject, $data );
                    }
                    catch ( Exception $e )
                    {
                        $logs                 = array();
                        $logs["file/line : "] = $e->getFile() . " : " . $e->getLine();
                        $logs["trace"]        = $e->getTraceAsString();
                        PlgSystemyoursites::throwAjaxError( "There was an exception (2) " . $e->getMessage() );
                    }
                }
            }
            else
            {
                PlgSystemyoursites::throwAjaxError( "Invalid Input" );
            }
        }
        else
        {
            //PlgSystemyoursites::throwAjaxError("There was an error - no request data " . var_export($_REQUEST, true) . var_export($_FILES, true)  );
            PlgSystemyoursites::throwAjaxError( "There was an error - no request data" );
        }

        if ( is_string( $data ) && $data === 'skip json' )
        {
            return true;
        }
        header( "Content-Type: application/javascript; charset=utf-8" );

        if ( is_object( $data ) )
        {
            if ( defined( '_SC_START' ) )
            {
                list ( $usec, $sec ) = explode( " ", microtime() );
                $time_end     = (float) $usec + (float) $sec;
                $data->timing = round( $time_end - _SC_START, 4 );
            }
            else
            {
                $data->timing = 0;
            }
        }

        // Must suppress any error messages
        @ob_end_clean();
        echo json_encode( $data );

        exit( 0 );

    }

    public function onAjaxHandler() {
        include_once "yoursites_getupdatedata.php";

        $input = Factory::getApplication()->input;

        $input->set( 'format', 'json' );

        if ( $input->get( 'json', '', 'raw' ) )
        {
            // Create JSON data structure
            $data         = new stdClass();
            $data->error  = 0;
            $data->result = "ERROR";
            $data->user   = "";

            $requestData = $input->get( 'json', '', 'raw' );

            if ( isset( $requestData ) )
            {
                try
                {
                    if ( ini_get( "magic_quotes_gpc" ) )
                    {
                        $requestData = stripslashes( $requestData );
                    }

                    $requestObject = json_decode( $requestData, 0 );
                    if ( ! $requestObject )
                    {
                        $requestObject = json_decode( utf8_encode( $requestData ), 0 );
                    }
                }
                catch ( Exception $e )
                {
                    plgSystemYourSites::throwAjaxError( "There was an exception" );
                }

                if ( ! $requestObject )
                {
                    //file_put_contents(dirname(__FILE__) . "/cache/error.txt", var_export($requestData, true));
                    plgSystemYourSites::throwAjaxError( "There was an error - no request object " );
                }
                else if ( isset( $requestObject->error ) && $requestObject->error )
                {
                    plgSystemYourSites::throwAjaxError( "There was an error - Request object error " . $requestObject->error );
                }
                else
                {
                    try
                    {
                        $data = ProcessYstsJsonRequest( $requestObject, $data );
                    }
                    catch ( Exception $e )
                    {
                        //plgSystemYourSites::throwAjaxError("There was an exception ".$e->getMessage()." ".var_export($e->getTrace()));
                        plgSystemYourSites::throwAjaxError( "There was an exception " . $e->getMessage() );
                    }
                }
            }
            else
            {
                plgSystemYourSites::throwAjaxError( "Invalid Input" );
            }
        }
        else
        {
            //plgSystemYourSites::throwAjaxError("There was an error - no request data " . var_export($_REQUEST, true));
            plgSystemYourSites::throwAjaxError( "There was an error - no request data" );
        }

        return $data;

        //header("Content-Type: application/javascript; charset=utf-8");

    }

    public function onAjaxYoursites() {

        $input = Factory::getApplication()->input;

        $input->set( 'format', 'json' );

        if ( $input->getCmd( 'task' ) == 'yoursites.serviceworker' )
        {
            // Check for request forgeries
//			Session::checkToken('get') or jexit(Text::_('JINVALID_TOKEN'));

            // Manually clear cache in Firefox using
            // about:serviceworkers

            $js = file_get_contents( JPATH_ADMINISTRATOR . "/components/com_yoursites/assets/js/service-worker.js" );
            header( "Content-Type: application/javascript; charset=utf-8" );
            header( 'Service-Worker-Allowed: /' );
            //header('Cache-Control: no-cache');
            // expire after 1 day
            header( 'Cache-Control: max-age=86400' );
            echo $js;
            exit();

        }
        // method to pass to custom plugins
        else if ( $input->getCmd( 'ystsaction', '' ) )
        {
            $ystsaction  = $input->getCmd( 'ystsaction', '' );
            $paramsArray = $this->params->toArray();
            foreach ( $paramsArray as $paramKey => $paramValue )
            {
                if ( strpos( $paramKey, "plugintrigger_" ) === 0 && (int) $paramValue == 1 )
                {
                    $parts = explode( "_", $paramKey );
                    if ( count( $parts ) == 3 )
                    {
                        $customActionFile = $parts[1];

                        if ( $ystsaction == $customActionFile )
                        {
                            $directory = __DIR__;
                            $directory = realpath( $directory );

                            if ( file_exists( $directory . "/customactions/" . basename( $customActionFile . ".php" ) ) )
                            {
                                include_once $directory . "/customactions/" . basename( $customActionFile . ".php" );

                                try
                                {
                                    $className = "Ysts" . ucfirst( $customActionFile );

                                    return $className::jsonRequest();

                                }
                                catch ( \Throwable $e )
                                {
                                    $x = 1;
                                }
                            }
                        }
                    }

                }
            }

        }
        else
        {
            //plgSystemYourSites::throwAjaxError("There was an error - no request data " . var_export($_REQUEST, true));
            plgSystemYourSites::throwAjaxError( "There was an error - no request data" );
        }

        //header("Content-Type: application/javascript; charset=utf-8");

    }

    public static function throwAjaxError( $msg, $logs = false ) {
        $data                = new stdClass();
        $data->errormessages = array( $msg );
        if ( $logs )
        {
            $data->log = array( $logs );
        }
        $data->error = 1;

        header( "Content-Type: application/javascript" );
        // Must suppress any error messages
        @ob_end_clean();
        echo json_encode( $data );
        exit( 0 );
    }

    public static function throwerror( $msg, $logs = false ) {
        $data                = new stdClass();
        $data->errormessages = array( $msg );
        if ( $logs )
        {
            $data->log = array( $logs );
        }
        $data->error = 1;
        $data->user  = "";

        header( "Content-Type: application/javascript" );
        // Must suppress any error messages
        @ob_end_clean();
        echo json_encode( $data );
        exit( 0 );
    }

    /*
     *
    // This is how we configure diagnosis!

    $plugin = PluginHelper::getPlugin("system" , "yoursites");
    if ($plugin)
    {
        $pluginparams = new Registry($plugin->params);
        $info = $pluginparams->get('yoursites.info', "nothing");
        $pluginparams->set('yoursites.info', "something");
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->update($db->quoteName('#__extensions'))
            ->set($db->quoteName('params') . ' = ' . $db->quote($pluginparams->toString()))
            ->where($db->quoteName('extension_id') . ' = ' . $plugin->id);
        $db->setQuery($query);
        $db->execute();
    }
     */

    /**
     * For cloned sites with images folder not copied we can use the parent images via this plugin
     *
     * Also add support for YourSites plugins e.g. json driven hits counter etc.
     *
     * @return  void
     */
    public function onBeforeRender() {
        if ( $this->app->input->getCmd( 'option' ) === 'com_ajax' || version_compare( JVERSION, '4.1', 'lt' ) )
        {
            return;
        }
        $paramsArray = $this->params->toArray();
        foreach ( $paramsArray as $paramKey => $paramValue )
        {
            if ( strpos( $paramKey, "plugintrigger_" ) === 0 && (int) $paramValue == 1 )
            {
                $parts = explode( "_", $paramKey );
                if ( count( $parts ) == 3 )
                {
                    $customActionFile = $parts[1];
                    $pluginTrigger    = $parts[2];
                    if ( $pluginTrigger == __FUNCTION__ )
                    {
                        $directory = __DIR__;
                        $directory = realpath( $directory );

                        if ( file_exists( $directory . "/customactions/" . basename( $customActionFile . ".php" ) ) )
                        {
                            include_once $directory . "/customactions/" . basename( $customActionFile . ".php" );

                            try
                            {
                                $className = "Ysts" . ucfirst( $customActionFile );
                                $function  = __FUNCTION__;
                                $className::$function();

                            }
                            catch ( \Throwable $e )
                            {
                            }
                        }
                    }
                }

            }
        }
    }

    /**
     * Add support for YourSites plugins e.g. json driven hits counter etc.
     *
     * @return  void
     */
    public function onAfterRoute() {
        if ( $this->app->input->getCmd( 'option' ) === 'com_ajax' || version_compare( JVERSION, '4.1', 'lt' ) )
        {
            return;
        }
        $paramsArray = $this->params->toArray();
        foreach ( $paramsArray as $paramKey => $paramValue )
        {
            if ( strpos( $paramKey, "plugintrigger_" ) === 0 && (int) $paramValue == 1 )
            {
                $parts = explode( "_", $paramKey );
                if ( count( $parts ) == 3 )
                {
                    $customActionFile = $parts[1];
                    $pluginTrigger    = $parts[2];
                    if ( $pluginTrigger == __FUNCTION__ )
                    {
                        $directory = __DIR__;
                        $directory = realpath( $directory );

                        if ( file_exists( $directory . "/customactions/" . basename( $customActionFile . ".php" ) ) )
                        {
                            include_once $directory . "/customactions/" . basename( $customActionFile . ".php" );

                            try
                            {
                                $className = "Ysts" . ucfirst( $customActionFile );
                                $function  = __FUNCTION__;
                                $className::$function();

                            }
                            catch ( \Throwable $e )
                            {
                            }
                        }
                    }
                }

            }
        }
    }


    /**
     * Add support for YourSites plugins e.g. json driven hits counter etc.
     *
     * @return  void
     */
    public function onAfterDispatch() {
        // Special handling of akeeba backups in Joomla 3 when the site is offline
        if ( $this->app->input->getCmd( 'option' ) === 'com_akeeba'
             && $this->app->get('offline')
             && $this->app->input->getCmd( 'view' ) === 'api'
             && $this->app->input->getCmd( 'format' ) === 'ysts'
             && version_compare( JVERSION, '4.0', 'lt' )
        )
        {
            $this->app->set('offline', 0);
            return;
        }

        if ( $this->app->input->getCmd( 'option' ) === 'com_ajax' || version_compare( JVERSION, '4.1', 'lt' ) )
        {
            return;
        }
        $paramsArray = $this->params->toArray();
        foreach ( $paramsArray as $paramKey => $paramValue )
        {
            if ( strpos( $paramKey, "plugintrigger_" ) === 0 && (int) $paramValue == 1 )
            {
                $parts = explode( "_", $paramKey );
                if ( count( $parts ) == 3 )
                {
                    $customActionFile = $parts[1];
                    $pluginTrigger    = $parts[2];
                    if ( $pluginTrigger == __FUNCTION__ )
                    {
                        $directory = __DIR__;
                        $directory = realpath( $directory );

                        if ( file_exists( $directory . "/customactions/" . basename( $customActionFile . ".php" ) ) )
                        {
                            include_once $directory . "/customactions/" . basename( $customActionFile . ".php" );

                            try
                            {
                                $className = "Ysts" . ucfirst( $customActionFile );
                                $function  = __FUNCTION__;
                                $className::$function();

                            }
                            catch ( \Throwable $e )
                            {
                            }
                        }
                    }
                }

            }
        }
    }

    /**
     * For cloned sites with images folder not copied we can use the parent images via this plugin
     *
     * Also add support for YourSites plugins e.g. json driven hits counter etc.
     *
     * @return  void
     */
    public function onAfterRender() {
        if ( $this->app->input->getCmd( 'option' ) === 'com_ajax' || version_compare( JVERSION, '4.1', 'lt' ) )
        {
            return;
        }

        $paramsArray = $this->params->toArray();
        foreach ( $paramsArray as $paramKey => $paramValue )
        {
            if ( strpos( $paramKey, "plugintrigger_" ) === 0 && (int) $paramValue == 1 )
            {
                $parts = explode( "_", $paramKey );
                if ( count( $parts ) == 3 )
                {
                    $customActionFile = $parts[1];
                    $pluginTrigger    = $parts[2];
                    if ( $pluginTrigger == __FUNCTION__ )
                    {
                        $directory = __DIR__;
                        $directory = realpath( $directory );

                        if ( file_exists( $directory . "/customactions/" . basename( $customActionFile . ".php" ) ) )
                        {
                            include_once $directory . "/customactions/" . basename( $customActionFile . ".php" );

                            try
                            {
                                $className = "Ysts" . ucfirst( $customActionFile );
                                $function  = __FUNCTION__;
                                $className::$function();

                            }
                            catch ( \Throwable $e )
                            {
                            }
                        }

                    }
                }

            }
        }

        if ( ! $this->app->isClient( 'site' ) )
        {
            return;
        }

        if ( $this->app->input->get( 'layout' ) === 'edit' )
        {
            return;
        }

        // only work for clone sites
        $base = Uri::base( true );
        if ( strpos( $base, "._ysts_" ) === false && strpos( $base, "clone_ysts_" ) === false )
        {
            return;
        }

        $parts = explode( "/clone_ysts_", $base );
        if ( count( $parts ) !== 2 )
        {
            $parts = explode( "/._ysts_", $base );
            if ( count( $parts ) !== 2 )
            {
                return;
            }

        }


        // No need for this code - we check the actual images
        if ( false && file_exists( JPATH_SITE . "/images" ) )
        {
            // only looks one layer deep since $recurse is false by default but its still overkill so do it ourselves
            /*
            $imagefiles = Folder::files(JPATH_SITE . "/images");
            if (count($imagefiles) > 1)
            {
                return;
            }
            */

            $path = Path::clean( JPATH_SITE . "/images" );
            if ( is_dir( $path ) )
            {
                // Read the source directory
                if ( ( $handle = @opendir( $path ) ) )
                {

                    while ( ( $file = readdir( $handle ) ) !== false )
                    {
                        if ( $file != '.' && $file != '..' && strpos( $file, ".html" ) === false )
                        {
                            return;
                        }
                    }
                }

            }
        }

        $buffer = $this->app->getBody();

        $matches = array();
        $pattern = "#['|\"]([^\s|\t|\r|\n]*?)\._ysts_" . $parts[1] . "(/images/[^)''\"\s]+\.(?:jpg|jpeg|gif|png))#";
        preg_match_all( $pattern, $buffer, $matches );
        if ( count( $matches ) == 3 )
        {
            $root = str_replace( "/._ysts_" . $parts[1], "", Uri::root() );
            for ( $m = 0; $m < count( $matches[2] ); $m ++ )
            {
                $match = $matches[2][$m];
                if (strpos($match, '#joomlaImage://local-images') > 0)
                {
                    $match = substr($match, 0, strpos($match, '#joomlaImage://local-images'));
                }

                if ( ! file_exists( JPATH_SITE . $match ) )
                {
                    $char1 = substr( $matches[0][$m], 0, 1 );

                    //echo "1. replace " . $matches[0][$m] . " with " . $char1 .  $root .  substr($matches[2][$m], 1). "<Br>";
                    $buffer = str_replace( $matches[0][$m], $char1 . $root . substr( $matches[2][$m], 1 ), $buffer );
                }
            }
        }

        $matches = array();
        $pattern = "#['|\"](images/[^)''\"\s]+\.(?:jpg|jpeg|gif|png))#";
        preg_match_all( $pattern, $buffer, $matches );
        if ( count( $matches ) == 2 )
        {
            $root = str_replace( "/._ysts_" . $parts[1], "", Uri::root() );
            foreach ( $matches[1] as $match )
            {
                if (strpos($match, '#joomlaImage://local-images') > 0)
                {
                    $match = substr($match, 0, strpos($match, '#joomlaImage://local-images'));
                }

                if ( ! file_exists( JPATH_SITE . $match ) )
                {
                    //echo "2. replace " . $match. " with " . $root . $match ."<Br>";
                    $buffer = str_replace( $match, $root . $match, $buffer );
                }
            }
        }

        $matches = array();
        $pattern = "#['|\"]([^\s|\t|\r|\n]*?)clone_ysts_" . $parts[1] . "(/images/[^)''\"\s]+\.(?:jpg|jpeg|gif|png))#";
        preg_match_all( $pattern, $buffer, $matches );
        if ( count( $matches ) == 3 )
        {
            $root = str_replace( "/clone_ysts_" . $parts[1], "", Uri::root() );
            for ( $m = 0; $m < count( $matches[2] ); $m ++ )
            {
                $match = $matches[2][$m];
                if (strpos($match, '#joomlaImage://local-images') > 0)
                {
                    $match = substr($match, 0, strpos($match, '#joomlaImage://local-images'));
                }

                if ( ! file_exists( JPATH_SITE . $match ) )
                {
                    $char1 = substr( $matches[0][$m], 0, 1 );

                    //echo "1. replace " . $matches[0][$m] . " with " . $char1 .  $root .  substr($matches[2][$m], 1). "<Br>";
                    $buffer = str_replace( $matches[0][$m], $char1 . $root . substr( $matches[2][$m], 1 ), $buffer );
                }
            }
        }

        $matches = array();
        $pattern = "#['|\"](images/[^)''\"\s]+\.(?:jpg|jpeg|gif|png))#";
        preg_match_all( $pattern, $buffer, $matches );
        if ( count( $matches ) == 2 )
        {
            $root = str_replace( "/clone_ysts_" . $parts[1], "", Uri::root() );
            foreach ( $matches[1] as $match )
            {
                if (strpos($match, '#joomlaImage://local-images') > 0)
                {
                    $match = substr($match, 0, strpos($match, '#joomlaImage://local-images'));
                }

                if ( ! file_exists( JPATH_SITE . $match ) )
                {
                    //echo "2. replace " . $match. " with " . $root . $match ."<Br>";
                    $buffer = str_replace( $match, $root . $match, $buffer );
                }
            }
        }

        // Use the replaced HTML body.
        $this->app->setBody( $buffer );

        return;
    }

}