<?php
/*
* @author Andrey Kvasnevskiy, http://ordasoft.com
* @email akbet@ordasoft.com
* @package Xmap
* @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
* @description Xmap plugin for BookLibrary Component
* adapted for BookLibrary by Rob de Cleen
*
* Plugin tested with Xmap 2.0 and BookLibrary 6.0 on J 3.9.x -4.x
*
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.plugin.plugin');

//$tmp = new XmapBookLibrary;
//XmapPlugins::addPlugin($tmp);

class xmap_com_booklibrary {
    
// Set to 0 if you dont want the books in your sitemap
//  var $show_books = 1;

  // Set the order to display books(title,hits,price,vote)
//  var $orderby = 'title';

  function isOfType( &$xmap, &$menu ) {
    if( strpos($menu->link, 'option=com_booklibrary') ) {
      return true;
    }
    return false;
  }

  
  static function &getTree($xmap, &$menu, &$params) {

    global $mosConfig_absolute_path;
    $list = array();
    
    if(strpos($menu->link, 'task=view')) {
      return $list;
    }
    
     $link_query = parse_url($menu->link);
     parse_str(html_entity_decode($link_query['query']), $link_vars);
             if (version_compare(JVERSION, "1.6.0", "lt")){
            $view = JArrayHelper::getValue($link_vars,'task','categories');
        } else{
            $view = JArrayHelper::getValue($link_vars,'view','categories');
        }
        
        switch ($view){
            case 'categories':
                $catid = JArrayHelper::getValue($link_vars,'catid',0);
                xmap_com_booklibrary::getCategorieTree($xmap, $menu, $catid, $params);
                break;
            case 'all_authors':
                xmap_com_booklibrary::getAuthors ($xmap, $menu, $params);
                break;


            case 'showCategory':
                if ($params['show_book'] == 'true')
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($menu->params, 'catid=')!==false){
                        $catid = substr($menu->params, strpos($menu->params,'=',0)+1,
                                strpos($menu->params,'back',0)-strpos($menu->params,'=',0)-2);
                    }
                } else{
                    $catid = ($menu->params->get('single_category'));
                }
                //var_dump($catid);
                xmap_com_booklibrary::singleCategoryHandler($xmap, $menu, $catid, $params);
                break;

            case 'books':
                if ($params['show_book'] == 'true')
                xmap_com_booklibrary::getAllBooks($xmap, $menu, $params);
                break;


            case 'my_books':
            case 'show_my_books':
                if ($params['show_book'] == 'true')
                xmap_com_booklibrary::myBooksHandler($xmap, $menu, $params);
                break;

            case 'owner_books':
            case 'owner_books':
                if ($params['show_book'] == 'true')
                if (version_compare(JVERSION, "1.6.0", "lt")){
                    if (strpos($menu->params, 'username=')!==false){
                        $username = substr($menu->params, strpos($menu->params,'=',0)+1, 
                                strpos($menu->params,'back',0)-strpos($menu->params,'=',0)-2);
                    }
                } else{
                    $username = ($menu->params->get('username'));
                }
                xmap_com_booklibrary::singleUserBookHandler($xmap, $menu, $username, $params);
                break;

            case 'owners_list':
                xmap_com_booklibrary::ownersListHandler($xmap, $menu, $params);
                break;
            
            default:
                break;
        }
        return $list;
    
     
     

}

  
    static function getAuthors(&$xmap, &$menu,&$params) {

      require_once (JPATH_SITE . "/components/com_booklibrary/functions.php");
      $GLOBALS['Itemid'] = $Itemid = intval(mosGetParam( $_REQUEST, 'Itemid', 0)); // for 1.6
      
       if($params['orderby_author'])
       {
         $orderby = $params['orderby_author'];
       }
       else
       {
         $orderby = 'id';
       }

      $xmap->changeLevel(1);
      $database = JFactory::getDBO();
      $database->setQuery("select a.id,a.authors_name FROM #__booklibrary_authors AS a
                            \nWHERE a.published = '1' AND a.approved='1' 
                            \nGROUP BY a.id 
                            \nORDER BY ". $orderby);                
      $authors = $database->loadObjectList();

      foreach($authors as $author) 
      {
        $node = new stdclass;
        $node->id = $menu->id;
        $node->uid=$menu->uid.'a'.$author->id;
        $node->name = $author->authors_name;
        $node->parent=1;
        $node->browsNav=1;//open new window
        $node->ordering=2;
        $node->priority=$menu->priority;
        $node->chansefreq=$menu->changefreq;
        $node->changefreq=$menu->changefreq;
        $node->modified= date("Y-m-d h:i:s");
        $node->type='component';
        $node->menutype='mainmenu';
        $node->link = 'index.php?option=com_booklibrary&amp;task=view_author&id='.$author->id.
                '&amp;Itemid='.$Itemid;
        $xmap->printNode($node);
      }
      $xmap->changeLevel(-1);
    }
    
    
    static function getAllBooks (&$xmap, &$menu, $params){
        $Itemid = $menu->id;
        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }
        $database = JFactory::getDBO();
        require_once (JPATH_SITE . "/components/com_booklibrary/functions.php");
        $s = getWhereUsergroupsString("c");
        $query = "SELECT b.*,bc.catid AS catid, c.title as category_titel
               \n FROM #__booklibrary AS b
               \n LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id
               \n LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid
               \n WHERE  b.published='1' AND b.approved='1'
               \n AND b.published='1' AND (".$s.")
               \n GROUP BY b.id ORDER BY " . $orderby . "";
        $database->setQuery($query);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);

        foreach ($items as $book)
            xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $book->id, $book->title,
                    $book->catid, $book->id, true);

        $xmap->changeLevel(-1);
    }
    


    static function getBooks(&$xmap, &$menu, &$catid, &$params){
        
        $GLOBALS['Itemid'] = $Itemid = intval(mosGetParam( $_REQUEST, 'Itemid', 0 )); // for 1.6

        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }

        $xmap->changeLevel(1);
        $database = JFactory::getDBO();
        $my=JFactory::getUser();
        $acl =JFactory::getACL();

        require_once (JPATH_SITE . "/components/com_booklibrary/functions.php");
        $s = getWhereUsergroupsString("c");	



        $database->setQuery ("select b.id, b.title, bc.catid FROM #__booklibrary AS b
                              \nLEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id
                              \nLEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid
                              \nWHERE ({$s}) AND b.published = '1' AND b.approved='1' AND bc.catid=$catid
                              \nGROUP BY b.id
                              \nORDER BY " . $orderby);
        $books = $database->loadObjectList();

          foreach($books as $book) 
          {
            $node = new stdclass;
            $node->id= $menu->id;
            $node->uid=$menu->uid.'a'.$book->id;
            $node->name = $book->title;
            $node->parent=1;
            $node->browsNav=1;//open new window
            $node->ordering=2;
            $node->priority=$menu->priority;
            $node->chansefreq=$menu->changefreq;
            $node->changefreq=$menu->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->menutype='mainmenu';

            $node->link = 'index.php?option=com_booklibrary&amp;task=view&amp;catid=' .$book->catid.
              '&amp;id='.$book->id.'&amp;Itemid='.$Itemid;
            $xmap->printNode($node);
          }
        $xmap->changeLevel(-1);
        }
  
    static function ownersListHandler (&$xmap, &$menu, $params){

        $Itemid = $menu->id;
        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }
        $database = JFactory::getDBO();
        require_once (JPATH_SITE . "/components/com_booklibrary/functions.php");
        $s = getWhereUsergroupsString("c");
        $items = "SELECT u.name, u.email, u.id, COUNT(b.owner_id)
               \n FROM #__booklibrary AS b
               \n LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id
               \n LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid
               \n LEFT JOIN #__users AS u ON b.owner_id=u.id
               \n WHERE b.published=1 AND b.approved=1 AND b.owneremail!='' AND (".$s.")
               \n GROUP BY u.name
               \n ORDER BY u.name";
        $database->setQuery($items);
        $owners = $database->loadObjectList();
        $xmap->changeLevel(1);
        
        foreach($owners as $owner){

            if($owner->name == '') $owner->name = "anonymous" ;
            xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $owner->id, $owner->name, 0, 0,
                    false, $owner->name);
            
            $q = "SELECT b.*, c.id AS catid FROM `#__booklibrary` AS b
                  LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id
                  LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid
                  WHERE b.approved = 1 AND b.published = 1 AND (".$s.") AND b.owner_id='".$owner->id."'
                  GROUP BY b.id ORDER BY " . $orderby;
            $database->setQuery($q);
            $books = $database->loadObjectList();

            $xmap->changeLevel(1);
            if ($params['show_book'] == 'true'){
            foreach ($books as $book)
                xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $book->id, $book->title,
            $book->catid, $book->id, true);}
            $xmap->changeLevel(-1);
        }
        $xmap->changeLevel(-1);
    }
    
    static function singleCategoryHandler(&$xmap, &$menu, &$catid, $params){

        $Itemid = $menu->id;
        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }
        $database = JFactory::getDBO();
        require_once (JPATH_SITE . "/components/com_booklibrary/functions.php");
        $s = getWhereUsergroupsString("c");
        $query = "SELECT b.*,bc.catid AS catid, c.title as category_titel
               \n FROM #__booklibrary AS b
               \n LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id
               \n LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid
               \n WHERE bc.catid = '".$catid."' AND b.published='1' AND b.approved='1'
               \n AND c.published='1' AND (".$s.")
               \n GROUP BY b.id ORDER BY " . $orderby;
        $database->setQuery($query);
        $items = $database->loadObjectList();
        


        $xmap->changeLevel(1);
        
        foreach ($items as $book)
            xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $book->id, $book->title,
                    $catid, $book->id, true);


    }
  
    static function myBooksHandler(&$xmap, &$menu, $params){

        $Itemid = $menu->id;
        $items = array();
        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }

        $my = JFActory::getUser();
        if (!isset($my->name)) return;

        $database = JFActory::getDBO();

        $q = "SELECT b.title as title, b.id as id, c.id AS catid 
              FROM `#__booklibrary` AS b
              LEFT JOIN `#__users` AS u ON u.id=b.owner_id
              LEFT JOIN `#__booklibrary_categories` AS bc ON bc.bookid=b.id
              LEFT JOIN `#__booklibrary_main_categories` AS c ON bc.catid=c.id
              WHERE b.published = 1 AND b.approved = 1 AND b.owner_id = '".$my->id."'
              GROUP BY id ORDER BY " . $orderby;
        $database->setQuery($q);
        $items = $database->loadObjectList();


        $xmap->changeLevel(1);

        if (isset($items[0])) foreach ($items as $book)
            xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $book->id, $book->title,
                    $book->catid, $book->id, true);
        $xmap->changeLevel(-1);
    }
    
    static function singleUserBookHandler(&$xmap, &$menu, &$id, $params){

        $Itemid = $menu->id;
        if($params['orderby'])
        {
          $orderby =$params['orderby'];
        }
        else
        {
          $orderby='title';
        }
        $database = JFactory::getDBO();
        $q = "SELECT b.*, c.id AS catid 
              FROM `#__booklibrary` AS b
              LEFT JOIN #__booklibrary_categories AS bc ON bc.bookid=b.id 
              LEFT JOIN #__booklibrary_main_categories AS c ON c.id=bc.catid 
              LEFT JOIN `#__users` AS u ON u.id=b.owner_id
              WHERE b.approved = 1 AND b.published = 1 AND b.published = 1 AND
              u.id='".$id."'
              GROUP BY b.title ORDER BY " . $orderby;
        $database->setQuery($q);
        $items = $database->loadObjectList();

        $xmap->changeLevel(1);
        
        foreach ($items as $book)
            xmap_com_booklibrary::printNode($xmap, $menu, $Itemid, $book->id, $book->title, 
                        $book->catid, $book->id, true);
        $xmap->changeLevel(-1);
    }
 
    
    static function getSubCategory(&$xmap, &$menu, &$catid ,&$params,$parentid,$cats)
    {
        
        $GLOBALS['Itemid'] = $Itemid = intval(mosGetParam( $_REQUEST, 'Itemid', 0 )); // for 1.6

        $xmap->changeLevel(1);
        foreach($cats as $subcat) 
        {
          if($subcat->parent_id==$parentid)
          {
            $node = new stdclass;
            $node->id   = $menu->id;
            $node->uid=$menu->uid.'a'.$subcat->id;
            $node->name = $subcat->title;
            $node->parent=1;
            $node->browsNav=1;
            $node->ordering=2;
            $node->priority=$menu->priority;
            $node->chansefreq=$menu->changefreq;
            $node->changefreq=$menu->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->link = 'index.php?option=com_booklibrary&amp;task=showCategory&amp;catid='.
                        $subcat->id.'&amp;Itemid='.$Itemid;
            $xmap->printNode($node);
            xmap_com_booklibrary::getSubCategory($xmap, $menu, $catid ,$params,$subcat->id,$cats);
            
            if(($params['show_book'])and($params['show_book']=='true'))
            {   
              xmap_com_booklibrary::getBooks ($xmap, $menu, $subcat->id ,$params);
            }
          }
        }
        $xmap->changeLevel(-1);
    }
  
    static function getCategorieTree ( &$xmap, &$menu, &$catid ,&$params) {
        global $my,$mosConfig_absolute_path;
        $database = JFactory::getDBO();
        $list = array();
        $my=JFactory::getUser();
        $acl =JFactory::getACL();

        require_once ( JPATH_SITE . "/components/com_booklibrary/functions.php" );
        $s = getWhereUsergroupsString("c");    

        $database->setQuery("select id, title, name, parent_id from #__booklibrary_main_categories
                as c where ({$s}) AND published = '1' and section='com_booklibrary'
                order by parent_id,ordering");
        $cats = $database->loadObjectList();

        xmap_com_booklibrary::getSubCategory($xmap, $menu, $catid ,$params,$catid,$cats);
        xmap_com_booklibrary::getBooks ($xmap, $menu, $catid ,$params,$catid);
        if(($params['show_book'])and($params['show_book']=='true'))
        {   
          xmap_com_booklibrary::getBooks ($xmap, $menu, $catid ,$params,$catid);
              }


      }
  
    static function printNode(&$xmap, &$menu, $Itemid, $node_uid, $node_name, $catid = 0, $bookid = 0,
            $is_book = false, $name = false){
        $node = new stdclass;
        $node->id = $Itemid; 
        $node->uid = $node_uid; 
        $node->name = $node_name;
        $node->parent = 1; 
        $node->browsNav = 1; 
        $node->ordering = 2; 
        $node->priority=$menu->priority;
        $node->chansefreq=$menu->changefreq;
        $node->changefreq=$menu->changefreq;
        $node->modified= date("Y-m-d h:i:s");
        $node->type = 'component'; 
        $node->menutype = 'mainmenu'; 
        if ($is_book) $node->link = 'index.php?option=com_booklibrary&amp;task=view&amp;id='
                .$bookid.'&amp;catid='.$catid.'&amp;Itemid='.$Itemid;
            elseif ($catid > 0) $node->link = 'index.php?option=com_booklibrary&amp;task='
                    . 'showcategory&amp;catid='.$catid.'&amp;Itemid='.$Itemid;
                elseif (isset($name) AND $name != '') $node->link = 'index.php?option='
                        . 'com_booklibrary&amp;task=view_user_books&amp;name='.$name.
                        '&amp;Itemid='.$Itemid;
        $xmap->printNode($node);
    }


}
